/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.display;

import ij.gui.GenericDialog;
import ij.measure.ResultsTable;
import ini.trakem2.Project;
import ini.trakem2.display.Bucketable;
import ini.trakem2.display.Display;
import ini.trakem2.display.Display3D;
import ini.trakem2.display.DoStep;
import ini.trakem2.display.Layer;
import ini.trakem2.display.LayerSet;
import ini.trakem2.display.Paintable;
import ini.trakem2.display.Patch;
import ini.trakem2.display.Profile;
import ini.trakem2.display.Tag;
import ini.trakem2.display.ZDisplayable;
import ini.trakem2.display.graphics.AddARGBComposite;
import ini.trakem2.display.graphics.ColorYCbCrComposite;
import ini.trakem2.display.graphics.DifferenceARGBComposite;
import ini.trakem2.display.graphics.MultiplyARGBComposite;
import ini.trakem2.display.graphics.SubtractARGBComposite;
import ini.trakem2.persistence.DBObject;
import ini.trakem2.persistence.XMLOptions;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.M;
import ini.trakem2.utils.Search;
import ini.trakem2.utils.Utils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class Displayable
extends DBObject
implements Paintable {
    protected static final String[] compositeModes = new String[]{"Normal", "Add", "Subtract", "Multiply", "Difference", "Color (YCbCr)"};
    public static final byte COMPOSITE_NORMAL = 0;
    public static final byte COMPOSITE_ADD = 1;
    public static final byte COMPOSITE_SUBTRACT = 2;
    public static final byte COMPOSITE_MULTIPLY = 3;
    public static final byte COMPOSITE_DIFFERENCE = 4;
    public static final byte COMPOSITE_COLOR_YCBCR = 5;
    private byte compositeMode = 0;
    protected final AffineTransform at = new AffineTransform();
    protected float width = 0.0f;
    protected float height = 0.0f;
    protected boolean locked = false;
    protected String title;
    protected String annotation = null;
    protected static Color last_color = Color.yellow;
    protected Color color = last_color;
    protected float alpha = 1.0f;
    protected boolean visible = true;
    protected Layer layer;
    protected HashSet<Displayable> hs_linked = null;
    protected Map<String, String> props = null;
    protected Map<Displayable, Map<String, String>> linked_props = null;
    protected Set<Displayable> linked_props_origins = null;
    protected static final String TAG_ATTR1 = "<!ATTLIST ";
    protected static final String TAG_ATTR2 = " NMTOKEN #REQUIRED>\n";

    public byte getCompositeMode() {
        return this.compositeMode;
    }

    protected Composite getComposite(byte mode) {
        return Displayable.getComposite(mode, this.alpha);
    }

    public void setCompositeMode(byte mode) {
        if (mode < 0 || mode > 5) {
            throw new IllegalArgumentException("Invalid composite mode: " + mode);
        }
        this.compositeMode = mode;
    }

    public static Composite getComposite(byte mode, float alpha) {
        Composite composite;
        switch (mode) {
            case 1: {
                composite = AddARGBComposite.getInstance(alpha);
                break;
            }
            case 2: {
                composite = SubtractARGBComposite.getInstance(alpha);
                break;
            }
            case 3: {
                composite = MultiplyARGBComposite.getInstance(alpha);
                break;
            }
            case 4: {
                composite = DifferenceARGBComposite.getInstance(alpha);
                break;
            }
            case 5: {
                composite = ColorYCbCrComposite.getInstance(alpha);
                break;
            }
            default: {
                composite = AlphaComposite.getInstance(3, alpha);
            }
        }
        return composite;
    }

    public synchronized boolean setProperty(String key, String value) {
        if (null == key) {
            return false;
        }
        if (null != this.props && null == value) {
            this.props.remove(key);
            if (this.props.isEmpty()) {
                this.props = null;
            }
        } else {
            if (null == this.props) {
                this.props = new HashMap<String, String>();
            }
            this.props.put(key, value);
        }
        return true;
    }

    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    public synchronized String getProperty(String key, String default_value) {
        if (null == key || null == this.props) {
            return default_value;
        }
        String val = this.props.get(key);
        if (null == val) {
            return default_value;
        }
        return val;
    }

    public synchronized Map<String, String> getProperties() {
        if (null == this.props) {
            return null;
        }
        return new HashMap<String, String>(this.props);
    }

    public synchronized boolean hasProperties() {
        return null != this.props && this.props.size() > 0;
    }

    public synchronized boolean setLinkedProperty(Displayable target, String key, String value) {
        if (null == target || null == key) {
            return false;
        }
        if (target.project != this.project) {
            Utils.log("Cannot link to a Displayable from another project!");
            return false;
        }
        if (null != this.linked_props && null == value) {
            Map<String, String> p = this.linked_props.get(target);
            if (null != p) {
                p.remove(key);
                if (p.isEmpty()) {
                    this.linked_props.remove(target);
                    if (this.linked_props.isEmpty()) {
                        this.linked_props = null;
                    }
                }
            }
        } else {
            this.linkedProps(target).put(key, value);
        }
        return true;
    }

    private final Map<String, String> linkedProps(Displayable target) {
        Map<String, String> p;
        if (null == this.linked_props) {
            this.linked_props = new HashMap<Displayable, Map<String, String>>();
        }
        if (null == (p = this.linked_props.get(target))) {
            p = new HashMap<String, String>();
            this.linked_props.put(target, p);
        }
        if (null == target.linked_props_origins) {
            target.linked_props_origins = new HashSet<Displayable>();
        }
        target.linked_props_origins.add(this);
        return p;
    }

    public synchronized void setLinkedProperties(Displayable target, Map<String, String> p) {
        if (null == target || null == p) {
            return;
        }
        if (target.project != this.project) {
            Utils.log("Cannot link to a Displayable from another project!");
            return;
        }
        Map<String, String> lp = this.linkedProps(target);
        for (Map.Entry<String, String> e : p.entrySet()) {
            String value = e.getValue();
            if (null == value) {
                lp.remove(e.getKey());
                continue;
            }
            lp.put(e.getKey(), value);
        }
        if (lp.isEmpty()) {
            this.linked_props.remove(target);
        }
    }

    public synchronized Map<String, String> removeLinkedProperties(Displayable target) {
        if (null == target || null == this.linked_props) {
            return new HashMap<String, String>();
        }
        Map<String, String> p = this.linked_props.remove(target);
        if (this.linked_props.isEmpty()) {
            this.linked_props = null;
        }
        if (null == p) {
            return new HashMap<String, String>();
        }
        return p;
    }

    protected void removeLinkedPropertiesFromOrigins() {
        if (null != this.linked_props_origins) {
            for (Displayable origin : this.linked_props_origins) {
                origin.removeLinkedProperties(this);
            }
        }
    }

    public String getLinkedProperty(Displayable target, String key) {
        return this.getLinkedProperty(target, key, null);
    }

    public synchronized String getLinkedProperty(Displayable target, String key, String default_value) {
        if (null == target || null == key) {
            return default_value;
        }
        if (target.project != this.project) {
            Utils.log("You attempted to get a property for a Displayable of another project, which is impossible.");
            return default_value;
        }
        if (null == this.linked_props) {
            return default_value;
        }
        Map<String, String> p = this.linked_props.get(target);
        if (null == p) {
            return default_value;
        }
        String value = p.get(key);
        if (null == value) {
            return default_value;
        }
        return value;
    }

    public synchronized Map<String, String> getLinkedProperties(Displayable target) {
        if (null == target || null == this.linked_props) {
            return null;
        }
        Map<String, String> m = this.linked_props.get(target);
        if (null == m) {
            return new HashMap<String, String>();
        }
        return new HashMap<String, String>(m);
    }

    public synchronized Map<Displayable, Map<String, String>> getLinkedProperties() {
        HashMap<Displayable, Map<String, String>> lp = new HashMap<Displayable, Map<String, String>>();
        if (null == this.linked_props) {
            return lp;
        }
        for (Map.Entry<Displayable, Map<String, String>> e : this.linked_props.entrySet()) {
            lp.put(e.getKey(), new HashMap<String, String>(e.getValue()));
        }
        return lp;
    }

    public void setLocked(boolean lock) {
        if (null == this.hs_linked) {
            if (this.locked == lock) {
                return;
            }
            this.locked = lock;
            this.updateInDatabase("locked");
            return;
        }
        for (Displayable d : this.getLinkedGroup(new HashSet<Displayable>())) {
            d.locked = lock;
            d.updateInDatabase("locked");
        }
    }

    public boolean isLocked2() {
        return this.locked;
    }

    public boolean isLocked() {
        if (this.locked) {
            return true;
        }
        return this.isLocked(new HashSet<Displayable>());
    }

    private final boolean isLocked(HashSet<Displayable> hs) {
        if (this.locked) {
            return true;
        }
        if (hs.contains(this)) {
            return false;
        }
        hs.add(this);
        if (null != this.hs_linked && this.hs_linked.size() > 0) {
            for (Displayable d : this.hs_linked) {
                if (!d.isLocked(hs)) continue;
                return true;
            }
        }
        return false;
    }

    public Displayable(Project project, String title, double x, double y) {
        super(project);
        this.title = title;
        this.at.translate(x, y);
    }

    public Displayable(Project project, long id, String title, boolean locked, AffineTransform at, float width, float height) {
        super(project, id);
        this.title = title;
        this.locked = locked;
        if (null != at) {
            this.at.setTransform(at);
        }
        this.width = width;
        this.height = height;
    }

    protected final void xmlError(String tag, Object default_value) {
        Displayable.xmlError(this, tag, default_value);
    }

    protected static final void xmlError(DBObject dbo, String tag, Object default_value) {
        Utils.log("WARNING: missing XML attribute '" + tag + "' in " + dbo.getClass().getSimpleName() + " #" + dbo.getId() + "\n  --> using default value:" + default_value);
    }

    public Displayable(Project project, long id, HashMap<String, String> ht, HashMap<Displayable, String> ht_links) {
        super(project, id);
        this.layer = null;
        try {
            String data = ht.get("width");
            if (null != data) {
                this.width = Float.parseFloat(data);
            } else {
                this.xmlError("width", Float.valueOf(this.width));
            }
            data = ht.get("height");
            if (null != data) {
                this.height = Float.parseFloat(data);
            } else {
                this.xmlError("height", Float.valueOf(this.height));
            }
            data = ht.get("transform");
            if (null != data) {
                String[] nums = data.substring(data.indexOf(40) + 1, data.lastIndexOf(41)).split(",");
                this.at.setTransform(Double.parseDouble(nums[0]), Double.parseDouble(nums[1]), Double.parseDouble(nums[2]), Double.parseDouble(nums[3]), Double.parseDouble(nums[4]), Double.parseDouble(nums[5]));
            } else {
                this.xmlError("transform", this.at);
            }
            data = ht.get("title");
            if (null != data) {
                this.title = -1 == data.toLowerCase().lastIndexOf("null") ? data.replaceAll("^#^", "\"") : null;
            } else {
                this.xmlError("title", this.title);
            }
            data = ht.get("style");
            if (null != data) {
                try {
                    int i_start = data.indexOf("stroke-opacity:");
                    this.alpha = -1 == i_start ? (-1 == (i_start = data.indexOf("fill-opacity:")) ? 1.0f : Float.parseFloat(data.substring(i_start + 13, data.indexOf(59, i_start + 13)).trim())) : Float.parseFloat(data.substring(i_start + 15, data.indexOf(59, i_start + 15)).trim());
                    i_start = data.indexOf("stroke:");
                    if (-1 == i_start) {
                        i_start = data.indexOf("fill:");
                    }
                    if (-1 != i_start) {
                        i_start = data.indexOf(35, data.indexOf(58, i_start + 4));
                        int i_end = data.indexOf(59, i_start + 1);
                        this.color = Utils.getRGBColorFromHex(data.substring(i_start + 1, i_end));
                    } else {
                        Utils.log2("Can't parse color for id=" + id);
                        this.color = Color.yellow;
                    }
                }
                catch (Exception es) {
                    if (null == this.color) {
                        this.color = Color.yellow;
                    }
                    Utils.log("ERROR at reading style for #" + this.id + ": " + es);
                }
            }
            if (null != (data = ht.get("locked"))) {
                this.locked = data.trim().toLowerCase().equals("true");
            }
            if (null != (data = ht.get("visible"))) {
                this.visible = data.trim().toLowerCase().equals("true");
            }
            if (null != (data = ht.get("links")) && data.length() > 0) {
                ht_links.put(this, data);
            }
            if (null != (data = ht.get("composite"))) {
                this.compositeMode = Byte.parseByte(data);
            }
            if (this.at.isIdentity()) {
                double x = 0.0;
                double y = 0.0;
                double rot = 0.0;
                data = ht.get("x");
                if (null != data) {
                    x = Double.parseDouble(data);
                }
                if (null != (data = ht.get("y"))) {
                    y = Double.parseDouble(data);
                }
                if (null != (data = ht.get("rot"))) {
                    rot = Double.parseDouble(data);
                }
                if (0.0 != x || 0.0 != y || 0.0 != rot) {
                    this.at.translate(x, y);
                    if (0.0 != rot) {
                        AffineTransform at2 = new AffineTransform();
                        at2.rotate(Math.toRadians(rot), x + (double)(this.width / 2.0f), y + (double)(this.height / 2.0f));
                        this.at.preConcatenate(at2);
                    }
                }
            }
        }
        catch (Exception ea) {
            Utils.log("ERROR: failed to read XML attributes for #" + this.id + ": " + ea);
        }
    }

    @Override
    public void paint(Graphics2D g, Rectangle srcRect, double magnification, boolean active, int channels, Layer active_layer, List<Layer> layers) {
        Utils.log2("paint g, srcRect, magnification, active, channels, active_layer, layers: not implemented yet for " + this.getClass());
    }

    @Override
    public void prePaint(Graphics2D g, Rectangle srcRect, double magnification, boolean active, int channels, Layer active_layer, List<Layer> layers) {
        this.paint(g, srcRect, magnification, active, channels, active_layer, layers);
    }

    public void paintOffscreen(Graphics2D g, Rectangle srcRect, double magnification, boolean active, int channels, Layer active_layer, List<Layer> layers) {
        this.paint(g, srcRect, magnification, active, channels, active_layer, layers);
    }

    public void setDimensions(double width, double height) {
        this.setDimensions(width, height, true);
    }

    public void setDimensions(double width, double height, boolean repaint) {
        if (width <= 0.0 || height <= 0.0) {
            return;
        }
        Rectangle b = this.getBoundingBox(null);
        if ((double)b.width == width && (double)b.height == height) {
            return;
        }
        double sx = width / (double)b.width;
        double sy = height / (double)b.height;
        this.scale(sx, sy, b.x, b.y);
        if (repaint) {
            Display.repaint(this.layer, this, 5);
        }
    }

    public void setLayer(Layer layer, boolean update_db) {
        if (null == layer || this.layer == layer) {
            return;
        }
        this.layer = layer;
        if (update_db) {
            this.updateInDatabase("layer_id");
        }
    }

    public void setLayer(Layer layer) {
        this.setLayer(layer, true);
    }

    public Layer getLayer() {
        return this.layer;
    }

    public void setTitle(String title) {
        if (null == title || 0 == title.length()) {
            return;
        }
        this.title = title;
        Display.updateTitle(this.layer, this);
        Search.repaint(this);
        this.updateInDatabase("title");
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getShortTitle() {
        String title = this.getTitle();
        if (null != title && !this.getClass().getSimpleName().toLowerCase().equals(title.toLowerCase())) {
            return title;
        }
        Rectangle b = this.getBoundingBox(null);
        return "x=" + Utils.cutNumber(b.x, 2) + " y=" + Utils.cutNumber(b.y, 2) + (null != this.layer ? " z=" + Utils.cutNumber(this.layer.getZ(), 2) : "");
    }

    public int getX() {
        return this.getBoundingBox(null).x;
    }

    public int getY() {
        return this.getBoundingBox(null).y;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public Rectangle getBoundingBox() {
        return this.getBoundingBox(null);
    }

    public Rectangle getBounds(Rectangle r, Layer layer) {
        return this.getBoundingBox(r);
    }

    public Rectangle getBoundingBox(Rectangle r) {
        return this.getBounds(null == r ? new Rectangle() : r);
    }

    protected Rectangle getBounds(Rectangle r) {
        r.x = 0;
        r.y = 0;
        r.width = (int)this.width;
        r.height = (int)this.height;
        if (this.at.getType() == 1) {
            r.x += (int)this.at.getTranslateX();
            r.y += (int)this.at.getTranslateY();
        } else {
            double[] d1 = new double[]{0.0, 0.0, this.width, 0.0, this.width, this.height, 0.0, this.height};
            double[] d2 = new double[8];
            this.at.transform(d1, 0, d2, 0, 4);
            double min_x = Double.MAX_VALUE;
            double min_y = Double.MAX_VALUE;
            double max_x = -min_x;
            double max_y = -min_y;
            for (int i = 0; i < d2.length; i += 2) {
                if (d2[i] < min_x) {
                    min_x = d2[i];
                }
                if (d2[i] > max_x) {
                    max_x = d2[i];
                }
                if (d2[i + 1] < min_y) {
                    min_y = d2[i + 1];
                }
                if (!(d2[i + 1] > max_y)) continue;
                max_y = d2[i + 1];
            }
            r.x = (int)min_x;
            r.y = (int)min_y;
            r.width = (int)(max_x - min_x);
            r.height = (int)(max_y - min_y);
        }
        return r;
    }

    public static Rectangle getBoundingBox(Collection<? extends Displayable> ds, Rectangle r) {
        Rectangle rect = null;
        Rectangle rd = new Rectangle();
        for (Displayable displayable : ds) {
            displayable.getBounds(rd);
            if (null == rect) {
                rect = (Rectangle)rd.clone();
                continue;
            }
            rect.add(rd);
        }
        if (null == r) {
            return rect;
        }
        r.setRect(rect);
        return r;
    }

    public Polygon getPerimeter() {
        if (this.at.isIdentity() || this.at.getType() == 1) {
            Rectangle r = this.getBoundingBox();
            return new Polygon(new int[]{r.x, r.x + r.width, r.x + r.width, r.x}, new int[]{r.y, r.y, r.y + r.height, r.y + r.height}, 4);
        }
        double[] po1 = new double[]{0.0, 0.0, this.width, 0.0, this.width, this.height, 0.0, this.height};
        double[] po2 = new double[8];
        this.at.transform(po1, 0, po2, 0, 4);
        return new Polygon(new int[]{(int)po2[0], (int)po2[2], (int)po2[4], (int)po2[6]}, new int[]{(int)po2[1], (int)po2[3], (int)po2[5], (int)po2[7]}, 4);
    }

    public Polygon getPerimeter(int w, int n, int e, int s) {
        if (this.at.isIdentity() || this.at.getType() == 1) {
            Rectangle r = this.getBoundingBox();
            return new Polygon(new int[]{r.x - w, r.x + r.width + w + e, r.x + r.width + w + e, r.x - w}, new int[]{r.y - n, r.y - n, r.y + r.height + n + s, r.y + r.height + n + s}, 4);
        }
        double[] po1 = new double[]{-w, -n, this.width + (float)w + (float)e, -n, this.width + (float)w + (float)e, this.height + (float)n + (float)s, -w, this.height + (float)n + (float)s};
        double[] po2 = new double[8];
        this.at.transform(po1, 0, po2, 0, 4);
        return new Polygon(new int[]{(int)po2[0], (int)po2[2], (int)po2[4], (int)po2[6]}, new int[]{(int)po2[1], (int)po2[3], (int)po2[5], (int)po2[7]}, 4);
    }

    public boolean contains(double x_p, double y_p) {
        return this.getPerimeter().contains(x_p, y_p);
    }

    public boolean contains(Layer layer, double x_p, double y_p) {
        return this.contains(x_p, y_p);
    }

    public void setAlpha(float alpha) {
        this.setAlpha(alpha, true);
    }

    protected void setAlpha(float alpha, boolean update) {
        if (alpha != this.alpha && alpha >= 0.0f && alpha <= 1.0f) {
            this.alpha = alpha;
            if (update) {
                this.updateInDatabase("alpha");
                Display3D.setTransparency(this, alpha);
            }
        }
    }

    public float getAlpha() {
        return this.alpha;
    }

    public Color getColor() {
        return this.color;
    }

    public HashSet<Displayable> getLinked() {
        return this.hs_linked;
    }

    public HashSet<Displayable> getLinked(Class<?> c) {
        if (null == this.hs_linked) {
            return null;
        }
        HashSet<Displayable> hs = new HashSet<Displayable>();
        for (Displayable d : this.hs_linked) {
            if (d.getClass() != c) continue;
            hs.add(d);
        }
        return hs;
    }

    public HashSet<Displayable> getLinkedGroup(HashSet<Displayable> hs) {
        if (null == hs) {
            hs = new HashSet();
        } else if (hs.contains(this)) {
            return hs;
        }
        hs.add(this);
        if (null == this.hs_linked) {
            return hs;
        }
        for (Displayable d : this.hs_linked) {
            d.getLinkedGroup(hs);
        }
        return hs;
    }

    public void mousePressed(MouseEvent me, Layer layer, int x_p, int y_p, double mag) {
        Utils.log2("mousePressed not implemented yet for " + this.getClass().getName());
    }

    public void mouseDragged(MouseEvent me, Layer layer, int x_p, int y_p, int x_d, int y_d, int x_d_old, int y_d_old) {
        Utils.log2("mouseDragged not implemented yet for " + this.getClass().getName());
    }

    public void mouseReleased(MouseEvent me, Layer layer, int x_p, int y_p, int x_d, int y_d, int x_r, int y_r) {
        Utils.log2("mouseReleased not implemented yet for " + this.getClass().getName());
    }

    public void mouseWheelMoved(MouseWheelEvent mwe) {
    }

    public void keyPressed(KeyEvent ke) {
        int key_code = ke.getKeyCode();
        switch (key_code) {
            case 10: {
                ke.consume();
                break;
            }
            case 38: {
                this.translate(0.0, -1.0, true);
                ke.consume();
                break;
            }
            case 40: {
                this.translate(0.0, 1.0, true);
                ke.consume();
                break;
            }
            case 37: {
                this.translate(-1.0, 0.0, true);
                ke.consume();
                break;
            }
            case 39: {
                this.translate(1.0, 0.0, true);
                ke.consume();
                break;
            }
            case 27: {
                Display.setActive(ke, null);
                ke.consume();
            }
        }
        Rectangle box = this.getLinkedBox(true);
        if (ke.isConsumed() && 27 != key_code) {
            Display.repaint(this.layer, box, 5);
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public final void setVisible(boolean visible) {
        this.setVisible(visible, true);
    }

    public void setVisible(boolean visible, boolean repaint) {
        if (visible == this.visible) {
            return;
        }
        this.visible = visible;
        if (repaint) {
            Display.repaint(this.layer, this, 5);
        }
        this.updateInDatabase("visible");
    }

    public void repaint() {
        Utils.log("called repaint() for " + this.getClass().getName());
        Display.repaint(this.layer, this, 5);
    }

    public void setColor(Color color) {
        if (null == color || color.equals(this.color)) {
            return;
        }
        this.color = color;
        last_color = color;
        this.updateInDatabase("color");
        Display.repaint(this.layer, this, 5);
        Display3D.setColor(this, color);
    }

    public void destroy() {
        this.layer = null;
    }

    public boolean isOutOfRepaintingClip(double magnification, Rectangle srcRect, Rectangle clipRect) {
        if (!this.visible) {
            return true;
        }
        Rectangle box = this.getBoundingBox(null);
        if (null != clipRect && null != srcRect) {
            int screen_x = (int)((double)(box.x - srcRect.x) * magnification);
            int screen_y = (int)((double)(box.y - srcRect.y) * magnification);
            int screen_width = (int)((double)box.width * magnification);
            int screen_height = (int)((double)box.height * magnification);
            if (screen_x + screen_width < clipRect.x || screen_y + screen_height < clipRect.y || screen_x > clipRect.x + clipRect.width || screen_y > clipRect.y + clipRect.height) {
                return true;
            }
        }
        return null != srcRect && (box.x + box.width < srcRect.x || box.y + box.height < srcRect.y || box.x > srcRect.x + srcRect.width || box.y > srcRect.y + srcRect.height);
    }

    public boolean isOutOfRepaintingClip(Rectangle clipRect, double scale) {
        if (!this.visible) {
            return true;
        }
        Rectangle box = this.getBoundingBox();
        if (null != clipRect) {
            int screen_x = (int)((double)box.x * scale);
            int screen_y = (int)((double)box.y * scale);
            int screen_width = (int)((double)box.width * scale);
            int screen_height = (int)((double)box.height * scale);
            if (screen_x + screen_width < clipRect.x || screen_y + screen_height < clipRect.y || screen_x > clipRect.x + clipRect.width || screen_y > clipRect.y + clipRect.height) {
                return true;
            }
        }
        return false;
    }

    protected boolean remove2(boolean check) {
        return this.remove(check);
    }

    @Override
    public boolean remove(boolean check) {
        if (super.remove(check) && this.layer.remove(this)) {
            this.unlink();
            this.removeLinkedPropertiesFromOrigins();
            Search.remove(this);
            Display.flush(this);
            this.project.decache(this);
            return true;
        }
        Utils.log("Failed to remove " + this.getClass().getName() + " " + this);
        return false;
    }

    public void link(Displayable d) {
        this.link(d, true);
    }

    public void link(Displayable d, boolean update_database) {
        if (this == d) {
            return;
        }
        if (null == this.hs_linked) {
            this.hs_linked = new HashSet();
        }
        this.hs_linked.add(d);
        if (null == d.hs_linked) {
            d.hs_linked = new HashSet();
        }
        d.hs_linked.add(this);
        if (update_database) {
            this.project.getLoader().addCrossLink(this.project.getId(), this.id, d.id);
        }
    }

    public void unlink() {
        if (null == this.hs_linked) {
            return;
        }
        Displayable[] displ = new Displayable[this.hs_linked.size()];
        this.hs_linked.toArray(displ);
        for (int i = 0; i < displ.length; ++i) {
            this.unlink(displ[i]);
        }
        this.hs_linked = null;
    }

    public void unlink(Displayable d) {
        if (this == d) {
            return;
        }
        if (null == this.hs_linked) {
            return;
        }
        if (!this.hs_linked.remove(d) || !d.hs_linked.remove(this)) {
            Utils.log("Database inconsistency: two displayables had a non-reciprocal link. BEWARE of other errors.");
        }
        this.project.getLoader().removeCrossLink(this.id, d.id);
    }

    public boolean isLinked() {
        if (null == this.hs_linked) {
            return false;
        }
        return !this.hs_linked.isEmpty();
    }

    public boolean isLinked(Class<?> c) {
        if (null == this.hs_linked) {
            return false;
        }
        for (Displayable d : this.hs_linked) {
            if (!c.isInstance(d)) continue;
            return true;
        }
        return false;
    }

    public boolean isLinked(Displayable d) {
        if (null == this.hs_linked) {
            return false;
        }
        return this.hs_linked.contains(d);
    }

    public boolean isOnlyLinkedTo(Class<?> c) {
        if (null == this.hs_linked || this.hs_linked.isEmpty()) {
            return true;
        }
        for (Displayable d : this.hs_linked) {
            if (d.getClass() == c) continue;
            return false;
        }
        return true;
    }

    public boolean isOnlyLinkedTo(Class<?> c, Layer layer) {
        if (null == this.hs_linked || this.hs_linked.isEmpty()) {
            return true;
        }
        for (Displayable d : this.hs_linked) {
            if (d.getClass() == c && d.layer == this.layer) continue;
            return false;
        }
        return true;
    }

    public boolean linkPatches() {
        this.unlinkAll(Patch.class);
        ArrayList<Displayable> al = this.layer.getDisplayables(Patch.class);
        Polygon perimeter = this.getPerimeter();
        if (null == perimeter) {
            return false;
        }
        Rectangle box = new Rectangle();
        boolean must_lock = false;
        for (Displayable displ : al) {
            if (!perimeter.intersects(displ.getBoundingBox(box))) continue;
            this.link(displ);
            if (!displ.locked) continue;
            must_lock = true;
        }
        if (must_lock && !this.locked) {
            this.setLocked(true);
            return true;
        }
        return false;
    }

    public void unlinkAll(Class<?> c) {
        if (!this.isLinked() || null == this.hs_linked) {
            return;
        }
        Displayable[] displ = new Displayable[this.hs_linked.size()];
        this.hs_linked.toArray(displ);
        for (int i = 0; i < displ.length; ++i) {
            if (displ[i].getClass() != c) continue;
            this.unlink(displ[i]);
        }
    }

    public boolean intersects(Displayable d) {
        return this.intersects(new Area(d.getPerimeter()));
    }

    public boolean intersects(Area area) {
        Area a = new Area(this.getPerimeter());
        a.intersect(area);
        Rectangle b = a.getBounds();
        return 0 != b.width && 0 != b.height;
    }

    public boolean intersects(Layer layer, Area area) {
        return this.intersects(area);
    }

    public boolean intersects(Layer layer, Rectangle r) {
        return this.getBoundingBox(null).intersects(r);
    }

    public Area getIntersection(Displayable d) {
        Area a = new Area(this.getPerimeter());
        a.intersect(new Area(d.getPerimeter()));
        return a;
    }

    public Rectangle getLinkedBox(boolean same_layer) {
        if (null == this.hs_linked || this.hs_linked.isEmpty()) {
            return this.getBoundingBox();
        }
        Rectangle box = new Rectangle();
        this.accumulateLinkedBox(same_layer, new HashSet<Displayable>(), box);
        return box;
    }

    private void accumulateLinkedBox(boolean same_layer, HashSet<Displayable> hs_done, Rectangle box) {
        if (hs_done.contains(this)) {
            return;
        }
        hs_done.add(this);
        box.add(this.getBoundingBox(null));
        for (Displayable d : this.hs_linked) {
            if (same_layer && !(d instanceof ZDisplayable) && d.layer != this.layer) continue;
            d.accumulateLinkedBox(same_layer, hs_done, box);
        }
    }

    public String toString() {
        return new StringBuilder(this.title.length() + 20).append(this.title).append(!(this instanceof ZDisplayable) && null != this.layer ? " z=" + this.layer.getZ() : "").append(' ').append('#').append(this.id).toString();
    }

    public abstract boolean isDeletable();

    public boolean canSendTo(Layer layer) {
        return true;
    }

    public void exportSVG(StringBuffer data, double z_scale, String indent) {
    }

    public void snapTo(int cx, int cy, int x_p, int y_p) {
    }

    public void adjustProperties() {
        GenericDialog gd = this.makeAdjustPropertiesDialog();
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        this.processAdjustPropertiesDialog(gd);
    }

    protected GenericDialog makeAdjustPropertiesDialog() {
        Rectangle box = this.getBoundingBox(null);
        GD gd = new GD("Properties of #" + this.id, this);
        gd.addStringField("title: ", this.title);
        gd.addNumericField("x: ", box.x, 2);
        gd.addNumericField("y: ", box.y, 2);
        gd.addNumericField("scale_x: ", 1.0, 2);
        gd.addNumericField("scale_y: ", 1.0, 2);
        gd.addNumericField("rot (degrees): ", 0.0, 2);
        gd.addSlider("alpha: ", 0.0, 100.0, (int)(this.alpha * 100.0f));
        gd.addCheckbox("visible", this.visible);
        gd.addSlider("Red: ", 0.0, 255.0, this.color.getRed());
        gd.addSlider("Green: ", 0.0, 255.0, this.color.getGreen());
        gd.addSlider("Blue: ", 0.0, 255.0, this.color.getBlue());
        gd.addCheckbox("locked", this.locked);
        final Scrollbar alp = (Scrollbar)gd.getSliders().get(0);
        final Scrollbar red = (Scrollbar)gd.getSliders().get(1);
        final Scrollbar green = (Scrollbar)gd.getSliders().get(2);
        final Scrollbar blue = (Scrollbar)gd.getSliders().get(3);
        TextField talp = (TextField)gd.getNumericFields().get(5);
        TextField tred = (TextField)gd.getNumericFields().get(6);
        TextField tgreen = (TextField)gd.getNumericFields().get(7);
        TextField tblue = (TextField)gd.getNumericFields().get(8);
        SliderListener sla = new SliderListener(){

            @Override
            public void update() {
                Displayable.this.setAlpha((float)alp.getValue() / 100.0f);
            }
        };
        SliderListener slc = new SliderListener(){

            @Override
            public void update() {
                Displayable.this.setColor(new Color(red.getValue(), green.getValue(), blue.getValue()));
            }
        };
        alp.addAdjustmentListener(sla);
        red.addAdjustmentListener(slc);
        green.addAdjustmentListener(slc);
        blue.addAdjustmentListener(slc);
        talp.addTextListener(sla);
        tred.addTextListener(slc);
        tgreen.addTextListener(slc);
        tblue.addTextListener(slc);
        gd.addChoice("composite mode: ", compositeModes, compositeModes[this.compositeMode]);
        return gd;
    }

    protected DoEdit processAdjustPropertiesDialog(GenericDialog gd) {
        HashSet<Displayable> hs = this.getLinkedGroup(new HashSet<Displayable>());
        this.layer.getParent().addTransformStep(hs);
        String title1 = gd.getNextString();
        double x1 = gd.getNextNumber();
        double y1 = gd.getNextNumber();
        double sx = gd.getNextNumber();
        double sy = gd.getNextNumber();
        double rot1 = gd.getNextNumber();
        float alpha1 = (float)gd.getNextNumber() / 100.0f;
        DoEdit prev = new DoEdit(this);
        if (Double.isNaN(x1) || Double.isNaN(y1) || Double.isNaN(sx) || Double.isNaN(sy) || Float.isNaN(alpha1)) {
            Utils.showMessage("Invalid values!");
            return null;
        }
        Color co = new Color((int)gd.getNextNumber(), (int)gd.getNextNumber(), (int)gd.getNextNumber());
        if (!co.equals(this.color)) {
            prev.add("color", this.color);
            this.color = co;
            this.updateInDatabase("color");
        }
        boolean visible1 = gd.getNextBoolean();
        boolean locked1 = gd.getNextBoolean();
        this.compositeMode = (byte)gd.getNextChoiceIndex();
        if (!this.title.equals(title1)) {
            prev.add("title", title1);
            this.setTitle(title1);
        }
        if (null != hs) {
            prev.add(new DoTransforms().addAll(hs));
        } else {
            prev.add("at", this.getAffineTransformCopy());
        }
        Rectangle b = this.getBoundingBox(null);
        if (x1 != (double)b.x || y1 != (double)b.y) {
            if (null != hs) {
                Object box_old = this.getBoundingBox();
                if (0 == ((Rectangle)box_old).width || 0 == ((Rectangle)box_old).height) {
                    if (this instanceof Profile) {
                        ((Profile)this).calculateBoundingBox(true);
                        box_old = this.getBoundingBox();
                    } else {
                        Utils.showMessage("Some error ocurred: zero width or height ob the object to adjust.\nUnlink this object '" + this + "' and adjust carefully");
                        return null;
                    }
                }
                this.setLocation(x1, y1);
                Rectangle b2 = this.getBoundingBox(null);
                int dx = b2.x - b.x;
                int dy = b2.y - b.y;
                for (Displayable d : hs) {
                    if (this.equals(d)) continue;
                    d.translate(dx, dy, false);
                }
            } else {
                this.setLocation(x1, y1);
            }
        }
        if (1.0 != sx || 1.0 != sy) {
            if (null != hs) {
                for (Displayable d : hs) {
                    d.scale(sx, sy, b.y + b.width / 2, b.y + b.height / 2, false);
                }
            } else {
                this.scale(sx, sy, b.y + b.width / 2, b.y + b.height / 2, false);
            }
        }
        if (rot1 != 0.0) {
            double rads = Math.toRadians(rot1);
            if (null != hs) {
                for (Displayable d : hs) {
                    d.rotate(rads, b.x + b.width / 2, b.y + b.height / 2, false);
                }
            } else {
                this.rotate(rads, b.x + b.width / 2, b.y + b.height / 2, false);
            }
        }
        if (alpha1 != this.alpha) {
            prev.add("alpha", Float.valueOf(alpha1));
            this.setAlpha(alpha1, true);
        }
        if (visible1 != this.visible) {
            prev.add("visible", visible1);
            this.setVisible(visible1);
            Display.updateCheckboxes(this, 2, visible1);
        }
        if (locked1 != this.locked) {
            prev.add("locked", locked1);
            this.setLocked(locked1);
        }
        this.getLayerSet().addEditStep(prev);
        Display.updateSelection();
        Display.repaint(this.getLayer());
        HashSet<Displayable> lg = this.getLinkedGroup(null);
        Display.updateCheckboxes(lg, 4);
        Display.updateCheckboxes(lg, 1);
        return prev;
    }

    public static void exportDTD(String type, StringBuilder sb_header, HashSet<String> hs, String indent) {
        sb_header.append(indent).append(TAG_ATTR1).append(type).append(" oid").append(TAG_ATTR2).append(indent).append(TAG_ATTR1).append(type).append(" layer_id").append(TAG_ATTR2).append(indent).append(TAG_ATTR1).append(type).append(" transform").append(TAG_ATTR2).append(indent).append(TAG_ATTR1).append(type).append(" style").append(TAG_ATTR2).append(indent).append(TAG_ATTR1).append(type).append(" locked").append(TAG_ATTR2).append(indent).append(TAG_ATTR1).append(type).append(" visible").append(TAG_ATTR2).append(indent).append(TAG_ATTR1).append(type).append(" title").append(TAG_ATTR2).append(indent).append(TAG_ATTR1).append(type).append(" links").append(TAG_ATTR2).append(indent).append(TAG_ATTR1).append(type).append(" composite").append(TAG_ATTR2);
    }

    public static void exportDTD(StringBuilder sb_header, HashSet<String> hs, String indent) {
        if (!hs.contains("t2_prop")) {
            sb_header.append(indent).append("<!ELEMENT t2_prop EMPTY>\n").append(indent).append(TAG_ATTR1).append("t2_prop key").append(TAG_ATTR2).append(indent).append(TAG_ATTR1).append("t2_prop value").append(TAG_ATTR2);
        }
        if (!hs.contains("t2_linked_prop")) {
            sb_header.append(indent).append("<!ELEMENT t2_linked_prop EMPTY>\n").append(indent).append(TAG_ATTR1).append("t2_linked_prop target_id").append(TAG_ATTR2).append(indent).append(TAG_ATTR1).append("t2_linked_prop key").append(TAG_ATTR2).append(indent).append(TAG_ATTR1).append("t2_linked_prop value").append(TAG_ATTR2);
        }
        if (!hs.contains("t2_annot")) {
            sb_header.append(indent).append("<!ELEMENT t2_annot EMPTY>\n");
        }
    }

    protected static String commonDTDChildren() {
        return "t2_prop,t2_linked_prop,t2_annot";
    }

    @Override
    public void exportXML(StringBuilder sb_body, String in, XMLOptions options) {
        double[] a = new double[6];
        this.at.getMatrix(a);
        sb_body.append(in).append("oid=\"").append(this.id).append("\"\n").append(in).append("width=\"").append(this.width).append("\"\n").append(in).append("height=\"").append(this.height).append("\"\n").append(in).append("transform=\"matrix(").append(a[0]).append(',').append(a[1]).append(',').append(a[2]).append(',').append(a[3]).append(',').append(a[4]).append(',').append(a[5]).append(")\"\n");
        if (this.locked) {
            sb_body.append(in).append("locked=\"true\"\n");
        }
        if (!this.visible) {
            sb_body.append(in).append("visible=\"false\"\n");
        }
        if (null != this.title && this.title.length() > 0) {
            sb_body.append(in).append("title=\"").append(this.title.replaceAll("\"", "^#^")).append("\"\n");
        }
        if (0 != this.compositeMode) {
            sb_body.append(in).append("composite=\"").append(this.compositeMode).append("\"\n");
        }
        sb_body.append(in).append("links=\"");
        if (null != this.hs_linked && 0 != this.hs_linked.size()) {
            long[] ids = new long[this.hs_linked.size()];
            int ii = 0;
            for (Displayable d : this.hs_linked) {
                ids[ii++] = d.id;
            }
            Arrays.sort(ids);
            for (int g = 0; g < ids.length; ++g) {
                sb_body.append(ids[g]).append(',');
            }
            sb_body.setLength(sb_body.length() - 1);
        }
        sb_body.append("\"\n");
    }

    protected synchronized void restXML(StringBuilder sb_body, String in, XMLOptions options) {
        if (null != this.props && this.props.size() > 0) {
            for (Map.Entry<String, String> entry : this.props.entrySet()) {
                String value = entry.getValue();
                if (null == value) continue;
                sb_body.append(in).append("<t2_prop key=\"").append(entry.getKey()).append("\" value=\"").append(Displayable.getXMLSafeValue(entry, value)).append("\" />\n");
            }
        }
        if (null != this.linked_props && !this.linked_props.isEmpty()) {
            for (Map.Entry<Object, Object> entry : this.linked_props.entrySet()) {
                Displayable target = (Displayable)entry.getKey();
                for (Map.Entry<String, String> entry2 : ((Map)entry.getValue()).entrySet()) {
                    String value = (String)entry2.getValue();
                    if (null == value) continue;
                    sb_body.append(in).append("<t2_linked_prop target_id=\"").append(target.id).append("\" key=\"").append((String)entry2.getKey()).append("\" value=\"").append(Displayable.getXMLSafeValue(entry2, value)).append("\" />\n");
                }
            }
        }
        if (null != this.annotation && this.annotation.length() > 0) {
            sb_body.append(in).append("<t2_annot>\n").append(this.annotation.replace("<", "&lt;")).append('\n').append(in).append("</t2_annot>\n");
        }
    }

    public static final String getXMLSafeValue(Map.Entry<String, String> e, String value) {
        if (-1 != value.indexOf(34)) {
            Utils.log("Property " + e.getKey() + " contains a \" which is being replaced by a single quote");
            value = value.replace('\"', '\'');
        }
        if (-1 != value.indexOf(10)) {
            Utils.log("Property " + e.getKey() + " contains a newline char which is being replaced by a space.");
            value = value.replace('\n', ' ');
        }
        return value;
    }

    public static final String getXMLSafeValue(String value) {
        if (-1 != value.indexOf(34)) {
            value = value.replace('\"', '\'');
        }
        if (-1 != value.indexOf(10)) {
            value = value.replace('\n', ' ');
        }
        return value;
    }

    public boolean hasLinkedGroupWithinLayer(Layer la) {
        for (Displayable d : this.getLinkedGroup(new HashSet<Displayable>())) {
            if (d.layer.equals(la)) continue;
            return false;
        }
        return true;
    }

    public static double[][] rotatePoints(double[][] p, double rot, double xo, double yo) {
        if (null == p) {
            Utils.log2("WARNING: Displayable.rotatePoints received a null points array.");
            return new double[0][0];
        }
        int length = p[0].length;
        double[][] pr = new double[p.length][length];
        for (int i = 0; i < length; ++i) {
            double x = p[0][i];
            double y = p[1][i];
            double b1 = M.getAngle(x - xo, y - yo);
            double b2 = b1 + rot;
            double hypot = Math.sqrt((x - xo) * (x - xo) + (y - yo) * (y - yo));
            pr[0][i] = xo + Math.cos(b2) * hypot;
            pr[1][i] = yo + Math.sin(b2) * hypot;
        }
        return pr;
    }

    public static double[][] scalePoints(double[][] p, double sx, double sy, double xo, double yo) {
        int length = p[0].length;
        double[][] ps = new double[p.length][length];
        for (int i = 0; i < length; ++i) {
            ps[0][i] = xo + (p[0][i] - xo) * sx;
            ps[1][i] = yo + (p[1][i] - yo) * sy;
        }
        return ps;
    }

    public static double[][] displacePoints(double[][] p, double dx, double dy) {
        int length = p[0].length;
        double[][] pd = new double[p.length][length];
        for (int i = 0; i < length; ++i) {
            pd[0][i] = p[0][i] + dx;
            pd[1][i] = p[1][i] + dy;
        }
        return pd;
    }

    public static void transformPoint(double[][] p, int i, double dx, double dy, double rot, double xo, double yo) {
        double[] dArray = p[0];
        int n = i;
        dArray[n] = dArray[n] + dx;
        double[] dArray2 = p[1];
        int n2 = i;
        dArray2[n2] = dArray2[n2] + dy;
        if (0.0 != rot) {
            double hypot = Math.sqrt(Math.pow(p[0][i] - xo, 2.0) + Math.pow(p[1][i] - yo, 2.0));
            double angle = M.getAngle(p[0][i] - xo, p[1][i] - yo);
            p[0][i] = xo + Math.cos(angle + rot) * hypot;
            p[1][i] = yo + Math.sin(angle + rot) * hypot;
        }
    }

    protected static int findNearestPoint(double[][] a, int n_points, double x_p, double y_p) {
        if (0 == n_points) {
            return -1;
        }
        double min_dist = Double.MAX_VALUE;
        int index = -1;
        for (int i = 0; i < n_points; ++i) {
            double sq_dist = Math.pow(a[0][i] - x_p, 2.0) + Math.pow(a[1][i] - y_p, 2.0);
            if (!(sq_dist < min_dist)) continue;
            index = i;
            min_dist = sq_dist;
        }
        return index;
    }

    protected static int findNearestPoint(double[][] a, long[] p_layer, int n_points, double x_p, double y_p, long lid) {
        if (0 == n_points) {
            return -1;
        }
        double min_dist = Double.MAX_VALUE;
        int index = -1;
        for (int i = 0; i < n_points; ++i) {
            double sq_dist;
            if (p_layer[i] != lid || !((sq_dist = Math.pow(a[0][i] - x_p, 2.0) + Math.pow(a[1][i] - y_p, 2.0)) < min_dist)) continue;
            index = i;
            min_dist = sq_dist;
        }
        return index;
    }

    public Displayable clone() {
        return this.clone(this.project);
    }

    public abstract Displayable clone(Project var1, boolean var2);

    public Displayable clone(Project pr) {
        return this.clone(pr, false);
    }

    public LayerSet getLayerSet() {
        if (null != this.layer) {
            return this.layer.getParent();
        }
        return null;
    }

    @Override
    public boolean updateInDatabase(String key) {
        return super.updateInDatabase(key);
    }

    public static Rectangle getMinimalBoundingBox(Displayable[] d) {
        Rectangle box = d[0].getBoundingBox();
        Rectangle tmp = new Rectangle();
        for (int i = 1; i < d.length; ++i) {
            box.add(d[i].getBoundingBox(tmp));
        }
        return box;
    }

    public AffineTransform getAffineTransform() {
        return this.at;
    }

    public AffineTransform getAffineTransformCopy() {
        return (AffineTransform)this.at.clone();
    }

    public void setAffineTransform(AffineTransform at) {
        this.at.setTransform(at);
        this.updateInDatabase("transform");
        this.updateBucket();
    }

    public void translate(double dx, double dy, boolean linked) {
        if (Double.isNaN(dx) || Double.isNaN(dy)) {
            return;
        }
        AffineTransform at2 = new AffineTransform();
        at2.translate(dx, dy);
        this.preTransform(at2, linked);
    }

    public void translate(double dx, double dy) {
        this.translate(dx, dy, true);
    }

    public void rotate(double radians, double xo, double yo) {
        this.rotate(radians, xo, yo, true);
    }

    public void rotate(double radians, double xo, double yo, boolean linked) {
        if (Double.isNaN(radians) || Double.isNaN(xo) || Double.isNaN(yo)) {
            return;
        }
        AffineTransform at2 = new AffineTransform();
        at2.rotate(radians, xo, yo);
        this.preTransform(at2, linked);
    }

    public static final void preConcatenate(AffineTransform at, Collection<Displayable> ds) {
        if (ds.isEmpty()) {
            return;
        }
        LayerSet ls = ds.iterator().next().getLayerSet();
        HashSet<Long> layerIds = new HashSet<Long>();
        for (Displayable d : ds) {
            d.at.preConcatenate(at);
            layerIds.addAll(d.getLayerIds());
        }
        for (Long lid : layerIds) {
            ls.getLayer(lid).recreateBuckets();
        }
    }

    public void updateBucket() {
        if (null != this.getBucketable()) {
            this.getBucketable().updateBucket(this, this.layer);
        }
    }

    public void scale(double sx, double sy, double xo, double yo) {
        this.scale(sx, sy, xo, yo, true);
    }

    public void scale(double sx, double sy, double xo, double yo, boolean linked) {
        if (Double.isNaN(sx) || Double.isNaN(sy) || Double.isNaN(xo) || Double.isNaN(yo)) {
            return;
        }
        AffineTransform at2 = new AffineTransform();
        at2.translate(xo, yo);
        at2.scale(sx, sy);
        at2.translate(-xo, -yo);
        this.preTransform(at2, linked);
    }

    public void setLocation(double x, double y) {
        if (Double.isNaN(x) || Double.isNaN(y)) {
            return;
        }
        Rectangle b = this.getBoundingBox(null);
        this.translate(x - (double)b.x, y - (double)b.y, false);
        this.updateBucket();
    }

    public Point2D.Double transformPoint(double px, double py) {
        Point2D.Double pSrc = new Point2D.Double(px, py);
        if (this.at.isIdentity()) {
            return pSrc;
        }
        Point2D.Double pDst = new Point2D.Double();
        this.at.transform(pSrc, pDst);
        return pDst;
    }

    public Point2D.Double inverseTransformPoint(double px, double py) {
        Point2D.Double pSrc = new Point2D.Double(px, py);
        if (this.at.isIdentity()) {
            return pSrc;
        }
        Point2D.Double pDst = new Point2D.Double();
        try {
            this.at.inverseTransform(pSrc, pDst);
        }
        catch (NoninvertibleTransformException nite) {
            IJError.print(nite);
        }
        return pDst;
    }

    public final Rectangle transformRectangle(Rectangle r) {
        if (this.at.isIdentity()) {
            return (Rectangle)r.clone();
        }
        return new Area(r).createTransformedArea(this.at).getBounds();
    }

    public double[][] transformPoints(double[][] p) {
        return Displayable.transformPoints(this.at, p, p[0].length);
    }

    protected double[][] transformPoints(double[][] p, int length) {
        return Displayable.transformPoints(this.at, p, length);
    }

    public double[][] transformPoints(double[][] p, AffineTransform additional) {
        return this.transformPoints(p, p[0].length, additional);
    }

    protected final double[][] transformPoints(double[][] p, int length, AffineTransform additional) {
        if (null == additional) {
            return Displayable.transformPoints(this.at, p, length);
        }
        AffineTransform aff = new AffineTransform(this.at);
        aff.preConcatenate(additional);
        return Displayable.transformPoints(aff, p, length);
    }

    protected static final double[][] transformPoints(AffineTransform aff, double[][] p, int length) {
        if (aff.isIdentity()) {
            return p;
        }
        double[] p2a = new double[length * 2];
        int i = 0;
        int j = 0;
        while (i < length) {
            p2a[j] = p[0][i];
            p2a[j + 1] = p[1][i];
            ++i;
            j += 2;
        }
        double[] p2b = new double[length * 2];
        aff.transform(p2a, 0, p2b, 0, length);
        double[][] p3 = new double[2][length];
        int i2 = 0;
        int j2 = 0;
        while (i2 < length) {
            p3[0][i2] = p2b[j2];
            p3[1][i2] = p2b[j2 + 1];
            ++i2;
            j2 += 2;
        }
        return p3;
    }

    protected double[] transformPoints(double[] p, AffineTransform additional) {
        if (null == additional) {
            return Displayable.transformPoints(this.at, p);
        }
        AffineTransform aff = new AffineTransform(this.at);
        aff.preConcatenate(additional);
        return Displayable.transformPoints(aff, p);
    }

    protected static double[] transformPoints(AffineTransform aff, double[] p) {
        double[] p2 = new double[p.length];
        aff.transform(p, 0, p2, 0, p.length / 2);
        return p2;
    }

    protected double[] transformPoints(double[] p) {
        return Displayable.transformPoints(this.at, p);
    }

    protected float[] transformPoints(float[] p) {
        float[] p2 = new float[p.length];
        this.at.transform(p, 0, p2, 0, p.length / 2);
        return p2;
    }

    public void transform(AffineTransform at) {
        for (Displayable d : this.getLinkedGroup(new HashSet<Displayable>())) {
            d.at.concatenate(at);
            d.updateInDatabase("transform");
            d.updateBucket();
        }
    }

    public void preTransform(AffineTransform affine, boolean linked) {
        if (linked) {
            for (Displayable d : this.getLinkedGroup(null)) {
                d.at.preConcatenate(affine);
                d.updateInDatabase("transform");
                d.updateBucket();
            }
        } else {
            this.at.preConcatenate(affine);
            this.updateInDatabase("transform");
            this.updateBucket();
        }
    }

    public void paintAsBox(Graphics2D g) {
        double[] c = new double[]{0.0, 0.0, this.width, 0.0, this.width, this.height, 0.0, this.height};
        double[] c2 = new double[8];
        this.at.transform(c, 0, c2, 0, 4);
        g.setColor(this.color);
        g.drawLine((int)c2[0], (int)c2[1], (int)c2[2], (int)c2[3]);
        g.drawLine((int)c2[2], (int)c2[3], (int)c2[4], (int)c2[5]);
        g.drawLine((int)c2[4], (int)c2[5], (int)c2[6], (int)c2[7]);
        g.drawLine((int)c2[6], (int)c2[7], (int)c2[0], (int)c2[1]);
    }

    public void paintSnapshot(Graphics2D g, Layer layer, List<Layer> layers, Rectangle srcRect, double mag) {
        switch (layer.getParent().getSnapshotsMode()) {
            case 0: {
                this.paint(g, srcRect, mag, false, -1, layer, layers);
                return;
            }
            case 1: {
                this.paintAsBox(g);
                return;
            }
        }
    }

    public DBObject findById(long id) {
        if (this.id == id) {
            return this;
        }
        return null;
    }

    public ResultsTable measure(ResultsTable rt) {
        Utils.showMessage("Not implemented yet for " + Project.getName(this.getClass()) + " [class " + this.getClass().getName() + "]");
        return rt;
    }

    public Bucketable getBucketable() {
        return this.layer;
    }

    protected double getNameId() {
        double nameid = 0.0;
        if (null != this.title) {
            try {
                nameid = Double.parseDouble(this.title.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return nameid;
    }

    final synchronized boolean setDataPackage(DataPackage pkg) {
        if (pkg.getClass() != this.getInternalDataPackageClass()) {
            Utils.log2("ERROR: cannot set " + pkg.getClass() + " to " + this.getClass());
            return false;
        }
        try {
            return pkg.to2(this);
        }
        catch (Exception e) {
            IJError.print(e);
            return false;
        }
    }

    Object getDataPackage() {
        Utils.log2("Displayable.getDataPackage not implemented yet for " + this.getClass());
        return null;
    }

    Class<?> getInternalDataPackageClass() {
        return DataPackage.class;
    }

    public static final boolean areThereLayerCrossLinks(Set<Layer> sublist, boolean ignore_stacks) {
        if (null == sublist || 0 == sublist.size()) {
            return false;
        }
        for (Layer l : sublist) {
            for (Displayable d : l.getDisplayables(Patch.class)) {
                if (!d.isLinked()) continue;
                for (Displayable other : d.getLinked()) {
                    Class<?> c = other.getClass();
                    if (!(!ignore_stacks && Patch.class == c && other.layer != d.layer || Profile.class == c && other.getLinked(Profile.class).size() > 0) && !ZDisplayable.class.isAssignableFrom(c)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    void removeTag(Tag tag) {
    }

    public Collection<Long> getLayerIds() {
        return Arrays.asList(this.layer.getId());
    }

    public Collection<Layer> getLayersWithData() {
        Collection<Long> lids = this.getLayerIds();
        ArrayList<Layer> layers = new ArrayList<Layer>(lids.size());
        LayerSet layer_set = this.getLayerSet();
        for (Long l : lids) {
            layers.add(layer_set.getLayer(l));
        }
        return layers;
    }

    public Area getArea() {
        return new Area(this.getPerimeter());
    }

    public Area getAreaAt(Layer layer) {
        return this.getArea();
    }

    protected Area getAreaForBucket(Layer layer) {
        return this.getAreaAt(layer);
    }

    protected boolean isRoughlyInside(Layer layer, Rectangle r) {
        Area a = this.getAreaForBucket(layer);
        if (a == null) {
            return false;
        }
        return a.getBounds().intersects(r);
    }

    public void setAnnotation(String annotation) {
        this.annotation = annotation;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public boolean softRemove() {
        return this.remove(false);
    }

    public void deselect() {
    }

    protected static abstract class DataPackage {
        protected final float width;
        protected final float height;
        protected final AffineTransform at;
        protected HashMap<Displayable, HashSet<Displayable>> links = null;

        DataPackage(Displayable d) {
            this.width = d.width;
            this.height = d.height;
            this.at = new AffineTransform(d.at);
            if (null != d.hs_linked) {
                this.links = new HashMap();
                for (Displayable ln : d.hs_linked) {
                    this.links.put(ln, new HashSet<Displayable>(ln.hs_linked));
                }
                this.links.put(d, new HashSet<Displayable>(d.hs_linked));
            }
        }

        final boolean to1(Displayable d) {
            d.width = this.width;
            d.height = this.height;
            d.setAffineTransform(this.at);
            if (null != this.links) {
                HashSet<Displayable> all_links = new HashSet<Displayable>();
                for (Map.Entry<Displayable, HashSet<Displayable>> e : this.links.entrySet()) {
                    Displayable o = e.getKey();
                    if (null != o.hs_linked) {
                        all_links.addAll(o.hs_linked);
                    }
                    all_links.addAll((Collection<Displayable>)e.getValue());
                    e.getKey().hs_linked = new HashSet(e.getValue());
                }
                Display.updateCheckboxes(all_links, 4);
            }
            return true;
        }

        abstract boolean to2(Displayable var1);
    }

    protected static class DoTransforms
    implements DoStep {
        private final HashMap<Displayable, AffineTransform> ht = new HashMap();
        final HashSet<Layer> layers = new HashSet();

        protected DoTransforms() {
        }

        DoTransforms addAll(Collection<? extends Displayable> col) {
            for (Displayable displayable : col) {
                this.ht.put(displayable, displayable.getAffineTransformCopy());
                this.layers.add(displayable.getLayer());
            }
            return this;
        }

        @Override
        public boolean isEmpty() {
            return null == this.ht || this.ht.isEmpty();
        }

        @Override
        public boolean apply(int action) {
            if (this.isEmpty()) {
                return false;
            }
            for (Map.Entry<Displayable, AffineTransform> e : this.ht.entrySet()) {
                e.getKey().at.setTransform(e.getValue());
            }
            for (Layer layer : this.layers) {
                layer.recreateBuckets();
            }
            if (!this.layers.isEmpty()) {
                this.layers.iterator().next().getParent().recreateBuckets(false);
            }
            return true;
        }

        @Override
        public Displayable getD() {
            return null;
        }

        @Override
        public boolean isIdenticalTo(Object ob) {
            if (ob instanceof Collection) {
                Collection col = (Collection)ob;
                if (this.ht.size() != col.size()) {
                    return false;
                }
                for (Displayable d : col) {
                    if (d.getAffineTransform().equals(this.ht.get(d))) continue;
                    return false;
                }
                return true;
            }
            if (ob instanceof DoTransforms) {
                DoTransforms dt = (DoTransforms)ob;
                if (dt.ht.size() != this.ht.size()) {
                    return false;
                }
                for (Map.Entry<Displayable, AffineTransform> e : this.ht.entrySet()) {
                    if (e.getValue().equals(dt.ht.get(e.getKey()))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    protected static class DoEdit
    implements DoStep {
        private final HashMap<String, Object> content = new HashMap();
        private ArrayList<DoStep> dependents = null;
        private final Displayable d;

        DoEdit(Displayable d) {
            this.d = d;
        }

        public boolean containsKey(String field) {
            return this.content.containsKey(field);
        }

        @Override
        public boolean isIdenticalTo(Object ob) {
            if (!(ob instanceof DoEdit)) {
                return false;
            }
            DoEdit other = (DoEdit)ob;
            if (this.d != other.d) {
                return false;
            }
            if (null != this.dependents) {
                return false;
            }
            if (this.content.size() != other.content.size()) {
                return false;
            }
            if (null != this.content.get("data") || null != other.content.get("data")) {
                return false;
            }
            for (Map.Entry<String, Object> e : this.content.entrySet()) {
                Object val = other.content.get(e.getKey());
                if (null == val) {
                    Utils.log2("WARNING: null val for " + e.getKey());
                    return false;
                }
                if (!(val instanceof HashMap ? !this.identical((HashMap)val, (HashMap)e.getValue()) : !val.equals(e.getValue()))) continue;
                return false;
            }
            return true;
        }

        private boolean identical(HashMap<?, ?> m1, HashMap<?, ?> m2) {
            if (m1.size() != m2.size()) {
                return false;
            }
            for (Map.Entry<?, ?> e : m1.entrySet()) {
                Object val1 = e.getValue();
                Object val2 = m2.get(e.getKey());
                if (null == val1 && null == val2 || val1.equals(val2)) continue;
                return false;
            }
            return true;
        }

        @Override
        public synchronized Displayable getD() {
            return this.d;
        }

        synchronized DoEdit fullCopy() {
            return this.init(this.d, new String[]{"data", "width", "height", "locked", "title", "color", "alpha", "visible", "props", "linked_props"});
        }

        synchronized DoEdit init(DoEdit de) {
            return this.init(de.d, de.content.keySet().toArray(new String[0]));
        }

        public synchronized boolean add(DoStep step) {
            if (null == this.dependents) {
                this.dependents = new ArrayList();
            }
            if (this.dependents.contains(step)) {
                return false;
            }
            this.dependents.add(step);
            return true;
        }

        public synchronized boolean add(String field, Object value) {
            this.content.put(field, value);
            return true;
        }

        synchronized DoEdit init(Displayable d, String[] fields) {
            Class[] c = new Class[]{Displayable.class, d.getClass(), ZDisplayable.class};
            for (int k = 0; k < fields.length; ++k) {
                if ("data".equals(fields[k])) {
                    this.content.put(fields[k], d.getDataPackage());
                    continue;
                }
                boolean got_it = false;
                for (int i = 0; i < c.length; ++i) {
                    try {
                        Field f = c[i].getDeclaredField(fields[k]);
                        f.setAccessible(true);
                        Object ob = f.get(d);
                        this.content.put(fields[k], null != ob ? this.duplicate(ob, fields[k]) : null);
                        got_it = true;
                        break;
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        continue;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
                if (got_it) continue;
                Utils.log2("ERROR: could not get '" + fields[k] + "' field for " + d);
                return null;
            }
            return this;
        }

        private final Object duplicate(Object ob, String field) {
            if (ob instanceof Color) {
                Color c = (Color)ob;
                return new Color(c.getRed(), c.getGreen(), c.getBlue());
            }
            if (ob instanceof HashMap) {
                if (field.equals("linked_props")) {
                    HashMap hm = new HashMap();
                    Iterator iterator = ((HashMap)ob).entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry e;
                        Map.Entry me = e = iterator.next();
                        hm.put(me.getKey(), ((HashMap)me.getValue()).clone());
                    }
                    return hm;
                }
                return new HashMap((HashMap)ob);
            }
            return ob;
        }

        @Override
        public boolean apply(int action) {
            Class[] c = new Class[]{Displayable.class, this.d.getClass(), ZDisplayable.class};
            for (Map.Entry<String, Object> e : this.content.entrySet()) {
                String field = e.getKey();
                if ("data".equals(field)) {
                    if (this.d.setDataPackage((DataPackage)e.getValue())) continue;
                    return false;
                }
                if ("at".equals(field)) {
                    this.d.at.setTransform((AffineTransform)e.getValue());
                    continue;
                }
                try {
                    for (int i = 0; i < c.length; ++i) {
                        Field f = c[i].getDeclaredField(field);
                        f.setAccessible(true);
                        f.set(this.d, e.getValue());
                    }
                }
                catch (NoSuchFieldException i) {
                }
                catch (IllegalAccessException i) {
                }
                catch (Exception ex) {
                    IJError.print(ex);
                    return false;
                }
            }
            boolean ok = true;
            if (null != this.dependents) {
                for (DoStep step : this.dependents) {
                    if (step.apply(action)) continue;
                    ok = false;
                }
            }
            Display.update(this.d.getLayerSet(), false);
            return ok;
        }

        @Override
        public boolean isEmpty() {
            return null == this.d || this.content.isEmpty() && (null == this.dependents || this.dependents.isEmpty());
        }
    }

    protected static class DoEdits
    implements DoStep {
        final HashSet<DoEdit> edits = new HashSet();
        HashSet<DoStep> dependents = null;

        DoEdits(Set<? extends Displayable> col) {
            for (Displayable displayable : col) {
                this.edits.add(new DoEdit(displayable));
            }
        }

        @Override
        public Displayable getD() {
            return null;
        }

        @Override
        public boolean isIdenticalTo(Object ob) {
            if (!(ob instanceof DoEdits)) {
                return false;
            }
            DoEdits other = (DoEdits)ob;
            if (this.edits.size() != other.edits.size()) {
                return false;
            }
            Iterator<DoEdit> it1 = this.edits.iterator();
            Iterator<DoEdit> it2 = other.edits.iterator();
            while (it1.hasNext() && it2.hasNext()) {
                if (it1.next().isIdenticalTo(it2.next())) continue;
                return false;
            }
            if (null != this.dependents && null != other.dependents) {
                if (this.dependents.size() != other.dependents.size()) {
                    return false;
                }
                Iterator<DoStep> s1 = this.dependents.iterator();
                Iterator<DoStep> s2 = other.dependents.iterator();
                while (s1.hasNext()) {
                    if (s1.next().isIdenticalTo(s2.next())) continue;
                    return false;
                }
            }
            return true;
        }

        public DoEdits init(String[] fields) {
            for (DoEdit edit : this.edits) {
                edit.init(edit.d, fields);
            }
            return this;
        }

        @Override
        public boolean isEmpty() {
            return this.edits.isEmpty();
        }

        @Override
        public boolean apply(int action) {
            boolean failed = false;
            for (DoEdit edit : this.edits) {
                if (edit.apply(action)) continue;
                failed = true;
            }
            if (null != this.dependents) {
                for (DoStep step : this.dependents) {
                    failed = !step.apply(action) || failed;
                }
            }
            return !failed;
        }

        public void addDependents(Collection<DoStep> dep) {
            if (null == this.dependents) {
                this.dependents = new HashSet();
            }
            this.dependents.addAll(dep);
        }
    }

    private class GD
    extends GenericDialog {
        private static final long serialVersionUID = 1L;
        Displayable displ;
        Color dcolor;
        float dalpha;

        GD(String title, Displayable displ) {
            super(title);
            this.displ = displ;
            this.dcolor = new Color(displ.color.getRed(), displ.color.getGreen(), displ.color.getBlue());
            this.dalpha = displ.alpha;
        }

        public void dispose() {
            if (this.wasCanceled()) {
                this.displ.alpha = this.dalpha;
                this.displ.setColor(this.dcolor);
            }
            super.dispose();
        }
    }

    protected abstract class SliderListener
    implements AdjustmentListener,
    TextListener {
        protected SliderListener() {
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent ae) {
            this.update();
        }

        @Override
        public void textValueChanged(TextEvent te) {
            this.update();
        }

        public abstract void update();
    }
}

