/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.analysis;

import ini.trakem2.analysis.Vertex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Centrality {
    public static final <T> ArrayList<Vertex<T>> safeCompute(Collection<Vertex<T>> vs) {
        ArrayList<Vertex<T>> copies = Vertex.clone(vs);
        Centrality.compute(copies);
        return copies;
    }

    public static final <T> void compute(Collection<Vertex<T>> vs) {
        if (1 == vs.size()) {
            return;
        }
        LinkedList<Object> stack = new LinkedList<Object>();
        LinkedList queue = new LinkedList();
        for (Vertex<T> s : vs) {
            for (Vertex<T> vertex : vs) {
                vertex.predecessors.clear();
                vertex.sigma = 0L;
                vertex.d = -1L;
            }
            s.sigma = 1L;
            s.d = 0L;
            queue.add(s);
            while (!queue.isEmpty()) {
                Vertex v = (Vertex)queue.removeFirst();
                stack.add(v);
                for (Vertex vertex : v.neighbors) {
                    if (-1L == vertex.d) {
                        queue.add(vertex);
                        vertex.d = v.d + 1L;
                    }
                    if (vertex.d != v.d + 1L) continue;
                    vertex.sigma += v.sigma;
                    vertex.predecessors.add(v);
                }
            }
            for (Vertex vertex : vs) {
                vertex.delta = 0.0f;
            }
            while (!stack.isEmpty()) {
                Vertex w = (Vertex)stack.removeLast();
                for (Vertex vertex : w.predecessors) {
                    vertex.delta += (float)vertex.sigma / (float)w.sigma * (1.0f + w.delta);
                }
                if (w == s) continue;
                w.centrality += w.delta;
            }
        }
    }

    private static final <T> List<Vertex<T>> findChain(Vertex<T> origin, Vertex<T> parent, Set<Vertex<T>> processed) {
        ArrayList<Vertex<T>> chain = new ArrayList<Vertex<T>>();
        chain.add(origin);
        Vertex<T> o = origin;
        Vertex<T> p = parent;
        block0: while (1 != o.neighbors.size()) {
            Vertex<T> o2 = o;
            for (Vertex v : o.neighbors) {
                if (v == p || processed.contains(v) || v.centrality < p.centrality) continue;
                chain.add(v);
                p = o;
                o = v;
                continue block0;
            }
            if (o2 != o) continue;
            break;
        }
        return chain;
    }

    public static final <T> ArrayList<EtchingStep<T>> branchWise(Collection<Vertex<T>> vs_, int etching_multiplier) {
        HashSet<Vertex<T>> vs = new HashSet<Vertex<T>>(Vertex.clone(vs_));
        HashMap m = new HashMap();
        for (Vertex<T> vertex : vs_) {
            m.put(vertex.data, vertex);
        }
        HashSet<Vertex> branch_vertices = new HashSet<Vertex>();
        for (Vertex vertex : vs) {
            if (vertex.getNeighborCount() <= 2) continue;
            branch_vertices.add(vertex);
        }
        ArrayList<EtchingStep<T>> arrayList = new ArrayList<EtchingStep<T>>();
        HashSet<Vertex<T>> hashSet = new HashSet<Vertex<T>>();
        while (vs.size() > 0) {
            Vertex v;
            Iterator v2;
            for (Vertex vertex : vs) {
                vertex.reset();
            }
            Centrality.compute(vs);
            HashSet removed = new HashSet();
            int n = vs.size();
            Iterator iterator = vs.iterator();
            while (iterator.hasNext()) {
                v2 = (Vertex)iterator.next();
                if (!(((Vertex)((Object)v2)).centrality < (float)(etching_multiplier * n))) continue;
                iterator.remove();
                removed.add(v2);
            }
            HashSet hashSet2 = new HashSet();
            v2 = removed.iterator();
            while (v2.hasNext()) {
                Vertex r = (Vertex)v2.next();
                for (Vertex vertex : r.neighbors) {
                    if (!vertex.isBranching() || !(vertex.centrality >= r.centrality)) continue;
                    List<Vertex<T>> branch = Centrality.findChain((Vertex)m.get(r.data), (Vertex)m.get(vertex.data), hashSet);
                    hashSet.addAll(branch);
                    hashSet2.add(branch);
                }
            }
            if (hashSet2.size() > 0) {
                arrayList.add(new EtchingStep(branch_vertices.size(), hashSet2));
            }
            v2 = removed.iterator();
            while (v2.hasNext()) {
                v = (Vertex)v2.next();
                Iterator it2 = v.neighbors.iterator();
                while (it2.hasNext()) {
                    Vertex vertex = it2.next();
                    if (removed.contains(vertex)) {
                        it2.remove();
                        continue;
                    }
                    vertex.neighbors.remove(v);
                }
            }
            Iterator it3 = branch_vertices.iterator();
            while (it3.hasNext()) {
                v = (Vertex)it3.next();
                if (v.neighbors.size() >= 3 && !removed.contains(v)) continue;
                it3.remove();
            }
            if (0 != branch_vertices.size()) continue;
            break;
        }
        for (EtchingStep etchingStep : arrayList) {
            for (Collection b : etchingStep.branches) {
                ArrayList b2 = new ArrayList(b);
                b.clear();
                for (Vertex vertex : b2) {
                    b.add(m.get(vertex.data));
                }
            }
        }
        HashSet done = new HashSet();
        for (Vertex vertex : hashSet) {
            done.add(vertex.data);
        }
        HashMap hashMap = new HashMap(m);
        hashMap.keySet().removeAll(done);
        HashSet hashSet3 = new HashSet();
        hashSet3.add(hashMap.values());
        arrayList.add(new EtchingStep(0, hashSet3));
        return arrayList;
    }

    public static class EtchingStep<T>
    implements Map.Entry<Integer, Set<Collection<Vertex<T>>>> {
        public int remaining_branch_vertices = 0;
        public Set<Collection<Vertex<T>>> branches = null;

        public EtchingStep(int remaining_branch_vertices, Set<Collection<Vertex<T>>> branches) {
            this.remaining_branch_vertices = remaining_branch_vertices;
            this.branches = branches;
        }

        @Override
        public Integer getKey() {
            return this.remaining_branch_vertices;
        }

        @Override
        public Set<Collection<Vertex<T>>> getValue() {
            return this.branches;
        }

        @Override
        public Set<Collection<Vertex<T>>> setValue(Set<Collection<Vertex<T>>> value) {
            throw new UnsupportedOperationException();
        }
    }
}

