/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2;

import ij.IJ;
import ij.ImageJ;
import ij.gui.GenericDialog;
import ij.gui.Toolbar;
import ij.gui.YesNoCancelDialog;
import ini.trakem2.Project;
import ini.trakem2.display.Display;
import ini.trakem2.display.Display3D;
import ini.trakem2.display.ImageJCommandListener;
import ini.trakem2.display.YesNoDialog;
import ini.trakem2.persistence.Loader;
import ini.trakem2.tree.LayerTree;
import ini.trakem2.tree.ProjectTree;
import ini.trakem2.tree.TemplateTree;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.ProjectToolbar;
import ini.trakem2.utils.RedPhone;
import ini.trakem2.utils.StdOutWindow;
import ini.trakem2.utils.Utils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ImageProducer;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;

public class ControlWindow {
    private static JFrame frame = null;
    private static JTabbedPane tabs = null;
    private static Hashtable<Project, JSplitPane> ht_projects = null;
    private static ControlWindow instance = null;
    private static final Object LOCK = new Object();
    private final RedPhone red_phone = new RedPhone();
    private static boolean gui_enabled = true;
    private ImageJCommandListener command_listener;
    private static MouseListener tool_listener = new MouseAdapter(){
        private int last_tool = 0;

        @Override
        public void mousePressed(MouseEvent me) {
            int tool = ProjectToolbar.getToolId();
            if (tool != this.last_tool) {
                this.last_tool = tool;
                Display.toolChanged(tool);
            }
        }
    };
    private static boolean hooked = false;
    private static Image icon = null;

    private ControlWindow() {
        if (null != Toolbar.getInstance()) {
            Toolbar.getInstance().addMouseListener(tool_listener);
        }
        Utils.setup(this);
        Loader.setupPreloader(this);
        if (IJ.isWindows() && ControlWindow.isGUIEnabled()) {
            StdOutWindow.start();
        }
        Display3D.init();
        ControlWindow.setLookAndFeel();
        this.command_listener = new ImageJCommandListener();
        this.red_phone.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final ControlWindow getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (null == instance) {
                instance = new ControlWindow();
            }
            return instance;
        }
    }

    public static void setLookAndFeel() {
        try {
            if (IJ.isLinux() && "com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel".equals(UIManager.getLookAndFeel().getClass().getName())) {
                UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
                for (Frame frame : Frame.getFrames()) {
                    if (!frame.isEnabled()) continue;
                    SwingUtilities.updateComponentTreeUI(frame);
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            Utils.log2("Could not find Nimbus L&F");
        }
        catch (Exception e) {
            IJError.print(e);
        }
    }

    public static void setGUIEnabled(boolean b) {
        gui_enabled = b;
        if (gui_enabled && null != frame) {
            frame.setVisible(true);
        }
    }

    public static final boolean isGUIEnabled() {
        return gui_enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Set<Project> getProjects() {
        Object object = LOCK;
        synchronized (object) {
            if (null == ht_projects) {
                return null;
            }
            return ht_projects.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void destroy() {
        Object object = LOCK;
        synchronized (object) {
            if (null == instance) {
                return;
            }
            if (IJ.isWindows()) {
                StdOutWindow.quit();
            }
            Display3D.destroy();
            if (null != ht_projects) {
                Enumeration<Project> e = ht_projects.keys();
                Project[] project = new Project[ht_projects.size()];
                int next = 0;
                while (e.hasMoreElements()) {
                    project[next++] = e.nextElement();
                }
                for (int i = 0; i < next; ++i) {
                    ht_projects.remove(project[i]);
                    if (project[i].destroy()) continue;
                    return;
                }
                ht_projects = null;
            }
            if (null != tabs) {
                tabs.removeMouseListener(tabs.getMouseListeners()[0]);
                tabs = null;
            }
            if (null != frame) {
                final JFrame fr = frame;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        fr.setVisible(false);
                        fr.dispose();
                        if (null != Toolbar.getInstance()) {
                            Toolbar.getInstance().repaint();
                        }
                    }
                });
                frame = null;
                ProjectToolbar.destroy();
            }
            if (null != tool_listener && null != Toolbar.getInstance()) {
                Toolbar.getInstance().removeMouseListener(tool_listener);
            }
            Utils.destroy(instance);
            Loader.destroyPreloader(instance);
            ControlWindow.instance.command_listener.destroy();
            ControlWindow.instance.command_listener = null;
            if (null != ControlWindow.instance.red_phone) {
                ControlWindow.instance.red_phone.quit();
            }
            instance = null;
        }
    }

    public static void add(final Project project, final TemplateTree template_tree, final ProjectTree thing_tree, final LayerTree layer_tree) {
        final Runnable[] other = new Runnable[2];
        if (!gui_enabled) {
            return;
        }
        final Runnable gui_thread = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = LOCK;
                synchronized (object) {
                    ControlWindow.getInstance();
                    if (null == frame) {
                        if (!hooked) {
                            Runtime.getRuntime().addShutdownHook(new Thread(){

                                @Override
                                public void run() {
                                    ControlWindow.destroy();
                                }
                            });
                            hooked = true;
                        }
                        frame = ControlWindow.createJFrame("TrakEM2");
                        frame.setBackground(Color.white);
                        frame.getContentPane().setBackground(Color.white);
                        frame.setDefaultCloseOperation(0);
                        frame.addWindowListener(new WindowAdapter(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void windowClosing(WindowEvent we) {
                                Object object = LOCK;
                                synchronized (object) {
                                    if (!Utils.check("Close " + (1 == ht_projects.size() ? "the project?" : "all projects?"))) {
                                        return;
                                    }
                                    ControlWindow.destroy();
                                }
                            }

                            @Override
                            public void windowClosed(WindowEvent we) {
                                ControlWindow.destroy();
                            }
                        });
                        tabs = new JTabbedPane(1);
                        tabs.setBackground(Color.white);
                        tabs.setMinimumSize(new Dimension(500, 400));
                        tabs.addMouseListener(new TabListener());
                        frame.getContentPane().add(tabs);
                        if (!IJ.isMacOSX()) {
                            JPopupMenu.setDefaultLightWeightPopupEnabled(false);
                        }
                        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
                    }
                    final JSplitPane tab = new JSplitPane(1);
                    tab.setBackground(Color.white);
                    if (null == ht_projects) {
                        ht_projects = new Hashtable();
                    }
                    ht_projects.put(project, tab);
                    JScrollPane scroll_template = new JScrollPane(template_tree);
                    scroll_template.setBackground(Color.white);
                    scroll_template.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5), "Template"));
                    scroll_template.setMinimumSize(new Dimension(0, 100));
                    scroll_template.setPreferredSize(new Dimension(300, 400));
                    JScrollPane scroll_things = new JScrollPane(thing_tree);
                    scroll_things.setBackground(Color.white);
                    scroll_things.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5), "Project Objects"));
                    scroll_things.setMinimumSize(new Dimension(0, 100));
                    scroll_things.setPreferredSize(new Dimension(300, 400));
                    JScrollPane scroll_layers = new JScrollPane(layer_tree);
                    scroll_layers.setBackground(Color.white);
                    scroll_layers.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5), "Layers"));
                    scroll_layers.setMinimumSize(new Dimension(0, 100));
                    scroll_layers.setPreferredSize(new Dimension(300, 400));
                    final JSplitPane left = new JSplitPane(1, scroll_template, scroll_things);
                    left.setBackground(Color.white);
                    left.setPreferredSize(new Dimension(600, 400));
                    tab.setBackground(Color.white);
                    tab.setLeftComponent(left);
                    tab.setRightComponent(scroll_layers);
                    tab.setPreferredSize(new Dimension(900, 400));
                    tabs.addTab(project.toString(), new CloseIcon(), tab);
                    tabs.setSelectedIndex(tabs.getTabCount() - 1);
                    if (!frame.isVisible() && gui_enabled) {
                        frame.pack();
                        frame.setVisible(true);
                        frame.toFront();
                    }
                    Rectangle bounds = frame.getBounds();
                    if (bounds.width < 200) {
                        frame.setSize(new Dimension(200, bounds.height > 100 ? bounds.height : 100));
                        frame.pack();
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    tab.setDividerLocation(0.66);
                    left.setDividerLocation(0.5);
                    if (1 == ht_projects.size() && gui_enabled) {
                        ProjectToolbar.setTool(10);
                    }
                    other[0] = new Runnable(){

                        @Override
                        public void run() {
                            tab.setDividerLocation(0.66);
                        }
                    };
                    other[1] = new Runnable(){

                        @Override
                        public void run() {
                            left.setDividerLocation(0.5);
                        }
                    };
                }
            }
        };
        new Thread(){
            {
                this.setPriority(5);
            }

            @Override
            public void run() {
                try {
                    SwingUtilities.invokeAndWait(gui_thread);
                    for (int i = 0; i < other.length; ++i) {
                        SwingUtilities.invokeAndWait(other[i]);
                    }
                }
                catch (Exception e) {
                    IJError.print(e);
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Project getActive() {
        Object object = LOCK;
        synchronized (object) {
            if (null == tabs || 0 == ht_projects.size()) {
                return null;
            }
            if (1 == ht_projects.size()) {
                return ht_projects.keySet().iterator().next();
            }
            Component c = tabs.getSelectedComponent();
            for (Map.Entry<Project, JSplitPane> e : ht_projects.entrySet()) {
                if (!e.getValue().equals(c)) continue;
                return e.getKey();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(Project project) {
        Object object = LOCK;
        synchronized (object) {
            if (null == tabs || null == ht_projects) {
                return;
            }
            if (null == instance) {
                return;
            }
            if (ht_projects.containsKey(project)) {
                int n_tabs = 0;
                JSplitPane tab = ht_projects.get(project);
                tabs.remove(tab);
                ht_projects.remove(project);
                n_tabs = tabs.getTabCount();
                if (0 == n_tabs) {
                    ControlWindow.destroy();
                }
            }
        }
    }

    public static void updateTitle(final Project project) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = LOCK;
                synchronized (object) {
                    if (null == tabs) {
                        return;
                    }
                    if (ht_projects.containsKey(project)) {
                        if (null == instance) {
                            return;
                        }
                        JSplitPane tab = (JSplitPane)ht_projects.get(project);
                        int index = tabs.indexOfComponent(tab);
                        if (-1 != index) {
                            tabs.setTitleAt(index, project.toString());
                        }
                    }
                }
            }
        });
    }

    public static GenericDialog makeGenericDialog(String title) {
        Object f = null == frame ? IJ.getInstance() : frame;
        return new GenericDialog(title, (Frame)f);
    }

    public static YesNoCancelDialog makeYesNoCancelDialog(String title, String msg) {
        Object f = null == frame ? IJ.getInstance() : frame;
        return new YesNoCancelDialog((Frame)f, title, msg);
    }

    public static YesNoDialog makeYesNoDialog(String title, String msg) {
        Object f = null == frame ? IJ.getInstance() : frame;
        return new YesNoDialog((Frame)f, title, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void toFront() {
        ControlWindow controlWindow = instance;
        synchronized (controlWindow) {
            if (null != frame) {
                frame.toFront();
            }
        }
    }

    public static void startWaitingCursor() {
        ControlWindow.setCursor(Cursor.getPredefinedCursor(3));
    }

    public static void endWaitingCursor() {
        ControlWindow.setCursor(Cursor.getDefaultCursor());
    }

    private static void setCursor(final Cursor c) {
        Utils.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (null != IJ.getInstance()) {
                    IJ.getInstance().setCursor(c);
                }
                Display.setCursorToAll(c);
                if (null != frame && frame.isVisible()) {
                    frame.setCursor(c);
                }
            }
        });
    }

    public static synchronized int getTabIndex(Project project) {
        if (null == project || null == ht_projects) {
            return -1;
        }
        Component tab = ht_projects.get(project);
        if (null == tab) {
            return -1;
        }
        return tabs.indexOfComponent(tab);
    }

    public static JFrame createJFrame(String title) {
        if (null == instance) {
            return new JFrame(title);
        }
        return instance.newJFrame(title);
    }

    private synchronized JFrame newJFrame(String title) {
        JFrame frame = new JFrame(title);
        if (null == icon) {
            try {
                Field mic = ImageJ.class.getDeclaredField("iconPath");
                mic.setAccessible(true);
                String path = (String)mic.get(IJ.getInstance());
                icon = IJ.getInstance().createImage((ImageProducer)new URL("file:" + path).getContent());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (null != icon) {
            frame.setIconImage(icon);
        }
        return frame;
    }

    private static class CloseIcon
    implements Icon {
        private Icon icon;
        private BufferedImage img = ControlWindow.access$100().getGraphicsConfiguration().createCompatibleImage(20, 16, 3);
        private int x = 0;
        private int y = 0;

        CloseIcon() {
            Graphics2D g = this.img.createGraphics();
            g.setColor(Color.black);
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.drawOval(6, 2, 12, 12);
            g.setStroke(new BasicStroke(1.0f, 1, 1));
            g.drawLine(8, 4, 15, 12);
            g.drawLine(8, 12, 15, 4);
            this.icon = new ImageIcon(this.img);
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.x = x;
            this.y = y;
            this.icon.paintIcon(c, g, x, y);
        }

        public boolean contains(int x, int y) {
            return new Rectangle(this.x, this.y, this.icon.getIconWidth(), this.icon.getIconHeight()).contains(x, y);
        }

        @Override
        public int getIconWidth() {
            return this.icon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.icon.getIconHeight();
        }

        public void flush() {
            if (null != this.img) {
                this.img.flush();
                this.img = null;
            }
        }
    }

    private static class TabListener
    extends MouseAdapter {
        private TabListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseReleased(MouseEvent me) {
            if (me.isConsumed()) {
                return;
            }
            Object object = LOCK;
            synchronized (object) {
                if (null == tabs) {
                    return;
                }
                int i_tab = tabs.getSelectedIndex();
                Component comp = tabs.getComponentAt(i_tab);
                Icon icon = tabs.getIconAt(i_tab);
                if (icon instanceof CloseIcon) {
                    CloseIcon ci = (CloseIcon)icon;
                    Project project = null;
                    for (Map.Entry e : ht_projects.entrySet()) {
                        project = (Project)e.getKey();
                        if (!((JSplitPane)e.getValue()).equals(comp)) continue;
                        break;
                    }
                    if (ci.contains(me.getX(), me.getY())) {
                        if (null == project) {
                            return;
                        }
                        if (!Utils.check("Close the project " + project.toString() + " ?")) {
                            return;
                        }
                        if (project.destroy()) {
                            ci.flush();
                        }
                    } else if (2 == me.getClickCount()) {
                        if (null == project) {
                            return;
                        }
                        project.getProjectTree().rename(project.getRootProjectThing());
                    }
                }
            }
        }
    }
}

