/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hssf.record.aggregates;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import loci.poi.hssf.record.DBCellRecord;
import loci.poi.hssf.record.Record;
import loci.poi.hssf.record.RecordInputStream;
import loci.poi.hssf.record.RowRecord;
import loci.poi.hssf.record.aggregates.ValueRecordsAggregate;

public class RowRecordsAggregate
extends Record {
    int firstrow = -1;
    int lastrow = -1;
    Map records = new TreeMap();
    int size = 0;

    public void insertRow(RowRecord row) {
        this.size += row.getRecordSize();
        this.records.put(row, row);
        if (row.getRowNumber() < this.firstrow || this.firstrow == -1) {
            this.firstrow = row.getRowNumber();
        }
        if (row.getRowNumber() > this.lastrow || this.lastrow == -1) {
            this.lastrow = row.getRowNumber();
        }
    }

    public void removeRow(RowRecord row) {
        this.size -= row.getRecordSize();
        this.records.remove(row);
    }

    public RowRecord getRow(int rownum) {
        if (rownum < 0 || rownum > 65535) {
            throw new IllegalArgumentException("The row number must be between 0 and 65535");
        }
        RowRecord row = new RowRecord();
        row.setRowNumber(rownum);
        return (RowRecord)this.records.get(row);
    }

    public int getPhysicalNumberOfRows() {
        return this.records.size();
    }

    public int getFirstRowNum() {
        return this.firstrow;
    }

    public int getLastRowNum() {
        return this.lastrow;
    }

    public int getRowBlockCount() {
        int size = this.records.size() / 32;
        if (this.records.size() % 32 != 0) {
            ++size;
        }
        return size;
    }

    public int getRowBlockSize(int block) {
        return 20 * this.getRowCountForBlock(block);
    }

    public int getRowCountForBlock(int block) {
        int startIndex = block * 32;
        int endIndex = startIndex + 32 - 1;
        if (endIndex >= this.records.size()) {
            endIndex = this.records.size() - 1;
        }
        return endIndex - startIndex + 1;
    }

    public int getStartRowNumberForBlock(int block) {
        int startIndex = block * 32;
        Iterator rowIter = this.records.values().iterator();
        RowRecord row = null;
        for (int i = 0; i <= startIndex; ++i) {
            row = (RowRecord)rowIter.next();
        }
        return row.getRowNumber();
    }

    public int getEndRowNumberForBlock(int block) {
        int endIndex = (block + 1) * 32 - 1;
        if (endIndex >= this.records.size()) {
            endIndex = this.records.size() - 1;
        }
        Iterator rowIter = this.records.values().iterator();
        RowRecord row = null;
        for (int i = 0; i <= endIndex; ++i) {
            row = (RowRecord)rowIter.next();
        }
        return row.getRowNumber();
    }

    private int serializeRowBlock(int block, int offset, byte[] data) {
        int i;
        int startIndex = block * 32;
        int endIndex = startIndex + 32;
        Iterator rowIterator = this.records.values().iterator();
        int pos = offset;
        for (i = 0; i < startIndex; ++i) {
            rowIterator.next();
        }
        while (rowIterator.hasNext() && i++ < endIndex) {
            RowRecord row = (RowRecord)rowIterator.next();
            pos += row.serialize(pos, data);
        }
        return pos - offset;
    }

    @Override
    public int serialize(int offset, byte[] data) {
        throw new RuntimeException("The serialize method that passes in cells should be used");
    }

    public int serialize(int offset, byte[] data, ValueRecordsAggregate cells) {
        int pos = offset;
        int blockCount = this.getRowBlockCount();
        for (int block = 0; block < blockCount; ++block) {
            int rowStartPos = pos;
            int rowBlockSize = this.serializeRowBlock(block, pos, data);
            pos += rowBlockSize;
            int startRowNumber = this.getStartRowNumberForBlock(block);
            int endRowNumber = this.getEndRowNumberForBlock(block);
            DBCellRecord cellRecord = new DBCellRecord();
            int cellRefOffset = rowBlockSize - 20;
            for (int row = startRowNumber; row <= endRowNumber; ++row) {
                if (null == cells || !cells.rowHasCells(row)) continue;
                int rowCellSize = cells.serializeCellRow(row, pos, data);
                pos += rowCellSize;
                cellRecord.addCellOffset((short)cellRefOffset);
                cellRefOffset = rowCellSize;
            }
            cellRecord.setRowOffset(pos - rowStartPos);
            pos += cellRecord.serialize(pos, data);
        }
        return pos - offset;
    }

    @Override
    protected void fillFields(RecordInputStream in) {
    }

    @Override
    protected void validateSid(short id) {
    }

    @Override
    public short getSid() {
        return -1000;
    }

    @Override
    public int getRecordSize() {
        return this.size;
    }

    public Iterator getIterator() {
        return this.records.values().iterator();
    }

    @Override
    public Object clone() {
        RowRecordsAggregate rec = new RowRecordsAggregate();
        Iterator rowIter = this.getIterator();
        while (rowIter.hasNext()) {
            RowRecord row = (RowRecord)((RowRecord)rowIter.next()).clone();
            rec.insertRow(row);
        }
        return rec;
    }

    public int findStartOfRowOutlineGroup(int row) {
        RowRecord rowRecord = this.getRow(row);
        short level = rowRecord.getOutlineLevel();
        int currentRow = row;
        while (this.getRow(currentRow) != null) {
            rowRecord = this.getRow(currentRow);
            if (rowRecord.getOutlineLevel() < level) {
                return currentRow + 1;
            }
            --currentRow;
        }
        return currentRow + 1;
    }

    public int findEndOfRowOutlineGroup(int row) {
        int currentRow;
        short level = this.getRow(row).getOutlineLevel();
        for (currentRow = row; currentRow < this.getLastRowNum() && this.getRow(currentRow) != null && this.getRow(currentRow).getOutlineLevel() >= level; ++currentRow) {
        }
        return currentRow - 1;
    }

    public int writeHidden(RowRecord rowRecord, int row, boolean hidden) {
        short level = rowRecord.getOutlineLevel();
        while (rowRecord != null && this.getRow(row).getOutlineLevel() >= level) {
            rowRecord.setZeroHeight(hidden);
            rowRecord = this.getRow(++row);
        }
        return row - 1;
    }

    public void collapseRow(int rowNumber) {
        int startRow = this.findStartOfRowOutlineGroup(rowNumber);
        RowRecord rowRecord = this.getRow(startRow);
        int lastRow = this.writeHidden(rowRecord, startRow, true);
        if (this.getRow(lastRow + 1) != null) {
            this.getRow(lastRow + 1).setColapsed(true);
        } else {
            RowRecord row = RowRecordsAggregate.createRow(lastRow + 1);
            row.setColapsed(true);
            this.insertRow(row);
        }
    }

    public static RowRecord createRow(int row) {
        RowRecord rowrec = new RowRecord();
        rowrec.setRowNumber(row);
        rowrec.setHeight((short)255);
        rowrec.setOptimize((short)0);
        rowrec.setOptionFlags((short)256);
        rowrec.setXFIndex((short)15);
        return rowrec;
    }

    public boolean isRowGroupCollapsed(int row) {
        int collapseRow = this.findEndOfRowOutlineGroup(row) + 1;
        if (this.getRow(collapseRow) == null) {
            return false;
        }
        return this.getRow(collapseRow).getColapsed();
    }

    public void expandRow(int rowNumber) {
        int idx = rowNumber;
        if (idx == -1) {
            return;
        }
        if (!this.isRowGroupCollapsed(idx)) {
            return;
        }
        int startIdx = this.findStartOfRowOutlineGroup(idx);
        RowRecord row = this.getRow(startIdx);
        int endIdx = this.findEndOfRowOutlineGroup(idx);
        if (!this.isRowGroupHiddenByParent(idx)) {
            for (int i = startIdx; i <= endIdx; ++i) {
                if (row.getOutlineLevel() == this.getRow(i).getOutlineLevel()) {
                    this.getRow(i).setZeroHeight(false);
                    continue;
                }
                if (this.isRowGroupCollapsed(i)) continue;
                this.getRow(i).setZeroHeight(false);
            }
        }
        this.getRow(endIdx + 1).setColapsed(false);
    }

    public boolean isRowGroupHiddenByParent(int row) {
        boolean startHidden;
        short startLevel;
        boolean endHidden;
        short endLevel;
        int endOfOutlineGroupIdx = this.findEndOfRowOutlineGroup(row);
        if (this.getRow(endOfOutlineGroupIdx + 1) == null) {
            endLevel = 0;
            endHidden = false;
        } else {
            endLevel = this.getRow(endOfOutlineGroupIdx + 1).getOutlineLevel();
            endHidden = this.getRow(endOfOutlineGroupIdx + 1).getZeroHeight();
        }
        int startOfOutlineGroupIdx = this.findStartOfRowOutlineGroup(row);
        if (startOfOutlineGroupIdx - 1 < 0 || this.getRow(startOfOutlineGroupIdx - 1) == null) {
            startLevel = 0;
            startHidden = false;
        } else {
            startLevel = this.getRow(startOfOutlineGroupIdx - 1).getOutlineLevel();
            startHidden = this.getRow(startOfOutlineGroupIdx - 1).getZeroHeight();
        }
        if (endLevel > startLevel) {
            return endHidden;
        }
        return startHidden;
    }
}

