/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.console;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.scijava.log.CallingClassUtils;
import org.scijava.log.IgnoreAsCallingClass;
import org.scijava.log.LogListener;
import org.scijava.log.LogMessage;

@IgnoreAsCallingClass
public class LogRecorder
implements LogListener,
Iterable<LogMessage> {
    private ConcurrentExpandableList<LogMessage> recorded = new ConcurrentExpandableList();
    private List<Runnable> observers = new CopyOnWriteArrayList<Runnable>();
    private boolean recordCallingClass = false;

    public void addObservers(Runnable observer) {
        this.observers.add(observer);
    }

    public void removeObserver(Runnable observer) {
        this.observers.remove(observer);
    }

    @Override
    public Iterator<LogMessage> iterator() {
        return this.recorded.iterator();
    }

    public Stream<LogMessage> stream() {
        return this.recorded.stream();
    }

    public Iterator<LogMessage> iteratorAtEnd() {
        return this.recorded.iteratorAtEnd();
    }

    public void clear() {
        this.recorded.clear();
    }

    public boolean isRecordCallingClass() {
        return this.recordCallingClass;
    }

    public void setRecordCallingClass(boolean enable) {
        this.recordCallingClass = enable;
    }

    public void messageLogged(LogMessage message) {
        if (this.recordCallingClass) {
            message.attach((Object)CallingClassUtils.getCallingClass());
        }
        this.recorded.add(message);
        this.notifyListeners();
    }

    private void notifyListeners() {
        for (Runnable listener : this.observers) {
            listener.run();
        }
    }

    private class ConcurrentExpandableList<T>
    implements Iterable<T> {
        private final AtomicLong lastKey = new AtomicLong(0L);
        private long firstKey = 0L;
        private final Map<Long, T> map = new ConcurrentHashMap<Long, T>();

        private ConcurrentExpandableList() {
        }

        public Stream<T> stream() {
            Spliterator<T> spliterator = Spliterators.spliteratorUnknownSize(this.iterator(), 16);
            return StreamSupport.stream(spliterator, false);
        }

        @Override
        public Iterator<T> iterator() {
            return new MyIterator(this.firstKey);
        }

        public Iterator<T> iteratorAtEnd() {
            return new MyIterator(this.lastKey.get());
        }

        public long add(T value) {
            long key = this.lastKey.getAndIncrement();
            this.map.put(key, value);
            return key;
        }

        public void clear() {
            this.map.clear();
            this.firstKey = this.lastKey.get();
        }

        private class MyIterator
        implements Iterator<T> {
            private long nextIndex;

            public MyIterator(long nextIndex) {
                this.nextIndex = nextIndex;
            }

            @Override
            public boolean hasNext() {
                return ConcurrentExpandableList.this.map.containsKey(this.nextIndex);
            }

            @Override
            public T next() {
                Object value = ConcurrentExpandableList.this.map.get(this.nextIndex);
                if (value == null) {
                    throw new NoSuchElementException();
                }
                ++this.nextIndex;
                return value;
            }
        }
    }
}

