/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.labeling.unary;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccess;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.labeling.Labeling;
import net.imglib2.labeling.LabelingType;
import net.imglib2.labeling.NativeImgLabeling;
import net.imglib2.ops.operation.UnaryOutputOperation;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.IntegerType;

@Deprecated
public final class MergeLabelings<L extends Comparable<L>>
implements UnaryOutputOperation<Labeling<L>[], NativeImgLabeling<L, ? extends IntegerType<?>>> {
    private final IntegerType<?> m_resType;
    private final boolean m_adjustDimensionality;
    private List<Integer> m_invalidDims;

    public MergeLabelings(IntegerType<?> resType, boolean adjustDimensionality) {
        this.m_resType = resType;
        this.m_adjustDimensionality = adjustDimensionality;
    }

    @Override
    public final NativeImgLabeling<L, ? extends IntegerType<?>> createEmptyOutput(Labeling<L>[] src) {
        long[] resDims = this.initConstants(src);
        NativeImgLabeling res = new NativeImgLabeling((Img)new ArrayImgFactory().create(resDims, (NativeType)this.m_resType));
        return res;
    }

    private long[] initConstants(Labeling<L>[] src) {
        int numMaxDims = 0;
        for (Labeling<L> interval : src) {
            numMaxDims = Math.max(interval.numDimensions(), numMaxDims);
        }
        HashSet[] setDims = new HashSet[numMaxDims];
        for (int s = 0; s < setDims.length; ++s) {
            setDims[s] = new HashSet();
        }
        for (Labeling<L> interval : src) {
            for (int d = 0; d < interval.numDimensions(); ++d) {
                for (long i = interval.min(d); i <= interval.max(d); ++i) {
                    setDims[d].add(i);
                }
            }
        }
        this.m_invalidDims = new ArrayList<Integer>();
        if (this.m_adjustDimensionality) {
            for (int d = 0; d < setDims.length; ++d) {
                if (setDims[d].size() != 1) continue;
                this.m_invalidDims.add(d);
            }
        }
        long[] resDims = new long[numMaxDims - this.m_invalidDims.size()];
        int k = 0;
        for (int d = 0; d < numMaxDims; ++d) {
            if (this.m_invalidDims.contains(d)) continue;
            resDims[k++] = setDims[d].size();
        }
        return resDims;
    }

    @Override
    public final NativeImgLabeling<L, ? extends IntegerType<?>> compute(Labeling<L>[] intervals, NativeImgLabeling<L, ? extends IntegerType<?>> res) {
        if (this.m_invalidDims == null) {
            this.initConstants(intervals);
        }
        RandomAccess randomAccess = res.randomAccess();
        Arrays.sort(intervals, new Comparator<Interval>(){

            @Override
            public int compare(Interval o1, Interval o2) {
                for (int d = 0; d < Math.min(o1.numDimensions(), o2.numDimensions()); ++d) {
                    if (o1.min(d) == o2.min(d)) continue;
                    return (int)o1.min(d) - (int)o2.min(d);
                }
                return 0;
            }
        });
        long[] offset = new long[intervals[0].numDimensions()];
        long[] intervalWidth = new long[intervals[0].numDimensions()];
        intervals[0].min(offset);
        intervals[0].dimensions(intervalWidth);
        this.writeInterval((RandomAccess<LabelingType<L>>)randomAccess, (IterableInterval<LabelingType<L>>)intervals[0], offset);
        for (int i = 1; i < intervals.length; ++i) {
            for (int d = 0; d < intervals[i].numDimensions(); ++d) {
                if (intervals[i].min(d) == intervals[i - 1].min(d)) continue;
                for (int innerD = d + 1; innerD < intervals[i].numDimensions(); ++innerD) {
                    intervalWidth[innerD] = 0L;
                }
                offset[d] = intervals[i].min(d) - intervalWidth[d];
                int n = d;
                intervalWidth[n] = intervalWidth[n] + intervals[i].dimension(d);
            }
            this.writeInterval((RandomAccess<LabelingType<L>>)randomAccess, (IterableInterval<LabelingType<L>>)intervals[i], offset);
        }
        return res;
    }

    private void writeInterval(RandomAccess<LabelingType<L>> resAccess, IterableInterval<LabelingType<L>> interval, long[] offset) {
        Cursor localizingCursor = interval.localizingCursor();
        while (localizingCursor.hasNext()) {
            localizingCursor.fwd();
            int offsetCtr = 0;
            for (int d = 0; d < interval.numDimensions(); ++d) {
                if (this.m_invalidDims.contains(d)) {
                    ++offsetCtr;
                    continue;
                }
                resAccess.setPosition((long)localizingCursor.getIntPosition(d) - offset[d], d - offsetCtr);
            }
            ((LabelingType)resAccess.get()).set((LabelingType)localizingCursor.get());
        }
    }

    @Override
    public MergeLabelings<L> copy() {
        return new MergeLabelings<L>((IntegerType)this.m_resType.copy(), this.m_adjustDimensionality);
    }

    @Override
    public NativeImgLabeling<L, ? extends IntegerType<?>> compute(Labeling<L>[] op) {
        return this.compute(op, this.createEmptyOutput(op));
    }

    public List<Integer> getInvalidDims() {
        return this.m_invalidDims;
    }
}

