/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.awt;

import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import org.scijava.display.Display;
import org.scijava.display.event.window.WinActivatedEvent;
import org.scijava.display.event.window.WinClosedEvent;
import org.scijava.display.event.window.WinClosingEvent;
import org.scijava.display.event.window.WinDeactivatedEvent;
import org.scijava.display.event.window.WinDeiconifiedEvent;
import org.scijava.display.event.window.WinIconifiedEvent;
import org.scijava.display.event.window.WinOpenedEvent;
import org.scijava.event.EventService;
import org.scijava.event.SciJavaEvent;

public class AWTWindowEventDispatcher
implements WindowListener {
    private final Display<?> display;
    private final EventService eventService;

    public AWTWindowEventDispatcher(Display<?> display) {
        this.display = display;
        this.eventService = (EventService)display.getContext().getService(EventService.class);
    }

    public AWTWindowEventDispatcher(EventService eventService) {
        this.display = null;
        this.eventService = eventService;
    }

    public void register(Window w) {
        w.addWindowListener(this);
    }

    @Override
    public void windowActivated(WindowEvent e) {
        this.eventService.publish((SciJavaEvent)new WinActivatedEvent(this.display, (Object)e.getWindow()));
    }

    @Override
    public void windowClosed(WindowEvent e) {
        this.eventService.publish((SciJavaEvent)new WinClosedEvent(this.display, (Object)e.getWindow()));
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.eventService.publish((SciJavaEvent)new WinClosingEvent(this.display, (Object)e.getWindow()));
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
        this.eventService.publish((SciJavaEvent)new WinDeactivatedEvent(this.display, (Object)e.getWindow()));
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
        this.eventService.publish((SciJavaEvent)new WinDeiconifiedEvent(this.display, (Object)e.getWindow()));
    }

    @Override
    public void windowIconified(WindowEvent e) {
        this.eventService.publish((SciJavaEvent)new WinIconifiedEvent(this.display, (Object)e.getWindow()));
    }

    @Override
    public void windowOpened(WindowEvent e) {
        this.eventService.publish((SciJavaEvent)new WinOpenedEvent(this.display, (Object)e.getWindow()));
    }
}

