/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.circulinear.buffer;

import math.geom2d.Angle2D;
import math.geom2d.Point2D;
import math.geom2d.Vector2D;
import math.geom2d.circulinear.CirculinearContinuousCurve2D;
import math.geom2d.circulinear.CirculinearElement2D;
import math.geom2d.circulinear.buffer.JoinFactory;
import math.geom2d.conic.CircleArc2D;
import math.geom2d.curve.Curves2D;
import math.geom2d.line.LineSegment2D;

public class RoundJoinFactory
implements JoinFactory {
    public CirculinearContinuousCurve2D createJoin(CirculinearElement2D curve1, CirculinearElement2D curve2, double dist) {
        double endAngle;
        double startAngle;
        Point2D center = curve2.firstPoint();
        Curves2D.JunctionType junctionType = Curves2D.getJunctionType(curve1, curve2);
        Vector2D direction1 = curve1.tangent(curve1.t1());
        Vector2D direction2 = curve2.tangent(curve2.t0());
        double angle1 = direction1.angle();
        double angle2 = direction2.angle();
        if (dist > 0.0 && junctionType == Curves2D.JunctionType.REENTRANT || dist <= 0.0 && junctionType == Curves2D.JunctionType.SALIENT) {
            Point2D p1 = Point2D.createPolar(center, dist, angle1 - 1.5707963267948966);
            Point2D p2 = Point2D.createPolar(center, dist, angle2 - 1.5707963267948966);
            return new LineSegment2D(p1, p2);
        }
        if (dist > 0.0) {
            startAngle = angle1 - 1.5707963267948966;
            endAngle = angle2 - 1.5707963267948966;
        } else {
            startAngle = angle1 + 1.5707963267948966;
            endAngle = angle2 + 1.5707963267948966;
        }
        startAngle = Angle2D.formatAngle(startAngle);
        endAngle = Angle2D.formatAngle(endAngle);
        if (junctionType == Curves2D.JunctionType.FLAT) {
            return new CircleArc2D(center, Math.abs(dist), startAngle, 0.0);
        }
        return new CircleArc2D(center, Math.abs(dist), startAngle, endAngle, dist > 0.0);
    }
}

