/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.VersionNumber;
import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.AbstractGraphicsScreen;
import com.jogamp.nativewindow.CapabilitiesChooser;
import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.nativewindow.GraphicsConfigurationFactory;
import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.nativewindow.NativeWindow;
import com.jogamp.nativewindow.NativeWindowFactory;
import com.jogamp.nativewindow.OffscreenLayerOption;
import com.jogamp.nativewindow.ProxySurface;
import com.jogamp.nativewindow.UpstreamSurfaceHook;
import com.jogamp.nativewindow.awt.AWTGraphicsConfiguration;
import com.jogamp.nativewindow.awt.AWTGraphicsDevice;
import com.jogamp.nativewindow.awt.AWTGraphicsScreen;
import com.jogamp.nativewindow.awt.JAWTWindow;
import com.jogamp.opengl.DefaultGLCapabilitiesChooser;
import com.jogamp.opengl.FBObject;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GL2ES3;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesChooser;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLFBODrawable;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.Threading;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Window;
import java.io.UnsupportedEncodingException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.Context;
import org.jogamp.java3d.Drawable;
import org.jogamp.java3d.DrawingSurfaceObject;
import org.jogamp.java3d.GeometryArray;
import org.jogamp.java3d.GeometryArrayRetained;
import org.jogamp.java3d.GeometryStripArrayRetained;
import org.jogamp.java3d.GraphicsConfigInfo;
import org.jogamp.java3d.GraphicsConfigTemplate3D;
import org.jogamp.java3d.IllegalRenderingStateException;
import org.jogamp.java3d.IndexedGeometryStripArrayRetained;
import org.jogamp.java3d.Jogl2es2Context;
import org.jogamp.java3d.Jogl2es2DEPPipeline;
import org.jogamp.java3d.Jogl2es2MatrixUtil;
import org.jogamp.java3d.JoglContext;
import org.jogamp.java3d.JoglDrawable;
import org.jogamp.java3d.JoglDrawingSurfaceObject;
import org.jogamp.java3d.JoglGraphicsConfiguration;
import org.jogamp.java3d.JoglShaderObject;
import org.jogamp.java3d.MasterControl;
import org.jogamp.java3d.Pipeline;
import org.jogamp.java3d.ShaderAttrLoc;
import org.jogamp.java3d.ShaderError;
import org.jogamp.java3d.ShaderId;
import org.jogamp.java3d.ShaderProgramId;
import org.jogamp.java3d.SparseArray;
import org.jogamp.java3d.VirtualUniverse;
import org.jogamp.vecmath.SingularMatrixException;
import org.jogamp.vecmath.Vector4f;

class Jogl2es2Pipeline
extends Jogl2es2DEPPipeline {
    private static final boolean DO_OUTPUT_ERRORS = false;
    static final boolean VERBOSE = false;
    private static final boolean DEBUG_CONFIG = false;
    private static final boolean EXTRA_DEBUGGING = false;
    private static final boolean OUTPUT_PER_FRAME_STATS = false;
    private static final boolean MINIMISE_NATIVE_CALLS_FFP = true;
    private static final boolean MINIMISE_NATIVE_CALLS_TRANSPARENCY = true;
    private static final boolean MINIMISE_NATIVE_CALLS_TEXTURE = true;
    private static final boolean MINIMISE_NATIVE_SHADER = true;
    private static final boolean MINIMISE_NATIVE_CALLS_OTHER = true;
    private static final boolean NEVER_RELEASE_CONTEXT = false;
    private static boolean quadArrayCautionPrinted = false;
    private boolean NO_PROGRAM_WARNING_GIVEN = false;
    private boolean USE_NULL_SHADER_WARNING_GIVEN = false;
    private static final Vector4f black = new Vector4f();
    private boolean pointsEnabled = false;
    private static final int[] _gl_textureCubeMapFace = new int[]{34069, 34070, 34071, 34072, 34073, 34074};
    private static final int[] blendFunctionTable = new int[9];
    public static boolean currently_current;
    private static final int WAIT_TIME = 1000;
    private static final int MIN_FRAME_SIZE = 1;
    private GLProfile profile;
    private static ThreadLocal<ShortBuffer> nioIndexTemp;
    private static ThreadLocal<FloatBuffer> nioVertexTemp;
    private static ThreadLocal<DoubleBuffer> nioVertexDoubleTemp;
    private static ThreadLocal<FloatBuffer> nioColorTemp;
    private static ThreadLocal<ByteBuffer> nioColorByteTemp;
    private static ThreadLocal<FloatBuffer> nioNormalTemp;
    private static ThreadLocal<FloatBuffer[]> nioTexCoordSetTemp;
    private static ThreadLocal<FloatBuffer[]> nioVertexAttrSetTemp;
    private isExtensionAvailable isExtensionAvailable = new isExtensionAvailable();

    protected Jogl2es2Pipeline() {
    }

    @Override
    void initialize(Pipeline.Type pipelineType) {
        super.initialize(pipelineType);
        Threading.disableSingleThreading();
        this.profile = GLProfile.get((String)"GL2ES2");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerClearBuffers(Context ctx, GeometryArrayRetained geo) {
        Jogl2es2Context joglesctx = (Jogl2es2Context)ctx;
        ArrayList<GeometryArrayRetained> arrayList = joglesctx.geoToClearBuffers;
        synchronized (arrayList) {
            joglesctx.geoToClearBuffers.add(geo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doClearBuffers(Context ctx) {
        Jogl2es2Context joglesctx = (Jogl2es2Context)ctx;
        if (joglesctx.geoToClearBuffers.size() > 0) {
            ArrayList<GeometryArrayRetained> arrayList = joglesctx.geoToClearBuffers;
            synchronized (arrayList) {
                GL2ES2 gl = joglesctx.gl2es2();
                for (GeometryArrayRetained geo : joglesctx.geoToClearBuffers) {
                    SparseArray<Integer> vaBufIds;
                    SparseArray<Integer> tcBufIds;
                    int[] bufIds;
                    Jogl2es2Context.GeometryData gd = joglesctx.allGeometryData.get(geo.nativeId);
                    joglesctx.allGeometryData.remove(geo.nativeId);
                    geo.nativeId = -1;
                    if (gd == null) continue;
                    if (gd.geoToIndBuf != -1) {
                        gl.glDeleteBuffers(1, new int[]{gd.geoToIndBuf}, 0);
                    }
                    if (gd.geoToCoordBuf != -1) {
                        gl.glDeleteBuffers(1, new int[]{gd.geoToCoordBuf}, 0);
                    }
                    if (gd.geoToColorBuf != -1) {
                        gl.glDeleteBuffers(1, new int[]{gd.geoToColorBuf}, 0);
                    }
                    if (gd.geoToNormalBuf != -1) {
                        gl.glDeleteBuffers(1, new int[]{gd.geoToNormalBuf}, 0);
                    }
                    if ((bufIds = gd.geoToIndStripBuf) != null && bufIds.length > 0) {
                        gl.glDeleteBuffers(bufIds.length, bufIds, 0);
                    }
                    if ((tcBufIds = gd.geoToTexCoordsBuf) != null) {
                        for (int i = 0; i < tcBufIds.size(); ++i) {
                            Integer tcBufId = tcBufIds.get(tcBufIds.keyAt(i));
                            if (tcBufId == null) continue;
                            gl.glDeleteBuffers(1, new int[]{tcBufId}, 0);
                        }
                        tcBufIds.clear();
                    }
                    if ((vaBufIds = gd.geoToVertAttribBuf) != null) {
                        for (int i = 0; i < vaBufIds.size(); ++i) {
                            Integer vaBufId = vaBufIds.get(vaBufIds.keyAt(i));
                            if (vaBufId == null) continue;
                            gl.glDeleteBuffers(1, new int[]{vaBufId}, 0);
                        }
                        vaBufIds.clear();
                    }
                    if (gd.interleavedBufId != -1) {
                        gl.glDeleteBuffers(1, new int[]{gd.interleavedBufId}, 0);
                    }
                    if (gd.vaoId == -1) continue;
                    ((GL2ES3)gl).glDeleteVertexArrays(1, new int[]{gd.vaoId}, 0);
                }
                joglesctx.geoToClearBuffers.clear();
            }
        }
    }

    @Override
    void execute(Context ctx, GeometryArrayRetained geo, int geo_type, boolean isNonUniformScale, boolean useAlpha, boolean ignoreVertexColors, int startVIndex, int vcount, int vformat, int texCoordSetCount, int[] texCoordSetMap, int texCoordSetMapLen, int[] texUnitOffset, int numActiveTexUnitState, int vertexAttrCount, int[] vertexAttrSizes, float[] varray, float[] carray, int cDirty) {
        this.executeGeometryArray(ctx, geo, geo_type, isNonUniformScale, useAlpha, ignoreVertexColors, startVIndex, vcount, vformat, texCoordSetCount, texCoordSetMap, texCoordSetMapLen, texUnitOffset, numActiveTexUnitState, vertexAttrCount, vertexAttrSizes, varray, null, carray, cDirty);
    }

    @Override
    void executeInterleavedBuffer(Context ctx, GeometryArrayRetained geo, int geo_type, boolean isNonUniformScale, boolean useAlpha, boolean ignoreVertexColors, int startVIndex, int vcount, int vformat, int texCoordSetCount, int[] texCoordSetMap, int texCoordSetMapLen, int[] texUnitOffset, int numActiveTexUnit, FloatBuffer varray, float[] cdata, int cdirty) {
        this.executeGeometryArray(ctx, geo, geo_type, isNonUniformScale, useAlpha, ignoreVertexColors, startVIndex, vcount, vformat, texCoordSetCount, texCoordSetMap, texCoordSetMapLen, texUnitOffset, numActiveTexUnit, 0, null, null, varray, cdata, cdirty);
    }

    private void executeGeometryArray(Context absCtx, GeometryArrayRetained geo, int geo_type, boolean isNonUniformScale, boolean useAlpha, boolean ignoreVertexColors, int startVIndex, int vcount, int vformat, int texCoordSetCount, int[] texCoordSetMap, int texCoordSetMapLen, int[] texCoordSetMapOffset, int numActiveTexUnitState, int vertexAttrCount, int[] vertexAttrSizes, float[] varray, FloatBuffer varrayBuffer, float[] carray, int cDirty) {
        Jogl2es2Context ctx = (Jogl2es2Context)absCtx;
        int shaderProgramId = ctx.shaderProgramId;
        if (shaderProgramId != -1) {
            boolean changable;
            GL2ES2 gl = ctx.gl2es2();
            Jogl2es2Context.ProgramData pd = ctx.programData;
            Jogl2es2Context.LocationData locs = pd.programToLocationData;
            Jogl2es2Pipeline.setFFPAttributes(ctx, gl, shaderProgramId, pd, vformat, ignoreVertexColors);
            int stride = 0;
            int coordoff = 0;
            int normoff = 0;
            int coloroff = 0;
            int texCoordoff = 0;
            int texSize = 0;
            int texStride = 0;
            int vAttrOff = 0;
            int vAttrStride = 0;
            int bstride = 0;
            int cbstride = 0;
            int[] sarray = null;
            int[] start_array = null;
            if ((vformat & 1) != 0) {
                stride += 3;
            }
            if ((vformat & 2) != 0) {
                stride += 3;
                coordoff += 3;
            }
            if ((vformat & 4) != 0) {
                if ((vformat & 8) != 0) {
                    stride += 4;
                    normoff += 4;
                    coordoff += 4;
                } else {
                    stride += 3;
                    normoff += 3;
                    coordoff += 3;
                }
            }
            if ((vformat & 0x460) != 0) {
                if ((vformat & 0x20) != 0) {
                    texSize = 2;
                    texStride = 2 * texCoordSetCount;
                } else if ((vformat & 0x40) != 0) {
                    texSize = 3;
                    texStride = 3 * texCoordSetCount;
                } else if ((vformat & 0x400) != 0) {
                    texSize = 4;
                    texStride = 4 * texCoordSetCount;
                }
                stride += texStride;
                normoff += texStride;
                coloroff += texStride;
                coordoff += texStride;
            }
            if ((vformat & 0x1000) != 0) {
                for (int i = 0; i < vertexAttrCount; ++i) {
                    vAttrStride += vertexAttrSizes[i];
                }
                stride += vAttrStride;
                normoff += vAttrStride;
                coloroff += vAttrStride;
                coordoff += vAttrStride;
                texCoordoff += vAttrStride;
            }
            bstride = stride * 4;
            if (geo_type == 5 || geo_type == 6 || geo_type == 7) {
                sarray = ((GeometryStripArrayRetained)geo).stripVertexCounts;
                start_array = ((GeometryStripArrayRetained)geo).stripStartOffsetIndices;
            }
            int cstride = stride;
            if (carray != null) {
                cstride = 4;
            }
            cbstride = cstride * 4;
            int startVertex = stride * startVIndex;
            int startClrs = cstride * startVIndex;
            if (carray == null) {
                startClrs += coloroff;
            }
            Jogl2es2Context.GeometryData gd = Jogl2es2Pipeline.loadAllBuffers(ctx, gl, geo, ignoreVertexColors, vcount, vformat, vformat, varrayBuffer, varray, startVertex, varrayBuffer, carray, startClrs);
            boolean morphable = geo.source.getCapability(19) || geo.source.getCapability(1);
            boolean bindingRequired = true;
            if (gl.isGL2ES3()) {
                GL2ES3 gl2es3 = (GL2ES3)gl;
                if (gd.vaoId == -1) {
                    int[] tmp = new int[1];
                    gl2es3.glGenVertexArrays(1, tmp, 0);
                    gd.vaoId = tmp[0];
                } else {
                    bindingRequired = false;
                }
                gl2es3.glBindVertexArray(gd.vaoId);
            }
            if (locs.glVertex != -1) {
                if (gd.geoToCoordBuf == -1) {
                    new Throwable("Buffer load issue!").printStackTrace();
                } else if (morphable) {
                    FloatBuffer verts = null;
                    verts = varray != null ? Jogl2es2Pipeline.getVertexArrayBuffer(varray) : varrayBuffer;
                    verts.position(startVertex);
                    if (gd.geoToCoordBufSize != verts.remaining()) {
                        System.err.println("Morphable buffer changed " + gd.geoToCoordBufSize + " != " + verts.remaining() + " un indexed ((GeometryArray) geo.source) " + ((GeometryArray)geo.source).getName() + " " + geo.source + ", this is not nessasarily a problem");
                        int prevBufId1 = gd.geoToCoordBuf1;
                        int prevBufId2 = gd.geoToCoordBuf2;
                        int[] tmp = new int[2];
                        gl.glGenBuffers(2, tmp, 0);
                        gd.geoToCoordBuf = tmp[0];
                        gd.geoToCoordBuf1 = tmp[0];
                        gd.geoToCoordBuf2 = tmp[1];
                        gl.glBindBuffer(34962, gd.geoToCoordBuf1);
                        gl.glBufferData(34962, (long)(verts.remaining() * 32 / 8), (Buffer)verts, 35048);
                        gl.glBindBuffer(34962, gd.geoToCoordBuf2);
                        gl.glBufferData(34962, (long)(verts.remaining() * 32 / 8), (Buffer)verts, 35048);
                        gd.geoToCoordBufSize = verts.remaining();
                        gl.glBindBuffer(34962, gd.geoToCoordBuf);
                        gl.glVertexAttribPointer(locs.glVertex, 3, 5126, false, 0, 0L);
                        gl.glEnableVertexAttribArray(locs.glVertex);
                        gl.glDeleteBuffers(1, new int[]{prevBufId1, prevBufId2}, 0);
                    } else if (gd.geoToCoordBuf == gd.geoToCoordBuf1) {
                        gl.glBindBuffer(34962, gd.geoToCoordBuf1);
                        gl.glBufferSubData(34962, 0L, (long)(verts.remaining() * 32 / 8), (Buffer)verts);
                        gd.geoToCoordBuf = gd.geoToCoordBuf2;
                    } else {
                        gl.glBindBuffer(34962, gd.geoToCoordBuf2);
                        gl.glBufferSubData(34962, 0L, (long)(verts.remaining() * 32 / 8), (Buffer)verts);
                        gd.geoToCoordBuf = gd.geoToCoordBuf1;
                    }
                }
            } else {
                throw new UnsupportedOperationException("Shader has no glVertex.\nThe Gl2ES2 pipeline only supports a subset of the Geometry data types and formats. \nCoordinates must be defined and float type, colors must be float type, if defined. \nDecaling is not supported. \nModel Clip is not supported and must be reimplemented in shaders \nTexture Coordinate generation ignored, must be done in shaders. \nTexture Lod, Filter, Sharpen and Combine cannot be supported. \nTexture3D cannot be supported. \nAccum style anti-aliasing cannot be supported. \nRasterOps from RenderingAttributes cannot be used. \nReadRaster for depth requires a custom shader and color read instead. \nIt is strongly recomended that you use the format GeometryArray.USE_NIO_BUFFER = true. \nNote LineArray and LineStripArray will not render as nicely as the fixed function pipeline.");
            }
            if ((vformat & 4) != 0 && locs.glColor != -1 && !ignoreVertexColors && (changable = geo.source.getCapability(3))) {
                FloatBuffer verts = null;
                FloatBuffer clrs = null;
                verts = varray != null ? Jogl2es2Pipeline.getVertexArrayBuffer(varray) : varrayBuffer;
                if (carray != null) {
                    verts = Jogl2es2Pipeline.getColorArrayBuffer(carray);
                } else {
                    clrs = verts;
                }
                clrs.position(0);
                gl.glBindBuffer(34962, gd.geoToColorBuf);
                gl.glBufferSubData(34962, 0L, (long)(clrs.remaining() * 32 / 8), (Buffer)clrs);
            }
            if (bindingRequired || morphable) {
                gl.glBindBuffer(34962, gd.geoToCoordBuf);
                gl.glVertexAttribPointer(locs.glVertex, 3, 5126, false, bstride, (long)((startVertex + coordoff) * 4));
                gl.glEnableVertexAttribArray(locs.glVertex);
            }
            if (bindingRequired) {
                if ((vformat & 4) != 0 && locs.glColor != -1 && !ignoreVertexColors) {
                    if (gd.geoToColorBuf == -1) {
                        new Throwable("Buffer load issue!").printStackTrace();
                    } else {
                        int sz = (vformat & 8) != 0 ? 4 : 3;
                        gl.glBindBuffer(34962, gd.geoToColorBuf);
                        gl.glVertexAttribPointer(locs.glColor, sz, 5126, false, cbstride, (long)((startVertex + coloroff) * 4));
                        gl.glEnableVertexAttribArray(locs.glColor);
                    }
                } else if (locs.glColor != -1) {
                    gl.glDisableVertexAttribArray(locs.glColor);
                }
                if ((vformat & 2) != 0 && locs.glNormal != -1) {
                    if (gd.geoToCoordBuf == -1) {
                        new Throwable("Buffer load issue!").printStackTrace();
                    } else {
                        gl.glBindBuffer(34962, gd.geoToCoordBuf);
                        gl.glVertexAttribPointer(locs.glNormal, 3, 5126, false, bstride, (long)((startVertex + normoff) * 4));
                        gl.glEnableVertexAttribArray(locs.glNormal);
                    }
                } else if (locs.glNormal != -1) {
                    gl.glDisableVertexAttribArray(locs.glNormal);
                }
                if ((vformat & 0x1000) != 0) {
                    int vAttrOffset = startVertex + vAttrOff;
                    for (int index = 0; index < vertexAttrCount; ++index) {
                        Integer attribLoc = locs.genAttIndexToLoc.get(index);
                        if (attribLoc == null || attribLoc == -1) continue;
                        int sz = vertexAttrSizes[index];
                        gl.glBindBuffer(34962, gd.geoToCoordBuf);
                        gl.glVertexAttribPointer(attribLoc.intValue(), sz, 5126, false, bstride, (long)(vAttrOffset * 4));
                        gl.glEnableVertexAttribArray(attribLoc.intValue());
                        vAttrOffset += vertexAttrSizes[index];
                    }
                }
                if ((vformat & 0x460) != 0) {
                    boolean[] texSetsBound = new boolean[texCoordSetMapLen];
                    for (int texUnit = 0; texUnit < numActiveTexUnitState && texUnit < texCoordSetMapLen; ++texUnit) {
                        int texSet = texCoordSetMap[texUnit];
                        if (texSet == -1 || locs.glMultiTexCoord[texSet] == -1 || texSetsBound[texSet]) continue;
                        texSetsBound[texSet] = true;
                        gl.glBindBuffer(34962, gd.geoToCoordBuf);
                        gl.glVertexAttribPointer(locs.glMultiTexCoord[texUnit], texSize, 5126, true, bstride, (long)((startVertex + texCoordoff + texCoordSetMapOffset[texUnit]) * 4));
                        gl.glEnableVertexAttribArray(locs.glMultiTexCoord[texUnit]);
                    }
                }
            }
            if (geo_type == 5 || geo_type == 6 || geo_type == 7) {
                int primType = 0;
                if (ctx.polygonMode == 1) {
                    geo_type = 7;
                }
                switch (geo_type) {
                    case 5: {
                        primType = 5;
                        break;
                    }
                    case 6: {
                        primType = 6;
                        break;
                    }
                    case 7: {
                        primType = 2;
                    }
                }
                for (int i = 0; i < sarray.length; ++i) {
                    if (sarray[i] <= 0) continue;
                    gl.glDrawArrays(primType, start_array[i], sarray[i]);
                }
            } else {
                if (ctx.polygonMode == 1) {
                    geo_type = 4;
                } else if (ctx.polygonMode == 0) {
                    geo_type = 3;
                }
                switch (geo_type) {
                    case 1: {
                        if (!quadArrayCautionPrinted) {
                            System.err.println("QuadArray will render incorrectly, consider using TriangleArray. If you have the java3d-utils in the buildpath you can convert like this:");
                            System.err.println("GeometryInfo gi = new GeometryInfo(quadArray);");
                            System.err.println("gi.convertToIndexedTriangles();\t");
                            System.err.println("GeometryArray ga = gi.getIndexedGeometryArray(true, true, true, true, true);");
                            quadArrayCautionPrinted = true;
                        }
                    }
                    case 2: {
                        gl.glDrawArrays(4, 0, vcount);
                        break;
                    }
                    case 3: {
                        gl.glDrawArrays(0, 0, vcount);
                        break;
                    }
                    case 4: {
                        gl.glDrawArrays(1, 0, vcount);
                    }
                }
            }
        } else {
            if (!this.NO_PROGRAM_WARNING_GIVEN) {
                System.err.println("Execute called with no shader Program in use!");
            }
            this.NO_PROGRAM_WARNING_GIVEN = true;
        }
    }

    private static String getVertexDescription(int vformat) {
        String res = "";
        if ((vformat & 1) != 0) {
            res = res + "COORDINATES ";
        }
        if ((vformat & 2) != 0) {
            res = res + "NORMALS ";
        }
        if ((vformat & 4) != 0) {
            res = res + "COLOR ";
        }
        if ((vformat & 8) != 0) {
            res = res + "(WITH_ALPHA) ";
        }
        if ((vformat & 0x460) != 0) {
            res = res + "TEXTURE_COORDINATE ";
        }
        if ((vformat & 0x20) != 0) {
            res = res + "(2) ";
        }
        if ((vformat & 0x40) != 0) {
            res = res + "(3) ";
        }
        if ((vformat & 0x400) != 0) {
            res = res + "(4) ";
        }
        if ((vformat & 0x1000) != 0) {
            res = res + "VERTEX_ATTRIBUTES ";
        }
        return res;
    }

    private static String getGeometryDescription(int geo_type) {
        switch (geo_type) {
            case 5: {
                return "GEO_TYPE_TRI_STRIP_SET";
            }
            case 6: {
                return "GEO_TYPE_TRI_FAN_SET";
            }
            case 7: {
                return "GEO_TYPE_LINE_STRIP_SET";
            }
            case 1: {
                return "GEO_TYPE_QUAD_SET";
            }
            case 2: {
                return "GEO_TYPE_TRI_SET";
            }
            case 3: {
                return "GEO_TYPE_POINT_SET";
            }
            case 4: {
                return "GEO_TYPE_LINE_SET";
            }
        }
        return "(unknown " + geo_type + ")";
    }

    @Override
    void executeVABuffer(Context ctx, GeometryArrayRetained geo, int geo_type, boolean isNonUniformScale, boolean ignoreVertexColors, int vcount, int vformat, int vdefined, int initialCoordIndex, Buffer vcoords, int initialColorIndex, Buffer cdataBuffer, float[] cfdata, byte[] cbdata, int initialNormalIndex, FloatBuffer ndata, int vertexAttrCount, int[] vertexAttrSizes, int[] vertexAttrIndices, FloatBuffer[] vertexAttrData, int texCoordMapLength, int[] texcoordoffset, int numActiveTexUnitState, int[] texIndex, int texstride, Object[] texCoords, int cdirty) {
        boolean floatCoordDefined = (vdefined & 1) != 0;
        boolean doubleCoordDefined = (vdefined & 2) != 0;
        boolean floatColorsDefined = (vdefined & 4) != 0;
        boolean byteColorsDefined = (vdefined & 8) != 0;
        boolean normalsDefined = (vdefined & 0x10) != 0;
        boolean vattrDefined = (vdefined & 0x40) != 0;
        boolean textureDefined = (vdefined & 0x20) != 0;
        FloatBuffer fverts = null;
        DoubleBuffer dverts = null;
        FloatBuffer fclrs = null;
        ByteBuffer bclrs = null;
        FloatBuffer norms = null;
        FloatBuffer[] vertexAttrBufs = null;
        if (vattrDefined) {
            vertexAttrBufs = vertexAttrData;
        }
        if (floatCoordDefined) {
            fverts = (FloatBuffer)vcoords;
        } else if (doubleCoordDefined) {
            throw new UnsupportedOperationException("Double coordinates in use.\nThe Gl2ES2 pipeline only supports a subset of the Geometry data types and formats. \nCoordinates must be defined and float type, colors must be float type, if defined. \nDecaling is not supported. \nModel Clip is not supported and must be reimplemented in shaders \nTexture Coordinate generation ignored, must be done in shaders. \nTexture Lod, Filter, Sharpen and Combine cannot be supported. \nTexture3D cannot be supported. \nAccum style anti-aliasing cannot be supported. \nRasterOps from RenderingAttributes cannot be used. \nReadRaster for depth requires a custom shader and color read instead. \nIt is strongly recomended that you use the format GeometryArray.USE_NIO_BUFFER = true. \nNote LineArray and LineStripArray will not render as nicely as the fixed function pipeline.");
        }
        if (fverts == null && dverts == null) {
            return;
        }
        if (floatColorsDefined) {
            fclrs = (FloatBuffer)cdataBuffer;
        }
        if (byteColorsDefined) {
            throw new UnsupportedOperationException("byteColorsDefined.\nThe Gl2ES2 pipeline only supports a subset of the Geometry data types and formats. \nCoordinates must be defined and float type, colors must be float type, if defined. \nDecaling is not supported. \nModel Clip is not supported and must be reimplemented in shaders \nTexture Coordinate generation ignored, must be done in shaders. \nTexture Lod, Filter, Sharpen and Combine cannot be supported. \nTexture3D cannot be supported. \nAccum style anti-aliasing cannot be supported. \nRasterOps from RenderingAttributes cannot be used. \nReadRaster for depth requires a custom shader and color read instead. \nIt is strongly recomended that you use the format GeometryArray.USE_NIO_BUFFER = true. \nNote LineArray and LineStripArray will not render as nicely as the fixed function pipeline.");
        }
        if (normalsDefined) {
            norms = ndata;
        }
        int[] sarray = null;
        int[] start_array = null;
        int strip_len = 0;
        if (geo_type == 5 || geo_type == 6 || geo_type == 7) {
            sarray = ((GeometryStripArrayRetained)geo).stripVertexCounts;
            strip_len = sarray.length;
            start_array = ((GeometryStripArrayRetained)geo).stripStartOffsetIndices;
        }
        this.executeGeometryArrayVA(ctx, geo, geo_type, isNonUniformScale, ignoreVertexColors, vcount, vformat, vdefined, initialCoordIndex, fverts, null, dverts, null, initialColorIndex, fclrs, cfdata, bclrs, null, initialNormalIndex, norms, null, vertexAttrCount, vertexAttrSizes, vertexAttrIndices, vertexAttrBufs, null, texCoordMapLength, texcoordoffset, numActiveTexUnitState, texIndex, texstride, texCoords, cdirty, sarray, strip_len, start_array);
    }

    @Override
    void executeVA(Context ctx, GeometryArrayRetained geo, int geo_type, boolean isNonUniformScale, boolean ignoreVertexColors, int vcount, int vformat, int vdefined, int initialCoordIndex, float[] vfcoords, double[] vdcoords, int initialColorIndex, float[] cfdata, byte[] cbdata, int initialNormalIndex, float[] ndata, int vertexAttrCount, int[] vertexAttrSizes, int[] vertexAttrIndices, float[][] vertexAttrData, int texCoordMapLength, int[] texcoordoffset, int numActiveTexUnitState, int[] texIndex, int texstride, Object[] texCoords, int cdirty) {
        boolean floatCoordDefined = (vdefined & 1) != 0;
        boolean doubleCoordDefined = (vdefined & 2) != 0;
        boolean floatColorsDefined = (vdefined & 4) != 0;
        boolean byteColorsDefined = (vdefined & 8) != 0;
        boolean normalsDefined = (vdefined & 0x10) != 0;
        boolean vattrDefined = (vdefined & 0x40) != 0;
        boolean textureDefined = (vdefined & 0x20) != 0;
        int[] sarray = null;
        int[] start_array = null;
        int strip_len = 0;
        if (geo_type == 5 || geo_type == 6 || geo_type == 7) {
            sarray = ((GeometryStripArrayRetained)geo).stripVertexCounts;
            strip_len = sarray.length;
            start_array = ((GeometryStripArrayRetained)geo).stripStartOffsetIndices;
        }
        if (doubleCoordDefined) {
            throw new UnsupportedOperationException("doubleCoordDefined.\nThe Gl2ES2 pipeline only supports a subset of the Geometry data types and formats. \nCoordinates must be defined and float type, colors must be float type, if defined. \nDecaling is not supported. \nModel Clip is not supported and must be reimplemented in shaders \nTexture Coordinate generation ignored, must be done in shaders. \nTexture Lod, Filter, Sharpen and Combine cannot be supported. \nTexture3D cannot be supported. \nAccum style anti-aliasing cannot be supported. \nRasterOps from RenderingAttributes cannot be used. \nReadRaster for depth requires a custom shader and color read instead. \nIt is strongly recomended that you use the format GeometryArray.USE_NIO_BUFFER = true. \nNote LineArray and LineStripArray will not render as nicely as the fixed function pipeline.");
        }
        if (byteColorsDefined) {
            throw new UnsupportedOperationException("byteColorsDefined.\nThe Gl2ES2 pipeline only supports a subset of the Geometry data types and formats. \nCoordinates must be defined and float type, colors must be float type, if defined. \nDecaling is not supported. \nModel Clip is not supported and must be reimplemented in shaders \nTexture Coordinate generation ignored, must be done in shaders. \nTexture Lod, Filter, Sharpen and Combine cannot be supported. \nTexture3D cannot be supported. \nAccum style anti-aliasing cannot be supported. \nRasterOps from RenderingAttributes cannot be used. \nReadRaster for depth requires a custom shader and color read instead. \nIt is strongly recomended that you use the format GeometryArray.USE_NIO_BUFFER = true. \nNote LineArray and LineStripArray will not render as nicely as the fixed function pipeline.");
        }
        this.executeGeometryArrayVA(ctx, geo, geo_type, isNonUniformScale, ignoreVertexColors, vcount, vformat, vdefined, initialCoordIndex, null, vfcoords, null, vdcoords, initialColorIndex, null, cfdata, null, cbdata, initialNormalIndex, null, ndata, vertexAttrCount, vertexAttrSizes, vertexAttrIndices, null, vertexAttrData, texCoordMapLength, texcoordoffset, numActiveTexUnitState, texIndex, texstride, texCoords, cdirty, sarray, strip_len, start_array);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void executeGeometryArrayVA(Context absCtx, GeometryArrayRetained geo, int geo_type, boolean isNonUniformScale, boolean ignoreVertexColors, int vertexCount, int vformat, int vdefined, int initialCoordIndex, FloatBuffer fverts, float[] vfcoords, DoubleBuffer dverts, double[] vdcoords, int initialColorIndex, FloatBuffer fclrs, float[] cfdata, ByteBuffer bclrs, byte[] cbdata, int initialNormalIndex, FloatBuffer norms, float[] ndata, int vertexAttrCount, int[] vertexAttrSizes, int[] vertexAttrIndices, FloatBuffer[] vertexAttrBufs, float[][] vertexAttrData, int texCoordMapLength, int[] texCoordSetMap, int numActiveTexUnitState, int[] texindices, int texStride, Object[] texCoords, int cDirty, int[] sarray, int strip_len, int[] start_array) {
        Jogl2es2Context ctx = (Jogl2es2Context)absCtx;
        int shaderProgramId = ctx.shaderProgramId;
        if (shaderProgramId != -1) {
            int texSet;
            Integer attribLoc;
            boolean changable;
            GL2ES2 gl = ctx.gl2es2();
            Jogl2es2Context.ProgramData pd = ctx.programData;
            Jogl2es2Context.LocationData locs = pd.programToLocationData;
            Jogl2es2Pipeline.setFFPAttributes(ctx, gl, shaderProgramId, pd, vdefined, ignoreVertexColors);
            Jogl2es2Context.GeometryData gd = Jogl2es2Pipeline.loadAllBuffers(ctx, gl, geo, ignoreVertexColors, vertexCount, vformat, vdefined, fverts, vfcoords, dverts, vdcoords, fclrs, cfdata, bclrs, cbdata, norms, ndata, vertexAttrCount, vertexAttrSizes, vertexAttrBufs, vertexAttrData, texCoordMapLength, texCoordSetMap, texStride, texCoords);
            boolean floatCoordDefined = (vdefined & 1) != 0;
            boolean doubleCoordDefined = (vdefined & 2) != 0;
            boolean floatColorsDefined = (vdefined & 4) != 0;
            boolean byteColorsDefined = (vdefined & 8) != 0;
            boolean normalsDefined = (vdefined & 0x10) != 0;
            boolean vattrDefined = (vdefined & 0x40) != 0;
            boolean textureDefined = (vdefined & 0x20) != 0;
            boolean morphable = geo.source.getCapability(19) || geo.source.getCapability(1);
            boolean bindingRequired = true;
            if (gl.isGL2ES3()) {
                GL2ES3 gl2es3 = (GL2ES3)gl;
                if (gd.vaoId == -1) {
                    int[] tmp = new int[1];
                    gl2es3.glGenVertexArrays(1, tmp, 0);
                    gd.vaoId = tmp[0];
                } else {
                    bindingRequired = false;
                }
                gl2es3.glBindVertexArray(gd.vaoId);
            }
            if (locs.glVertex == -1) throw new UnsupportedOperationException("Shader has no glVertex.\nThe Gl2ES2 pipeline only supports a subset of the Geometry data types and formats. \nCoordinates must be defined and float type, colors must be float type, if defined. \nDecaling is not supported. \nModel Clip is not supported and must be reimplemented in shaders \nTexture Coordinate generation ignored, must be done in shaders. \nTexture Lod, Filter, Sharpen and Combine cannot be supported. \nTexture3D cannot be supported. \nAccum style anti-aliasing cannot be supported. \nRasterOps from RenderingAttributes cannot be used. \nReadRaster for depth requires a custom shader and color read instead. \nIt is strongly recomended that you use the format GeometryArray.USE_NIO_BUFFER = true. \nNote LineArray and LineStripArray will not render as nicely as the fixed function pipeline.");
            if (floatCoordDefined) {
                if (gd.geoToCoordBuf == -1) {
                    new Throwable("Buffer load issue!").printStackTrace();
                } else if (morphable) {
                    if (vfcoords != null) {
                        fverts = Jogl2es2Pipeline.getVertexArrayBuffer(vfcoords);
                    }
                    int coordoff = 3 * initialCoordIndex;
                    fverts.position(coordoff);
                    if (gd.geoToCoordBufSize != fverts.remaining()) {
                        System.err.println("Morphable buffer changed " + gd.geoToCoordBufSize + " != " + fverts.remaining() + " un indexed ((GeometryArray) geo.source) " + ((GeometryArray)geo.source).getName() + " " + geo.source + ", this is not nessasarily a problem");
                        int prevBufId1 = gd.geoToCoordBuf1;
                        int prevBufId2 = gd.geoToCoordBuf2;
                        int[] tmp = new int[2];
                        gl.glGenBuffers(2, tmp, 0);
                        gd.geoToCoordBuf = tmp[0];
                        gd.geoToCoordBuf1 = tmp[0];
                        gd.geoToCoordBuf2 = tmp[1];
                        gl.glBindBuffer(34962, gd.geoToCoordBuf1);
                        gl.glBufferData(34962, (long)(fverts.remaining() * 32 / 8), (Buffer)fverts, 35048);
                        gl.glBindBuffer(34962, gd.geoToCoordBuf2);
                        gl.glBufferData(34962, (long)(fverts.remaining() * 32 / 8), (Buffer)fverts, 35048);
                        gd.geoToCoordBufSize = fverts.remaining();
                        gl.glBindBuffer(34962, gd.geoToCoordBuf);
                        gl.glVertexAttribPointer(locs.glVertex, 3, 5126, false, 0, 0L);
                        gl.glEnableVertexAttribArray(locs.glVertex);
                        gl.glDeleteBuffers(1, new int[]{prevBufId1, prevBufId2}, 0);
                    } else if (gd.geoToCoordBuf == gd.geoToCoordBuf1) {
                        gl.glBindBuffer(34962, gd.geoToCoordBuf1);
                        gl.glBufferSubData(34962, 0L, (long)(fverts.remaining() * 32 / 8), (Buffer)fverts);
                        gd.geoToCoordBuf = gd.geoToCoordBuf2;
                    } else {
                        gl.glBindBuffer(34962, gd.geoToCoordBuf2);
                        gl.glBufferSubData(34962, 0L, (long)(fverts.remaining() * 32 / 8), (Buffer)fverts);
                        gd.geoToCoordBuf = gd.geoToCoordBuf1;
                    }
                }
            } else {
                if (!doubleCoordDefined) throw new UnsupportedOperationException("No coords defined.\nThe Gl2ES2 pipeline only supports a subset of the Geometry data types and formats. \nCoordinates must be defined and float type, colors must be float type, if defined. \nDecaling is not supported. \nModel Clip is not supported and must be reimplemented in shaders \nTexture Coordinate generation ignored, must be done in shaders. \nTexture Lod, Filter, Sharpen and Combine cannot be supported. \nTexture3D cannot be supported. \nAccum style anti-aliasing cannot be supported. \nRasterOps from RenderingAttributes cannot be used. \nReadRaster for depth requires a custom shader and color read instead. \nIt is strongly recomended that you use the format GeometryArray.USE_NIO_BUFFER = true. \nNote LineArray and LineStripArray will not render as nicely as the fixed function pipeline.");
                throw new UnsupportedOperationException("doubleCoordDefined.\nThe Gl2ES2 pipeline only supports a subset of the Geometry data types and formats. \nCoordinates must be defined and float type, colors must be float type, if defined. \nDecaling is not supported. \nModel Clip is not supported and must be reimplemented in shaders \nTexture Coordinate generation ignored, must be done in shaders. \nTexture Lod, Filter, Sharpen and Combine cannot be supported. \nTexture3D cannot be supported. \nAccum style anti-aliasing cannot be supported. \nRasterOps from RenderingAttributes cannot be used. \nReadRaster for depth requires a custom shader and color read instead. \nIt is strongly recomended that you use the format GeometryArray.USE_NIO_BUFFER = true. \nNote LineArray and LineStripArray will not render as nicely as the fixed function pipeline.");
            }
            if (floatColorsDefined && locs.glColor != -1 && !ignoreVertexColors && (changable = geo.source.getCapability(3))) {
                if (cfdata != null) {
                    fclrs = Jogl2es2Pipeline.getColorArrayBuffer(cfdata);
                }
                fclrs.position(0);
                gl.glBindBuffer(34962, gd.geoToColorBuf);
                gl.glBufferSubData(34962, 0L, (long)(fclrs.remaining() * 32 / 8), (Buffer)fclrs);
            }
            if (normalsDefined && locs.glNormal != -1 && (changable = geo.source.getCapability(5))) {
                if (ndata != null) {
                    norms = Jogl2es2Pipeline.getNormalArrayBuffer(ndata);
                }
                norms.position(0);
                gl.glBindBuffer(34962, gd.geoToNormalBuf);
                gl.glBufferSubData(34962, 0L, (long)(norms.remaining() * 32 / 8), (Buffer)norms);
            }
            if (vattrDefined) {
                if (vertexAttrData != null) {
                    vertexAttrBufs = Jogl2es2Pipeline.getVertexAttrSetBuffer((Object[])vertexAttrData);
                }
                for (int index = 0; index < vertexAttrCount; ++index) {
                    boolean changable2;
                    attribLoc = locs.genAttIndexToLoc.get(index);
                    if (attribLoc == null || attribLoc == -1 || !(changable2 = geo.source.getCapability(23))) continue;
                    FloatBuffer vertexAttrs = vertexAttrBufs[index];
                    vertexAttrs.position(0);
                    SparseArray<Integer> bufIds = gd.geoToVertAttribBuf;
                    Integer bufId = bufIds.get(index);
                    gl.glBindBuffer(34962, bufId.intValue());
                    gl.glBufferSubData(34962, 0L, (long)(vertexAttrs.remaining() * 32 / 8), (Buffer)vertexAttrs);
                }
            }
            if (textureDefined) {
                if (!(texCoords[0] instanceof FloatBuffer)) {
                    texCoords = Jogl2es2Pipeline.getTexCoordSetBuffer(texCoords);
                }
                boolean[] texSetsBound = new boolean[texCoords.length];
                for (int texUnit = 0; texUnit < numActiveTexUnitState && texUnit < texCoordMapLength; ++texUnit) {
                    boolean changable3;
                    texSet = texCoordSetMap[texUnit];
                    if (texSet == -1 || locs.glMultiTexCoord[texSet] == -1 || texSetsBound[texSet] || !(changable3 = geo.source.getCapability(7))) continue;
                    FloatBuffer buf = (FloatBuffer)texCoords[texSet];
                    buf.position(0);
                    SparseArray<Integer> bufIds = gd.geoToTexCoordsBuf;
                    Integer bufId = bufIds.get(texUnit);
                    gl.glBindBuffer(34962, bufId.intValue());
                    gl.glBufferSubData(34962, 0L, (long)(buf.remaining() * 32 / 8), (Buffer)buf);
                }
            }
            if (bindingRequired || morphable) {
                gl.glBindBuffer(34962, gd.geoToCoordBuf);
                gl.glVertexAttribPointer(locs.glVertex, 3, 5126, false, 0, 0L);
                gl.glEnableVertexAttribArray(locs.glVertex);
            }
            if (bindingRequired) {
                if (floatColorsDefined && locs.glColor != -1 && !ignoreVertexColors) {
                    if (gd.geoToColorBuf == -1) {
                        new Throwable("Buffer load issue!").printStackTrace();
                    } else {
                        int sz = (vformat & 8) != 0 ? 4 : 3;
                        int coloroff = sz * initialColorIndex;
                        fclrs.position(coloroff);
                        gl.glBindBuffer(34962, gd.geoToColorBuf);
                        gl.glVertexAttribPointer(locs.glColor, sz, 5126, false, 0, 0L);
                        gl.glEnableVertexAttribArray(locs.glColor);
                    }
                } else {
                    if (byteColorsDefined && locs.glColor != -1 && !ignoreVertexColors) {
                        throw new UnsupportedOperationException("byteColorsDefined.\nThe Gl2ES2 pipeline only supports a subset of the Geometry data types and formats. \nCoordinates must be defined and float type, colors must be float type, if defined. \nDecaling is not supported. \nModel Clip is not supported and must be reimplemented in shaders \nTexture Coordinate generation ignored, must be done in shaders. \nTexture Lod, Filter, Sharpen and Combine cannot be supported. \nTexture3D cannot be supported. \nAccum style anti-aliasing cannot be supported. \nRasterOps from RenderingAttributes cannot be used. \nReadRaster for depth requires a custom shader and color read instead. \nIt is strongly recomended that you use the format GeometryArray.USE_NIO_BUFFER = true. \nNote LineArray and LineStripArray will not render as nicely as the fixed function pipeline.");
                    }
                    if (locs.glColor != -1) {
                        gl.glDisableVertexAttribArray(locs.glColor);
                    }
                }
                if (normalsDefined && locs.glNormal != -1) {
                    if (gd.geoToNormalBuf == -1) {
                        new Throwable("Buffer load issue!").printStackTrace();
                    } else {
                        gl.glBindBuffer(34962, gd.geoToNormalBuf);
                        gl.glVertexAttribPointer(locs.glNormal, 3, 5126, false, 0, 0L);
                        gl.glEnableVertexAttribArray(locs.glNormal);
                    }
                } else if (locs.glNormal != -1) {
                    gl.glDisableVertexAttribArray(locs.glNormal);
                }
                if (vattrDefined) {
                    for (int index = 0; index < vertexAttrCount; ++index) {
                        Integer bufId;
                        attribLoc = locs.genAttIndexToLoc.get(index);
                        if (attribLoc == null || attribLoc == -1) continue;
                        SparseArray<Integer> bufIds = gd.geoToVertAttribBuf;
                        if (bufIds == null) {
                            new Throwable("Buffer load issue!").printStackTrace();
                        }
                        if ((bufId = bufIds.get(index)) == null) {
                            new Throwable("Buffer load issue!").printStackTrace();
                            continue;
                        }
                        int sz = vertexAttrSizes[index];
                        gl.glBindBuffer(34962, bufId.intValue());
                        gl.glVertexAttribPointer(attribLoc.intValue(), sz, 5126, false, 0, 0L);
                        gl.glEnableVertexAttribArray(attribLoc.intValue());
                    }
                }
                if (textureDefined) {
                    boolean[] texSetsBound = new boolean[texCoords.length];
                    for (int texUnit = 0; texUnit < numActiveTexUnitState && texUnit < texCoordMapLength; ++texUnit) {
                        Integer bufId;
                        texSet = texCoordSetMap[texUnit];
                        if (texSet == -1 || locs.glMultiTexCoord[texSet] == -1 || texSetsBound[texSet]) continue;
                        texSetsBound[texSet] = true;
                        SparseArray<Integer> bufIds = gd.geoToTexCoordsBuf;
                        if (bufIds == null) {
                            new Throwable("Buffer load issue!").printStackTrace();
                        }
                        if ((bufId = bufIds.get(texUnit)) == null) {
                            new Throwable("Buffer load issue!").printStackTrace();
                            continue;
                        }
                        gl.glBindBuffer(34962, bufId.intValue());
                        gl.glVertexAttribPointer(locs.glMultiTexCoord[texUnit], texStride, 5126, true, 0, 0L);
                        gl.glEnableVertexAttribArray(locs.glMultiTexCoord[texUnit]);
                    }
                }
            }
            if (geo_type == 5 || geo_type == 6 || geo_type == 7) {
                int primType = 0;
                if (ctx.polygonMode == 1) {
                    geo_type = 7;
                }
                switch (geo_type) {
                    case 5: {
                        primType = 5;
                        break;
                    }
                    case 6: {
                        primType = 6;
                        break;
                    }
                    case 7: {
                        primType = 2;
                    }
                }
                for (int i = 0; i < strip_len; ++i) {
                    if (sarray[i] <= 0) continue;
                    gl.glDrawArrays(primType, start_array[i], sarray[i]);
                }
                return;
            } else {
                if (ctx.polygonMode == 1) {
                    geo_type = 4;
                } else if (ctx.polygonMode == 0) {
                    geo_type = 3;
                }
                switch (geo_type) {
                    case 1: {
                        if (!quadArrayCautionPrinted) {
                            System.err.println("QuadArray will render incorrectly, consider using TriangleArray. If you have the java3d-utils in the buildpath you can convert like this:");
                            System.err.println("GeometryInfo gi = new GeometryInfo(quadArray);");
                            System.err.println("gi.convertToIndexedTriangles();\t");
                            System.err.println("GeometryArray ga = gi.getIndexedGeometryArray(true, true, true, true, true);");
                            quadArrayCautionPrinted = true;
                        }
                    }
                    case 2: {
                        gl.glDrawArrays(4, 0, vertexCount);
                        return;
                    }
                    case 3: {
                        gl.glDrawArrays(0, 0, vertexCount);
                        return;
                    }
                    case 4: {
                        gl.glDrawArrays(1, 0, vertexCount);
                    }
                }
            }
            return;
        } else {
            if (!this.NO_PROGRAM_WARNING_GIVEN) {
                System.err.println("Execute called with no shader Program in use!");
            }
            this.NO_PROGRAM_WARNING_GIVEN = true;
        }
    }

    @Override
    void executeIndexedGeometry(Context ctx, GeometryArrayRetained geo, int geo_type, boolean isNonUniformScale, boolean useAlpha, boolean ignoreVertexColors, int initialIndexIndex, int indexCount, int vertexCount, int vformat, int vertexAttrCount, int[] vertexAttrSizes, int texCoordSetCount, int[] texCoordSetMap, int texCoordSetMapLen, int[] texCoordSetOffset, int numActiveTexUnitState, float[] varray, float[] carray, int cdirty, int[] indexCoord) {
        this.executeIndexedGeometryArray(ctx, geo, geo_type, isNonUniformScale, useAlpha, ignoreVertexColors, initialIndexIndex, indexCount, vertexCount, vformat, vertexAttrCount, vertexAttrSizes, texCoordSetCount, texCoordSetMap, texCoordSetMapLen, texCoordSetOffset, numActiveTexUnitState, varray, null, carray, cdirty, indexCoord);
    }

    @Override
    void executeIndexedGeometryBuffer(Context ctx, GeometryArrayRetained geo, int geo_type, boolean isNonUniformScale, boolean useAlpha, boolean ignoreVertexColors, int initialIndexIndex, int indexCount, int vertexCount, int vformat, int texCoordSetCount, int[] texCoordSetMap, int texCoordSetMapLen, int[] texCoordSetOffset, int numActiveTexUnitState, FloatBuffer vdata, float[] carray, int cDirty, int[] indexCoord) {
        this.executeIndexedGeometryArray(ctx, geo, geo_type, isNonUniformScale, useAlpha, ignoreVertexColors, initialIndexIndex, indexCount, vertexCount, vformat, 0, null, texCoordSetCount, texCoordSetMap, texCoordSetMapLen, texCoordSetOffset, numActiveTexUnitState, null, vdata, carray, cDirty, indexCoord);
    }

    private void executeIndexedGeometryArray(Context absCtx, GeometryArrayRetained geo, int geo_type, boolean isNonUniformScale, boolean useAlpha, boolean ignoreVertexColors, int initialIndexIndex, int indexCount, int vcount, int vformat, int vertexAttrCount, int[] vertexAttrSizes, int texCoordSetCount, int[] texCoordSetMap, int texCoordSetMapLen, int[] texCoordSetOffset, int numActiveTexUnitState, float[] varray, FloatBuffer vdata, float[] carray, int cDirty, int[] indexCoord) {
        Jogl2es2Context ctx = (Jogl2es2Context)absCtx;
        int shaderProgramId = ctx.shaderProgramId;
        if (shaderProgramId != -1) {
            boolean changable;
            GL2ES2 gl = ctx.gl2es2();
            Jogl2es2Context.ProgramData pd = ctx.programData;
            Jogl2es2Context.LocationData locs = pd.programToLocationData;
            Jogl2es2Pipeline.setFFPAttributes(ctx, gl, shaderProgramId, pd, vformat, ignoreVertexColors);
            int stride = 0;
            int coordoff = 0;
            int normoff = 0;
            int coloroff = 0;
            int texCoordoff = 0;
            int texSize = 0;
            int texStride = 0;
            int vAttrOff = 0;
            int vAttrStride = 0;
            int bstride = 0;
            int cbstride = 0;
            int[] sarray = null;
            int strip_len = 0;
            if ((vformat & 1) != 0) {
                stride += 3;
            }
            if ((vformat & 2) != 0) {
                stride += 3;
                coordoff += 3;
            }
            if ((vformat & 4) != 0) {
                if ((vformat & 8) != 0) {
                    stride += 4;
                    normoff += 4;
                    coordoff += 4;
                } else {
                    stride += 3;
                    normoff += 3;
                    coordoff += 3;
                }
            }
            if ((vformat & 0x460) != 0) {
                if ((vformat & 0x20) != 0) {
                    texSize = 2;
                    texStride = 2 * texCoordSetCount;
                } else if ((vformat & 0x40) != 0) {
                    texSize = 3;
                    texStride = 3 * texCoordSetCount;
                } else if ((vformat & 0x400) != 0) {
                    texSize = 4;
                    texStride = 4 * texCoordSetCount;
                }
                stride += texStride;
                normoff += texStride;
                coloroff += texStride;
                coordoff += texStride;
            }
            if ((vformat & 0x1000) != 0) {
                for (int i = 0; i < vertexAttrCount; ++i) {
                    vAttrStride += vertexAttrSizes[i];
                }
                stride += vAttrStride;
                normoff += vAttrStride;
                coloroff += vAttrStride;
                coordoff += vAttrStride;
                texCoordoff += vAttrStride;
            }
            bstride = stride * 4;
            if (geo_type == 12 || geo_type == 13 || geo_type == 14) {
                sarray = ((IndexedGeometryStripArrayRetained)geo).stripIndexCounts;
                strip_len = sarray.length;
            }
            int cstride = stride;
            if (carray != null) {
                cstride = 4;
            }
            cbstride = cstride * 4;
            Jogl2es2Context.GeometryData gd = Jogl2es2Pipeline.loadAllBuffers(ctx, gl, geo, ignoreVertexColors, vcount, vformat, vformat, vdata, varray, 0, vdata, carray, 0);
            boolean morphable = geo.source.getCapability(19) || geo.source.getCapability(1);
            boolean bindingRequired = true;
            if (gl.isGL2ES3()) {
                GL2ES3 gl2es3 = (GL2ES3)gl;
                if (gd.vaoId == -1) {
                    int[] tmp = new int[1];
                    gl2es3.glGenVertexArrays(1, tmp, 0);
                    gd.vaoId = tmp[0];
                } else {
                    bindingRequired = false;
                }
                gl2es3.glBindVertexArray(gd.vaoId);
            }
            if (locs.glVertex != -1) {
                if (gd.geoToCoordBuf == -1) {
                    new Throwable("Buffer load issue!").printStackTrace();
                } else if (morphable) {
                    FloatBuffer verts = null;
                    verts = varray != null ? Jogl2es2Pipeline.getVertexArrayBuffer(varray) : vdata;
                    verts.position(0);
                    if (gd.geoToCoordBufSize != verts.remaining()) {
                        System.err.println("Morphable buffer changed " + gd.geoToCoordBufSize + " != " + verts.remaining() + " un indexed ((GeometryArray) geo.source) " + ((GeometryArray)geo.source).getName() + " " + geo.source + ", this is not nessasarily a problem");
                        int prevBufId1 = gd.geoToCoordBuf1;
                        int prevBufId2 = gd.geoToCoordBuf2;
                        int[] tmp = new int[2];
                        gl.glGenBuffers(2, tmp, 0);
                        gd.geoToCoordBuf = tmp[0];
                        gd.geoToCoordBuf1 = tmp[0];
                        gd.geoToCoordBuf2 = tmp[1];
                        gl.glBindBuffer(34962, gd.geoToCoordBuf1);
                        gl.glBufferData(34962, (long)(verts.remaining() * 32 / 8), (Buffer)verts, 35048);
                        gl.glBindBuffer(34962, gd.geoToCoordBuf2);
                        gl.glBufferData(34962, (long)(verts.remaining() * 32 / 8), (Buffer)verts, 35048);
                        gd.geoToCoordBufSize = verts.remaining();
                        gl.glBindBuffer(34962, gd.geoToCoordBuf);
                        gl.glVertexAttribPointer(locs.glVertex, 3, 5126, false, 0, 0L);
                        gl.glEnableVertexAttribArray(locs.glVertex);
                        gl.glDeleteBuffers(1, new int[]{prevBufId1, prevBufId2}, 0);
                    } else if (gd.geoToCoordBuf == gd.geoToCoordBuf1) {
                        gl.glBindBuffer(34962, gd.geoToCoordBuf1);
                        gl.glBufferSubData(34962, 0L, (long)(verts.remaining() * 32 / 8), (Buffer)verts);
                        gd.geoToCoordBuf = gd.geoToCoordBuf2;
                    } else {
                        gl.glBindBuffer(34962, gd.geoToCoordBuf2);
                        gl.glBufferSubData(34962, 0L, (long)(verts.remaining() * 32 / 8), (Buffer)verts);
                        gd.geoToCoordBuf = gd.geoToCoordBuf1;
                    }
                }
            } else {
                throw new UnsupportedOperationException("Shader has no glVertex.\nThe Gl2ES2 pipeline only supports a subset of the Geometry data types and formats. \nCoordinates must be defined and float type, colors must be float type, if defined. \nDecaling is not supported. \nModel Clip is not supported and must be reimplemented in shaders \nTexture Coordinate generation ignored, must be done in shaders. \nTexture Lod, Filter, Sharpen and Combine cannot be supported. \nTexture3D cannot be supported. \nAccum style anti-aliasing cannot be supported. \nRasterOps from RenderingAttributes cannot be used. \nReadRaster for depth requires a custom shader and color read instead. \nIt is strongly recomended that you use the format GeometryArray.USE_NIO_BUFFER = true. \nNote LineArray and LineStripArray will not render as nicely as the fixed function pipeline.");
            }
            if ((vformat & 4) != 0 && locs.glColor != -1 && !ignoreVertexColors && (changable = geo.source.getCapability(3))) {
                FloatBuffer clrs = null;
                FloatBuffer verts = null;
                verts = varray != null ? Jogl2es2Pipeline.getVertexArrayBuffer(varray) : vdata;
                clrs = carray != null ? Jogl2es2Pipeline.getColorArrayBuffer(carray) : verts;
                clrs.position(0);
                gl.glBindBuffer(34962, gd.geoToColorBuf);
                gl.glBufferSubData(34962, 0L, (long)(clrs.remaining() * 32 / 8), (Buffer)clrs);
            }
            if (bindingRequired || morphable) {
                gl.glBindBuffer(34962, gd.geoToCoordBuf);
                gl.glVertexAttribPointer(locs.glVertex, 3, 5126, false, bstride, (long)(coordoff * 4));
                gl.glEnableVertexAttribArray(locs.glVertex);
            }
            if (bindingRequired) {
                if ((vformat & 4) != 0 && locs.glColor != -1 && !ignoreVertexColors) {
                    if (gd.geoToColorBuf == -1) {
                        new Throwable("Buffer load issue!").printStackTrace();
                    } else {
                        int sz = (vformat & 8) != 0 ? 4 : 3;
                        gl.glBindBuffer(34962, gd.geoToColorBuf);
                        gl.glVertexAttribPointer(locs.glColor, sz, 5126, false, cbstride, (long)(coloroff * 4));
                        gl.glEnableVertexAttribArray(locs.glColor);
                    }
                } else if (locs.glColor != -1) {
                    gl.glDisableVertexAttribArray(locs.glColor);
                }
                if ((vformat & 2) != 0 && locs.glNormal != -1) {
                    if (gd.geoToCoordBuf == -1) {
                        new Throwable("Buffer load issue!").printStackTrace();
                    } else {
                        gl.glBindBuffer(34962, gd.geoToCoordBuf);
                        gl.glVertexAttribPointer(locs.glNormal, 3, 5126, false, bstride, (long)(normoff * 4));
                        gl.glEnableVertexAttribArray(locs.glNormal);
                    }
                } else if (locs.glNormal != -1) {
                    gl.glDisableVertexAttribArray(locs.glNormal);
                }
                if ((vformat & 0x1000) != 0) {
                    int vAttrOffset = vAttrOff;
                    for (int index = 0; index < vertexAttrCount; ++index) {
                        Integer attribLoc = locs.genAttIndexToLoc.get(index);
                        if (attribLoc == null || attribLoc == -1) continue;
                        int sz = vertexAttrSizes[index];
                        gl.glBindBuffer(34962, gd.geoToCoordBuf);
                        gl.glVertexAttribPointer(attribLoc.intValue(), sz, 5126, false, bstride, (long)(vAttrOffset * 4));
                        gl.glEnableVertexAttribArray(attribLoc.intValue());
                        vAttrOffset += vertexAttrSizes[index];
                    }
                }
                if ((vformat & 0x460) != 0) {
                    boolean[] texSetsBound = new boolean[texCoordSetMapLen];
                    for (int texUnit = 0; texUnit < numActiveTexUnitState && texUnit < texCoordSetMapLen; ++texUnit) {
                        int texSet = texCoordSetMap[texUnit];
                        if (texSet == -1 || locs.glMultiTexCoord[texSet] == -1 || texSetsBound[texSet]) continue;
                        texSetsBound[texSet] = true;
                        gl.glBindBuffer(34962, gd.geoToCoordBuf);
                        gl.glVertexAttribPointer(locs.glMultiTexCoord[texUnit], texSize, 5126, true, bstride, (long)(texCoordoff * 4));
                        gl.glEnableVertexAttribArray(locs.glMultiTexCoord[texUnit]);
                    }
                }
            }
            if (geo_type == 12 || geo_type == 13 || geo_type == 14) {
                int primType = 0;
                if (ctx.polygonMode == 1) {
                    geo_type = 14;
                }
                switch (geo_type) {
                    case 12: {
                        primType = 5;
                        break;
                    }
                    case 13: {
                        primType = 6;
                        break;
                    }
                    case 14: {
                        primType = 2;
                    }
                }
                int[] stripInd = gd.geoToIndStripBuf;
                if (stripInd == null) {
                    stripInd = new int[strip_len];
                    gl.glGenBuffers(strip_len, stripInd, 0);
                    int offset = initialIndexIndex;
                    ShortBuffer indicesBuffer = Jogl2es2Pipeline.getIndexArrayBuffer(indexCoord);
                    for (int i = 0; i < strip_len; ++i) {
                        indicesBuffer.position(offset);
                        int count = sarray[i];
                        int indBufId = stripInd[i];
                        gl.glBindBuffer(34963, indBufId);
                        gl.glBufferData(34963, (long)(count * 16 / 8), (Buffer)indicesBuffer, 35044);
                        offset += count;
                    }
                    gd.geoToIndStripBuf = stripInd;
                }
                for (int i = 0; i < strip_len; ++i) {
                    int count = sarray[i];
                    int indBufId = stripInd[i];
                    gl.glBindBuffer(34963, indBufId);
                    gl.glDrawElements(primType, count, 5123, 0L);
                }
            } else {
                if (gd.geoToIndBuf == -1) {
                    ShortBuffer indBuf = Jogl2es2Pipeline.getIndexArrayBuffer(indexCoord);
                    int[] tmp = new int[1];
                    gl.glGenBuffers(1, tmp, 0);
                    gd.geoToIndBuf = tmp[0];
                    gl.glBindBuffer(34963, gd.geoToIndBuf);
                    gl.glBufferData(34963, (long)(indBuf.remaining() * 16 / 8), (Buffer)indBuf, 35044);
                    gd.geoToIndBufSize = indBuf.remaining();
                }
                gl.glBindBuffer(34963, gd.geoToIndBuf);
                if (ctx.polygonMode == 1) {
                    geo_type = 11;
                } else if (ctx.polygonMode == 0) {
                    geo_type = 10;
                }
                switch (geo_type) {
                    case 8: {
                        if (!quadArrayCautionPrinted) {
                            System.err.println("QuadArray will render incorrectly, consider using TriangleArray. If you have the java3d-utils in the buildpath you can convert like this:");
                            System.err.println("GeometryInfo gi = new GeometryInfo(quadArray);");
                            System.err.println("gi.convertToIndexedTriangles();\t");
                            System.err.println("GeometryArray ga = gi.getIndexedGeometryArray(true, true, true, true, true);");
                            quadArrayCautionPrinted = true;
                        }
                    }
                    case 9: {
                        gl.glDrawElements(4, indexCount, 5123, 0L);
                        break;
                    }
                    case 10: {
                        gl.glDrawElements(0, indexCount, 5123, 0L);
                        break;
                    }
                    case 11: {
                        gl.glDrawElements(1, indexCount, 5123, 0L);
                    }
                }
            }
        } else {
            if (!this.NO_PROGRAM_WARNING_GIVEN) {
                System.err.println("Execute called with no shader Program in use!");
            }
            this.NO_PROGRAM_WARNING_GIVEN = true;
        }
    }

    @Override
    void executeIndexedGeometryVA(Context ctx, GeometryArrayRetained geo, int geo_type, boolean isNonUniformScale, boolean ignoreVertexColors, int initialIndexIndex, int validIndexCount, int vertexCount, int vformat, int vdefined, float[] vfcoords, double[] vdcoords, float[] cfdata, byte[] cbdata, float[] ndata, int vertexAttrCount, int[] vertexAttrSizes, float[][] vertexAttrData, int texCoordMapLength, int[] texcoordoffset, int numActiveTexUnitState, int texStride, Object[] texCoords, int cdirty, int[] indexCoord) {
        boolean floatCoordDefined = (vdefined & 1) != 0;
        boolean doubleCoordDefined = (vdefined & 2) != 0;
        boolean floatColorsDefined = (vdefined & 4) != 0;
        boolean byteColorsDefined = (vdefined & 8) != 0;
        boolean normalsDefined = (vdefined & 0x10) != 0;
        boolean vattrDefined = (vdefined & 0x40) != 0;
        boolean textureDefined = (vdefined & 0x20) != 0;
        int[] sarray = null;
        int strip_len = 0;
        if (geo_type == 12 || geo_type == 13 || geo_type == 14) {
            sarray = ((IndexedGeometryStripArrayRetained)geo).stripIndexCounts;
            strip_len = sarray.length;
        }
        if (doubleCoordDefined) {
            throw new UnsupportedOperationException("doubleCoordDefined.\nThe Gl2ES2 pipeline only supports a subset of the Geometry data types and formats. \nCoordinates must be defined and float type, colors must be float type, if defined. \nDecaling is not supported. \nModel Clip is not supported and must be reimplemented in shaders \nTexture Coordinate generation ignored, must be done in shaders. \nTexture Lod, Filter, Sharpen and Combine cannot be supported. \nTexture3D cannot be supported. \nAccum style anti-aliasing cannot be supported. \nRasterOps from RenderingAttributes cannot be used. \nReadRaster for depth requires a custom shader and color read instead. \nIt is strongly recomended that you use the format GeometryArray.USE_NIO_BUFFER = true. \nNote LineArray and LineStripArray will not render as nicely as the fixed function pipeline.");
        }
        if (byteColorsDefined) {
            throw new UnsupportedOperationException("byteColorsDefined.\nThe Gl2ES2 pipeline only supports a subset of the Geometry data types and formats. \nCoordinates must be defined and float type, colors must be float type, if defined. \nDecaling is not supported. \nModel Clip is not supported and must be reimplemented in shaders \nTexture Coordinate generation ignored, must be done in shaders. \nTexture Lod, Filter, Sharpen and Combine cannot be supported. \nTexture3D cannot be supported. \nAccum style anti-aliasing cannot be supported. \nRasterOps from RenderingAttributes cannot be used. \nReadRaster for depth requires a custom shader and color read instead. \nIt is strongly recomended that you use the format GeometryArray.USE_NIO_BUFFER = true. \nNote LineArray and LineStripArray will not render as nicely as the fixed function pipeline.");
        }
        this.executeIndexedGeometryArrayVA(ctx, geo, geo_type, isNonUniformScale, ignoreVertexColors, initialIndexIndex, validIndexCount, vertexCount, vformat, vdefined, null, vfcoords, null, vdcoords, null, cfdata, null, cbdata, null, ndata, vertexAttrCount, vertexAttrSizes, null, vertexAttrData, texCoordMapLength, texcoordoffset, numActiveTexUnitState, texStride, texCoords, cdirty, indexCoord, sarray, strip_len);
    }

    @Override
    void executeIndexedGeometryVABuffer(Context ctx, GeometryArrayRetained geo, int geo_type, boolean isNonUniformScale, boolean ignoreVertexColors, int initialIndexIndex, int validIndexCount, int vertexCount, int vformat, int vdefined, Buffer vcoords, Buffer cdataBuffer, float[] cfdata, byte[] cbdata, FloatBuffer ndata, int vertexAttrCount, int[] vertexAttrSizes, FloatBuffer[] vertexAttrData, int texCoordMapLength, int[] texcoordoffset, int numActiveTexUnitState, int texStride, Object[] texCoords, int cdirty, int[] indexCoord) {
        boolean floatCoordDefined = (vdefined & 1) != 0;
        boolean doubleCoordDefined = (vdefined & 2) != 0;
        boolean floatColorsDefined = (vdefined & 4) != 0;
        boolean byteColorsDefined = (vdefined & 8) != 0;
        boolean normalsDefined = (vdefined & 0x10) != 0;
        boolean vattrDefined = (vdefined & 0x40) != 0;
        boolean textureDefined = (vdefined & 0x20) != 0;
        FloatBuffer fverts = null;
        DoubleBuffer dverts = null;
        FloatBuffer fclrs = null;
        ByteBuffer bclrs = null;
        FloatBuffer norms = null;
        FloatBuffer[] vertexAttrBufs = null;
        if (vattrDefined) {
            vertexAttrBufs = vertexAttrData;
        }
        if (floatCoordDefined) {
            fverts = (FloatBuffer)vcoords;
        } else if (doubleCoordDefined) {
            throw new UnsupportedOperationException("doubleCoordDefined.\nThe Gl2ES2 pipeline only supports a subset of the Geometry data types and formats. \nCoordinates must be defined and float type, colors must be float type, if defined. \nDecaling is not supported. \nModel Clip is not supported and must be reimplemented in shaders \nTexture Coordinate generation ignored, must be done in shaders. \nTexture Lod, Filter, Sharpen and Combine cannot be supported. \nTexture3D cannot be supported. \nAccum style anti-aliasing cannot be supported. \nRasterOps from RenderingAttributes cannot be used. \nReadRaster for depth requires a custom shader and color read instead. \nIt is strongly recomended that you use the format GeometryArray.USE_NIO_BUFFER = true. \nNote LineArray and LineStripArray will not render as nicely as the fixed function pipeline.");
        }
        if (fverts == null && dverts == null) {
            return;
        }
        int[] sarray = null;
        int strip_len = 0;
        if (geo_type == 12 || geo_type == 13 || geo_type == 14) {
            sarray = ((IndexedGeometryStripArrayRetained)geo).stripIndexCounts;
            strip_len = sarray.length;
        }
        if (floatColorsDefined) {
            fclrs = (FloatBuffer)cdataBuffer;
        } else if (byteColorsDefined) {
            throw new UnsupportedOperationException("byteColorsDefined.\nThe Gl2ES2 pipeline only supports a subset of the Geometry data types and formats. \nCoordinates must be defined and float type, colors must be float type, if defined. \nDecaling is not supported. \nModel Clip is not supported and must be reimplemented in shaders \nTexture Coordinate generation ignored, must be done in shaders. \nTexture Lod, Filter, Sharpen and Combine cannot be supported. \nTexture3D cannot be supported. \nAccum style anti-aliasing cannot be supported. \nRasterOps from RenderingAttributes cannot be used. \nReadRaster for depth requires a custom shader and color read instead. \nIt is strongly recomended that you use the format GeometryArray.USE_NIO_BUFFER = true. \nNote LineArray and LineStripArray will not render as nicely as the fixed function pipeline.");
        }
        if (normalsDefined) {
            norms = ndata;
        }
        this.executeIndexedGeometryArrayVA(ctx, geo, geo_type, isNonUniformScale, ignoreVertexColors, initialIndexIndex, validIndexCount, vertexCount, vformat, vdefined, fverts, null, dverts, null, fclrs, cfdata, bclrs, null, norms, null, vertexAttrCount, vertexAttrSizes, vertexAttrBufs, null, texCoordMapLength, texcoordoffset, numActiveTexUnitState, texStride, texCoords, cdirty, indexCoord, sarray, strip_len);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void executeIndexedGeometryArrayVA(Context absCtx, GeometryArrayRetained geo, int geo_type, boolean isNonUniformScale, boolean ignoreVertexColors, int initialIndexIndex, int validIndexCount, int vertexCount, int vformat, int vdefined, FloatBuffer fverts, float[] vfarray, DoubleBuffer dverts, double[] vdarray, FloatBuffer fclrs, float[] cfarray, ByteBuffer bclrs, byte[] cbarray, FloatBuffer norms, float[] fnorms, int vertexAttrCount, int[] vertexAttrSizes, FloatBuffer[] vertexAttrBufs, float[][] vertexAttrArrays, int texCoordMapLength, int[] texCoordSetMap, int numActiveTexUnitState, int texStride, Object[] texCoords, int cDirty, int[] indexCoord, int[] sarray, int strip_len) {
        Jogl2es2Context ctx = (Jogl2es2Context)absCtx;
        int shaderProgramId = ctx.shaderProgramId;
        if (shaderProgramId != -1) {
            Integer bufId;
            Integer attribLoc;
            boolean changable;
            int[] tmp;
            GL2ES2 gl = ctx.gl2es2();
            Jogl2es2Context.ProgramData pd = ctx.programData;
            Jogl2es2Context.LocationData locs = pd.programToLocationData;
            Jogl2es2Pipeline.setFFPAttributes(ctx, gl, shaderProgramId, pd, vdefined, ignoreVertexColors);
            Jogl2es2Context.GeometryData gd = Jogl2es2Pipeline.loadAllBuffers(ctx, gl, geo, ignoreVertexColors, vertexCount, vformat, vdefined, fverts, vfarray, dverts, vdarray, fclrs, cfarray, bclrs, cbarray, norms, fnorms, vertexAttrCount, vertexAttrSizes, vertexAttrBufs, vertexAttrArrays, texCoordMapLength, texCoordSetMap, texStride, texCoords);
            boolean floatCoordDefined = (vdefined & 1) != 0;
            boolean doubleCoordDefined = (vdefined & 2) != 0;
            boolean floatColorsDefined = (vdefined & 4) != 0;
            boolean byteColorsDefined = (vdefined & 8) != 0;
            boolean normalsDefined = (vdefined & 0x10) != 0;
            boolean vattrDefined = (vdefined & 0x40) != 0;
            boolean textureDefined = (vdefined & 0x20) != 0;
            boolean morphable = geo.source.getCapability(19) || geo.source.getCapability(1);
            boolean bindingRequired = true;
            if (gl.isGL2ES3()) {
                GL2ES3 gl2es3 = (GL2ES3)gl;
                if (gd.vaoId == -1) {
                    tmp = new int[1];
                    gl2es3.glGenVertexArrays(1, tmp, 0);
                    gd.vaoId = tmp[0];
                } else {
                    bindingRequired = false;
                }
                gl2es3.glBindVertexArray(gd.vaoId);
            }
            if (locs.glVertex == -1) throw new UnsupportedOperationException("Shader has no glVertex.\nThe Gl2ES2 pipeline only supports a subset of the Geometry data types and formats. \nCoordinates must be defined and float type, colors must be float type, if defined. \nDecaling is not supported. \nModel Clip is not supported and must be reimplemented in shaders \nTexture Coordinate generation ignored, must be done in shaders. \nTexture Lod, Filter, Sharpen and Combine cannot be supported. \nTexture3D cannot be supported. \nAccum style anti-aliasing cannot be supported. \nRasterOps from RenderingAttributes cannot be used. \nReadRaster for depth requires a custom shader and color read instead. \nIt is strongly recomended that you use the format GeometryArray.USE_NIO_BUFFER = true. \nNote LineArray and LineStripArray will not render as nicely as the fixed function pipeline.");
            if (floatCoordDefined) {
                if (gd.geoToCoordBuf == -1) {
                    new Throwable("Buffer load issue!").printStackTrace();
                } else if (morphable) {
                    if (vfarray != null) {
                        fverts = Jogl2es2Pipeline.getVertexArrayBuffer(vfarray);
                    }
                    fverts.position(0);
                    if (gd.geoToCoordBufSize != fverts.remaining()) {
                        System.err.println("Morphable buffer changed " + gd.geoToCoordBufSize + " != " + fverts.remaining() + " ((GeometryArray) geo.source) " + ((GeometryArray)geo.source).getName() + " " + geo.source);
                        int prevBufId1 = gd.geoToCoordBuf1;
                        int prevBufId2 = gd.geoToCoordBuf2;
                        int[] tmp2 = new int[2];
                        gl.glGenBuffers(2, tmp2, 0);
                        gd.geoToCoordBuf = tmp2[0];
                        gd.geoToCoordBuf1 = tmp2[0];
                        gd.geoToCoordBuf2 = tmp2[1];
                        gl.glBindBuffer(34962, gd.geoToCoordBuf1);
                        gl.glBufferData(34962, (long)(fverts.remaining() * 32 / 8), (Buffer)fverts, 35044);
                        gl.glBindBuffer(34962, gd.geoToCoordBuf2);
                        gl.glBufferData(34962, (long)(fverts.remaining() * 32 / 8), (Buffer)fverts, 35044);
                        gd.geoToCoordBufSize = fverts.remaining();
                        gl.glBindBuffer(34962, gd.geoToCoordBuf);
                        gl.glVertexAttribPointer(locs.glVertex, 3, 5126, false, 0, 0L);
                        gl.glEnableVertexAttribArray(locs.glVertex);
                        gl.glDeleteBuffers(1, new int[]{prevBufId1, prevBufId2}, 0);
                    } else if (gd.geoToCoordBuf == gd.geoToCoordBuf1) {
                        gl.glBindBuffer(34962, gd.geoToCoordBuf1);
                        gl.glBufferSubData(34962, 0L, (long)(fverts.remaining() * 32 / 8), (Buffer)fverts);
                        gd.geoToCoordBuf = gd.geoToCoordBuf2;
                    } else {
                        gl.glBindBuffer(34962, gd.geoToCoordBuf2);
                        gl.glBufferSubData(34962, 0L, (long)(fverts.remaining() * 32 / 8), (Buffer)fverts);
                        gd.geoToCoordBuf = gd.geoToCoordBuf1;
                    }
                }
            } else {
                if (!doubleCoordDefined) throw new UnsupportedOperationException("No coords defined.\nThe Gl2ES2 pipeline only supports a subset of the Geometry data types and formats. \nCoordinates must be defined and float type, colors must be float type, if defined. \nDecaling is not supported. \nModel Clip is not supported and must be reimplemented in shaders \nTexture Coordinate generation ignored, must be done in shaders. \nTexture Lod, Filter, Sharpen and Combine cannot be supported. \nTexture3D cannot be supported. \nAccum style anti-aliasing cannot be supported. \nRasterOps from RenderingAttributes cannot be used. \nReadRaster for depth requires a custom shader and color read instead. \nIt is strongly recomended that you use the format GeometryArray.USE_NIO_BUFFER = true. \nNote LineArray and LineStripArray will not render as nicely as the fixed function pipeline.");
                throw new UnsupportedOperationException("doubleCoordDefined.\nThe Gl2ES2 pipeline only supports a subset of the Geometry data types and formats. \nCoordinates must be defined and float type, colors must be float type, if defined. \nDecaling is not supported. \nModel Clip is not supported and must be reimplemented in shaders \nTexture Coordinate generation ignored, must be done in shaders. \nTexture Lod, Filter, Sharpen and Combine cannot be supported. \nTexture3D cannot be supported. \nAccum style anti-aliasing cannot be supported. \nRasterOps from RenderingAttributes cannot be used. \nReadRaster for depth requires a custom shader and color read instead. \nIt is strongly recomended that you use the format GeometryArray.USE_NIO_BUFFER = true. \nNote LineArray and LineStripArray will not render as nicely as the fixed function pipeline.");
            }
            if (floatColorsDefined && locs.glColor != -1 && !ignoreVertexColors && (changable = geo.source.getCapability(3))) {
                if (cfarray != null) {
                    fclrs = Jogl2es2Pipeline.getColorArrayBuffer(cfarray);
                }
                fclrs.position(0);
                gl.glBindBuffer(34962, gd.geoToColorBuf);
                gl.glBufferSubData(34962, 0L, (long)(fclrs.remaining() * 32 / 8), (Buffer)fclrs);
            }
            if (normalsDefined && locs.glNormal != -1 && (changable = geo.source.getCapability(5))) {
                if (fnorms != null) {
                    norms = Jogl2es2Pipeline.getNormalArrayBuffer(fnorms);
                }
                norms.position(0);
                gl.glBindBuffer(34962, gd.geoToNormalBuf);
                gl.glBufferSubData(34962, 0L, (long)(norms.remaining() * 32 / 8), (Buffer)norms);
            }
            if (vattrDefined) {
                if (vertexAttrArrays != null) {
                    vertexAttrBufs = Jogl2es2Pipeline.getVertexAttrSetBuffer((Object[])vertexAttrArrays);
                }
                for (int index = 0; index < vertexAttrCount; ++index) {
                    boolean changable2;
                    attribLoc = locs.genAttIndexToLoc.get(index);
                    if (attribLoc == null || attribLoc == -1 || !(changable2 = geo.source.getCapability(23))) continue;
                    FloatBuffer vertexAttrs = vertexAttrBufs[index];
                    vertexAttrs.position(0);
                    SparseArray<Integer> bufIds = gd.geoToVertAttribBuf;
                    bufId = bufIds.get(index);
                    gl.glBindBuffer(34962, bufId.intValue());
                    gl.glBufferSubData(34962, 0L, (long)(vertexAttrs.remaining() * 32 / 8), (Buffer)vertexAttrs);
                }
            }
            if (textureDefined) {
                if (!(texCoords[0] instanceof FloatBuffer)) {
                    texCoords = Jogl2es2Pipeline.getTexCoordSetBuffer(texCoords);
                }
                boolean[] texSetsBound = new boolean[texCoords.length];
                for (int texUnit = 0; texUnit < numActiveTexUnitState && texUnit < texCoordMapLength; ++texUnit) {
                    boolean changable3;
                    int texSet = texCoordSetMap[texUnit];
                    if (texSet == -1 || locs.glMultiTexCoord[texSet] == -1 || texSetsBound[texSet] || !(changable3 = geo.source.getCapability(7))) continue;
                    FloatBuffer buf = (FloatBuffer)texCoords[texSet];
                    buf.position(0);
                    SparseArray<Integer> bufIds = gd.geoToTexCoordsBuf;
                    Integer bufId2 = bufIds.get(texUnit);
                    gl.glBindBuffer(34962, bufId2.intValue());
                    gl.glBufferSubData(34962, 0L, (long)(buf.remaining() * 32 / 8), (Buffer)buf);
                }
            }
            if (bindingRequired || morphable) {
                gl.glBindBuffer(34962, gd.geoToCoordBuf);
                gl.glVertexAttribPointer(locs.glVertex, 3, 5126, false, 0, 0L);
                gl.glEnableVertexAttribArray(locs.glVertex);
            }
            if (bindingRequired) {
                if (floatColorsDefined && locs.glColor != -1 && !ignoreVertexColors) {
                    if (gd.geoToColorBuf == -1) {
                        new Throwable("Buffer load issue!").printStackTrace();
                    } else {
                        int sz = (vformat & 8) != 0 ? 4 : 3;
                        gl.glBindBuffer(34962, gd.geoToColorBuf);
                        gl.glVertexAttribPointer(locs.glColor, sz, 5126, true, 0, 0L);
                        gl.glEnableVertexAttribArray(locs.glColor);
                    }
                } else {
                    if (byteColorsDefined && locs.glColor != -1 && !ignoreVertexColors) {
                        throw new UnsupportedOperationException("byteColorsDefined.\nThe Gl2ES2 pipeline only supports a subset of the Geometry data types and formats. \nCoordinates must be defined and float type, colors must be float type, if defined. \nDecaling is not supported. \nModel Clip is not supported and must be reimplemented in shaders \nTexture Coordinate generation ignored, must be done in shaders. \nTexture Lod, Filter, Sharpen and Combine cannot be supported. \nTexture3D cannot be supported. \nAccum style anti-aliasing cannot be supported. \nRasterOps from RenderingAttributes cannot be used. \nReadRaster for depth requires a custom shader and color read instead. \nIt is strongly recomended that you use the format GeometryArray.USE_NIO_BUFFER = true. \nNote LineArray and LineStripArray will not render as nicely as the fixed function pipeline.");
                    }
                    if (locs.glColor != -1) {
                        gl.glDisableVertexAttribArray(locs.glColor);
                    }
                }
                if (normalsDefined) {
                    if (locs.glNormal != -1) {
                        if (gd.geoToNormalBuf == -1) {
                            new Throwable("Buffer load issue!").printStackTrace();
                        } else {
                            gl.glBindBuffer(34962, gd.geoToNormalBuf);
                            gl.glVertexAttribPointer(locs.glNormal, 3, 5126, true, 0, 0L);
                            gl.glEnableVertexAttribArray(locs.glNormal);
                        }
                    }
                } else if (locs.glNormal != -1) {
                    gl.glDisableVertexAttribArray(locs.glNormal);
                }
                if (vattrDefined) {
                    for (int index = 0; index < vertexAttrCount; ++index) {
                        Integer bufId3;
                        attribLoc = locs.genAttIndexToLoc.get(index);
                        if (attribLoc == null || attribLoc == -1) continue;
                        SparseArray<Integer> bufIds = gd.geoToVertAttribBuf;
                        if (bufIds == null) {
                            new Throwable("Buffer load issue!").printStackTrace();
                        }
                        if ((bufId3 = bufIds.get(index)) == null) {
                            new Throwable("Buffer load issue!").printStackTrace();
                            continue;
                        }
                        gl.glBindBuffer(34962, bufId3.intValue());
                        int sz = vertexAttrSizes[index];
                        gl.glVertexAttribPointer(attribLoc.intValue(), sz, 5126, false, 0, 0L);
                        gl.glEnableVertexAttribArray(attribLoc.intValue());
                    }
                }
                if (textureDefined) {
                    boolean[] texSetsBound = new boolean[texCoords.length];
                    for (int texUnit = 0; texUnit < numActiveTexUnitState && texUnit < texCoordMapLength; ++texUnit) {
                        int texSet = texCoordSetMap[texUnit];
                        if (texSet == -1 || locs.glMultiTexCoord[texSet] == -1 || texSetsBound[texSet]) continue;
                        texSetsBound[texSet] = true;
                        FloatBuffer buf = (FloatBuffer)texCoords[texSet];
                        buf.position(0);
                        SparseArray<Integer> bufIds = gd.geoToTexCoordsBuf;
                        if (bufIds == null) {
                            new Throwable("Buffer load issue!").printStackTrace();
                        }
                        if ((bufId = bufIds.get(texUnit)) == null) {
                            new Throwable("Buffer load issue!").printStackTrace();
                            continue;
                        }
                        gl.glBindBuffer(34962, bufId.intValue());
                        gl.glVertexAttribPointer(locs.glMultiTexCoord[texUnit], texStride, 5126, true, 0, 0L);
                        gl.glEnableVertexAttribArray(locs.glMultiTexCoord[texUnit]);
                    }
                }
            }
            if (geo_type == 12 || geo_type == 13 || geo_type == 14) {
                int primType = 0;
                if (ctx.polygonMode == 1) {
                    geo_type = 14;
                }
                switch (geo_type) {
                    case 12: {
                        primType = 5;
                        break;
                    }
                    case 13: {
                        primType = 6;
                        break;
                    }
                    case 14: {
                        primType = 1;
                    }
                }
                int[] stripInd = gd.geoToIndStripBuf;
                if (stripInd == null) {
                    stripInd = new int[strip_len];
                    gl.glGenBuffers(strip_len, stripInd, 0);
                    int offset = initialIndexIndex;
                    ShortBuffer indicesBuffer = Jogl2es2Pipeline.getIndexArrayBuffer(indexCoord);
                    for (int i = 0; i < strip_len; ++i) {
                        indicesBuffer.position(offset);
                        int count = sarray[i];
                        int indBufId = stripInd[i];
                        gl.glBindBuffer(34963, indBufId);
                        gl.glBufferData(34963, (long)(count * 16 / 8), (Buffer)indicesBuffer, 35044);
                        offset += count;
                    }
                    gd.geoToIndStripBuf = stripInd;
                }
                for (int i = 0; i < strip_len; ++i) {
                    int count = sarray[i];
                    int indBufId = stripInd[i];
                    gl.glBindBuffer(34963, indBufId);
                    gl.glDrawElements(primType, count, 5123, 0L);
                }
                return;
            } else {
                if (gd.geoToIndBuf == -1) {
                    ShortBuffer indBuf = Jogl2es2Pipeline.getIndexArrayBuffer(indexCoord);
                    tmp = new int[1];
                    gl.glGenBuffers(1, tmp, 0);
                    gd.geoToIndBuf = tmp[0];
                    gl.glBindBuffer(34963, gd.geoToIndBuf);
                    gl.glBufferData(34963, (long)(indBuf.remaining() * 16 / 8), (Buffer)indBuf, 35044);
                    gd.geoToIndBufSize = indBuf.remaining();
                }
                gl.glBindBuffer(34963, gd.geoToIndBuf);
                if (ctx.polygonMode == 1) {
                    geo_type = 11;
                } else if (ctx.polygonMode == 0) {
                    geo_type = 10;
                }
                switch (geo_type) {
                    case 8: {
                        if (!quadArrayCautionPrinted) {
                            System.err.println("QuadArray will render incorrectly, consider using TriangleArray. If you have the java3d-utils in the buildpath you can convert like this:");
                            System.err.println("GeometryInfo gi = new GeometryInfo(quadArray);");
                            System.err.println("gi.convertToIndexedTriangles();\t");
                            System.err.println("GeometryArray ga = gi.getIndexedGeometryArray(true, true, true, true, true);");
                            quadArrayCautionPrinted = true;
                        }
                    }
                    case 9: {
                        gl.glDrawElements(4, validIndexCount, 5123, 0L);
                        return;
                    }
                    case 10: {
                        gl.glDrawElements(0, validIndexCount, 5123, 0L);
                        return;
                    }
                    case 11: {
                        gl.glDrawElements(1, validIndexCount, 5123, 0L);
                    }
                }
            }
            return;
        } else {
            if (!this.NO_PROGRAM_WARNING_GIVEN) {
                System.err.println("Execute called with no shader Program in use!");
            }
            this.NO_PROGRAM_WARNING_GIVEN = true;
        }
    }

    private static void setFFPAttributes(Jogl2es2Context ctx, GL2ES2 gl, int shaderProgramId, Jogl2es2Context.ProgramData pd, int vdefined, boolean ignoreVertexColors) {
        Jogl2es2Context.LocationData locs = pd.programToLocationData;
        boolean floatColorsDefined = (vdefined & 4) != 0;
        boolean byteColorsDefined = (vdefined & 8) != 0;
        boolean isGL2ES3 = gl.isGL2ES3();
        if (locs.glProjectionMatrix != -1 && shaderProgramId != ctx.prevShaderProgram) {
            if (isGL2ES3) {
                gl.glUniformMatrix4fv(locs.glProjectionMatrix, 1, true, ctx.matrixUtil.toArray(ctx.currentProjMat), 0);
            } else {
                gl.glUniformMatrix4fv(locs.glProjectionMatrix, 1, false, Jogl2es2MatrixUtil.transposeInPlace(ctx.matrixUtil.toArray(ctx.currentProjMat)), 0);
            }
        }
        if (locs.glProjectionMatrixInverse != -1 && shaderProgramId != ctx.prevShaderProgram) {
            try {
                ctx.currentProjMatInverse.set(ctx.currentProjMat);
                ctx.matrixUtil.invert(ctx.currentProjMatInverse);
            }
            catch (SingularMatrixException e) {
                System.err.println("" + e);
            }
            if (isGL2ES3) {
                gl.glUniformMatrix4fv(locs.glProjectionMatrixInverse, 1, true, ctx.matrixUtil.toArray(ctx.currentProjMatInverse), 0);
            } else {
                gl.glUniformMatrix4fv(locs.glProjectionMatrixInverse, 1, false, Jogl2es2MatrixUtil.transposeInPlace(ctx.matrixUtil.toArray(ctx.currentProjMatInverse)), 0);
            }
        }
        if (locs.glViewMatrix != -1 && shaderProgramId != ctx.prevShaderProgram) {
            gl.glUniformMatrix4fv(locs.glViewMatrix, 1, true, ctx.matrixUtil.toArray(ctx.currentViewMat), 0);
        }
        if (locs.glModelMatrix != -1 && (shaderProgramId != ctx.prevShaderProgram || ctx.gl_state.modelMatrix.m00 == Double.NEGATIVE_INFINITY)) {
            if (isGL2ES3) {
                gl.glUniformMatrix4fv(locs.glModelMatrix, 1, true, ctx.matrixUtil.toArray(ctx.currentModelMat), 0);
            } else {
                gl.glUniformMatrix4fv(locs.glModelMatrix, 1, false, Jogl2es2MatrixUtil.transposeInPlace(ctx.matrixUtil.toArray(ctx.currentModelMat)), 0);
            }
            ctx.gl_state.modelMatrix.m00 = 0.0;
        }
        if (locs.glModelViewMatrix != -1 && (shaderProgramId != ctx.prevShaderProgram || ctx.gl_state.glModelViewMatrix.m00 == Double.NEGATIVE_INFINITY)) {
            if (ctx.currentModelViewMat.m00 == Double.NEGATIVE_INFINITY) {
                ctx.currentModelViewMat.mul(ctx.currentViewMat, ctx.currentModelMat);
            }
            if (isGL2ES3) {
                gl.glUniformMatrix4fv(locs.glModelViewMatrix, 1, true, ctx.matrixUtil.toArray(ctx.currentModelViewMat), 0);
            } else {
                gl.glUniformMatrix4fv(locs.glModelViewMatrix, 1, false, Jogl2es2MatrixUtil.transposeInPlace(ctx.matrixUtil.toArray(ctx.currentModelViewMat)), 0);
            }
            ctx.gl_state.glModelViewMatrix.m00 = 0.0;
        }
        if (locs.glModelViewMatrixInverse != -1 && (shaderProgramId != ctx.prevShaderProgram || ctx.gl_state.glModelViewMatrixInverse.m00 == Double.NEGATIVE_INFINITY)) {
            if (ctx.currentModelViewMatInverse.m00 == Double.NEGATIVE_INFINITY) {
                ctx.currentModelViewMatInverse.mul(ctx.currentViewMat, ctx.currentModelMat);
                ctx.matrixUtil.invert(ctx.currentModelViewMatInverse);
            }
            if (isGL2ES3) {
                gl.glUniformMatrix4fv(locs.glModelViewMatrixInverse, 1, true, ctx.matrixUtil.toArray(ctx.currentModelViewMatInverse), 0);
            } else {
                gl.glUniformMatrix4fv(locs.glModelViewMatrixInverse, 1, false, Jogl2es2MatrixUtil.transposeInPlace(ctx.matrixUtil.toArray(ctx.currentModelViewMatInverse)), 0);
            }
            ctx.gl_state.glModelViewMatrixInverse.m00 = 0.0;
        }
        if (locs.glModelViewProjectionMatrix != -1 && (shaderProgramId != ctx.prevShaderProgram || ctx.gl_state.glModelViewProjectionMatrix.m00 == Double.NEGATIVE_INFINITY)) {
            if (ctx.currentModelViewMat.m00 == Double.NEGATIVE_INFINITY) {
                ctx.currentModelViewMat.mul(ctx.currentViewMat, ctx.currentModelMat);
            }
            if (ctx.currentModelViewProjMat.m00 == Double.NEGATIVE_INFINITY) {
                ctx.currentModelViewProjMat.mul(ctx.currentProjMat, ctx.currentModelViewMat);
            }
            if (isGL2ES3) {
                gl.glUniformMatrix4fv(locs.glModelViewProjectionMatrix, 1, true, ctx.matrixUtil.toArray(ctx.currentModelViewProjMat), 0);
            } else {
                gl.glUniformMatrix4fv(locs.glModelViewProjectionMatrix, 1, false, Jogl2es2MatrixUtil.transposeInPlace(ctx.matrixUtil.toArray(ctx.currentModelViewProjMat)), 0);
            }
            ctx.gl_state.glModelViewProjectionMatrix.m00 = 0.0;
        }
        if (locs.glNormalMatrix != -1 && (shaderProgramId != ctx.prevShaderProgram || ctx.gl_state.glNormalMatrix.m00 == Double.NEGATIVE_INFINITY)) {
            if (ctx.currentModelViewMat.m00 == Double.NEGATIVE_INFINITY) {
                ctx.currentModelViewMat.mul(ctx.currentViewMat, ctx.currentModelMat);
            }
            if (ctx.currentNormalMat.m00 == Double.NEGATIVE_INFINITY) {
                Jogl2es2MatrixUtil.transposeInvert(ctx.currentModelViewMat, ctx.currentNormalMat);
            }
            if (isGL2ES3) {
                gl.glUniformMatrix3fv(locs.glNormalMatrix, 1, true, ctx.matrixUtil.toArray(ctx.currentNormalMat), 0);
            } else {
                gl.glUniformMatrix3fv(locs.glNormalMatrix, 1, false, Jogl2es2MatrixUtil.transposeInPlace(ctx.matrixUtil.toArray(ctx.currentNormalMat)), 0);
            }
            ctx.gl_state.glNormalMatrix.m00 = 0.0;
        }
        if (locs.ignoreVertexColors != -1) {
            int finalIgnoreVertexColorsInt;
            boolean finalIgnoreVertexColors = !floatColorsDefined && !byteColorsDefined || ctx.renderingData.ignoreVertexColors == 1;
            int n = finalIgnoreVertexColorsInt = finalIgnoreVertexColors ? 1 : 0;
            if (shaderProgramId != ctx.prevShaderProgram || ctx.gl_state.ignoreVertexColors != finalIgnoreVertexColorsInt) {
                gl.glUniform1i(locs.ignoreVertexColors, finalIgnoreVertexColorsInt);
                ctx.gl_state.ignoreVertexColors = finalIgnoreVertexColorsInt;
            }
        }
        if (locs.glFrontMaterial.present) {
            if (locs.glFrontMaterial.lightEnabled != -1 && (shaderProgramId != ctx.prevShaderProgram || ctx.gl_state.glFrontMaterial.lightEnabled != ctx.materialData.lightEnabled)) {
                gl.glUniform1i(locs.glFrontMaterial.lightEnabled, ctx.materialData.lightEnabled);
                ctx.gl_state.glFrontMaterial.lightEnabled = ctx.materialData.lightEnabled;
            }
            if (locs.glFrontMaterial.ambient != -1 && (shaderProgramId != ctx.prevShaderProgram || ctx.gl_state.glFrontMaterial.ambient.x == Float.NEGATIVE_INFINITY)) {
                gl.glUniform4f(locs.glFrontMaterial.ambient, ctx.materialData.ambient.x, ctx.materialData.ambient.y, ctx.materialData.ambient.z, 1.0f);
                ctx.gl_state.glFrontMaterial.ambient.x = 0.0f;
            }
            if (locs.glFrontMaterial.diffuse != -1 && (shaderProgramId != ctx.prevShaderProgram || ctx.gl_state.glFrontMaterial.diffuse.x == Float.NEGATIVE_INFINITY)) {
                gl.glUniform4f(locs.glFrontMaterial.diffuse, ctx.materialData.diffuse.x, ctx.materialData.diffuse.y, ctx.materialData.diffuse.z, ctx.materialData.diffuse.w);
                ctx.gl_state.glFrontMaterial.diffuse.x = 0.0f;
            }
            if (locs.glFrontMaterial.emission != -1 && (shaderProgramId != ctx.prevShaderProgram || ctx.gl_state.glFrontMaterial.emission.x == Float.NEGATIVE_INFINITY)) {
                gl.glUniform4f(locs.glFrontMaterial.emission, ctx.materialData.emission.x, ctx.materialData.emission.y, ctx.materialData.emission.z, 1.0f);
                ctx.gl_state.glFrontMaterial.emission.x = 0.0f;
            }
            if (locs.glFrontMaterial.specular != -1 && (shaderProgramId != ctx.prevShaderProgram || ctx.gl_state.glFrontMaterial.specular.x == Float.NEGATIVE_INFINITY)) {
                gl.glUniform3f(locs.glFrontMaterial.specular, ctx.materialData.specular.x, ctx.materialData.specular.y, ctx.materialData.specular.z);
                ctx.gl_state.glFrontMaterial.specular.x = 0.0f;
            }
            if (locs.glFrontMaterial.shininess != -1 && (shaderProgramId != ctx.prevShaderProgram || ctx.gl_state.glFrontMaterial.shininess != ctx.materialData.shininess)) {
                gl.glUniform1f(locs.glFrontMaterial.shininess, ctx.materialData.shininess);
                ctx.gl_state.glFrontMaterial.shininess = ctx.materialData.shininess;
            }
        }
        if (locs.glLightModelambient != -1 && (shaderProgramId != ctx.prevShaderProgram || ctx.gl_state.glLightModelambient.x == Float.NEGATIVE_INFINITY)) {
            gl.glUniform4f(locs.glLightModelambient, ctx.currentAmbientColor.x, ctx.currentAmbientColor.y, ctx.currentAmbientColor.z, ctx.currentAmbientColor.w);
            ctx.gl_state.glLightModelambient.x = 0.0f;
        }
        if (locs.objectColor != -1 && (shaderProgramId != ctx.prevShaderProgram || ctx.gl_state.objectColor.x == Float.NEGATIVE_INFINITY)) {
            gl.glUniform4f(locs.objectColor, ctx.objectColor.x, ctx.objectColor.y, ctx.objectColor.z, ctx.objectColor.w);
            ctx.gl_state.objectColor.x = 0.0f;
        }
        if (locs.transparencyAlpha != -1 && (shaderProgramId != ctx.prevShaderProgram || ctx.gl_state.transparencyAlpha != ctx.transparencyAlpha)) {
            gl.glUniform1f(locs.transparencyAlpha, ctx.transparencyAlpha);
            ctx.gl_state.transparencyAlpha = ctx.transparencyAlpha;
        }
        if (locs.numberOfLights != -1 && (shaderProgramId != ctx.prevShaderProgram || ctx.gl_state.numberOfLights != ctx.numberOfLights)) {
            gl.glUniform1i(locs.numberOfLights, ctx.numberOfLights);
            ctx.gl_state.numberOfLights = ctx.numberOfLights;
        }
        int pipelineLightSlotToUse = 0;
        for (int shaderLightIndex = 0; shaderLightIndex < ctx.maxLights; ++shaderLightIndex) {
            if (locs.glLightSource[pipelineLightSlotToUse] == null) continue;
            Jogl2es2Context.glLightSource glLightSource2 = ctx.glLightSource[shaderLightIndex];
            if (glLightSource2.enabled != 1) continue;
            if (shaderProgramId != ctx.prevShaderProgram || ctx.gl_state.glLightSource[shaderLightIndex] != glLightSource2) {
                glLightSource2.prevLightSlot = pipelineLightSlotToUse;
                Jogl2es2Context.glLightSourceLocs glLightSourceLocs2 = locs.glLightSource[pipelineLightSlotToUse];
                if (glLightSourceLocs2.position != -1) {
                    gl.glUniform4f(glLightSourceLocs2.position, glLightSource2.position.x, glLightSource2.position.y, glLightSource2.position.z, glLightSource2.position.w);
                }
                if (glLightSourceLocs2.diffuse != -1) {
                    gl.glUniform4f(glLightSourceLocs2.diffuse, glLightSource2.diffuse.x, glLightSource2.diffuse.y, glLightSource2.diffuse.z, glLightSource2.diffuse.w);
                }
                if (glLightSourceLocs2.specular != -1) {
                    gl.glUniform4f(glLightSourceLocs2.specular, glLightSource2.specular.x, glLightSource2.specular.y, glLightSource2.specular.z, glLightSource2.specular.w);
                }
                if (glLightSourceLocs2.constantAttenuation != -1) {
                    gl.glUniform1f(glLightSourceLocs2.constantAttenuation, glLightSource2.constantAttenuation);
                }
                if (glLightSourceLocs2.linearAttenuation != -1) {
                    gl.glUniform1f(glLightSourceLocs2.linearAttenuation, glLightSource2.linearAttenuation);
                }
                if (glLightSourceLocs2.quadraticAttenuation != -1) {
                    gl.glUniform1f(glLightSourceLocs2.quadraticAttenuation, glLightSource2.quadraticAttenuation);
                }
                if (glLightSourceLocs2.spotCutoff != -1) {
                    gl.glUniform1f(glLightSourceLocs2.spotCutoff, glLightSource2.spotCutoff);
                }
                if (glLightSourceLocs2.spotExponent != -1) {
                    gl.glUniform1f(glLightSourceLocs2.spotExponent, glLightSource2.spotExponent);
                }
                if (glLightSourceLocs2.spotDirection != -1) {
                    gl.glUniform3f(glLightSourceLocs2.spotDirection, glLightSource2.spotDirection.x, glLightSource2.spotDirection.y, glLightSource2.spotDirection.z);
                }
                ctx.gl_state.glLightSource[shaderLightIndex] = glLightSource2;
            }
            ++pipelineLightSlotToUse;
        }
        if (locs.alphaTestEnabled != -1 && (shaderProgramId != ctx.prevShaderProgram || ctx.gl_state.alphaTestEnabled != ctx.renderingData.alphaTestEnabled)) {
            gl.glUniform1i(locs.alphaTestEnabled, ctx.renderingData.alphaTestEnabled ? 1 : 0);
            ctx.gl_state.alphaTestEnabled = ctx.renderingData.alphaTestEnabled;
            if (ctx.renderingData.alphaTestEnabled) {
                if (shaderProgramId != ctx.prevShaderProgram || ctx.gl_state.alphaTestFunction != ctx.renderingData.alphaTestFunction) {
                    gl.glUniform1i(locs.alphaTestFunction, ctx.renderingData.alphaTestFunction);
                    ctx.gl_state.alphaTestFunction = ctx.renderingData.alphaTestFunction;
                }
                if (shaderProgramId != ctx.prevShaderProgram || ctx.gl_state.alphaTestValue != ctx.renderingData.alphaTestValue) {
                    gl.glUniform1f(locs.alphaTestValue, ctx.renderingData.alphaTestValue);
                    ctx.gl_state.alphaTestValue = ctx.renderingData.alphaTestValue;
                }
            }
        }
        if (locs.textureTransform != -1 && (shaderProgramId != ctx.prevShaderProgram || ctx.gl_state.textureTransform.m00 == Double.NEGATIVE_INFINITY)) {
            gl.glUniformMatrix4fv(locs.textureTransform, 1, true, ctx.matrixUtil.toArray(ctx.textureTransform), 0);
            ctx.gl_state.textureTransform.m00 = 0.0;
        }
        if (locs.fogData.present && locs.fogData.fogEnabled != -1 && (shaderProgramId != ctx.prevShaderProgram || ctx.gl_state.fogData.fogEnabled != ctx.fogData.fogEnabled)) {
            gl.glUniform1i(locs.fogData.fogEnabled, ctx.fogData.fogEnabled);
            ctx.gl_state.fogData.fogEnabled = ctx.fogData.fogEnabled;
            if (ctx.fogData.fogEnabled == 1 && (shaderProgramId != ctx.prevShaderProgram || ctx.gl_state.fogData.expColor.x == Float.NEGATIVE_INFINITY)) {
                if (locs.fogData.expColor != -1) {
                    gl.glUniform4f(locs.fogData.expColor, ctx.fogData.expColor.x, ctx.fogData.expColor.y, ctx.fogData.expColor.z, 1.0f);
                }
                if (locs.fogData.expDensity != -1) {
                    gl.glUniform1f(locs.fogData.expDensity, ctx.fogData.expDensity);
                }
                if (locs.fogData.linearColor != -1) {
                    gl.glUniform4f(locs.fogData.linearColor, ctx.fogData.linearColor.x, ctx.fogData.linearColor.y, ctx.fogData.linearColor.z, 1.0f);
                }
                if (locs.fogData.linearStart != -1) {
                    gl.glUniform1f(locs.fogData.linearStart, ctx.fogData.linearStart);
                }
                if (locs.fogData.linearEnd != -1) {
                    gl.glUniform1f(locs.fogData.linearEnd, ctx.fogData.linearEnd);
                }
                ctx.gl_state.fogData.expColor.x = 0.0f;
            }
        }
        ctx.prevShaderProgram = shaderProgramId;
    }

    private static void loadLocs(Jogl2es2Context ctx, GL2ES2 gl) {
        Jogl2es2Context.ProgramData pd = ctx.programData;
        if (pd.programToLocationData == null) {
            Jogl2es2Context.LocationData locs = new Jogl2es2Context.LocationData();
            int shaderProgramId = ctx.shaderProgramId;
            if (shaderProgramId != -1) {
                int position;
                int i;
                locs.glProjectionMatrix = gl.glGetUniformLocation(shaderProgramId, "glProjectionMatrix");
                locs.glProjectionMatrixInverse = gl.glGetUniformLocation(shaderProgramId, "glProjectionMatrixInverse");
                locs.glModelMatrix = gl.glGetUniformLocation(shaderProgramId, "glModelMatrix");
                locs.glViewMatrix = gl.glGetUniformLocation(shaderProgramId, "glViewMatrix");
                locs.glModelViewMatrix = gl.glGetUniformLocation(shaderProgramId, "glModelViewMatrix");
                locs.glModelViewMatrixInverse = gl.glGetUniformLocation(shaderProgramId, "glModelViewMatrixInverse");
                locs.glModelViewProjectionMatrix = gl.glGetUniformLocation(shaderProgramId, "glModelViewProjectionMatrix");
                locs.glNormalMatrix = gl.glGetUniformLocation(shaderProgramId, "glNormalMatrix");
                locs.ignoreVertexColors = gl.glGetUniformLocation(shaderProgramId, "ignoreVertexColors");
                locs.glLightModelambient = gl.glGetUniformLocation(shaderProgramId, "glLightModelambient");
                locs.objectColor = gl.glGetUniformLocation(shaderProgramId, "objectColor");
                locs.transparencyAlpha = gl.glGetUniformLocation(shaderProgramId, "transparencyAlpha");
                locs.alphaTestEnabled = gl.glGetUniformLocation(shaderProgramId, "alphaTestEnabled");
                locs.alphaTestFunction = gl.glGetUniformLocation(shaderProgramId, "alphaTestFunction");
                locs.alphaTestValue = gl.glGetUniformLocation(shaderProgramId, "alphaTestValue");
                locs.textureTransform = gl.glGetUniformLocation(shaderProgramId, "textureTransform");
                locs.fogData.fogEnabled = gl.glGetUniformLocation(shaderProgramId, "fogData.fogEnabled");
                locs.fogData.expColor = gl.glGetUniformLocation(shaderProgramId, "fogData.expColor");
                locs.fogData.expDensity = gl.glGetUniformLocation(shaderProgramId, "fogData.expDensity");
                locs.fogData.linearColor = gl.glGetUniformLocation(shaderProgramId, "fogData.linearColor");
                locs.fogData.linearStart = gl.glGetUniformLocation(shaderProgramId, "fogData.linearStart");
                locs.fogData.linearEnd = gl.glGetUniformLocation(shaderProgramId, "fogData.linearEnd");
                locs.fogData.setPresent();
                locs.glFrontMaterial.lightEnabled = gl.glGetUniformLocation(shaderProgramId, "glFrontMaterial.lightEnabled");
                locs.glFrontMaterial.ambient = gl.glGetUniformLocation(shaderProgramId, "glFrontMaterial.ambient");
                locs.glFrontMaterial.diffuse = gl.glGetUniformLocation(shaderProgramId, "glFrontMaterial.diffuse");
                locs.glFrontMaterial.emission = gl.glGetUniformLocation(shaderProgramId, "glFrontMaterial.emission");
                locs.glFrontMaterial.specular = gl.glGetUniformLocation(shaderProgramId, "glFrontMaterial.specular");
                locs.glFrontMaterial.shininess = gl.glGetUniformLocation(shaderProgramId, "glFrontMaterial.shininess");
                locs.glFrontMaterial.setPresent();
                locs.numberOfLights = gl.glGetUniformLocation(shaderProgramId, "numberOfLights");
                for (i = 0; i < locs.glLightSource.length && (position = gl.glGetUniformLocation(shaderProgramId, "glLightSource[" + i + "].position")) != -1; ++i) {
                    locs.glLightSource[i] = new Jogl2es2Context.glLightSourceLocs();
                    locs.glLightSource[i].position = position;
                    locs.glLightSource[i].diffuse = gl.glGetUniformLocation(shaderProgramId, "glLightSource[" + i + "].diffuse");
                    locs.glLightSource[i].specular = gl.glGetUniformLocation(shaderProgramId, "glLightSource[" + i + "].specular");
                    locs.glLightSource[i].constantAttenuation = gl.glGetUniformLocation(shaderProgramId, "glLightSource[" + i + "].constantAttenuation");
                    locs.glLightSource[i].linearAttenuation = gl.glGetUniformLocation(shaderProgramId, "glLightSource[" + i + "].linearAttenuation");
                    locs.glLightSource[i].quadraticAttenuation = gl.glGetUniformLocation(shaderProgramId, "glLightSource[" + i + "].quadraticAttenuation");
                    locs.glLightSource[i].spotCutoff = gl.glGetUniformLocation(shaderProgramId, "glLightSource[" + i + "].spotCutoff");
                    locs.glLightSource[i].spotExponent = gl.glGetUniformLocation(shaderProgramId, "glLightSource[" + i + "].spotExponent");
                    locs.glLightSource[i].spotDirection = gl.glGetUniformLocation(shaderProgramId, "glLightSource[" + i + "].spotDirection");
                }
                locs.glVertex = gl.glGetAttribLocation(shaderProgramId, "glVertex");
                locs.glColor = gl.glGetAttribLocation(shaderProgramId, "glColor");
                locs.glNormal = gl.glGetAttribLocation(shaderProgramId, "glNormal");
                for (i = 0; i < locs.glMultiTexCoord.length; ++i) {
                    locs.glMultiTexCoord[i] = gl.glGetAttribLocation(shaderProgramId, "glMultiTexCoord" + i);
                }
                HashMap<String, Integer> attToIndex = pd.progToGenVertAttNameToGenVertAttIndex;
                if (attToIndex != null) {
                    for (String attrib : attToIndex.keySet()) {
                        int index = attToIndex.get(attrib);
                        int attribLoc = gl.glGetAttribLocation(shaderProgramId, attrib);
                        locs.genAttIndexToLoc.put(index, new Integer(attribLoc));
                    }
                }
            }
            pd.programToLocationData = locs;
        }
    }

    private static Jogl2es2Context.GeometryData loadAllBuffers(Jogl2es2Context ctx, GL2ES2 gl, GeometryArrayRetained geo, boolean ignoreVertexColors, int vertexCount, int vformat, int vdefined, FloatBuffer fverts, float[] vfarray, int startVertex, FloatBuffer fclrs, float[] cfarray, int startClrs) {
        Jogl2es2Context.GeometryData gd = ctx.allGeometryData.get(geo.nativeId);
        if (gd == null) {
            gd = new Jogl2es2Context.GeometryData();
            geo.nativeId = gd.nativeId;
            ctx.allGeometryData.put(geo.nativeId, gd);
        }
        if (gd.geoToCoordBuf == -1) {
            if (vfarray != null) {
                fverts = Jogl2es2Pipeline.getVertexArrayBuffer(vfarray);
            }
            boolean morphable = geo.source.getCapability(19) || geo.source.getCapability(1);
            fverts.position(startVertex);
            if (morphable) {
                int[] tmp = new int[2];
                gl.glGenBuffers(2, tmp, 0);
                gd.geoToCoordBuf = tmp[0];
                gd.geoToCoordBuf1 = tmp[0];
                gd.geoToCoordBuf2 = tmp[1];
                gl.glBindBuffer(34962, gd.geoToCoordBuf1);
                int usage = morphable ? 35048 : 35044;
                gl.glBufferData(34962, (long)(fverts.remaining() * 32 / 8), (Buffer)fverts, usage);
                gl.glBindBuffer(34962, gd.geoToCoordBuf2);
                gl.glBufferData(34962, (long)(fverts.remaining() * 32 / 8), (Buffer)fverts, usage);
            } else {
                int[] tmp = new int[1];
                gl.glGenBuffers(1, tmp, 0);
                gd.geoToCoordBuf = tmp[0];
                gl.glBindBuffer(34962, gd.geoToCoordBuf);
                int usage = morphable ? 35048 : 35044;
                gl.glBufferData(34962, (long)(fverts.remaining() * 32 / 8), (Buffer)fverts, usage);
            }
            gd.geoToCoordBufSize = fverts.remaining();
            if (ctx.allGeometryData.size() % 500 == 0) {
                System.out.println("Coord buffer count " + ctx.allGeometryData.size());
            }
        }
        if (!ignoreVertexColors && gd.geoToColorBuf == -1) {
            if (cfarray != null) {
                fclrs = Jogl2es2Pipeline.getColorArrayBuffer(cfarray);
            }
            if (fclrs != null) {
                if (fclrs != fverts) {
                    fclrs.position(startClrs);
                    int[] tmp = new int[1];
                    gl.glGenBuffers(1, tmp, 0);
                    gd.geoToColorBuf = tmp[0];
                    gl.glBindBuffer(34962, gd.geoToColorBuf);
                    gl.glBufferData(34962, (long)(fclrs.remaining() * 32 / 8), (Buffer)fclrs, 35044);
                } else {
                    gd.geoToColorBuf = gd.geoToCoordBuf;
                }
            }
        }
        return gd;
    }

    private static Jogl2es2Context.GeometryData loadAllBuffers(Jogl2es2Context ctx, GL2ES2 gl, GeometryArrayRetained geo, boolean ignoreVertexColors, int vertexCount, int vformat, int vdefined, FloatBuffer fverts, float[] vfcoords, DoubleBuffer dverts, double[] vdcoords, FloatBuffer fclrs, float[] cfarray, ByteBuffer bclrs, byte[] cbdata, FloatBuffer norms, float[] narray, int vertexAttrCount, int[] vertexAttrSizes, FloatBuffer[] vertexAttrBufs, float[][] vertexAttrData, int texCoordMapLength, int[] texCoordSetMap, int texStride, Object[] texCoords) {
        boolean textureDefined;
        Jogl2es2Context.GeometryData gd = ctx.allGeometryData.get(geo.nativeId);
        if (gd == null) {
            gd = new Jogl2es2Context.GeometryData();
            geo.nativeId = gd.nativeId;
            ctx.allGeometryData.put(geo.nativeId, gd);
        }
        boolean floatCoordDefined = (vdefined & 1) != 0;
        boolean doubleCoordDefined = (vdefined & 2) != 0;
        boolean floatColorsDefined = (vdefined & 4) != 0;
        boolean byteColorsDefined = (vdefined & 8) != 0;
        boolean normalsDefined = (vdefined & 0x10) != 0;
        boolean vattrDefined = (vdefined & 0x40) != 0;
        boolean bl = textureDefined = (vdefined & 0x20) != 0;
        if (floatCoordDefined && gd.geoToCoordBuf == -1) {
            int usage;
            int[] tmp;
            if (vfcoords != null) {
                fverts = Jogl2es2Pipeline.getVertexArrayBuffer(vfcoords);
            }
            boolean morphable = geo.source.getCapability(19) || geo.source.getCapability(1);
            fverts.position(0);
            if (morphable) {
                tmp = new int[2];
                gl.glGenBuffers(2, tmp, 0);
                gd.geoToCoordBuf = tmp[0];
                gd.geoToCoordBuf1 = tmp[0];
                gd.geoToCoordBuf2 = tmp[1];
                gl.glBindBuffer(34962, gd.geoToCoordBuf1);
                usage = morphable ? 35048 : 35044;
                gl.glBufferData(34962, (long)(fverts.remaining() * 32 / 8), (Buffer)fverts, usage);
                gl.glBindBuffer(34962, gd.geoToCoordBuf2);
                gl.glBufferData(34962, (long)(fverts.remaining() * 32 / 8), (Buffer)fverts, usage);
            } else {
                tmp = new int[1];
                gl.glGenBuffers(1, tmp, 0);
                gd.geoToCoordBuf = tmp[0];
                gl.glBindBuffer(34962, gd.geoToCoordBuf);
                usage = morphable ? 35048 : 35044;
                gl.glBufferData(34962, (long)(fverts.remaining() * 32 / 8), (Buffer)fverts, usage);
            }
            gd.geoToCoordBufSize = fverts.remaining();
            if (ctx.allGeometryData.size() % 500 == 0) {
                System.out.println("Coord buffer count " + ctx.allGeometryData.size());
            }
        }
        if (floatColorsDefined && !ignoreVertexColors && gd.geoToColorBuf == -1) {
            if (cfarray != null) {
                fclrs = Jogl2es2Pipeline.getColorArrayBuffer(cfarray);
            }
            fclrs.position(0);
            int[] tmp = new int[1];
            gl.glGenBuffers(1, tmp, 0);
            gd.geoToColorBuf = tmp[0];
            gl.glBindBuffer(34962, gd.geoToColorBuf);
            gl.glBufferData(34962, (long)(fclrs.remaining() * 32 / 8), (Buffer)fclrs, 35044);
        }
        if (normalsDefined && gd.geoToNormalBuf == -1) {
            if (narray != null) {
                norms = Jogl2es2Pipeline.getNormalArrayBuffer(narray);
            }
            norms.position(0);
            int[] tmp = new int[1];
            gl.glGenBuffers(1, tmp, 0);
            gd.geoToNormalBuf = tmp[0];
            gl.glBindBuffer(34962, gd.geoToNormalBuf);
            gl.glBufferData(34962, (long)(norms.remaining() * 32 / 8), (Buffer)norms, 35044);
        }
        if (vattrDefined) {
            if (vertexAttrData != null) {
                vertexAttrBufs = Jogl2es2Pipeline.getVertexAttrSetBuffer((Object[])vertexAttrData);
            }
            for (int index = 0; index < vertexAttrCount; ++index) {
                Integer bufId;
                FloatBuffer vertexAttrs = vertexAttrBufs[index];
                vertexAttrs.position(0);
                SparseArray<Integer> bufIds = gd.geoToVertAttribBuf;
                if (bufIds == null) {
                    bufIds = new SparseArray();
                    gd.geoToVertAttribBuf = bufIds;
                }
                if ((bufId = bufIds.get(index)) != null) continue;
                int[] tmp2 = new int[1];
                gl.glGenBuffers(1, tmp2, 0);
                bufId = new Integer(tmp2[0]);
                bufIds.put(index, bufId);
                gl.glBindBuffer(34962, bufId.intValue());
                gl.glBufferData(34962, (long)(vertexAttrs.remaining() * 32 / 8), (Buffer)vertexAttrs, 35044);
            }
        }
        if (textureDefined) {
            if (!(texCoords[0] instanceof FloatBuffer)) {
                texCoords = Jogl2es2Pipeline.getTexCoordSetBuffer(texCoords);
            }
            boolean[] texSetsLoaded = new boolean[texCoords.length];
            for (int texUnit = 0; texUnit < texCoordMapLength; ++texUnit) {
                Integer bufId;
                int texSet = texCoordSetMap[texUnit];
                if (texSet == -1 || texSetsLoaded[texSet]) continue;
                texSetsLoaded[texSet] = true;
                FloatBuffer buf = (FloatBuffer)texCoords[texSet];
                buf.position(0);
                SparseArray<Integer> bufIds = gd.geoToTexCoordsBuf;
                if (bufIds == null) {
                    bufIds = new SparseArray();
                    gd.geoToTexCoordsBuf = bufIds;
                }
                if ((bufId = bufIds.get(texUnit)) != null) continue;
                int[] tmp = new int[1];
                gl.glGenBuffers(1, tmp, 0);
                bufId = new Integer(tmp[0]);
                gl.glBindBuffer(34962, bufId.intValue());
                gl.glBufferData(34962, (long)(buf.remaining() * 32 / 8), (Buffer)buf, 35044);
                bufIds.put(texUnit, bufId);
            }
        }
        return gd;
    }

    @Override
    void setVertexFormat(Context ctx, GeometryArrayRetained geo, int vformat, boolean useAlpha, boolean ignoreVertexColors) {
    }

    @Override
    void readRaster(Context ctx, int type, int xSrcOffset, int ySrcOffset, int width, int height, int hCanvas, int imageDataType, int imageFormat, Object imageBuffer, int depthFormat, Object depthBuffer) {
        Jogl2es2Context joglesctx = (Jogl2es2Context)ctx;
        GL2ES2 gl = joglesctx.gl2es2();
        gl.glPixelStorei(3333, 1);
        int yAdjusted = hCanvas - height - ySrcOffset;
        if ((type & 1) != 0) {
            int format = 0;
            if (imageDataType == 4096) {
                switch (imageFormat) {
                    case 1: {
                        format = 32992;
                        break;
                    }
                    case 2: {
                        format = 6407;
                        break;
                    }
                    case 4: {
                        format = 6408;
                        break;
                    }
                    case 8: {
                        format = 6408;
                        break;
                    }
                    case 16: {
                        format = 6410;
                        break;
                    }
                    default: {
                        assert (false);
                        return;
                    }
                }
                gl.glReadPixels(xSrcOffset, yAdjusted, width, height, format, 5121, (Buffer)ByteBuffer.wrap((byte[])imageBuffer));
            } else if (imageDataType == 8192) {
                switch (imageFormat) {
                    case 128: {
                        format = 6407;
                        break;
                    }
                    case 256: {
                        format = 6407;
                        break;
                    }
                    case 512: {
                        format = 6408;
                        break;
                    }
                    default: {
                        assert (false);
                        return;
                    }
                }
                gl.glReadPixels(xSrcOffset, yAdjusted, width, height, format, 5121, (Buffer)IntBuffer.wrap((int[])imageBuffer));
            } else assert (false);
        }
        if ((type & 2) != 0) {
            throw new UnsupportedOperationException("To get depth you should use a shader that return depth info for gl2es2 then read from color");
        }
    }

    @Override
    ShaderError setGLSLUniform1i(Context ctx, ShaderProgramId shaderProgramId, ShaderAttrLoc uniformLocation, int value) {
        Jogl2es2Context joglesctx = (Jogl2es2Context)ctx;
        GL2ES2 gl = joglesctx.gl2es2();
        int loc = Jogl2es2Pipeline.unbox(uniformLocation);
        if (joglesctx.gl_state.setGLSLUniform1i[loc] != value) {
            gl.glUniform1i(loc, value);
            joglesctx.gl_state.setGLSLUniform1i[loc] = value;
        }
        return null;
    }

    @Override
    ShaderError setGLSLUniform1f(Context ctx, ShaderProgramId shaderProgramId, ShaderAttrLoc uniformLocation, float value) {
        Jogl2es2Context joglesctx = (Jogl2es2Context)ctx;
        GL2ES2 gl = joglesctx.gl2es2();
        int loc = Jogl2es2Pipeline.unbox(uniformLocation);
        if (joglesctx.gl_state.setGLSLUniform1f[loc] != value) {
            gl.glUniform1f(loc, value);
            joglesctx.gl_state.setGLSLUniform1f[loc] = value;
        }
        return null;
    }

    @Override
    ShaderError setGLSLUniform2i(Context ctx, ShaderProgramId shaderProgramId, ShaderAttrLoc uniformLocation, int[] value) {
        GL2ES2 gl = ((Jogl2es2Context)ctx).gl2es2();
        gl.glUniform2i(Jogl2es2Pipeline.unbox(uniformLocation), value[0], value[1]);
        return null;
    }

    @Override
    ShaderError setGLSLUniform2f(Context ctx, ShaderProgramId shaderProgramId, ShaderAttrLoc uniformLocation, float[] value) {
        GL2ES2 gl = ((Jogl2es2Context)ctx).gl2es2();
        gl.glUniform2f(Jogl2es2Pipeline.unbox(uniformLocation), value[0], value[1]);
        return null;
    }

    @Override
    ShaderError setGLSLUniform3i(Context ctx, ShaderProgramId shaderProgramId, ShaderAttrLoc uniformLocation, int[] value) {
        GL2ES2 gl = ((Jogl2es2Context)ctx).gl2es2();
        gl.glUniform3i(Jogl2es2Pipeline.unbox(uniformLocation), value[0], value[1], value[2]);
        return null;
    }

    @Override
    ShaderError setGLSLUniform3f(Context ctx, ShaderProgramId shaderProgramId, ShaderAttrLoc uniformLocation, float[] value) {
        GL2ES2 gl = ((Jogl2es2Context)ctx).gl2es2();
        gl.glUniform3f(Jogl2es2Pipeline.unbox(uniformLocation), value[0], value[1], value[2]);
        return null;
    }

    @Override
    ShaderError setGLSLUniform4i(Context ctx, ShaderProgramId shaderProgramId, ShaderAttrLoc uniformLocation, int[] value) {
        GL2ES2 gl = ((Jogl2es2Context)ctx).gl2es2();
        gl.glUniform4i(Jogl2es2Pipeline.unbox(uniformLocation), value[0], value[1], value[2], value[3]);
        return null;
    }

    @Override
    ShaderError setGLSLUniform4f(Context ctx, ShaderProgramId shaderProgramId, ShaderAttrLoc uniformLocation, float[] value) {
        GL2ES2 gl = ((Jogl2es2Context)ctx).gl2es2();
        gl.glUniform4f(Jogl2es2Pipeline.unbox(uniformLocation), value[0], value[1], value[2], value[3]);
        return null;
    }

    @Override
    ShaderError setGLSLUniformMatrix3f(Context ctx, ShaderProgramId shaderProgramId, ShaderAttrLoc uniformLocation, float[] value) {
        GL2ES2 gl = ((Jogl2es2Context)ctx).gl2es2();
        gl.glUniformMatrix3fv(Jogl2es2Pipeline.unbox(uniformLocation), 1, false, ((Jogl2es2Context)ctx).matrixUtil.toFB3(value));
        return null;
    }

    @Override
    ShaderError setGLSLUniformMatrix4f(Context ctx, ShaderProgramId shaderProgramId, ShaderAttrLoc uniformLocation, float[] value) {
        GL2ES2 gl = ((Jogl2es2Context)ctx).gl2es2();
        gl.glUniformMatrix4fv(Jogl2es2Pipeline.unbox(uniformLocation), 1, false, ((Jogl2es2Context)ctx).matrixUtil.toFB4(value));
        return null;
    }

    @Override
    ShaderError setGLSLUniform1iArray(Context ctx, ShaderProgramId shaderProgramId, ShaderAttrLoc uniformLocation, int numElements, int[] value) {
        GL2ES2 gl = ((Jogl2es2Context)ctx).gl2es2();
        gl.glUniform1iv(Jogl2es2Pipeline.unbox(uniformLocation), numElements, value, 0);
        return null;
    }

    @Override
    ShaderError setGLSLUniform1fArray(Context ctx, ShaderProgramId shaderProgramId, ShaderAttrLoc uniformLocation, int numElements, float[] value) {
        GL2ES2 gl = ((Jogl2es2Context)ctx).gl2es2();
        gl.glUniform1fv(Jogl2es2Pipeline.unbox(uniformLocation), numElements, value, 0);
        return null;
    }

    @Override
    ShaderError setGLSLUniform2iArray(Context ctx, ShaderProgramId shaderProgramId, ShaderAttrLoc uniformLocation, int numElements, int[] value) {
        GL2ES2 gl = ((Jogl2es2Context)ctx).gl2es2();
        gl.glUniform2iv(Jogl2es2Pipeline.unbox(uniformLocation), numElements, value, 0);
        return null;
    }

    @Override
    ShaderError setGLSLUniform2fArray(Context ctx, ShaderProgramId shaderProgramId, ShaderAttrLoc uniformLocation, int numElements, float[] value) {
        GL2ES2 gl = ((Jogl2es2Context)ctx).gl2es2();
        gl.glUniform2fv(Jogl2es2Pipeline.unbox(uniformLocation), numElements, value, 0);
        return null;
    }

    @Override
    ShaderError setGLSLUniform3iArray(Context ctx, ShaderProgramId shaderProgramId, ShaderAttrLoc uniformLocation, int numElements, int[] value) {
        GL2ES2 gl = ((Jogl2es2Context)ctx).gl2es2();
        gl.glUniform3iv(Jogl2es2Pipeline.unbox(uniformLocation), numElements, value, 0);
        return null;
    }

    @Override
    ShaderError setGLSLUniform3fArray(Context ctx, ShaderProgramId shaderProgramId, ShaderAttrLoc uniformLocation, int numElements, float[] value) {
        GL2ES2 gl = ((Jogl2es2Context)ctx).gl2es2();
        gl.glUniform3fv(Jogl2es2Pipeline.unbox(uniformLocation), numElements, value, 0);
        return null;
    }

    @Override
    ShaderError setGLSLUniform4iArray(Context ctx, ShaderProgramId shaderProgramId, ShaderAttrLoc uniformLocation, int numElements, int[] value) {
        GL2ES2 gl = ((Jogl2es2Context)ctx).gl2es2();
        gl.glUniform4iv(Jogl2es2Pipeline.unbox(uniformLocation), numElements, value, 0);
        return null;
    }

    @Override
    ShaderError setGLSLUniform4fArray(Context ctx, ShaderProgramId shaderProgramId, ShaderAttrLoc uniformLocation, int numElements, float[] value) {
        GL2ES2 gl = ((Jogl2es2Context)ctx).gl2es2();
        gl.glUniform4fv(Jogl2es2Pipeline.unbox(uniformLocation), numElements, value, 0);
        return null;
    }

    @Override
    ShaderError setGLSLUniformMatrix3fArray(Context ctx, ShaderProgramId shaderProgramId, ShaderAttrLoc uniformLocation, int numElements, float[] value) {
        GL2ES2 gl = ((Jogl2es2Context)ctx).gl2es2();
        gl.glUniformMatrix3fv(Jogl2es2Pipeline.unbox(uniformLocation), numElements, true, value, 0);
        return null;
    }

    @Override
    ShaderError setGLSLUniformMatrix4fArray(Context ctx, ShaderProgramId shaderProgramId, ShaderAttrLoc uniformLocation, int numElements, float[] value) {
        GL2ES2 gl = ((Jogl2es2Context)ctx).gl2es2();
        gl.glUniformMatrix4fv(Jogl2es2Pipeline.unbox(uniformLocation), numElements, true, value, 0);
        return null;
    }

    @Override
    ShaderError createGLSLShader(Context ctx, int shaderType, ShaderId[] shaderId) {
        GL2ES2 gl = ((Jogl2es2Context)ctx).gl2es2();
        int shaderHandle = 0;
        if (shaderType == 1) {
            shaderHandle = gl.glCreateShader(35633);
        } else if (shaderType == 2) {
            shaderHandle = gl.glCreateShader(35632);
        }
        if (shaderHandle == 0) {
            return new ShaderError(1, "Unable to create native shader object");
        }
        shaderId[0] = new JoglShaderObject(shaderHandle);
        return null;
    }

    @Override
    ShaderError destroyGLSLShader(Context ctx, ShaderId shaderId) {
        GL2ES2 gl = ((Jogl2es2Context)ctx).gl2es2();
        gl.glDeleteShader(Jogl2es2Pipeline.unbox(shaderId));
        return null;
    }

    @Override
    ShaderError compileGLSLShader(Context ctx, ShaderId shaderId, String program) {
        int id = Jogl2es2Pipeline.unbox(shaderId);
        if (id == 0) {
            throw new AssertionError((Object)"shaderId == 0");
        }
        if (program == null) {
            throw new AssertionError((Object)"shader program string is null");
        }
        GL2ES2 gl = ((Jogl2es2Context)ctx).gl2es2();
        gl.glShaderSource(id, 1, new String[]{program}, null, 0);
        gl.glCompileShader(id);
        int[] status = new int[1];
        gl.glGetShaderiv(id, 35713, status, 0);
        if (status[0] == 0) {
            String detailMsg = Jogl2es2Pipeline.getShaderInfoLog(gl, id);
            ShaderError res = new ShaderError(1, "GLSL shader compile error");
            res.setDetailMessage(detailMsg);
            return res;
        }
        return null;
    }

    @Override
    ShaderError createGLSLShaderProgram(Context ctx, ShaderProgramId[] shaderProgramId) {
        GL2ES2 gl = ((Jogl2es2Context)ctx).gl2es2();
        int shaderProgramHandle = gl.glCreateProgram();
        if (shaderProgramHandle == 0) {
            return new ShaderError(2, "Unable to create native shader program object");
        }
        shaderProgramId[0] = new JoglShaderObject(shaderProgramHandle);
        return null;
    }

    @Override
    ShaderError destroyGLSLShaderProgram(Context ctx, ShaderProgramId shaderProgramId) {
        GL2ES2 gl = ((Jogl2es2Context)ctx).gl2es2();
        gl.glDeleteShader(Jogl2es2Pipeline.unbox(shaderProgramId));
        ((Jogl2es2Context)ctx).allProgramData.remove(Jogl2es2Pipeline.unbox(shaderProgramId));
        return null;
    }

    @Override
    ShaderError linkGLSLShaderProgram(Context ctx, ShaderProgramId shaderProgramId, ShaderId[] shaderIds) {
        GL2ES2 gl = ((Jogl2es2Context)ctx).gl2es2();
        int id = Jogl2es2Pipeline.unbox(shaderProgramId);
        for (int i = 0; i < shaderIds.length; ++i) {
            gl.glAttachShader(id, Jogl2es2Pipeline.unbox(shaderIds[i]));
        }
        gl.glLinkProgram(id);
        int[] status = new int[1];
        gl.glGetProgramiv(id, 35714, status, 0);
        if (status[0] == 0) {
            String detailMsg = Jogl2es2Pipeline.getProgramInfoLog(gl, id);
            ShaderError res = new ShaderError(2, "GLSL shader program link error");
            res.setDetailMessage(detailMsg);
            return res;
        }
        return null;
    }

    @Override
    ShaderError bindGLSLVertexAttrName(Context ctx, ShaderProgramId shaderProgramId, String attrName, int attrIndex) {
        HashMap<String, Integer> attToIndex;
        int progId = Jogl2es2Pipeline.unbox(shaderProgramId);
        Jogl2es2Context joglesContext = (Jogl2es2Context)ctx;
        Jogl2es2Context.ProgramData pd = joglesContext.allProgramData.get(progId);
        if (pd == null) {
            pd = new Jogl2es2Context.ProgramData();
            joglesContext.allProgramData.put(progId, pd);
        }
        if ((attToIndex = pd.progToGenVertAttNameToGenVertAttIndex) == null) {
            pd.progToGenVertAttNameToGenVertAttIndex = attToIndex = new HashMap();
        }
        attToIndex.put(attrName, attrIndex);
        return null;
    }

    @Override
    void lookupGLSLShaderAttrNames(Context ctx, ShaderProgramId shaderProgramId, int numAttrNames, String[] attrNames, ShaderAttrLoc[] locArr, int[] typeArr, int[] sizeArr, boolean[] isArrayArr) {
        int i;
        GL2ES2 gl = ((Jogl2es2Context)ctx).gl2es2();
        for (int i2 = 0; i2 < attrNames.length; ++i2) {
            locArr[i2] = null;
            typeArr[i2] = -1;
            sizeArr[i2] = -1;
        }
        int id = Jogl2es2Pipeline.unbox(shaderProgramId);
        int[] tmp = new int[1];
        int[] tmp2 = new int[1];
        int[] tmp3 = new int[1];
        gl.glGetProgramiv(id, 35718, tmp, 0);
        int numActiveUniforms = tmp[0];
        gl.glGetProgramiv(id, 35719, tmp, 0);
        int maxStrLen = tmp[0];
        byte[] nameBuf = new byte[maxStrLen];
        block3: for (i = 0; i < numActiveUniforms; ++i) {
            gl.glGetActiveUniform(id, i, maxStrLen, tmp3, 0, tmp, 0, tmp2, 0, nameBuf, 0);
            int size = tmp[0];
            int type = tmp2[0];
            String name = null;
            try {
                name = new String(nameBuf, 0, tmp3[0], "US-ASCII");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            if (name.length() >= 3 && name.endsWith("]")) {
                if (!name.endsWith("[0]")) continue;
                name = name.substring(0, name.length() - 3);
            }
            for (int j = 0; j < numAttrNames; ++j) {
                if (!name.equals(attrNames[j])) continue;
                sizeArr[j] = size;
                isArrayArr[j] = size > 1;
                typeArr[j] = Jogl2es2Pipeline.glslToJ3dType(type);
                continue block3;
            }
        }
        for (i = 0; i < numAttrNames; ++i) {
            int loc = gl.glGetUniformLocation(id, attrNames[i]);
            locArr[i] = new JoglShaderObject(loc);
        }
    }

    @Override
    ShaderError useGLSLShaderProgram(Context ctx, ShaderProgramId inShaderProgramId) {
        int shaderProgramId = Jogl2es2Pipeline.unbox(inShaderProgramId);
        Jogl2es2Context joglesContext = (Jogl2es2Context)ctx;
        if (joglesContext.gl_state.currentProgramId != shaderProgramId) {
            if (shaderProgramId == -1) {
                if (!this.USE_NULL_SHADER_WARNING_GIVEN) {
                    System.err.println("Null shader passed for use");
                }
                this.USE_NULL_SHADER_WARNING_GIVEN = true;
            }
            GL2ES2 gl = joglesContext.gl2es2();
            gl.glUseProgram(shaderProgramId);
            joglesContext.setShaderProgram((JoglShaderObject)inShaderProgramId);
            Jogl2es2Pipeline.loadLocs(joglesContext, gl);
            joglesContext.gl_state.currentProgramId = shaderProgramId;
        }
        return null;
    }

    private static int unbox(ShaderAttrLoc loc) {
        if (loc == null) {
            return -1;
        }
        return ((JoglShaderObject)loc).getValue();
    }

    private static int unbox(ShaderProgramId id) {
        if (id == null) {
            return 0;
        }
        return ((JoglShaderObject)id).getValue();
    }

    private static int unbox(ShaderId id) {
        if (id == null) {
            return 0;
        }
        return ((JoglShaderObject)id).getValue();
    }

    private static String getShaderInfoLog(GL2ES2 gl, int id) {
        int[] infoLogLength = new int[1];
        gl.glGetShaderiv(id, 35716, infoLogLength, 0);
        if (infoLogLength[0] > 0) {
            byte[] storage = new byte[infoLogLength[0]];
            int[] len = new int[1];
            gl.glGetShaderInfoLog(id, infoLogLength[0], len, 0, storage, 0);
            try {
                return new String(storage, 0, len[0], "US-ASCII");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private static String getProgramInfoLog(GL2ES2 gl, int id) {
        int[] infoLogLength = new int[1];
        gl.glGetProgramiv(id, 35716, infoLogLength, 0);
        if (infoLogLength[0] > 0) {
            byte[] storage = new byte[infoLogLength[0]];
            int[] len = new int[1];
            gl.glGetProgramInfoLog(id, infoLogLength[0], len, 0, storage, 0);
            try {
                return new String(storage, 0, len[0], "US-ASCII");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private static int glslToJ3dType(int type) {
        switch (type) {
            case 5124: 
            case 35670: 
            case 35678: 
            case 35679: 
            case 35680: {
                return 0;
            }
            case 5126: {
                return 1;
            }
            case 35667: 
            case 35671: {
                return 2;
            }
            case 35664: {
                return 3;
            }
            case 35668: 
            case 35672: {
                return 4;
            }
            case 35665: {
                return 5;
            }
            case 35669: 
            case 35673: {
                return 6;
            }
            case 35666: {
                return 7;
            }
            case 35675: {
                return 8;
            }
            case 35676: {
                return 9;
            }
        }
        return -1;
    }

    @Override
    void updateDirectionalLight(Context ctx, int lightSlot, float red, float green, float blue, float dirx, float diry, float dirz) {
        Jogl2es2Context joglesctx = (Jogl2es2Context)ctx;
        Vector4f lightPos = joglesctx.matrixUtil.transform(joglesctx.currentModelMat, joglesctx.currentViewMat, -dirx, -diry, -dirz, 0.0f);
        if (joglesctx.glLightSource[lightSlot] == null) {
            joglesctx.glLightSource[lightSlot] = new Jogl2es2Context.glLightSource();
            joglesctx.gl_state.glLightSource[lightSlot] = null;
        }
        joglesctx.glLightSource[lightSlot].diffuse.x = red;
        joglesctx.glLightSource[lightSlot].diffuse.y = green;
        joglesctx.glLightSource[lightSlot].diffuse.z = blue;
        joglesctx.glLightSource[lightSlot].diffuse.w = 1.0f;
        joglesctx.glLightSource[lightSlot].specular.x = red;
        joglesctx.glLightSource[lightSlot].specular.y = green;
        joglesctx.glLightSource[lightSlot].specular.z = blue;
        joglesctx.glLightSource[lightSlot].specular.w = 1.0f;
        joglesctx.glLightSource[lightSlot].position.x = lightPos.x;
        joglesctx.glLightSource[lightSlot].position.y = lightPos.y;
        joglesctx.glLightSource[lightSlot].position.z = lightPos.z;
        joglesctx.glLightSource[lightSlot].position.w = 0.0f;
        joglesctx.glLightSource[lightSlot].constantAttenuation = 1.0f;
        joglesctx.glLightSource[lightSlot].linearAttenuation = 0.0f;
        joglesctx.glLightSource[lightSlot].quadraticAttenuation = 0.0f;
        joglesctx.glLightSource[lightSlot].spotExponent = 0.0f;
        joglesctx.glLightSource[lightSlot].spotCutoff = 180.0f;
    }

    @Override
    void updatePointLight(Context ctx, int lightSlot, float red, float green, float blue, float attenx, float atteny, float attenz, float posx, float posy, float posz) {
        Jogl2es2Context joglesctx = (Jogl2es2Context)ctx;
        Vector4f lightPos = joglesctx.matrixUtil.transform(joglesctx.currentModelMat, joglesctx.currentViewMat, posx, posy, posz, 1.0f);
        if (joglesctx.glLightSource[lightSlot] == null) {
            joglesctx.glLightSource[lightSlot] = new Jogl2es2Context.glLightSource();
            joglesctx.gl_state.glLightSource[lightSlot] = null;
        }
        joglesctx.glLightSource[lightSlot].diffuse.x = red;
        joglesctx.glLightSource[lightSlot].diffuse.y = green;
        joglesctx.glLightSource[lightSlot].diffuse.z = blue;
        joglesctx.glLightSource[lightSlot].diffuse.w = 1.0f;
        joglesctx.glLightSource[lightSlot].specular.x = red;
        joglesctx.glLightSource[lightSlot].specular.y = green;
        joglesctx.glLightSource[lightSlot].specular.z = blue;
        joglesctx.glLightSource[lightSlot].specular.w = 1.0f;
        joglesctx.glLightSource[lightSlot].position.x = lightPos.x;
        joglesctx.glLightSource[lightSlot].position.y = lightPos.y;
        joglesctx.glLightSource[lightSlot].position.z = lightPos.z;
        joglesctx.glLightSource[lightSlot].position.w = 1.0f;
        joglesctx.glLightSource[lightSlot].constantAttenuation = attenx;
        joglesctx.glLightSource[lightSlot].linearAttenuation = atteny;
        joglesctx.glLightSource[lightSlot].quadraticAttenuation = attenz;
        joglesctx.glLightSource[lightSlot].spotExponent = 0.0f;
        joglesctx.glLightSource[lightSlot].spotCutoff = 180.0f;
    }

    @Override
    void updateSpotLight(Context ctx, int lightSlot, float red, float green, float blue, float attenx, float atteny, float attenz, float posx, float posy, float posz, float spreadAngle, float concentration, float dirx, float diry, float dirz) {
        Jogl2es2Context joglesctx = (Jogl2es2Context)ctx;
        Vector4f lightPos = joglesctx.matrixUtil.transform(joglesctx.currentModelMat, joglesctx.currentViewMat, posx, posy, posz, 1.0f);
        if (joglesctx.glLightSource[lightSlot] == null) {
            joglesctx.glLightSource[lightSlot] = new Jogl2es2Context.glLightSource();
            joglesctx.gl_state.glLightSource[lightSlot] = null;
        }
        joglesctx.glLightSource[lightSlot].diffuse.x = red;
        joglesctx.glLightSource[lightSlot].diffuse.y = green;
        joglesctx.glLightSource[lightSlot].diffuse.z = blue;
        joglesctx.glLightSource[lightSlot].diffuse.w = 1.0f;
        joglesctx.glLightSource[lightSlot].specular.x = red;
        joglesctx.glLightSource[lightSlot].specular.y = green;
        joglesctx.glLightSource[lightSlot].specular.z = blue;
        joglesctx.glLightSource[lightSlot].specular.w = 1.0f;
        joglesctx.glLightSource[lightSlot].position.x = lightPos.x;
        joglesctx.glLightSource[lightSlot].position.y = lightPos.y;
        joglesctx.glLightSource[lightSlot].position.z = lightPos.z;
        joglesctx.glLightSource[lightSlot].position.w = 1.0f;
        joglesctx.glLightSource[lightSlot].constantAttenuation = attenx;
        joglesctx.glLightSource[lightSlot].linearAttenuation = atteny;
        joglesctx.glLightSource[lightSlot].quadraticAttenuation = attenz;
        joglesctx.glLightSource[lightSlot].spotDirection.x = dirx;
        joglesctx.glLightSource[lightSlot].spotDirection.y = diry;
        joglesctx.glLightSource[lightSlot].spotDirection.z = dirz;
        joglesctx.glLightSource[lightSlot].spotExponent = concentration;
        joglesctx.glLightSource[lightSlot].spotCutoff = (float)((double)(spreadAngle * 180.0f) / Math.PI);
    }

    @Override
    void updateExponentialFog(Context ctx, float red, float green, float blue, float density) {
        Jogl2es2Context joglesctx = (Jogl2es2Context)ctx;
        joglesctx.gl_state.fogData.expColor.x = Float.NEGATIVE_INFINITY;
        joglesctx.fogData.expColor.x = red;
        joglesctx.fogData.expColor.y = green;
        joglesctx.fogData.expColor.z = blue;
        joglesctx.fogData.expDensity = density;
        joglesctx.fogData.fogEnabled = 1;
    }

    @Override
    void updateLinearFog(Context ctx, float red, float green, float blue, double fdist, double bdist) {
        Jogl2es2Context joglesctx = (Jogl2es2Context)ctx;
        joglesctx.gl_state.fogData.expColor.x = Float.NEGATIVE_INFINITY;
        joglesctx.fogData.linearColor.x = red;
        joglesctx.fogData.linearColor.y = green;
        joglesctx.fogData.linearColor.z = blue;
        joglesctx.fogData.linearStart = (float)fdist;
        joglesctx.fogData.linearEnd = (float)bdist;
        joglesctx.fogData.fogEnabled = 1;
    }

    @Override
    void disableFog(Context ctx) {
        Jogl2es2Context joglesctx = (Jogl2es2Context)ctx;
        joglesctx.gl_state.fogData.expColor.x = Float.NEGATIVE_INFINITY;
        joglesctx.fogData.fogEnabled = 0;
    }

    @Override
    void setFogEnableFlag(Context ctx, boolean enable) {
        Jogl2es2Context joglesctx = (Jogl2es2Context)ctx;
        joglesctx.gl_state.fogData.expColor.x = Float.NEGATIVE_INFINITY;
        joglesctx.fogData.fogEnabled = enable ? 1 : 0;
    }

    @Override
    void updateLineAttributes(Context ctx, float lineWidth, int linePattern, int linePatternMask, int linePatternScaleFactor, boolean lineAntialiasing) {
        GL2ES2 gl = ((Jogl2es2Context)ctx).gl2es2();
        gl.glLineWidth(lineWidth);
    }

    @Override
    void resetLineAttributes(Context ctx) {
        GL2ES2 gl = ((Jogl2es2Context)ctx).gl2es2();
        gl.glLineWidth(1.0f);
    }

    @Override
    void updateMaterial(Context ctx, float red, float green, float blue, float alpha, float aRed, float aGreen, float aBlue, float eRed, float eGreen, float eBlue, float dRed, float dGreen, float dBlue, float sRed, float sGreen, float sBlue, float shininess, int colorTarget, boolean lightEnable) {
        Jogl2es2Context joglesctx = (Jogl2es2Context)ctx;
        if (joglesctx.objectColor.x != red || joglesctx.objectColor.y != green || joglesctx.objectColor.z != blue || joglesctx.objectColor.w != alpha) {
            joglesctx.gl_state.objectColor.x = Float.NEGATIVE_INFINITY;
            joglesctx.objectColor.x = red;
            joglesctx.objectColor.y = green;
            joglesctx.objectColor.z = blue;
            joglesctx.objectColor.w = alpha;
        }
        joglesctx.materialData.lightEnabled = lightEnable ? 1 : 0;
        joglesctx.materialData.shininess = shininess;
        if (joglesctx.materialData.emission.x != eRed || joglesctx.materialData.emission.y != eGreen || joglesctx.materialData.emission.z != eBlue) {
            joglesctx.gl_state.glFrontMaterial.emission.x = Float.NEGATIVE_INFINITY;
            joglesctx.materialData.emission.x = eRed;
            joglesctx.materialData.emission.y = eGreen;
            joglesctx.materialData.emission.z = eBlue;
        }
        if (joglesctx.materialData.ambient.x != aRed || joglesctx.materialData.ambient.y != aGreen || joglesctx.materialData.ambient.z != aBlue) {
            joglesctx.gl_state.glFrontMaterial.ambient.x = Float.NEGATIVE_INFINITY;
            joglesctx.materialData.ambient.x = aRed;
            joglesctx.materialData.ambient.y = aGreen;
            joglesctx.materialData.ambient.z = aBlue;
        }
        if (joglesctx.materialData.specular.x != sRed || joglesctx.materialData.specular.y != sGreen || joglesctx.materialData.specular.z != sBlue) {
            joglesctx.gl_state.glFrontMaterial.specular.x = Float.NEGATIVE_INFINITY;
            joglesctx.materialData.specular.x = sRed;
            joglesctx.materialData.specular.y = sGreen;
            joglesctx.materialData.specular.z = sBlue;
        }
        if (joglesctx.materialData.diffuse.x != dRed || joglesctx.materialData.diffuse.y != dGreen || joglesctx.materialData.diffuse.z != dBlue || joglesctx.materialData.diffuse.w != alpha) {
            joglesctx.gl_state.glFrontMaterial.diffuse.x = Float.NEGATIVE_INFINITY;
            joglesctx.materialData.diffuse.x = dRed;
            joglesctx.materialData.diffuse.y = dGreen;
            joglesctx.materialData.diffuse.z = dBlue;
            joglesctx.materialData.diffuse.w = alpha;
        }
    }

    @Override
    void updateMaterialColor(Context ctx, float r, float g, float b, float a) {
        Jogl2es2Context joglesctx = (Jogl2es2Context)ctx;
        if (joglesctx.objectColor.x != r || joglesctx.objectColor.y != g || joglesctx.objectColor.z != b || joglesctx.objectColor.w != a) {
            joglesctx.gl_state.objectColor.x = Float.NEGATIVE_INFINITY;
        }
        joglesctx.objectColor.x = r;
        joglesctx.objectColor.y = g;
        joglesctx.objectColor.z = b;
        joglesctx.objectColor.w = a;
    }

    @Override
    void updateColoringAttributes(Context ctx, float dRed, float dGreen, float dBlue, float red, float green, float blue, float alpha, boolean lightEnable, int shadeModel) {
        Jogl2es2Context joglesctx = (Jogl2es2Context)ctx;
        if (joglesctx.objectColor.x != red || joglesctx.objectColor.y != green || joglesctx.objectColor.z != blue || joglesctx.objectColor.w != alpha) {
            joglesctx.gl_state.objectColor.x = Float.NEGATIVE_INFINITY;
        }
        joglesctx.objectColor.x = red;
        joglesctx.objectColor.y = green;
        joglesctx.objectColor.z = blue;
        joglesctx.objectColor.w = alpha;
    }

    @Override
    void resetColoringAttributes(Context ctx, float r, float g, float b, float a, boolean enableLight) {
        Jogl2es2Context joglesctx = (Jogl2es2Context)ctx;
        if (joglesctx.objectColor.x != r || joglesctx.objectColor.y != g || joglesctx.objectColor.z != b || joglesctx.objectColor.w != a) {
            joglesctx.gl_state.objectColor.x = Float.NEGATIVE_INFINITY;
        }
        joglesctx.objectColor.x = r;
        joglesctx.objectColor.y = g;
        joglesctx.objectColor.z = b;
        joglesctx.objectColor.w = a;
    }

    @Override
    void updatePointAttributes(Context ctx, float pointSize, boolean pointAntialiasing) {
        Jogl2es2Context joglesctx = (Jogl2es2Context)ctx;
        joglesctx.pointSize = pointSize;
        if (!this.pointsEnabled) {
            GL2ES2 gl = ((Jogl2es2Context)ctx).gl2es2();
            gl.glEnable(34370);
            gl.glEnable(34913);
            this.pointsEnabled = true;
        }
    }

    @Override
    void resetPointAttributes(Context ctx) {
        Jogl2es2Context joglesctx = (Jogl2es2Context)ctx;
        joglesctx.pointSize = 1.0f;
    }

    @Override
    void updatePolygonAttributes(Context ctx, int polygonMode, int cullFace, boolean backFaceNormalFlip, float polygonOffset, float polygonOffsetFactor) {
        GL2ES2 gl = null;
        Jogl2es2Context joglesctx = (Jogl2es2Context)ctx;
        if (joglesctx.gl_state.cullFace != cullFace) {
            gl = ((Jogl2es2Context)ctx).gl2es2();
            if (cullFace == 0) {
                gl.glDisable(2884);
            } else {
                if (cullFace == 1) {
                    gl.glCullFace(1029);
                } else {
                    gl.glCullFace(1028);
                }
                gl.glEnable(2884);
            }
            joglesctx.gl_state.cullFace = cullFace;
        }
        if (joglesctx.gl_state.polygonOffsetFactor != polygonOffsetFactor || joglesctx.gl_state.polygonOffset != polygonOffset) {
            gl = gl == null ? ((Jogl2es2Context)ctx).gl2es2() : gl;
            gl.glPolygonOffset(polygonOffsetFactor, polygonOffset);
            if (polygonOffsetFactor != 0.0f || polygonOffset != 0.0f) {
                gl.glEnable(32823);
            } else {
                gl.glDisable(32823);
            }
            joglesctx.gl_state.polygonOffsetFactor = polygonOffsetFactor;
            joglesctx.gl_state.polygonOffset = polygonOffset;
        }
        joglesctx.polygonMode = polygonMode;
    }

    @Override
    void resetPolygonAttributes(Context ctx) {
        GL2ES2 gl = null;
        Jogl2es2Context joglesctx = (Jogl2es2Context)ctx;
        if (joglesctx.gl_state.cullFace != 1) {
            gl = ((Jogl2es2Context)ctx).gl2es2();
            gl.glCullFace(1029);
            gl.glEnable(2884);
            joglesctx.gl_state.cullFace = 1;
        }
        if (joglesctx.gl_state.polygonOffsetFactor != 0.0f || joglesctx.gl_state.polygonOffset != 0.0f) {
            gl = gl == null ? ((Jogl2es2Context)ctx).gl2es2() : gl;
            gl.glPolygonOffset(0.0f, 0.0f);
            gl.glDisable(32823);
            joglesctx.gl_state.polygonOffsetFactor = 0.0f;
            joglesctx.gl_state.polygonOffset = 0.0f;
        }
        joglesctx.polygonMode = 2;
    }

    @Override
    void updateRenderingAttributes(Context ctx, boolean depthBufferWriteEnableOverride, boolean depthBufferEnableOverride, boolean depthBufferEnable, boolean depthBufferWriteEnable, int depthTestFunction, float alphaTestValue, int alphaTestFunction, boolean ignoreVertexColors, boolean rasterOpEnable, int rasterOp, boolean userStencilAvailable, boolean stencilEnable, int stencilFailOp, int stencilZFailOp, int stencilZPassOp, int stencilFunction, int stencilReferenceValue, int stencilCompareMask, int stencilWriteMask) {
        GL2ES2 gl = null;
        Jogl2es2Context joglesctx = (Jogl2es2Context)ctx;
        if (joglesctx.gl_state.depthBufferEnableOverride != depthBufferEnable || joglesctx.gl_state.depthBufferEnable != depthBufferEnable || joglesctx.gl_state.depthTestFunction != depthTestFunction) {
            if (!depthBufferEnableOverride) {
                GL2ES2 gL2ES2 = gl = gl == null ? ((Jogl2es2Context)ctx).gl2es2() : gl;
                if (depthBufferEnable) {
                    gl.glEnable(2929);
                    gl.glDepthFunc(Jogl2es2Pipeline.getFunctionValue(depthTestFunction));
                } else {
                    gl.glDisable(2929);
                }
            }
            joglesctx.gl_state.depthBufferEnableOverride = depthBufferEnable;
            joglesctx.gl_state.depthBufferEnable = depthBufferEnable;
            joglesctx.gl_state.depthTestFunction = depthTestFunction;
        }
        if (!depthBufferWriteEnableOverride) {
            if (depthBufferWriteEnable) {
                if (!joglesctx.gl_state.glDepthMask) {
                    gl = gl == null ? ((Jogl2es2Context)ctx).gl2es2() : gl;
                    gl.glDepthMask(true);
                    joglesctx.gl_state.glDepthMask = true;
                }
            } else if (joglesctx.gl_state.glDepthMask) {
                gl = gl == null ? ((Jogl2es2Context)ctx).gl2es2() : gl;
                gl.glDepthMask(false);
                joglesctx.gl_state.glDepthMask = true;
            }
        }
        if (alphaTestFunction == 0) {
            joglesctx.renderingData.alphaTestEnabled = false;
        } else {
            joglesctx.renderingData.alphaTestEnabled = true;
            joglesctx.renderingData.alphaTestFunction = Jogl2es2Pipeline.getFunctionValue(alphaTestFunction);
            joglesctx.renderingData.alphaTestValue = alphaTestValue;
        }
        int n = joglesctx.renderingData.ignoreVertexColors = ignoreVertexColors ? 1 : 0;
        if (rasterOpEnable) {
            System.err.println("rasterOpEnable!!!! no no no!");
        }
        if (userStencilAvailable) {
            if (stencilEnable) {
                if (!joglesctx.gl_state.glEnableGL_STENCIL_TEST || joglesctx.gl_state.stencilFailOp != stencilFailOp || joglesctx.gl_state.stencilZFailOp != stencilZFailOp || joglesctx.gl_state.stencilZPassOp != stencilZPassOp || joglesctx.gl_state.stencilFunction != stencilFunction || joglesctx.gl_state.stencilReferenceValue != stencilReferenceValue || joglesctx.gl_state.stencilCompareMask != stencilCompareMask || joglesctx.gl_state.stencilWriteMask != stencilWriteMask) {
                    gl = gl == null ? ((Jogl2es2Context)ctx).gl2es2() : gl;
                    gl.glEnable(2960);
                    gl.glStencilOp(Jogl2es2Pipeline.getStencilOpValue(stencilFailOp), Jogl2es2Pipeline.getStencilOpValue(stencilZFailOp), Jogl2es2Pipeline.getStencilOpValue(stencilZPassOp));
                    gl.glStencilFunc(Jogl2es2Pipeline.getFunctionValue(stencilFunction), stencilReferenceValue, stencilCompareMask);
                    gl.glStencilMask(stencilWriteMask);
                    joglesctx.gl_state.glEnableGL_STENCIL_TEST = true;
                }
            } else if (joglesctx.gl_state.glEnableGL_STENCIL_TEST) {
                gl = gl == null ? ((Jogl2es2Context)ctx).gl2es2() : gl;
                gl.glDisable(2960);
                joglesctx.gl_state.glEnableGL_STENCIL_TEST = false;
            }
        }
    }

    @Override
    void resetRenderingAttributes(Context ctx, boolean depthBufferWriteEnableOverride, boolean depthBufferEnableOverride) {
        GL2ES2 gl = null;
        Jogl2es2Context joglesctx = (Jogl2es2Context)ctx;
        if (!depthBufferWriteEnableOverride && !joglesctx.gl_state.glDepthMask) {
            gl = gl == null ? ((Jogl2es2Context)ctx).gl2es2() : gl;
            gl.glDepthMask(true);
            joglesctx.gl_state.glDepthMask = true;
        }
        if (!depthBufferEnableOverride && !joglesctx.gl_state.depthBufferEnable) {
            gl = gl == null ? ((Jogl2es2Context)ctx).gl2es2() : gl;
            gl.glEnable(2929);
            joglesctx.gl_state.depthBufferEnable = true;
        }
        if (joglesctx.gl_state.depthTestFunction != 5) {
            gl = gl == null ? ((Jogl2es2Context)ctx).gl2es2() : gl;
            gl.glDepthFunc(515);
            joglesctx.gl_state.depthTestFunction = 5;
        }
        joglesctx.renderingData.alphaTestEnabled = false;
        joglesctx.renderingData.alphaTestFunction = 0;
        joglesctx.renderingData.alphaTestValue = 0.0f;
        joglesctx.renderingData.ignoreVertexColors = 0;
        if (joglesctx.gl_state.glEnableGL_STENCIL_TEST) {
            gl = gl == null ? ((Jogl2es2Context)ctx).gl2es2() : gl;
            gl.glDisable(2960);
            joglesctx.gl_state.glEnableGL_STENCIL_TEST = false;
        }
    }

    @Override
    void updateTransparencyAttributes(Context ctx, float alpha, int geometryType, int polygonMode, boolean lineAA, boolean pointAA, int transparencyMode, int srcBlendFunction, int dstBlendFunction) {
        GL2ES2 gl = null;
        Jogl2es2Context joglesctx = (Jogl2es2Context)ctx;
        joglesctx.transparencyAlpha = alpha;
        if (transparencyMode < 3 || ((geometryType & 2) != 0 || polygonMode == 1) && lineAA || ((geometryType & 1) != 0 || polygonMode == 0) && pointAA) {
            if (!joglesctx.gl_state.glEnableGL_BLEND || joglesctx.gl_state.srcBlendFunction != srcBlendFunction || joglesctx.gl_state.dstBlendFunction != dstBlendFunction) {
                gl = gl == null ? ((Jogl2es2Context)ctx).gl2es2() : gl;
                gl.glEnable(3042);
                gl.glBlendFunc(blendFunctionTable[srcBlendFunction], blendFunctionTable[dstBlendFunction]);
                joglesctx.gl_state.glEnableGL_BLEND = true;
                joglesctx.gl_state.srcBlendFunction = srcBlendFunction;
                joglesctx.gl_state.dstBlendFunction = dstBlendFunction;
            }
        } else if (joglesctx.gl_state.glEnableGL_BLEND) {
            gl = gl == null ? ((Jogl2es2Context)ctx).gl2es2() : gl;
            gl.glDisable(3042);
            joglesctx.gl_state.glEnableGL_BLEND = false;
        }
    }

    @Override
    void resetTransparency(Context ctx, int geometryType, int polygonMode, boolean lineAA, boolean pointAA) {
        GL2ES2 gl = null;
        Jogl2es2Context joglesctx = (Jogl2es2Context)ctx;
        joglesctx.transparencyAlpha = 1.0f;
        if (((geometryType & 2) != 0 || polygonMode == 1) && lineAA || ((geometryType & 1) != 0 || polygonMode == 0) && pointAA) {
            if (!joglesctx.gl_state.glEnableGL_BLEND || joglesctx.gl_state.srcBlendFunction != 2 || joglesctx.gl_state.dstBlendFunction != 3) {
                gl = gl == null ? ((Jogl2es2Context)ctx).gl2es2() : gl;
                gl.glEnable(3042);
                gl.glBlendFunc(770, 771);
                joglesctx.gl_state.glEnableGL_BLEND = true;
                joglesctx.gl_state.srcBlendFunction = 2;
                joglesctx.gl_state.dstBlendFunction = 3;
            }
        } else if (joglesctx.gl_state.glEnableGL_BLEND) {
            gl = gl == null ? ((Jogl2es2Context)ctx).gl2es2() : gl;
            gl.glDisable(3042);
            joglesctx.gl_state.glEnableGL_BLEND = false;
        }
    }

    @Override
    void updateTextureAttributes(Context ctx, double[] transform, boolean isIdentity, int textureMode, int perspCorrectionMode, float textureBlendColorRed, float textureBlendColorGreen, float textureBlendColorBlue, float textureBlendColorAlpha, int textureFormat) {
        Jogl2es2Context joglesctx = (Jogl2es2Context)ctx;
        joglesctx.gl_state.textureTransform.m00 = Double.NEGATIVE_INFINITY;
        joglesctx.textureTransform.set(transform);
    }

    @Override
    void resetTextureAttributes(Context ctx) {
        Jogl2es2Context joglesctx = (Jogl2es2Context)ctx;
        joglesctx.gl_state.textureTransform.m00 = Double.NEGATIVE_INFINITY;
        joglesctx.textureTransform.setIdentity();
    }

    @Override
    void resetTexCoordGeneration(Context ctx) {
    }

    @Override
    void updateTextureUnitState(Context ctx, int index, boolean enable) {
        Jogl2es2Context joglesContext = (Jogl2es2Context)ctx;
        GL2ES2 gl = null;
        if (index >= 0 && joglesContext.gl_state.glActiveTexture != index + 33984) {
            gl = gl == null ? ((Jogl2es2Context)ctx).gl2es2() : gl;
            gl.glActiveTexture(index + 33984);
            joglesContext.gl_state.glActiveTexture = index + 33984;
        }
    }

    @Override
    void bindTexture2D(Context ctx, int objectId, boolean enable) {
        Jogl2es2Context joglesContext = (Jogl2es2Context)ctx;
        GL2ES2 gl = null;
        if (enable && joglesContext.gl_state.glBindTextureGL_TEXTURE_2D[joglesContext.gl_state.glActiveTexture] != objectId) {
            gl = gl == null ? ((Jogl2es2Context)ctx).gl2es2() : gl;
            gl.glBindTexture(3553, objectId);
            joglesContext.gl_state.glBindTextureGL_TEXTURE_2D[joglesContext.gl_state.glActiveTexture] = objectId;
        }
    }

    @Override
    void updateTexture2DImage(Context ctx, int numLevels, int level, int textureFormat, int imageFormat, int width, int height, int boundaryWidth, int dataType, Object data, boolean useAutoMipMap) {
        this.updateTexture2DImage(ctx, 3553, numLevels, level, textureFormat, imageFormat, width, height, boundaryWidth, dataType, data, useAutoMipMap);
    }

    @Override
    void updateTexture2DSubImage(Context ctx, int level, int xoffset, int yoffset, int textureFormat, int imageFormat, int imgXOffset, int imgYOffset, int tilew, int width, int height, int dataType, Object data, boolean useAutoMipMap) {
        this.updateTexture2DSubImage(ctx, 3553, level, xoffset, yoffset, textureFormat, imageFormat, imgXOffset, imgYOffset, tilew, width, height, dataType, data);
    }

    @Override
    void updateTexture2DLodRange(Context ctx, int baseLevel, int maximumLevel, float minimumLOD, float maximumLOD) {
        Jogl2es2Pipeline.updateTextureLodRange(ctx, 3553, baseLevel, maximumLevel, minimumLOD, maximumLOD);
    }

    @Override
    void updateTexture2DBoundary(Context ctx, int boundaryModeS, int boundaryModeT, float boundaryRed, float boundaryGreen, float boundaryBlue, float boundaryAlpha) {
        this.updateTextureBoundary(ctx, 3553, boundaryModeS, boundaryModeT, -1, boundaryRed, boundaryGreen, boundaryBlue, boundaryAlpha);
    }

    @Override
    void updateTexture2DFilterModes(Context ctx, int minFilter, int magFilter) {
        Jogl2es2Pipeline.updateTextureFilterModes(ctx, 3553, minFilter, magFilter);
    }

    @Override
    void updateTexture2DAnisotropicFilter(Context ctx, float degree) {
        Jogl2es2Pipeline.updateTextureAnisotropicFilter(ctx, 3553, degree);
    }

    private static void updateTextureLodRange(Context ctx, int target, int baseLevel, int maximumLevel, float minimumLOD, float maximumLOD) {
    }

    private static void updateTextureAnisotropicFilter(Context ctx, int target, float degree) {
        GL2ES2 gl = ((Jogl2es2Context)ctx).gl2es2();
        gl.glTexParameterf(target, 34046, degree);
    }

    @Override
    void bindTextureCubeMap(Context ctx, int objectId, boolean enable) {
        GL2ES2 gl = null;
        if (enable) {
            gl = gl == null ? ((Jogl2es2Context)ctx).gl2es2() : gl;
            gl.glBindTexture(34067, objectId);
        }
    }

    @Override
    void updateTextureCubeMapImage(Context ctx, int face, int numLevels, int level, int textureFormat, int imageFormat, int width, int height, int boundaryWidth, int dataType, Object data, boolean useAutoMipMap) {
        this.updateTexture2DImage(ctx, _gl_textureCubeMapFace[face], numLevels, level, textureFormat, imageFormat, width, height, boundaryWidth, dataType, data, useAutoMipMap);
    }

    @Override
    void updateTextureCubeMapSubImage(Context ctx, int face, int level, int xoffset, int yoffset, int textureFormat, int imageFormat, int imgXOffset, int imgYOffset, int tilew, int width, int height, int dataType, Object data, boolean useAutoMipMap) {
        throw new UnsupportedOperationException();
    }

    @Override
    void updateTextureCubeMapLodRange(Context ctx, int baseLevel, int maximumLevel, float minimumLod, float maximumLod) {
        Jogl2es2Pipeline.updateTextureLodRange(ctx, 34067, baseLevel, maximumLevel, minimumLod, maximumLod);
    }

    @Override
    void updateTextureCubeMapBoundary(Context ctx, int boundaryModeS, int boundaryModeT, float boundaryRed, float boundaryGreen, float boundaryBlue, float boundaryAlpha) {
        this.updateTextureBoundary(ctx, 34067, boundaryModeS, boundaryModeT, -1, boundaryRed, boundaryGreen, boundaryBlue, boundaryAlpha);
    }

    @Override
    void updateTextureCubeMapFilterModes(Context ctx, int minFilter, int magFilter) {
        Jogl2es2Pipeline.updateTextureFilterModes(ctx, 34067, minFilter, magFilter);
    }

    @Override
    void updateTextureCubeMapAnisotropicFilter(Context ctx, float degree) {
        Jogl2es2Pipeline.updateTextureAnisotropicFilter(ctx, 34067, degree);
    }

    private void updateTexture2DImage(Context ctx, int target, int numLevels, int level, int textureFormat, int imageFormat, int width, int height, int boundaryWidth, int dataType, Object data, boolean useAutoMipMap) {
        GL2ES2 gl = ((Jogl2es2Context)ctx).gl2es2();
        int internalFormat = 0;
        switch (textureFormat) {
            case 1: {
                new Throwable("Texture.INTENSITY not supported").printStackTrace();
                break;
            }
            case 2: {
                internalFormat = 6409;
                break;
            }
            case 3: {
                internalFormat = 6406;
                break;
            }
            case 4: {
                internalFormat = 6410;
                break;
            }
            case 5: {
                internalFormat = 6407;
                break;
            }
            case 6: {
                internalFormat = 6408;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        boolean createMipMaps = useAutoMipMap;
        int format = 0;
        if (dataType == 4096 || dataType == 16384) {
            switch (imageFormat) {
                case 1: {
                    format = 32992;
                    break;
                }
                case 2: {
                    format = 6407;
                    break;
                }
                case 4: {
                    if (this.isExtensionAvailable.GL_EXT_abgr(gl)) {
                        format = 32768;
                        break;
                    }
                    assert (false);
                    return;
                }
                case 8: {
                    format = 6408;
                    break;
                }
                case 16: {
                    format = 6410;
                    break;
                }
                case 32: {
                    if (internalFormat == 6406) {
                        format = 6406;
                        break;
                    }
                    format = 6409;
                    break;
                }
                case 33698: {
                    internalFormat = 6408;
                    format = 6408;
                    break;
                }
                case 33777: 
                case 33778: 
                case 33779: 
                case 35954: 
                case 37492: 
                case 37493: 
                case 37494: 
                case 37495: 
                case 37496: 
                case 37497: 
                case 37808: 
                case 37809: 
                case 37810: 
                case 37811: 
                case 37812: 
                case 37813: 
                case 37814: 
                case 37815: 
                case 37816: 
                case 37817: 
                case 37818: 
                case 37819: 
                case 37820: 
                case 37821: {
                    internalFormat = imageFormat;
                    format = -1;
                    break;
                }
                default: {
                    assert (false);
                    return;
                }
            }
            if (dataType == 4096) {
                gl.glTexImage2D(target, level, internalFormat, width, height, boundaryWidth, format, 5121, (Buffer)ByteBuffer.wrap((byte[])data));
            } else if (format == -1) {
                ByteBuffer bb = (ByteBuffer)data;
                gl.glCompressedTexImage2D(target, level, internalFormat, width, height, boundaryWidth, bb.limit(), (Buffer)bb);
            } else {
                gl.glTexImage2D(target, level, internalFormat, width, height, boundaryWidth, format, 5121, (Buffer)data);
            }
        } else if (dataType == 8192 || dataType == 32768) {
            switch (imageFormat) {
                case 128: {
                    format = 6407;
                    break;
                }
                case 256: {
                    format = 6407;
                    break;
                }
                case 512: {
                    format = 6408;
                    break;
                }
                default: {
                    assert (false);
                    return;
                }
            }
            if (dataType == 8192) {
                gl.glTexImage2D(target, level, internalFormat, width, height, boundaryWidth, format, 5121, (Buffer)IntBuffer.wrap((int[])data));
            } else {
                gl.glTexImage2D(target, level, internalFormat, width, height, boundaryWidth, format, 5121, (Buffer)data);
            }
        } else assert (false);
        if (createMipMaps && level == 0) {
            gl.glTexParameteri(target, 10241, 9987);
            gl.glHint(33170, 4354);
            gl.glGenerateMipmap(target);
            Jogl2es2Pipeline.outputErrors(ctx);
        }
    }

    private void updateTexture2DSubImage(Context ctx, int target, int level, int xoffset, int yoffset, int textureFormat, int imageFormat, int imgXOffset, int imgYOffset, int tilew, int width, int height, int dataType, Object data) {
        GL2ES2 gl = ((Jogl2es2Context)ctx).gl2es2();
        if (imgXOffset > 0 || width < tilew) {
            // empty if block
        }
        int internalFormat = 0;
        switch (textureFormat) {
            case 1: {
                new Throwable("Texture.INTENSITY not supported").printStackTrace();
                break;
            }
            case 2: {
                internalFormat = 6409;
                break;
            }
            case 3: {
                internalFormat = 6406;
                break;
            }
            case 4: {
                internalFormat = 6410;
                break;
            }
            case 5: {
                internalFormat = 6407;
                break;
            }
            case 6: {
                internalFormat = 6408;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (dataType == 4096 || dataType == 16384) {
            int format = 0;
            int numBytes = 0;
            switch (imageFormat) {
                case 1: {
                    format = 32992;
                    numBytes = 3;
                    break;
                }
                case 2: {
                    format = 6407;
                    numBytes = 3;
                    break;
                }
                case 4: {
                    if (this.isExtensionAvailable.GL_EXT_abgr(gl)) {
                        format = 32768;
                        numBytes = 4;
                        break;
                    }
                    assert (false);
                    return;
                }
                case 8: {
                    format = 6408;
                    numBytes = 4;
                    break;
                }
                case 16: {
                    format = 6410;
                    numBytes = 2;
                    break;
                }
                case 32: {
                    if (internalFormat == 6406) {
                        format = 6406;
                        numBytes = 1;
                        break;
                    }
                    format = 6409;
                    numBytes = 1;
                    break;
                }
                default: {
                    assert (false);
                    return;
                }
            }
            ByteBuffer buf = null;
            buf = dataType == 4096 ? ByteBuffer.wrap((byte[])data) : (ByteBuffer)data;
            buf.position((tilew * imgYOffset + imgXOffset) * numBytes);
            gl.glTexSubImage2D(target, level, xoffset, yoffset, width, height, format, 5121, (Buffer)buf);
        } else if (dataType == 8192 || dataType == 32768) {
            int format = 0;
            switch (imageFormat) {
                case 128: {
                    format = 6407;
                    break;
                }
                case 256: {
                    format = 6407;
                    break;
                }
                case 512: {
                    format = 6408;
                    break;
                }
                default: {
                    assert (false);
                    return;
                }
            }
            IntBuffer buf = null;
            buf = dataType == 8192 ? IntBuffer.wrap((int[])data) : (IntBuffer)data;
            buf.position(tilew * imgYOffset + imgXOffset);
            gl.glTexSubImage2D(target, level, xoffset, yoffset, width, height, format, 5121, (Buffer)buf);
        } else {
            assert (false);
            return;
        }
    }

    private static void updateTextureFilterModes(Context ctx, int target, int minFilter, int magFilter) {
        GL2ES2 gl = ((Jogl2es2Context)ctx).gl2es2();
        switch (minFilter) {
            case 0: 
            case 2: {
                gl.glTexParameteri(target, 10241, 9728);
                break;
            }
            case 3: {
                gl.glTexParameteri(target, 10241, 9729);
                break;
            }
            case 4: {
                gl.glTexParameteri(target, 10241, 9984);
                break;
            }
            case 1: 
            case 5: {
                gl.glTexParameteri(target, 10241, 9987);
                break;
            }
        }
        switch (magFilter) {
            case 0: 
            case 2: {
                gl.glTexParameteri(target, 10240, 9728);
                break;
            }
            case 1: 
            case 3: {
                gl.glTexParameteri(target, 10240, 9729);
                break;
            }
            default: {
                assert (false);
                return;
            }
        }
    }

    void updateTextureBoundary(Context ctx, int target, int boundaryModeS, int boundaryModeT, int boundaryModeR, float boundaryRed, float boundaryGreen, float boundaryBlue, float boundaryAlpha) {
        GL2ES2 gl = ((Jogl2es2Context)ctx).gl2es2();
        switch (boundaryModeS) {
            case 3: {
                gl.glTexParameteri(target, 10242, 10497);
                break;
            }
            case 2: {
                gl.glTexParameteri(target, 10242, 33071);
                break;
            }
            case 4: {
                gl.glTexParameteri(target, 10242, 33071);
                break;
            }
            case 5: {
                gl.glTexParameteri(target, 10242, 33071);
            }
        }
        switch (boundaryModeT) {
            case 3: {
                gl.glTexParameteri(target, 10243, 10497);
                break;
            }
            case 2: {
                gl.glTexParameteri(target, 10243, 33071);
                break;
            }
            case 4: {
                gl.glTexParameteri(target, 10243, 33071);
                break;
            }
            case 5: {
                gl.glTexParameteri(target, 10243, 33071);
            }
        }
    }

    @Override
    void setBlendColor(Context ctx, float red, float green, float blue, float alpha) {
        GL2ES2 gl = null;
        if (this.isExtensionAvailable.GL_ARB_imaging(gl)) {
            gl = gl == null ? ((Jogl2es2Context)ctx).gl2es2() : gl;
            gl.glBlendColor(red, green, blue, alpha);
        }
    }

    @Override
    void setBlendFunc(Context ctx, int srcBlendFunction, int dstBlendFunction) {
        GL2ES2 gl = null;
        Jogl2es2Context joglesctx = (Jogl2es2Context)ctx;
        if (!joglesctx.gl_state.glEnableGL_BLEND || joglesctx.gl_state.srcBlendFunction != srcBlendFunction || joglesctx.gl_state.dstBlendFunction != dstBlendFunction) {
            gl = gl == null ? ((Jogl2es2Context)ctx).gl2es2() : gl;
            gl.glEnable(3042);
            gl.glBlendFunc(blendFunctionTable[srcBlendFunction], blendFunctionTable[dstBlendFunction]);
            joglesctx.gl_state.glEnableGL_BLEND = true;
            joglesctx.gl_state.srcBlendFunction = srcBlendFunction;
            joglesctx.gl_state.dstBlendFunction = dstBlendFunction;
        }
    }

    @Override
    void setLightEnables(Context ctx, long enableMask, int maxLights) {
        Jogl2es2Context joglesctx = (Jogl2es2Context)ctx;
        joglesctx.maxLights = maxLights;
        joglesctx.numberOfLights = 0;
        for (int i = 0; i < maxLights; ++i) {
            boolean enable;
            boolean bl = enable = (enableMask & (long)(1 << i)) >> i != 0L;
            if (joglesctx.glLightSource[i] == null) {
                joglesctx.glLightSource[i] = new Jogl2es2Context.glLightSource();
            }
            joglesctx.glLightSource[i].enabled = enable ? 1 : 0;
            joglesctx.numberOfLights = joglesctx.numberOfLights + (enable ? 1 : 0);
            joglesctx.gl_state.glLightSource[i] = null;
        }
    }

    @Override
    void setSceneAmbient(Context ctx, float red, float green, float blue) {
        Jogl2es2Context joglesctx = (Jogl2es2Context)ctx;
        if (joglesctx.currentAmbientColor.x != red || joglesctx.currentAmbientColor.y != green || joglesctx.currentAmbientColor.z != blue) {
            joglesctx.gl_state.glLightModelambient.x = Float.NEGATIVE_INFINITY;
            joglesctx.currentAmbientColor.x = red;
            joglesctx.currentAmbientColor.y = green;
            joglesctx.currentAmbientColor.z = blue;
            joglesctx.currentAmbientColor.w = 1.0f;
        }
    }

    @Override
    void disableModelClip(Context ctx) {
    }

    @Override
    void activeTextureUnit(Context ctx, int texUnitIndex) {
        Jogl2es2Context joglesContext = (Jogl2es2Context)ctx;
        GL2ES2 gl = null;
        if (texUnitIndex >= 0 && joglesContext.gl_state.glActiveTexture != texUnitIndex + 33984) {
            gl = gl == null ? ((Jogl2es2Context)ctx).gl2es2() : gl;
            gl.glActiveTexture(texUnitIndex + 33984);
            joglesContext.gl_state.glActiveTexture = texUnitIndex + 33984;
        }
    }

    @Override
    void resetTextureNative(Context ctx, int texUnitIndex) {
        Jogl2es2Context joglesContext = (Jogl2es2Context)ctx;
        GL2ES2 gl = null;
        if (texUnitIndex >= 0 && joglesContext.gl_state.glActiveTexture != texUnitIndex + 33984) {
            gl = gl == null ? ((Jogl2es2Context)ctx).gl2es2() : gl;
            gl.glActiveTexture(texUnitIndex + 33984);
            joglesContext.gl_state.glActiveTexture = texUnitIndex + 33984;
        }
    }

    @Override
    void setModelViewMatrix(Context ctx, double[] viewMatrix, double[] modelMatrix) {
        Jogl2es2Context joglesctx = (Jogl2es2Context)ctx;
        joglesctx.currentViewMat.set(viewMatrix);
        joglesctx.currentModelMat.set(modelMatrix);
        joglesctx.gl_state.modelMatrix.m00 = Double.NEGATIVE_INFINITY;
        joglesctx.gl_state.glModelViewMatrix.m00 = Double.NEGATIVE_INFINITY;
        joglesctx.gl_state.glModelViewMatrixInverse.m00 = Double.NEGATIVE_INFINITY;
        joglesctx.gl_state.glModelViewProjectionMatrix.m00 = Double.NEGATIVE_INFINITY;
        joglesctx.gl_state.glNormalMatrix.m00 = Double.NEGATIVE_INFINITY;
        joglesctx.currentModelViewMat.m00 = Double.NEGATIVE_INFINITY;
        joglesctx.currentModelViewMatInverse.m00 = Double.NEGATIVE_INFINITY;
        joglesctx.currentModelViewProjMat.m00 = Double.NEGATIVE_INFINITY;
        joglesctx.currentNormalMat.m00 = Double.NEGATIVE_INFINITY;
    }

    @Override
    void setProjectionMatrix(Context ctx, double[] projMatrix) {
        Jogl2es2Context joglesctx = (Jogl2es2Context)ctx;
        projMatrix[8] = projMatrix[8] * -1.0;
        projMatrix[9] = projMatrix[9] * -1.0;
        projMatrix[10] = projMatrix[10] * -1.0;
        projMatrix[11] = projMatrix[11] * -1.0;
        joglesctx.currentProjMat.set(projMatrix);
        projMatrix[8] = projMatrix[8] * -1.0;
        projMatrix[9] = projMatrix[9] * -1.0;
        projMatrix[10] = projMatrix[10] * -1.0;
        projMatrix[11] = projMatrix[11] * -1.0;
    }

    @Override
    void setViewport(Context ctx, int x, int y, int width, int height) {
        GL2ES2 gl = ((Jogl2es2Context)ctx).gl2es2();
        gl.glViewport(x, y, width, height);
    }

    private static String lineString(double[] da) {
        String ret = "double[";
        for (double d : da) {
            ret = ret + " " + d;
        }
        return ret + "]";
    }

    private static String lineString(float[] fa) {
        String ret = "float[";
        for (float f : fa) {
            ret = ret + " " + f;
        }
        return ret + "]";
    }

    @Override
    void freeTexture(Context ctx, int id) {
        GL2ES2 gl = ((Jogl2es2Context)ctx).gl2es2();
        if (id > 0) {
            int[] tmp = new int[]{id};
            gl.glDeleteTextures(1, tmp, 0);
        } else {
            System.err.println("tried to delete tex with texid <= 0");
        }
    }

    @Override
    int generateTexID(Context ctx) {
        GL2ES2 gl = ((Jogl2es2Context)ctx).gl2es2();
        int[] tmp = new int[]{-1};
        gl.glGenTextures(1, tmp, 0);
        if (tmp[0] < 1) {
            return -1;
        }
        return tmp[0];
    }

    @Override
    void texturemapping(Context ctx, int px, int py, int minX, int minY, int maxX, int maxY, int texWidth, int texHeight, int rasWidth, int format, int objectId, byte[] imageYdown, int winWidth, int winHeight) {
        GL2ES2 gl = ((Jogl2es2Context)ctx).gl2es2();
        int glType = 6408;
        Jogl2es2Pipeline.disableAttribFor2D(gl);
        gl.glDepthMask(false);
        gl.glPixelStorei(3317, 1);
        gl.glBindTexture(3553, objectId);
        gl.glTexParameteri(3553, 10240, 9729);
        gl.glTexParameteri(3553, 10241, 9729);
        gl.glTexParameteri(3553, 10242, 10497);
        gl.glTexParameteri(3553, 10243, 10497);
        gl.glEnable(3042);
        gl.glBlendFunc(770, 771);
        if (this.isExtensionAvailable.GL_EXT_abgr(gl)) {
            glType = 32768;
        } else {
            switch (format) {
                case 8: {
                    glType = 6408;
                    break;
                }
                case 2: {
                    glType = 6407;
                }
            }
        }
        gl.glTexSubImage2D(3553, 0, minX, minY, maxX - minX, maxY - minY, glType, 5121, (Buffer)ByteBuffer.wrap(imageYdown));
        float texMinU = (float)minX / (float)texWidth;
        float texMinV = (float)minY / (float)texHeight;
        float texMaxU = (float)maxX / (float)texWidth;
        float texMaxV = (float)maxY / (float)texHeight;
        float halfWidth = (float)winWidth / 2.0f;
        float halfHeight = (float)winHeight / 2.0f;
        float mapMinX = ((float)(px + minX) - halfWidth) / halfWidth;
        float mapMinY = (halfHeight - (float)(py + maxY)) / halfHeight;
        float mapMaxX = ((float)(px + maxX) - halfWidth) / halfWidth;
        float mapMaxY = (halfHeight - (float)(py + minY)) / halfHeight;
        float mapZ = 0.0f;
        Jogl2es2Pipeline.renderTexturedQuad(ctx, texMinU, texMaxU, texMaxV, texMinV, mapMinX, mapMaxX, mapMinY, mapMaxY, mapZ);
        gl.glDepthMask(true);
        gl.glClear(256);
    }

    @Override
    boolean initTexturemapping(Context ctx, int texWidth, int texHeight, int objectId) {
        GL2ES2 gl = ((Jogl2es2Context)ctx).gl2es2();
        gl.glBindTexture(3553, objectId);
        int glType = 6408;
        glType = this.isExtensionAvailable.GL_EXT_abgr(gl) ? 32768 : 6408;
        gl.glTexImage2D(3553, 0, 6408, texWidth, texHeight, 0, glType, 5121, null);
        return true;
    }

    @Override
    void setDepthBufferWriteEnable(Context ctx, boolean mode) {
        GL2ES2 gl = ((Jogl2es2Context)ctx).gl2es2();
        if (mode) {
            gl.glDepthMask(true);
        } else {
            gl.glDepthMask(false);
        }
    }

    @Override
    void setRenderMode(Context ctx, int mode, boolean doubleBuffer) {
        GL2ES3 gl2es3 = ((Jogl2es2Context)ctx).gl2es3();
        if (gl2es3 != null) {
            gl2es3.glBindVertexArray(0);
        }
    }

    private static int getFunctionValue(int func) {
        switch (func) {
            case 0: {
                func = 519;
                break;
            }
            case 1: {
                func = 512;
                break;
            }
            case 2: {
                func = 514;
                break;
            }
            case 3: {
                func = 517;
                break;
            }
            case 4: {
                func = 513;
                break;
            }
            case 5: {
                func = 515;
                break;
            }
            case 6: {
                func = 516;
                break;
            }
            case 7: {
                func = 518;
            }
        }
        return func;
    }

    private static int getStencilOpValue(int op) {
        switch (op) {
            case 1: {
                op = 7680;
                break;
            }
            case 2: {
                op = 0;
                break;
            }
            case 3: {
                op = 7681;
                break;
            }
            case 4: {
                op = 7682;
                break;
            }
            case 5: {
                op = 7683;
                break;
            }
            case 6: {
                op = 5386;
            }
        }
        return op;
    }

    private static boolean getPropertiesFromCurrentContext(JoglContext ctx, GL2ES2 gl) {
        int[] tmp = new int[1];
        gl.glGetIntegerv(34930, tmp, 0);
        ctx.setMaxTexCoordSets(tmp[0]);
        if (VirtualUniverse.mc.transparentOffScreen) {
            ctx.setAlphaClearValue(0.0f);
        } else {
            ctx.setAlphaClearValue(1.0f);
        }
        return true;
    }

    private static int[] extractVersionInfo(String versionString) {
        if (versionString.startsWith("OpenGL ES ")) {
            versionString = versionString.substring("OpenGL ES ".length());
        }
        StringTokenizer tok = new StringTokenizer(versionString, ". ");
        int major = Integer.valueOf(tok.nextToken());
        int minor = Integer.valueOf(tok.nextToken());
        tok = new StringTokenizer(versionString, " ");
        if (tok.hasMoreTokens()) {
            Pattern p;
            Matcher m;
            tok.nextToken();
            if (tok.hasMoreTokens() && (m = (p = Pattern.compile("\\D*(\\d+)\\.(\\d+)\\.?(\\d*).*")).matcher(tok.nextToken())).matches()) {
                int altMajor = Integer.valueOf(m.group(1));
                int altMinor = Integer.valueOf(m.group(2));
                if (altMajor == major && altMinor > minor) {
                    minor = altMinor;
                }
            }
        }
        return new int[]{major, minor};
    }

    private static void checkTextureExtensions(Canvas3D cv, JoglContext ctx, GL2ES2 gl, boolean gl13) {
        Object[] tmp;
        if (gl13) {
            cv.textureExtendedFeatures |= 4;
            cv.multiTexAccelerated = true;
            tmp = new int[1];
            gl.glGetIntegerv(34930, tmp, 0);
            cv.maxTexCoordSets = cv.maxTextureUnits = tmp[0];
        }
        if (gl13) {
            cv.textureExtendedFeatures |= 0x80;
        }
        if (gl.isExtensionAvailable("GL_EXT_texture_filter_anisotropic")) {
            cv.textureExtendedFeatures |= 0x800;
            tmp = new float[1];
            gl.glGetFloatv(34047, (float[])tmp, 0);
            cv.anisotropicDegreeMax = tmp[0];
        }
        if (!VirtualUniverse.mc.enforcePowerOfTwo && (gl.isExtensionAvailable("GL_ARB_texture_non_power_of_two") || gl.isExtensionAvailable("GL_OES_texture_npot"))) {
            cv.textureExtendedFeatures |= 0x8000;
        }
        cv.textureExtendedFeatures |= 0x10000;
    }

    private static void checkGLSLShaderExtensions(Canvas3D cv, JoglContext ctx, GL2ES2 gl, boolean hasgl13) {
        int[] tmp = new int[1];
        gl.glGetIntegerv(34930, tmp, 0);
        cv.maxTextureImageUnits = tmp[0];
        gl.glGetIntegerv(35660, tmp, 0);
        cv.maxVertexTextureImageUnits = tmp[0];
        gl.glGetIntegerv(35661, tmp, 0);
        cv.maxCombinedTextureImageUnits = tmp[0];
        int vertexAttrOffset = VirtualUniverse.mc.glslVertexAttrOffset;
        ctx.setGLSLVertexAttrOffset(vertexAttrOffset);
        gl.glGetIntegerv(34921, tmp, 0);
        cv.maxVertexAttrs = tmp[0];
        cv.maxVertexAttrs -= vertexAttrOffset;
        if (cv.maxVertexAttrs < 0) {
            cv.maxVertexAttrs = 0;
        }
        gl.glGetIntegerv(36348, tmp, 0);
        cv.maxVaryingVectors = tmp[0];
        cv.shadingLanguageGLSL = true;
    }

    private static void setupCanvasProperties(Canvas3D cv, JoglContext ctx, GL2ES2 gl) {
        cv.multiTexAccelerated = false;
        cv.maxTextureUnits = 1;
        cv.maxTexCoordSets = 1;
        cv.maxTextureImageUnits = 0;
        cv.maxVertexTextureImageUnits = 0;
        cv.maxCombinedTextureImageUnits = 0;
        cv.maxVertexAttrs = 0;
        cv.maxVaryingVectors = 0;
        cv.extensionsSupported = 0;
        cv.textureExtendedFeatures = 0;
        cv.textureColorTableSize = 0;
        cv.anisotropicDegreeMax = 0.0f;
        cv.textureBoundaryWidthMax = 0;
        cv.textureWidthMax = 0;
        cv.textureHeightMax = 0;
        cv.texture3DWidthMax = 0;
        cv.texture3DHeightMax = 0;
        cv.texture3DDepthMax = 0;
        cv.shadingLanguageGLSL = false;
        String glVersion = gl.glGetString(7938);
        String glVendor = gl.glGetString(7936);
        String glRenderer = gl.glGetString(7937);
        cv.nativeGraphicsVersion = glVersion;
        cv.nativeGraphicsVendor = glVendor;
        cv.nativeGraphicsRenderer = glRenderer;
        int[] versionNumbers = Jogl2es2Pipeline.extractVersionInfo(glVersion);
        int major = versionNumbers[0];
        int minor = versionNumbers[1];
        if (major < 1 || major == 1 && minor < 2) {
            if (glVendor.equalsIgnoreCase("Microsoft Corporation") && glRenderer.equalsIgnoreCase("GDI Generic") && glVersion.equalsIgnoreCase("1.1.0")) {
                System.err.println("Java3D - GDI Generic Driver use detected.");
                System.err.println("This may be caused by any of the following issues.");
                if (System.getProperty("sun.java2d.noddraw", "false").equals("true") || System.getProperty("sun.java2d.d3d", "true").equals("false")) {
                    System.err.println("Issue: Use of System.setProperty(\"sun.java2d.noddraw\", \"true\");");
                    System.err.println("or System.setProperty(\"sun.java2d.d3d\", \"false\");");
                    System.err.println("If either of these are being used please try either reversing or removing them,");
                    System.err.println("or if they are required else where try adding System.setProperty(\"sun.awt.nopixfmt\", \"true\");");
                }
                if (Platform.getOSName().equalsIgnoreCase("Windows 10") && Platform.JAVA_VERSION_NUMBER.compareTo(new VersionNumber(1, 8, 0)) > 0 || Platform.JAVA_VERSION_NUMBER.compareTo(new VersionNumber(1, 8, 0)) == 0 && Platform.JAVA_VERSION_UPDATE > 51 && Platform.getJavaVMName().toLowerCase().startsWith("java hotspot(tm)")) {
                    System.err.println("Issue: The use of an Intel HD2000/3000 driver in combination with Windows 10 and");
                    System.err.println("a JRE greater than 1.8 update 51. Please downgrade the JRE in use to JRE 1.8u51 or lower.");
                    System.err.println("For more information please see https://jogamp.org/bugzilla/show_bug.cgi?id=1278.");
                }
                System.err.println("If this software has been supplied to you and you are unable to modify it's configuration");
                System.err.println("please contact the suppler of this software with this entire message.");
            }
            throw new IllegalRenderingStateException("Java 3D ERROR : OpenGL 1.2 or better is required (GL_VERSION=" + major + "." + minor + ")");
        }
        boolean gl20 = false;
        boolean gl14 = false;
        boolean gl13 = false;
        if (major == 1) {
            if (minor == 2) {
                System.err.println("JAVA 3D: OpenGL 1.2 detected; will run with reduced functionality");
            }
            if (minor >= 3) {
                gl13 = true;
            }
            if (minor >= 4) {
                gl14 = true;
            }
        } else {
            gl13 = true;
            gl14 = true;
            gl20 = true;
        }
        if (gl20) {
            assert (gl13);
            assert (gl14);
            assert (gl.isExtensionAvailable("GL_VERSION_2_0"));
        }
        if (gl14) {
            assert (gl13);
            assert (gl.isExtensionAvailable("GL_VERSION_1_4"));
        }
        if (gl13) assert (gl.isExtensionAvailable("GL_VERSION_1_3"));
        cv.textureExtendedFeatures |= 0x1000;
        if (gl.isExtensionAvailable("GL_EXT_abgr")) {
            cv.extensionsSupported |= 2;
        }
        cv.extensionsSupported |= 4;
        if (gl13) {
            cv.extensionsSupported |= 8;
            ctx.setHasMultisample(true);
        }
        if ((cv.extensionsSupported & 8) == 0 || !VirtualUniverse.mc.implicitAntialiasing) {
            // empty if block
        }
        Jogl2es2Pipeline.checkTextureExtensions(cv, ctx, gl, gl13);
        Jogl2es2Pipeline.checkGLSLShaderExtensions(cv, ctx, gl, gl13);
        cv.textureBoundaryWidthMax = 1;
        int[] tmp = new int[1];
        gl.glGetIntegerv(3379, tmp, 0);
        cv.textureWidthMax = tmp[0];
        cv.textureHeightMax = tmp[0];
    }

    private static void disableAttribFor2D(GL2ES2 gl) {
        gl.glDisable(3042);
        gl.glDisable(2884);
        gl.glDisable(2929);
        gl.glDisable(32823);
        gl.glDisable(2960);
    }

    private static void disableAttribForRaster(GL2ES2 gl) {
        gl.glDisable(2884);
        gl.glDisable(32823);
    }

    public static void copyTranspose(double[] src, double[] dst) {
        dst[0] = src[0];
        dst[1] = src[4];
        dst[2] = src[8];
        dst[3] = src[12];
        dst[4] = src[1];
        dst[5] = src[5];
        dst[6] = src[9];
        dst[7] = src[13];
        dst[8] = src[2];
        dst[9] = src[6];
        dst[10] = src[10];
        dst[11] = src[14];
        dst[12] = src[3];
        dst[13] = src[7];
        dst[14] = src[11];
        dst[15] = src[15];
    }

    @Override
    void clear(Context ctx, float r, float g, float b, boolean clearStencil) {
        Jogl2es2Context jctx = (Jogl2es2Context)ctx;
        GL2ES2 gl = jctx.gl2es2();
        int clearMask = 17664;
        gl.glDepthMask(true);
        gl.glClearColor(r, g, b, jctx.getAlphaClearValue());
        gl.glClear(clearMask);
    }

    private static int createSimpleTextureShaderProgram(Context ctx) {
        String vertexProgram = "#version 120\n";
        vertexProgram = vertexProgram + "attribute vec2 glMultiTexCoord0;\n";
        vertexProgram = vertexProgram + "attribute vec4 glVertex;\n";
        vertexProgram = vertexProgram + "varying vec2 glTexCoord0;\n";
        vertexProgram = vertexProgram + "void main( void ){\n";
        vertexProgram = vertexProgram + "gl_Position = glVertex;\n";
        vertexProgram = vertexProgram + "glTexCoord0 = glMultiTexCoord0.st;\n";
        vertexProgram = vertexProgram + "}";
        String fragmentProgram = "#version 120\n";
        fragmentProgram = fragmentProgram + "precision mediump float;\n";
        fragmentProgram = fragmentProgram + "varying vec2 glTexCoord0;\n";
        fragmentProgram = fragmentProgram + "uniform sampler2D BaseMap;\n";
        fragmentProgram = fragmentProgram + "void main( void ){\n ";
        fragmentProgram = fragmentProgram + "vec4 baseMap = texture2D( BaseMap, glTexCoord0.st );\n";
        fragmentProgram = fragmentProgram + "gl_FragColor = baseMap;\n";
        fragmentProgram = fragmentProgram + "}";
        int programId = Jogl2es2Pipeline.createShaderProgram(ctx, vertexProgram, fragmentProgram);
        Jogl2es2Context jctx = (Jogl2es2Context)ctx;
        GL2ES2 gl = jctx.gl2es2();
        jctx.simpleTextureShaderProgramVertLoc = gl.glGetAttribLocation(programId, "glVertex");
        jctx.simpleTextureShaderProgramTexCoordLoc = gl.glGetAttribLocation(programId, "glMultiTexCoord0");
        jctx.simpleTextureShaderProgramBaseMapLoc = gl.glGetUniformLocation(programId, "BaseMap");
        return programId;
    }

    private static int createShaderProgram(Context ctx, String vertexProgram, String fragmentProgram) {
        String detailMsg;
        Jogl2es2Context jctx = (Jogl2es2Context)ctx;
        GL2ES2 gl = jctx.gl2es2();
        int shaderHandleV = gl.glCreateShader(35633);
        int shaderHandleF = gl.glCreateShader(35632);
        int shaderProgramHandle = gl.glCreateProgram();
        gl.glAttachShader(shaderProgramHandle, shaderHandleV);
        gl.glAttachShader(shaderProgramHandle, shaderHandleF);
        gl.glShaderSource(shaderHandleV, 1, new String[]{vertexProgram}, null, 0);
        gl.glCompileShader(shaderHandleV);
        int[] status = new int[1];
        gl.glGetShaderiv(shaderHandleV, 35713, status, 0);
        if (status[0] == 0) {
            detailMsg = Jogl2es2Pipeline.getShaderInfoLog(gl, shaderHandleV);
            System.err.println(detailMsg);
        }
        gl.glShaderSource(shaderHandleF, 1, new String[]{fragmentProgram}, null, 0);
        gl.glCompileShader(shaderHandleF);
        gl.glGetShaderiv(shaderHandleF, 35713, status, 0);
        if (status[0] == 0) {
            detailMsg = Jogl2es2Pipeline.getShaderInfoLog(gl, shaderHandleF);
            System.err.println(detailMsg);
        }
        gl.glLinkProgram(shaderProgramHandle);
        gl.glGetProgramiv(shaderProgramHandle, 35714, status, 0);
        if (status[0] == 0) {
            detailMsg = Jogl2es2Pipeline.getProgramInfoLog(gl, shaderProgramHandle);
            System.err.println(detailMsg);
        }
        return shaderProgramHandle;
    }

    private static void renderTexturedQuad(Context ctx, float texMinU, float texMaxU, float texMinV, float texMaxV, float mapMinX, float mapMaxX, float mapMinY, float mapMaxY, float mapZ) {
        Jogl2es2Context jctx = (Jogl2es2Context)ctx;
        GL2ES2 gl = jctx.gl2es2();
        int vcount = 6;
        FloatBuffer verts = ByteBuffer.allocateDirect(12 * vcount).order(ByteOrder.nativeOrder()).asFloatBuffer();
        FloatBuffer tcs = ByteBuffer.allocateDirect(8 * vcount).order(ByteOrder.nativeOrder()).asFloatBuffer();
        tcs.put(texMinU).put(texMinV);
        verts.put(mapMinX).put(mapMinY).put(mapZ);
        tcs.put(texMaxU).put(texMaxV);
        verts.put(mapMaxX).put(mapMaxY).put(mapZ);
        tcs.put(texMinU).put(texMaxV);
        verts.put(mapMinX).put(mapMaxY).put(mapZ);
        tcs.put(texMinU).put(texMinV);
        verts.put(mapMinX).put(mapMinY).put(mapZ);
        tcs.put(texMaxU).put(texMinV);
        verts.put(mapMaxX).put(mapMinY).put(mapZ);
        tcs.put(texMaxU).put(texMaxV);
        verts.put(mapMaxX).put(mapMaxY).put(mapZ);
        verts.position(0);
        tcs.position(0);
        int[] tmp = new int[2];
        gl.glGenBuffers(2, tmp, 0);
        int vertBufId = tmp[0];
        int tcBufId = tmp[1];
        gl.glBindBuffer(34962, vertBufId);
        gl.glBufferData(34962, (long)(verts.remaining() * 32 / 8), (Buffer)verts, 35040);
        gl.glBindBuffer(34962, tcBufId);
        gl.glBufferData(34962, (long)(tcs.remaining() * 32 / 8), (Buffer)tcs, 35040);
        if (jctx.simpleTextureShaderProgramId == -1) {
            jctx.simpleTextureShaderProgramId = Jogl2es2Pipeline.createSimpleTextureShaderProgram(ctx);
        }
        gl.glUseProgram(jctx.simpleTextureShaderProgramId);
        jctx.prevShaderProgram = jctx.simpleTextureShaderProgramId;
        boolean bindingRequired = true;
        int vaoId = -1;
        if (gl.isGL2ES3()) {
            GL2ES3 gl2es3 = (GL2ES3)gl;
            if (vaoId == -1) {
                int[] tmp2 = new int[1];
                gl2es3.glGenVertexArrays(1, tmp2, 0);
                vaoId = tmp2[0];
            } else {
                bindingRequired = false;
            }
            gl2es3.glBindVertexArray(vaoId);
        }
        if (bindingRequired) {
            if (jctx.simpleTextureShaderProgramVertLoc != -1) {
                gl.glBindBuffer(34962, vertBufId);
                gl.glVertexAttribPointer(jctx.simpleTextureShaderProgramVertLoc, 3, 5126, false, 0, 0L);
                gl.glEnableVertexAttribArray(jctx.simpleTextureShaderProgramVertLoc);
            }
            if (jctx.simpleTextureShaderProgramTexCoordLoc != -1) {
                gl.glBindBuffer(34962, tcBufId);
                gl.glVertexAttribPointer(jctx.simpleTextureShaderProgramTexCoordLoc, 2, 5126, false, 0, 0L);
                gl.glEnableVertexAttribArray(jctx.simpleTextureShaderProgramTexCoordLoc);
            }
        }
        if (jctx.simpleTextureShaderProgramBaseMapLoc != -1) {
            gl.glUniform1i(jctx.simpleTextureShaderProgramBaseMapLoc, 0);
        }
        gl.glDrawArrays(4, 0, vcount);
        if (vaoId != -1) {
            ((GL2ES3)gl).glDeleteVertexArrays(1, new int[]{vaoId}, 0);
        }
        if (vertBufId != -1) {
            gl.glDeleteBuffers(1, new int[]{vertBufId}, 0);
        }
        if (tcBufId != -1) {
            gl.glDeleteBuffers(1, new int[]{tcBufId}, 0);
        }
    }

    @Override
    void textureFillBackground(Context ctx, float texMinU, float texMaxU, float texMinV, float texMaxV, float mapMinX, float mapMaxX, float mapMinY, float mapMaxY, boolean useBilinearFilter) {
        Jogl2es2Context jctx = (Jogl2es2Context)ctx;
        GL2ES2 gl = jctx.gl2es2();
        Jogl2es2Pipeline.disableAttribFor2D(gl);
        if (useBilinearFilter) {
            gl.glTexParameteri(3553, 10241, 9729);
            gl.glTexParameteri(3553, 10240, 9729);
        }
        gl.glPixelStorei(3317, 1);
        float mapZ = 0.0f;
        Jogl2es2Pipeline.renderTexturedQuad(ctx, texMinU, texMaxU, texMaxV, texMinV, mapMinX, mapMaxX, mapMinY, mapMaxY, mapZ);
    }

    @Override
    void textureFillRaster(Context ctx, float texMinU, float texMaxU, float texMinV, float texMaxV, float mapMinX, float mapMaxX, float mapMinY, float mapMaxY, float mapZ, float alpha, boolean useBilinearFilter) {
        Jogl2es2Context jctx = (Jogl2es2Context)ctx;
        GL2ES2 gl = jctx.gl2es2();
        Jogl2es2Pipeline.disableAttribForRaster(gl);
        if (useBilinearFilter) {
            gl.glTexParameteri(3553, 10241, 9729);
            gl.glTexParameteri(3553, 10240, 9729);
        }
        gl.glPixelStorei(3317, 1);
        Jogl2es2Pipeline.renderTexturedQuad(ctx, texMinU, texMaxU, texMaxV, texMinV, mapMinX, mapMaxX, mapMinY, mapMaxY, mapZ);
    }

    @Override
    void executeRasterDepth(Context ctx, float posX, float posY, float posZ, int srcOffsetX, int srcOffsetY, int rasterWidth, int rasterHeight, int depthWidth, int depthHeight, int depthFormat, Object depthData) {
        throw new UnsupportedOperationException("To get depth you should use a shader that return depth info for gl2es2 then read from color");
    }

    @Override
    void syncRender(Context ctx, boolean wait) {
        Jogl2es2Pipeline.doClearBuffers(ctx);
        GL2ES2 gl = ((Jogl2es2Context)ctx).gl2es2();
        if (wait) {
            gl.glFinish();
        } else {
            gl.glFlush();
        }
    }

    @Override
    void swapBuffers(Canvas3D cv, Context ctx, Drawable drawable) {
        GLDrawable draw = Jogl2es2Pipeline.drawable(drawable);
        draw.swapBuffers();
        ((Jogl2es2Context)ctx).gl_state.clear();
    }

    private static void outputErrors(Context ctx) {
    }

    @Override
    boolean useCtx(Context ctx, Drawable drawable) {
        GLContext context = Jogl2es2Pipeline.context(ctx);
        if (context.getGLDrawable() == null) {
            System.out.println("context.getGLDrawable() == null!");
        }
        currently_current = true;
        int res = context.makeCurrent();
        return res != 0;
    }

    @Override
    boolean releaseCtx(Context ctx) {
        GLContext context = Jogl2es2Pipeline.context(ctx);
        if (context.isCurrent()) {
            context.release();
        }
        return true;
    }

    @Override
    int getMaximumLights() {
        return 8;
    }

    @Override
    void readOffScreenBuffer(Canvas3D cv, Context ctx, int format, int dataType, Object data, int width, int height) {
        GLDrawable glDrawable = ((JoglDrawable)cv.drawable).getGLDrawable();
        GLCapabilitiesImmutable chosenCaps = glDrawable.getChosenGLCapabilities();
        GLFBODrawable fboDrawable = null;
        GL2ES2 gl = Jogl2es2Pipeline.context(ctx).getGL().getGL2ES2();
        if (chosenCaps.isFBO()) {
            fboDrawable = (GLFBODrawable)glDrawable;
            if (chosenCaps.getDoubleBuffered()) {
                fboDrawable.swapBuffers();
                gl.glBindTexture(3553, 0);
            }
            fboDrawable.getFBObject(1028).bind((GL)gl);
        }
        gl.glPixelStorei(3333, 1);
        int type = 0;
        if (dataType == 4096 || dataType == 16384) {
            switch (format) {
                case 1: {
                    type = 32992;
                    break;
                }
                case 2: {
                    type = 6407;
                    break;
                }
                case 4: {
                    if (this.isExtensionAvailable.GL_EXT_abgr(gl)) {
                        type = 32768;
                        break;
                    }
                    assert (false);
                    return;
                }
                case 8: {
                    type = 6408;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("illegal format " + format));
                }
            }
            ByteBuffer buf = null;
            buf = dataType == 4096 ? ByteBuffer.wrap((byte[])data) : (ByteBuffer)data;
            gl.glReadPixels(0, 0, width, height, type, 5121, (Buffer)buf);
        } else if (dataType == 8192 || dataType == 32768) {
            switch (format) {
                case 128: {
                    type = 32992;
                    break;
                }
                case 256: {
                    type = 6407;
                    break;
                }
                case 512: {
                    type = 6408;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("illegal format " + format));
                }
            }
            IntBuffer buf = null;
            buf = dataType == 8192 ? IntBuffer.wrap((int[])data) : (IntBuffer)data;
            gl.glReadPixels(0, 0, width, height, type, 5121, (Buffer)buf);
        } else {
            throw new AssertionError((Object)("illegal image data type " + dataType + " Try creating a BufferedImage of type TYPE_3BYTE_BGR"));
        }
        if (chosenCaps.isFBO()) {
            fboDrawable.getFBObject(1029).bind((GL)gl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Context createNewContext(Canvas3D cv, Drawable drawable, Context shareCtx, boolean isSharedCtx, boolean offScreen) {
        GLDrawable glDrawable = null;
        GLContext glContext = null;
        if (offScreen) {
            glDrawable = Jogl2es2Pipeline.drawable(cv.drawable);
            glContext = glDrawable.createContext(Jogl2es2Pipeline.context(shareCtx));
        } else {
            GraphicsConfigInfo gcInf0 = Canvas3D.graphicsConfigTable.get(cv.graphicsConfiguration);
            AWTGraphicsConfiguration awtConfig = (AWTGraphicsConfiguration)gcInf0.getPrivateData();
            JAWTWindow nativeWindow = (JAWTWindow)NativeWindowFactory.getNativeWindow((Object)cv, (AbstractGraphicsConfiguration)awtConfig);
            nativeWindow.lockSurface();
            try {
                glDrawable = GLDrawableFactory.getFactory((GLProfile)this.profile).createGLDrawable((NativeSurface)nativeWindow);
                glContext = glDrawable.createContext(Jogl2es2Pipeline.context(shareCtx));
            }
            finally {
                nativeWindow.unlockSurface();
            }
            cv.drawable = new JoglDrawable(glDrawable, (NativeWindow)nativeWindow);
        }
        if (!glDrawable.isRealized()) {
            glDrawable.setRealized(true);
        }
        boolean failed = false;
        int failCount = 0;
        int MAX_FAIL_COUNT = 5;
        do {
            failed = false;
            int res = glContext.makeCurrent();
            if (res != 0) continue;
            failed = true;
            ++failCount;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        } while (failed && failCount < MAX_FAIL_COUNT);
        if (failCount == MAX_FAIL_COUNT) {
            throw new IllegalRenderingStateException("Unable to make new context current after " + failCount + "tries");
        }
        GL2ES2 gl = glContext.getGL().getGL2ES2();
        Jogl2es2Context ctx = new Jogl2es2Context(glContext);
        try {
            if (!Jogl2es2Pipeline.getPropertiesFromCurrentContext(ctx, gl)) {
                throw new IllegalRenderingStateException("Unable to fetch properties from current OpenGL context");
            }
            if (!isSharedCtx) {
                Jogl2es2Pipeline.setupCanvasProperties(cv, ctx, gl);
            }
            gl.glDepthFunc(515);
            gl.glPixelStorei(3317, 1);
            if (!offScreen && glDrawable instanceof GLFBODrawable) {
                GLFBODrawable fboDrawable = (GLFBODrawable)glDrawable;
                fboDrawable.getFBObject(1029).bind((GL)gl);
            }
            if (offScreen) {
                GLCapabilitiesImmutable chosenCaps = glDrawable.getChosenGLCapabilities();
                if (glDrawable instanceof GLFBODrawable) {
                    GLFBODrawable fboDrawable = (GLFBODrawable)glDrawable;
                    fboDrawable.getFBObject(1029).bind((GL)gl);
                }
            }
        }
        finally {
            glContext.release();
        }
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void createQueryContext(Canvas3D cv, Drawable drawable, boolean offScreen, int width, int height) {
        if (offScreen) {
            Drawable offDrawable = this.createOffScreenBuffer(cv, null, width, height);
            GLDrawable glDrawable = Jogl2es2Pipeline.drawable(offDrawable);
            glDrawable.setRealized(true);
            GLContext glContext = glDrawable.createContext(null);
            glContext.makeCurrent();
            Jogl2es2Context ctx = new Jogl2es2Context(glContext);
            GL2ES2 gl = glContext.getGL().getGL2ES2();
            Jogl2es2Pipeline.getPropertiesFromCurrentContext(ctx, gl);
            Jogl2es2Pipeline.setupCanvasProperties(cv, ctx, gl);
            glContext.release();
            glContext.destroy();
            glDrawable.setRealized(false);
        } else {
            Frame f = new Frame();
            Dialog d = new Dialog(f);
            d.setUndecorated(true);
            d.setLayout(new BorderLayout());
            ContextQuerier querier = new ContextQuerier(cv);
            AWTGraphicsConfiguration awtConfig = (AWTGraphicsConfiguration)Canvas3D.graphicsConfigTable.get(cv.graphicsConfiguration).getPrivateData();
            QueryCanvas canvas = new QueryCanvas(awtConfig, querier);
            d.add((Component)canvas, "Center");
            d.setSize(1, 1);
            d.setVisible(true);
            canvas.doQuery();
            if (!EventQueue.isDispatchThread()) {
                ContextQuerier contextQuerier = querier;
                synchronized (contextQuerier) {
                    if (!querier.done()) {
                        try {
                            querier.wait(1000L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                }
            }
            Jogl2es2Pipeline.disposeOnEDT(d);
            Jogl2es2Pipeline.disposeOnEDT(f);
        }
    }

    static boolean isOffscreenLayerSurfaceEnabled(Canvas3D cv) {
        if (cv.drawable == null || cv.offScreen) {
            return false;
        }
        JoglDrawable joglDrawble = (JoglDrawable)cv.drawable;
        if (joglDrawble.getNativeWindow() instanceof OffscreenLayerOption) {
            OffscreenLayerOption olo = (OffscreenLayerOption)joglDrawble.getNativeWindow();
            if (olo == null) {
                return false;
            }
            return olo.isOffscreenLayerSurfaceEnabled();
        }
        return false;
    }

    static boolean hasFBObjectSizeChanged(JoglDrawable jdraw, int width, int height) {
        if (!(jdraw.getGLDrawable() instanceof GLFBODrawable)) {
            return false;
        }
        FBObject fboBack = ((GLFBODrawable)jdraw.getGLDrawable()).getFBObject(1029);
        if (fboBack == null) {
            return false;
        }
        return width != fboBack.getWidth() || height != fboBack.getHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void resizeOffscreenLayer(Canvas3D cv, int cvWidth, int cvHeight) {
        block14: {
            if (!Jogl2es2Pipeline.isOffscreenLayerSurfaceEnabled(cv)) {
                return;
            }
            JoglDrawable joglDrawable = (JoglDrawable)cv.drawable;
            if (!Jogl2es2Pipeline.hasFBObjectSizeChanged(joglDrawable, cvWidth, cvHeight)) {
                return;
            }
            int newWidth = Math.max(1, cvWidth);
            int newHeight = Math.max(1, cvHeight);
            GLDrawable glDrawble = joglDrawable.getGLDrawable();
            GLContext glContext = Jogl2es2Pipeline.context(cv.ctx);
            NativeSurface surface = glDrawble.getNativeSurface();
            ProxySurface proxySurface = surface instanceof ProxySurface ? (ProxySurface)surface : null;
            int lockRes = surface.lockSurface();
            try {
                UpstreamSurfaceHook ush;
                if (proxySurface != null && (ush = proxySurface.getUpstreamSurfaceHook()) instanceof UpstreamSurfaceHook.MutableSize) {
                    ((UpstreamSurfaceHook.MutableSize)ush).setSurfaceSize(newWidth, newHeight);
                }
                GL2ES2 gl = glContext.getGL().getGL2ES2();
                if (glDrawble instanceof GLFBODrawable) {
                    int numSamples = ((GLFBODrawable)glDrawble).getChosenGLCapabilities().getNumSamples();
                    FBObject fboObjectBack = ((GLFBODrawable)glDrawble).getFBObject(1029);
                    fboObjectBack.reset((GL)gl, newWidth, newHeight, numSamples);
                    fboObjectBack.bind((GL)gl);
                    break block14;
                }
                GLContext currentContext = GLContext.getCurrent();
                GLDrawableFactory factory = glDrawble.getFactory();
                if (currentContext != glContext) {
                    glContext.makeCurrent();
                }
                gl.glFinish();
                glContext.release();
                if (proxySurface != null) {
                    proxySurface.enableUpstreamSurfaceHookLifecycle(false);
                }
                try {
                    glDrawble.setRealized(false);
                    glDrawble = factory.createGLDrawable(surface);
                    glDrawble.setRealized(true);
                    joglDrawable.setGLDrawable(glDrawble);
                }
                finally {
                    if (proxySurface != null) {
                        proxySurface.enableUpstreamSurfaceHookLifecycle(true);
                    }
                }
                glContext.setGLDrawable(glDrawble, true);
                if (currentContext != null) {
                    currentContext.makeCurrent();
                }
            }
            finally {
                surface.unlockSurface();
            }
        }
    }

    @Override
    Drawable createOffScreenBuffer(Canvas3D cv, Context ctx, int width, int height) {
        JoglGraphicsConfiguration jgc = (JoglGraphicsConfiguration)cv.graphicsConfiguration;
        GraphicsConfigInfo gcInf0 = Canvas3D.graphicsConfigTable.get(jgc);
        AWTGraphicsConfiguration awtConfig = (AWTGraphicsConfiguration)gcInf0.getPrivateData();
        AbstractGraphicsDevice device = GLDrawableFactory.getDesktopFactory().getDefaultDevice();
        GLCapabilities canvasCaps = (GLCapabilities)awtConfig.getChosenCapabilities();
        GraphicsConfigTemplate3D gct3D = gcInf0.getGraphicsConfigTemplate3D();
        GLCapabilities offCaps = new GLCapabilities(this.profile);
        offCaps.copyFrom((GLCapabilitiesImmutable)canvasCaps);
        if (!offCaps.getSampleBuffers()) {
            offCaps.setDoubleBuffered(false);
            offCaps.setNumSamples(0);
        }
        offCaps.setStereo(false);
        offCaps.setFBO(true);
        GLDrawable offDrawable = GLDrawableFactory.getFactory((GLProfile)this.profile).createOffscreenDrawable(device, (GLCapabilitiesImmutable)offCaps, null, width, height);
        return new JoglDrawable(offDrawable, null);
    }

    @Override
    void destroyOffScreenBuffer(Canvas3D cv, Context ctx, Drawable drawable) {
    }

    @Override
    void setFullSceneAntialiasing(Context ctx, boolean enable) {
        JoglContext joglctx = (JoglContext)ctx;
        GL2ES2 gl = ((Jogl2es2Context)ctx).gl2es2();
        if (joglctx.getHasMultisample() && !VirtualUniverse.mc.implicitAntialiasing) {
            if (enable) {
                System.out.println("I just set MULTISAMPLE just then");
                gl.glEnable(32925);
            } else {
                gl.glDisable(32925);
            }
        }
    }

    @Override
    void updateSeparateSpecularColorEnable(Context ctx, boolean enable) {
    }

    @Override
    void destroyContext(Drawable drawable, Context ctx) {
        JoglDrawable joglDrawable = (JoglDrawable)drawable;
        GLContext context = Jogl2es2Pipeline.context(ctx);
        if (joglDrawable != null) {
            if (GLContext.getCurrent() == context) {
                context.release();
            }
            context.destroy();
            joglDrawable.getGLDrawable().setRealized(false);
            joglDrawable.destroyNativeWindow();
        }
    }

    @Override
    int getNumCtxLights(Context ctx) {
        return 8;
    }

    @Override
    boolean validGraphicsMode() {
        return true;
    }

    @Override
    void ctxUpdateEyeLightingEnable(Context ctx, boolean localEyeLightingEnable) {
    }

    @Override
    DrawingSurfaceObject createDrawingSurfaceObject(Canvas3D cv) {
        return new JoglDrawingSurfaceObject(cv);
    }

    @Override
    void freeDrawingSurface(Canvas3D cv, DrawingSurfaceObject drawingSurfaceObject) {
    }

    @Override
    void freeDrawingSurfaceNative(Object o) {
    }

    private static GLContext context(Context ctx) {
        if (ctx == null) {
            return null;
        }
        return ((JoglContext)ctx).getGLContext();
    }

    private static GLDrawable drawable(Drawable drawable) {
        if (drawable == null) {
            return null;
        }
        return ((JoglDrawable)drawable).getGLDrawable();
    }

    private static ShortBuffer getIndexArrayBuffer(int[] indexArray) {
        return Jogl2es2Pipeline.getIndexArrayBuffer(indexArray, true);
    }

    private static ShortBuffer getIndexArrayBuffer(int[] indexArray, boolean copyData) {
        return Jogl2es2Pipeline.getNIOBuffer(indexArray, nioIndexTemp, copyData);
    }

    private static FloatBuffer getVertexArrayBuffer(float[] vertexArray) {
        return Jogl2es2Pipeline.getVertexArrayBuffer(vertexArray, true);
    }

    private static FloatBuffer getVertexArrayBuffer(float[] vertexArray, boolean copyData) {
        return Jogl2es2Pipeline.getNIOBuffer(vertexArray, nioVertexTemp, copyData);
    }

    private static DoubleBuffer getVertexArrayBuffer(double[] vertexArray) {
        return Jogl2es2Pipeline.getVertexArrayBuffer(vertexArray, true);
    }

    private static DoubleBuffer getVertexArrayBuffer(double[] vertexArray, boolean copyData) {
        return Jogl2es2Pipeline.getNIOBuffer(vertexArray, nioVertexDoubleTemp, true);
    }

    private static FloatBuffer getColorArrayBuffer(float[] colorArray) {
        return Jogl2es2Pipeline.getColorArrayBuffer(colorArray, true);
    }

    private static FloatBuffer getColorArrayBuffer(float[] colorArray, boolean copyData) {
        return Jogl2es2Pipeline.getNIOBuffer(colorArray, nioColorTemp, true);
    }

    private static ByteBuffer getColorArrayBuffer(byte[] colorArray) {
        return Jogl2es2Pipeline.getColorArrayBuffer(colorArray, true);
    }

    private static ByteBuffer getColorArrayBuffer(byte[] colorArray, boolean copyData) {
        return Jogl2es2Pipeline.getNIOBuffer(colorArray, nioColorByteTemp, true);
    }

    private static FloatBuffer getNormalArrayBuffer(float[] normalArray) {
        return Jogl2es2Pipeline.getNormalArrayBuffer(normalArray, true);
    }

    private static FloatBuffer getNormalArrayBuffer(float[] normalArray, boolean copyData) {
        return Jogl2es2Pipeline.getNIOBuffer(normalArray, nioNormalTemp, true);
    }

    private static FloatBuffer[] getTexCoordSetBuffer(Object[] texCoordSet) {
        return Jogl2es2Pipeline.getNIOBuffer(texCoordSet, nioTexCoordSetTemp);
    }

    private static FloatBuffer[] getVertexAttrSetBuffer(Object[] vertexAttrSet) {
        return Jogl2es2Pipeline.getNIOBuffer(vertexAttrSet, nioVertexAttrSetTemp);
    }

    private static ShortBuffer getNIOBuffer(int[] array, ThreadLocal<ShortBuffer> threadLocal, boolean copyData) {
        if (array == null) {
            return null;
        }
        ShortBuffer buf = threadLocal.get();
        if (buf == null) {
            buf = Buffers.newDirectShortBuffer((int)array.length);
            threadLocal.set(buf);
        } else {
            buf.rewind();
            if (buf.remaining() < array.length) {
                int newSize = Math.max(2 * buf.remaining(), array.length);
                buf = Buffers.newDirectShortBuffer((int)newSize);
                threadLocal.set(buf);
            }
        }
        if (copyData) {
            short[] shorts = new short[array.length];
            for (int i = 0; i < array.length; ++i) {
                shorts[i] = (short)array[i];
            }
            buf.put(shorts);
            buf.rewind();
            buf.limit(array.length);
        }
        return buf;
    }

    private static FloatBuffer getNIOBuffer(float[] array, ThreadLocal<FloatBuffer> threadLocal, boolean copyData) {
        if (array == null) {
            return null;
        }
        FloatBuffer buf = threadLocal.get();
        if (buf == null) {
            buf = Buffers.newDirectFloatBuffer((int)array.length);
            threadLocal.set(buf);
        } else {
            buf.rewind();
            if (buf.remaining() < array.length) {
                int newSize = Math.max(2 * buf.remaining(), array.length);
                buf = Buffers.newDirectFloatBuffer((int)newSize);
                threadLocal.set(buf);
            }
        }
        if (copyData) {
            buf.put(array);
            buf.rewind();
            buf.limit(array.length);
        }
        return buf;
    }

    private static DoubleBuffer getNIOBuffer(double[] array, ThreadLocal<DoubleBuffer> threadLocal, boolean copyData) {
        if (array == null) {
            return null;
        }
        DoubleBuffer buf = threadLocal.get();
        if (buf == null) {
            buf = Buffers.newDirectDoubleBuffer((int)array.length);
            threadLocal.set(buf);
        } else {
            buf.rewind();
            if (buf.remaining() < array.length) {
                int newSize = Math.max(2 * buf.remaining(), array.length);
                buf = Buffers.newDirectDoubleBuffer((int)newSize);
                threadLocal.set(buf);
            }
        }
        if (copyData) {
            buf.put(array);
            buf.rewind();
            buf.limit(array.length);
        }
        return buf;
    }

    private static ByteBuffer getNIOBuffer(byte[] array, ThreadLocal<ByteBuffer> threadLocal, boolean copyData) {
        if (array == null) {
            return null;
        }
        ByteBuffer buf = threadLocal.get();
        if (buf == null) {
            buf = Buffers.newDirectByteBuffer((int)array.length);
            threadLocal.set(buf);
        } else {
            buf.rewind();
            if (buf.remaining() < array.length) {
                int newSize = Math.max(2 * buf.remaining(), array.length);
                buf = Buffers.newDirectByteBuffer((int)newSize);
                threadLocal.set(buf);
            }
        }
        if (copyData) {
            buf.put(array);
            buf.rewind();
            buf.limit(array.length);
        }
        return buf;
    }

    private static FloatBuffer[] getNIOBuffer(Object[] array, ThreadLocal<FloatBuffer[]> threadLocal) {
        if (array == null) {
            return null;
        }
        FloatBuffer[] bufs = threadLocal.get();
        if (bufs == null) {
            bufs = new FloatBuffer[array.length];
            threadLocal.set(bufs);
        } else if (bufs.length < array.length) {
            FloatBuffer[] newBufs = new FloatBuffer[array.length];
            System.arraycopy(bufs, 0, newBufs, 0, bufs.length);
            bufs = newBufs;
            threadLocal.set(bufs);
        }
        for (int i = 0; i < array.length; ++i) {
            float[] cur = (float[])array[i];
            FloatBuffer buf = bufs[i];
            if (buf == null) {
                bufs[i] = buf = Buffers.newDirectFloatBuffer((int)cur.length);
            } else {
                buf.rewind();
                if (buf.remaining() < cur.length) {
                    int newSize = Math.max(2 * buf.remaining(), cur.length);
                    bufs[i] = buf = Buffers.newDirectFloatBuffer((int)newSize);
                }
            }
            buf.put(cur);
            buf.rewind();
            buf.limit(cur.length);
        }
        return bufs;
    }

    @Override
    boolean hasDoubleBuffer(Canvas3D cv) {
        return Jogl2es2Pipeline.caps(cv).getDoubleBuffered();
    }

    @Override
    boolean hasStereo(Canvas3D cv) {
        return Jogl2es2Pipeline.caps(cv).getStereo();
    }

    @Override
    int getStencilSize(Canvas3D cv) {
        return Jogl2es2Pipeline.caps(cv).getStencilBits();
    }

    @Override
    boolean hasSceneAntialiasingMultisample(Canvas3D cv) {
        return Jogl2es2Pipeline.caps(cv).getSampleBuffers();
    }

    @Override
    boolean hasSceneAntialiasingAccum(Canvas3D cv) {
        return false;
    }

    private static GLCapabilities caps(Canvas3D ctx) {
        if (ctx.drawable != null) {
            return (GLCapabilities)Jogl2es2Pipeline.drawable(ctx.drawable).getChosenGLCapabilities();
        }
        return ((JoglGraphicsConfiguration)ctx.graphicsConfiguration).getGLCapabilities();
    }

    @Override
    boolean isGraphicsConfigSupported(GraphicsConfigTemplate3D gct, GraphicsConfiguration gc) {
        return true;
    }

    @Override
    GraphicsConfiguration getGraphicsConfig(GraphicsConfiguration gconfig) {
        GraphicsConfigInfo gcInf0 = Canvas3D.graphicsConfigTable.get(gconfig);
        AWTGraphicsConfiguration awtConfig = (AWTGraphicsConfiguration)gcInf0.getPrivateData();
        return awtConfig.getAWTGraphicsConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    GraphicsConfiguration getBestConfiguration(GraphicsConfigTemplate3D gct, GraphicsConfiguration[] gc) {
        GraphicsDevice device;
        GLCapabilities caps = new GLCapabilities(this.profile);
        caps.setDoubleBuffered(gct.getDoubleBuffer() != 3);
        caps.setStereo(gct.getStereo() != 3);
        if (gct.getSceneAntialiasing() != 3 && gct.getDoubleBuffer() != 3) {
            caps.setSampleBuffers(true);
            int numSamples = MasterControl.getIntegerProperty("j3d.numSamples", 2);
            caps.setNumSamples(numSamples);
        } else {
            caps.setSampleBuffers(false);
            caps.setNumSamples(0);
        }
        caps.setDepthBits(gct.getDepthSize());
        caps.setStencilBits(gct.getStencilSize());
        caps.setRedBits(Math.max(5, gct.getRedSize()));
        caps.setGreenBits(Math.max(5, gct.getGreenSize()));
        caps.setBlueBits(Math.max(5, gct.getBlueSize()));
        if (VirtualUniverse.mc.transparentOffScreen) {
            caps.setAlphaBits(1);
        }
        ArrayList<DisabledCaps> capsToDisable = new ArrayList<DisabledCaps>();
        if (gct.getStereo() == 2) {
            capsToDisable.add(DisabledCaps.STEREO);
        }
        if (gct.getSceneAntialiasing() == 2) {
            capsToDisable.add(DisabledCaps.AA);
        }
        if (gct.getSceneAntialiasing() != 1 && gct.getDoubleBuffer() == 2) {
            capsToDisable.add(DisabledCaps.DOUBLE_BUFFER);
        }
        AbstractGraphicsScreen screen = (device = gc[0].getDevice()) != null ? AWTGraphicsScreen.createScreenDevice((GraphicsDevice)device, (int)0) : AWTGraphicsScreen.createDefault();
        boolean tryAgain = true;
        CapabilitiesCapturer capturer = null;
        AWTGraphicsConfiguration awtConfig = null;
        while (tryAgain) {
            Frame f = new Frame();
            Dialog d = new Dialog(f);
            d.setUndecorated(true);
            d.setLayout(new BorderLayout());
            capturer = new CapabilitiesCapturer();
            try {
                awtConfig = Jogl2es2Pipeline.createAwtGraphicsConfiguration(caps, (CapabilitiesChooser)capturer, screen);
                QueryCanvas canvas = new QueryCanvas(awtConfig, capturer);
                d.add((Component)canvas, "Center");
                d.setSize(1, 1);
                d.setVisible(true);
                canvas.doQuery();
                if (!EventQueue.isDispatchThread()) {
                    CapabilitiesCapturer capabilitiesCapturer = capturer;
                    synchronized (capabilitiesCapturer) {
                        if (!capturer.done()) {
                            try {
                                capturer.wait(1000L);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                        }
                    }
                }
                Jogl2es2Pipeline.disposeOnEDT(d);
                Jogl2es2Pipeline.disposeOnEDT(f);
                tryAgain = false;
            }
            catch (GLException e) {
                if (capsToDisable.size() == 0) {
                    tryAgain = false;
                    continue;
                }
                switch ((DisabledCaps)((Object)capsToDisable.remove(0))) {
                    case STEREO: {
                        caps.setStereo(false);
                        break;
                    }
                    case AA: {
                        caps.setSampleBuffers(false);
                        break;
                    }
                    case DOUBLE_BUFFER: {
                        caps.setDoubleBuffered(false);
                    }
                }
                awtConfig = null;
            }
        }
        int chosenIndex = capturer.getChosenIndex();
        GLCapabilities chosenCaps = null;
        chosenCaps = chosenIndex < 0 ? caps : capturer.getCapabilities();
        JoglGraphicsConfiguration config = new JoglGraphicsConfiguration(chosenCaps, chosenIndex, device);
        GraphicsConfigInfo gcInf0 = new GraphicsConfigInfo(gct);
        gcInf0.setPrivateData(awtConfig);
        Hashtable<GraphicsConfiguration, GraphicsConfigInfo> hashtable = Canvas3D.graphicsConfigTable;
        synchronized (hashtable) {
            Canvas3D.graphicsConfigTable.put(config, gcInf0);
        }
        return config;
    }

    @Override
    int getScreen(GraphicsDevice graphicsDevice) {
        return 0;
    }

    private static AWTGraphicsConfiguration createAwtGraphicsConfiguration(GLCapabilities capabilities, CapabilitiesChooser chooser, AbstractGraphicsScreen screen) {
        GraphicsConfigurationFactory factory = GraphicsConfigurationFactory.getFactory(AWTGraphicsDevice.class, GLCapabilities.class);
        AWTGraphicsConfiguration awtGraphicsConfiguration = (AWTGraphicsConfiguration)factory.chooseGraphicsConfiguration((CapabilitiesImmutable)capabilities, (CapabilitiesImmutable)capabilities, chooser, screen, 0);
        return awtGraphicsConfiguration;
    }

    private static void disposeOnEDT(final Window f) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                f.setVisible(false);
                f.dispose();
            }
        };
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(r);
        } else {
            r.run();
        }
    }

    static {
        Jogl2es2Pipeline.blendFunctionTable[0] = 0;
        Jogl2es2Pipeline.blendFunctionTable[1] = 1;
        Jogl2es2Pipeline.blendFunctionTable[2] = 770;
        Jogl2es2Pipeline.blendFunctionTable[3] = 771;
        Jogl2es2Pipeline.blendFunctionTable[4] = 774;
        Jogl2es2Pipeline.blendFunctionTable[5] = 775;
        Jogl2es2Pipeline.blendFunctionTable[6] = 768;
        Jogl2es2Pipeline.blendFunctionTable[7] = 769;
        Jogl2es2Pipeline.blendFunctionTable[8] = 32769;
        currently_current = false;
        nioIndexTemp = new ThreadLocal();
        nioVertexTemp = new ThreadLocal();
        nioVertexDoubleTemp = new ThreadLocal();
        nioColorTemp = new ThreadLocal();
        nioColorByteTemp = new ThreadLocal();
        nioNormalTemp = new ThreadLocal();
        nioTexCoordSetTemp = new ThreadLocal();
        nioVertexAttrSetTemp = new ThreadLocal();
    }

    private final class ContextQuerier
    extends DefaultGLCapabilitiesChooser
    implements ExtendedCapabilitiesChooser {
        private Canvas3D canvas;
        private boolean done;

        public ContextQuerier(Canvas3D canvas) {
            this.canvas = canvas;
        }

        public boolean done() {
            return this.done;
        }

        @Override
        public void init(GLContext context) {
            JoglContext jctx = new JoglContext(context);
            GL2ES2 gl = context.getGL().getGL2ES2();
            if (Jogl2es2Pipeline.getPropertiesFromCurrentContext(jctx, gl)) {
                Jogl2es2Pipeline.setupCanvasProperties(this.canvas, jctx, gl);
            }
            this.markDone();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void markDone() {
            ContextQuerier contextQuerier = this;
            synchronized (contextQuerier) {
                this.done = true;
                this.notifyAll();
            }
        }
    }

    private static class CapabilitiesCapturer
    extends DefaultGLCapabilitiesChooser
    implements ExtendedCapabilitiesChooser {
        private boolean done;
        private GLCapabilities capabilities;
        private int chosenIndex = -1;

        private CapabilitiesCapturer() {
        }

        public boolean done() {
            return this.done;
        }

        public GLCapabilities getCapabilities() {
            return this.capabilities;
        }

        public int getChosenIndex() {
            return this.chosenIndex;
        }

        public int chooseCapabilities(GLCapabilities desired, GLCapabilities[] available, int windowSystemRecommendedChoice) {
            int res = super.chooseCapabilities((CapabilitiesImmutable)desired, Arrays.asList(available), windowSystemRecommendedChoice);
            this.capabilities = available[res];
            this.chosenIndex = res;
            this.markDone();
            return res;
        }

        @Override
        public void init(GLContext context) {
            this.kick();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void markDone() {
            CapabilitiesCapturer capabilitiesCapturer = this;
            synchronized (capabilitiesCapturer) {
                this.done = true;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void kick() {
            CapabilitiesCapturer capabilitiesCapturer = this;
            synchronized (capabilitiesCapturer) {
                this.notifyAll();
            }
        }
    }

    private final class QueryCanvas
    extends Canvas {
        private GLDrawable glDrawable;
        private ExtendedCapabilitiesChooser chooser;
        private boolean alreadyRan;
        private AWTGraphicsConfiguration awtConfig;
        private JAWTWindow nativeWindow;

        private QueryCanvas(AWTGraphicsConfiguration awtConfig, ExtendedCapabilitiesChooser chooser) {
            super(awtConfig.getAWTGraphicsConfiguration());
            this.awtConfig = null;
            this.nativeWindow = null;
            this.awtConfig = awtConfig;
            this.chooser = chooser;
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.nativeWindow = (JAWTWindow)NativeWindowFactory.getNativeWindow((Object)this, (AbstractGraphicsConfiguration)this.awtConfig);
            this.nativeWindow.lockSurface();
            try {
                this.glDrawable = GLDrawableFactory.getFactory((GLProfile)Jogl2es2Pipeline.this.profile).createGLDrawable((NativeSurface)this.nativeWindow);
            }
            finally {
                this.nativeWindow.unlockSurface();
            }
            this.glDrawable.setRealized(true);
        }

        private void doQuery() {
            if (this.alreadyRan) {
                return;
            }
            GLContext context = this.glDrawable.createContext(null);
            int res = context.makeCurrent();
            if (res != 0) {
                try {
                    this.chooser.init(context);
                }
                finally {
                    context.release();
                }
            }
            context.destroy();
            this.alreadyRan = true;
            this.glDrawable.setRealized(false);
            this.nativeWindow.destroy();
        }
    }

    private static interface ExtendedCapabilitiesChooser
    extends GLCapabilitiesChooser {
        public void init(GLContext var1);
    }

    private static enum DisabledCaps {
        STEREO,
        AA,
        DOUBLE_BUFFER;

    }

    private class isExtensionAvailable {
        private int GL_EXT_abgr = 0;
        private int GL_ARB_imaging = 0;

        private isExtensionAvailable() {
        }

        private boolean GL_EXT_abgr(GL2ES2 gl) {
            if (this.GL_EXT_abgr == 0) {
                this.GL_EXT_abgr = gl.isExtensionAvailable("GL_EXT_abgr") ? 1 : -1;
            }
            return this.GL_EXT_abgr == 1;
        }

        private boolean GL_ARB_imaging(GL2ES2 gl) {
            if (this.GL_ARB_imaging == 0) {
                this.GL_ARB_imaging = gl.isExtensionAvailable("GL_ARB_imaging") ? 1 : -1;
            }
            return this.GL_ARB_imaging == 1;
        }
    }
}

