/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import org.jogamp.vecmath.Matrix3d;
import org.jogamp.vecmath.Matrix4d;
import org.jogamp.vecmath.SingularMatrixException;
import org.jogamp.vecmath.Tuple4f;
import org.jogamp.vecmath.Vector4f;

class Jogl2es2MatrixUtil {
    double[] result3 = new double[9];
    int[] row_perm3 = new int[3];
    double[] tmp3 = new double[9];
    double[] row_scale3 = new double[3];
    double[] result4 = new double[16];
    int[] row_perm4 = new int[4];
    double[] tmp4 = new double[16];
    double[] row_scale4 = new double[4];
    public double[] deburnV2 = null;
    public Matrix4d deburnV = new Matrix4d();
    public Matrix4d deburnM = new Matrix4d();
    public float[] tempMat9 = new float[9];
    public float[] tempMat12 = new float[12];
    public float[] tempMat16 = new float[16];
    public double[] tempMatD9 = new double[9];
    private Vector4f tmpV4f = new Vector4f();
    private FloatBuffer matFB4x4;
    private FloatBuffer matFB3x3;

    Jogl2es2MatrixUtil() {
    }

    public static void transposeInvert(Matrix3d m, Matrix3d out) {
        double determinant = m.determinant();
        if (determinant > 0.0) {
            double invdet = 1.0 / determinant;
            out.m00 = (m.m11 * m.m22 - m.m21 * m.m12) * invdet;
            out.m10 = -(m.m01 * m.m22 - m.m02 * m.m21) * invdet;
            out.m20 = (m.m01 * m.m12 - m.m02 * m.m11) * invdet;
            out.m01 = -(m.m10 * m.m22 - m.m12 * m.m20) * invdet;
            out.m11 = (m.m00 * m.m22 - m.m02 * m.m20) * invdet;
            out.m21 = -(m.m00 * m.m12 - m.m10 * m.m02) * invdet;
            out.m02 = (m.m10 * m.m21 - m.m20 * m.m11) * invdet;
            out.m12 = -(m.m00 * m.m21 - m.m20 * m.m01) * invdet;
            out.m22 = (m.m00 * m.m11 - m.m10 * m.m01) * invdet;
        } else {
            out.setIdentity();
        }
    }

    public static void transposeInvert(Matrix4d m, Matrix3d out) {
        double determinant = m.determinant();
        if (determinant > 0.0) {
            double invdet = 1.0 / determinant;
            out.m00 = (m.m11 * m.m22 - m.m21 * m.m12) * invdet;
            out.m10 = -(m.m01 * m.m22 - m.m02 * m.m21) * invdet;
            out.m20 = (m.m01 * m.m12 - m.m02 * m.m11) * invdet;
            out.m01 = -(m.m10 * m.m22 - m.m12 * m.m20) * invdet;
            out.m11 = (m.m00 * m.m22 - m.m02 * m.m20) * invdet;
            out.m21 = -(m.m00 * m.m12 - m.m10 * m.m02) * invdet;
            out.m02 = (m.m10 * m.m21 - m.m20 * m.m11) * invdet;
            out.m12 = -(m.m00 * m.m21 - m.m20 * m.m01) * invdet;
            out.m22 = (m.m00 * m.m11 - m.m10 * m.m01) * invdet;
        } else {
            out.setIdentity();
        }
    }

    final void invertGeneral3(Matrix3d thisM, Matrix3d m1) {
        int i;
        for (i = 0; i < 3; ++i) {
            this.row_perm3[i] = 0;
        }
        for (i = 0; i < 9; ++i) {
            this.result3[i] = 0.0;
        }
        this.tmp3[0] = m1.m00;
        this.tmp3[1] = m1.m01;
        this.tmp3[2] = m1.m02;
        this.tmp3[3] = m1.m10;
        this.tmp3[4] = m1.m11;
        this.tmp3[5] = m1.m12;
        this.tmp3[6] = m1.m20;
        this.tmp3[7] = m1.m21;
        this.tmp3[8] = m1.m22;
        if (!this.luDecomposition3(this.tmp3, this.row_perm3)) {
            throw new SingularMatrixException("!luDecomposition(tmp, row_perm)");
        }
        this.result3[0] = 1.0;
        this.result3[4] = 1.0;
        this.result3[8] = 1.0;
        this.luBacksubstitution3(this.tmp3, this.row_perm3, this.result3);
        thisM.m00 = this.result3[0];
        thisM.m01 = this.result3[1];
        thisM.m02 = this.result3[2];
        thisM.m10 = this.result3[3];
        thisM.m11 = this.result3[4];
        thisM.m12 = this.result3[5];
        thisM.m20 = this.result3[6];
        thisM.m21 = this.result3[7];
        thisM.m22 = this.result3[8];
    }

    boolean luDecomposition3(double[] matrix0, int[] row_perm) {
        int i;
        for (i = 0; i < 3; ++i) {
            this.row_scale3[i] = 0.0;
        }
        int ptr = 0;
        int rs = 0;
        i = 3;
        while (i-- != 0) {
            double big = 0.0;
            int j = 3;
            while (j-- != 0) {
                double temp = matrix0[ptr++];
                if (!((temp = Math.abs(temp)) > big)) continue;
                big = temp;
            }
            if (big == 0.0) {
                return false;
            }
            this.row_scale4[rs++] = 1.0 / big;
        }
        int mtx = 0;
        for (int j = 0; j < 3; ++j) {
            double temp;
            int p1;
            int k;
            int p2;
            double sum;
            int target;
            int i2;
            for (i2 = 0; i2 < j; ++i2) {
                target = mtx + 3 * i2 + j;
                sum = matrix0[target];
                int k2 = i2;
                int p12 = mtx + 3 * i2;
                p2 = mtx + j;
                while (k2-- != 0) {
                    sum -= matrix0[p12] * matrix0[p2];
                    ++p12;
                    p2 += 3;
                }
                matrix0[target] = sum;
            }
            double big = 0.0;
            int imax = -1;
            for (i2 = j; i2 < 3; ++i2) {
                double d;
                target = mtx + 3 * i2 + j;
                sum = matrix0[target];
                k = j;
                p1 = mtx + 3 * i2;
                p2 = mtx + j;
                while (k-- != 0) {
                    sum -= matrix0[p1] * matrix0[p2];
                    ++p1;
                    p2 += 3;
                }
                matrix0[target] = sum;
                temp = this.row_scale3[i2] * Math.abs(sum);
                if (!(d >= big)) continue;
                big = temp;
                imax = i2;
            }
            if (imax < 0) {
                throw new RuntimeException("imax < 0");
            }
            if (j != imax) {
                k = 3;
                p1 = mtx + 3 * imax;
                p2 = mtx + 3 * j;
                while (k-- != 0) {
                    temp = matrix0[p1];
                    matrix0[p1++] = matrix0[p2];
                    matrix0[p2++] = temp;
                }
                this.row_scale3[imax] = this.row_scale3[j];
            }
            row_perm[j] = imax;
            if (matrix0[mtx + 3 * j + j] == 0.0) {
                return false;
            }
            if (j == 2) continue;
            temp = 1.0 / matrix0[mtx + 3 * j + j];
            target = mtx + 3 * (j + 1) + j;
            i2 = 2 - j;
            while (i2-- != 0) {
                int n = target;
                matrix0[n] = matrix0[n] * temp;
                target += 3;
            }
        }
        return true;
    }

    void luBacksubstitution3(double[] matrix1, int[] row_perm, double[] matrix2) {
        int rp = 0;
        for (int k = 0; k < 3; ++k) {
            int rv;
            int cv = k;
            int ii = -1;
            for (int i = 0; i < 3; ++i) {
                int ip = row_perm[rp + i];
                double sum = matrix2[cv + 3 * ip];
                matrix2[cv + 3 * ip] = matrix2[cv + 3 * i];
                if (ii >= 0) {
                    rv = i * 3;
                    for (int j = ii; j <= i - 1; ++j) {
                        sum -= matrix1[rv + j] * matrix2[cv + 3 * j];
                    }
                } else if (sum != 0.0) {
                    ii = i;
                }
                matrix2[cv + 3 * i] = sum;
            }
            rv = 6;
            int n = cv + 6;
            matrix2[n] = matrix2[n] / matrix1[rv + 2];
            matrix2[cv + 3] = (matrix2[cv + 3] - matrix1[(rv -= 3) + 2] * matrix2[cv + 6]) / matrix1[rv + 1];
            matrix2[cv + 0] = (matrix2[cv + 0] - matrix1[(rv -= 3) + 1] * matrix2[cv + 3] - matrix1[rv + 2] * matrix2[cv + 6]) / matrix1[rv + 0];
        }
    }

    final void invertGeneral4(Matrix4d thisM, Matrix4d m1) {
        int i;
        for (i = 0; i < 4; ++i) {
            this.row_perm4[i] = 0;
        }
        for (i = 0; i < 16; ++i) {
            this.result4[i] = 0.0;
        }
        this.tmp4[0] = m1.m00;
        this.tmp4[1] = m1.m01;
        this.tmp4[2] = m1.m02;
        this.tmp4[3] = m1.m03;
        this.tmp4[4] = m1.m10;
        this.tmp4[5] = m1.m11;
        this.tmp4[6] = m1.m12;
        this.tmp4[7] = m1.m13;
        this.tmp4[8] = m1.m20;
        this.tmp4[9] = m1.m21;
        this.tmp4[10] = m1.m22;
        this.tmp4[11] = m1.m23;
        this.tmp4[12] = m1.m30;
        this.tmp4[13] = m1.m31;
        this.tmp4[14] = m1.m32;
        this.tmp4[15] = m1.m33;
        if (!this.luDecomposition4(this.tmp4, this.row_perm4)) {
            throw new SingularMatrixException("luDecomposition4(tmp4, row_perm4)");
        }
        this.result4[0] = 1.0;
        this.result4[5] = 1.0;
        this.result4[10] = 1.0;
        this.result4[15] = 1.0;
        this.luBacksubstitution4(this.tmp4, this.row_perm4, this.result4);
        thisM.m00 = this.result4[0];
        thisM.m01 = this.result4[1];
        thisM.m02 = this.result4[2];
        thisM.m03 = this.result4[3];
        thisM.m10 = this.result4[4];
        thisM.m11 = this.result4[5];
        thisM.m12 = this.result4[6];
        thisM.m13 = this.result4[7];
        thisM.m20 = this.result4[8];
        thisM.m21 = this.result4[9];
        thisM.m22 = this.result4[10];
        thisM.m23 = this.result4[11];
        thisM.m30 = this.result4[12];
        thisM.m31 = this.result4[13];
        thisM.m32 = this.result4[14];
        thisM.m33 = this.result4[15];
    }

    boolean luDecomposition4(double[] matrix0, int[] row_perm) {
        int i;
        for (i = 0; i < 4; ++i) {
            this.row_scale4[i] = 0.0;
        }
        int ptr = 0;
        int rs = 0;
        i = 4;
        while (i-- != 0) {
            double big = 0.0;
            int j = 4;
            while (j-- != 0) {
                double temp = matrix0[ptr++];
                if (!((temp = Math.abs(temp)) > big)) continue;
                big = temp;
            }
            if (big == 0.0) {
                return false;
            }
            this.row_scale4[rs++] = 1.0 / big;
        }
        int mtx = 0;
        for (int j = 0; j < 4; ++j) {
            double temp;
            int p1;
            int k;
            int p2;
            double sum;
            int target;
            int i2;
            for (i2 = 0; i2 < j; ++i2) {
                target = mtx + 4 * i2 + j;
                sum = matrix0[target];
                int k2 = i2;
                int p12 = mtx + 4 * i2;
                p2 = mtx + j;
                while (k2-- != 0) {
                    sum -= matrix0[p12] * matrix0[p2];
                    ++p12;
                    p2 += 4;
                }
                matrix0[target] = sum;
            }
            double big = 0.0;
            int imax = -1;
            for (i2 = j; i2 < 4; ++i2) {
                double d;
                target = mtx + 4 * i2 + j;
                sum = matrix0[target];
                k = j;
                p1 = mtx + 4 * i2;
                p2 = mtx + j;
                while (k-- != 0) {
                    sum -= matrix0[p1] * matrix0[p2];
                    ++p1;
                    p2 += 4;
                }
                matrix0[target] = sum;
                temp = this.row_scale4[i2] * Math.abs(sum);
                if (!(d >= big)) continue;
                big = temp;
                imax = i2;
            }
            if (imax < 0) {
                throw new RuntimeException("(imax < 0)");
            }
            if (j != imax) {
                k = 4;
                p1 = mtx + 4 * imax;
                p2 = mtx + 4 * j;
                while (k-- != 0) {
                    temp = matrix0[p1];
                    matrix0[p1++] = matrix0[p2];
                    matrix0[p2++] = temp;
                }
                this.row_scale4[imax] = this.row_scale4[j];
            }
            row_perm[j] = imax;
            if (matrix0[mtx + 4 * j + j] == 0.0) {
                return false;
            }
            if (j == 3) continue;
            temp = 1.0 / matrix0[mtx + 4 * j + j];
            target = mtx + 4 * (j + 1) + j;
            i2 = 3 - j;
            while (i2-- != 0) {
                int n = target;
                matrix0[n] = matrix0[n] * temp;
                target += 4;
            }
        }
        return true;
    }

    void luBacksubstitution4(double[] matrix1, int[] row_perm, double[] matrix2) {
        int rp = 0;
        for (int k = 0; k < 4; ++k) {
            int rv;
            int cv = k;
            int ii = -1;
            for (int i = 0; i < 4; ++i) {
                int ip = row_perm[rp + i];
                double sum = matrix2[cv + 4 * ip];
                matrix2[cv + 4 * ip] = matrix2[cv + 4 * i];
                if (ii >= 0) {
                    rv = i * 4;
                    for (int j = ii; j <= i - 1; ++j) {
                        sum -= matrix1[rv + j] * matrix2[cv + 4 * j];
                    }
                } else if (sum != 0.0) {
                    ii = i;
                }
                matrix2[cv + 4 * i] = sum;
            }
            rv = 12;
            int n = cv + 12;
            matrix2[n] = matrix2[n] / matrix1[rv + 3];
            matrix2[cv + 8] = (matrix2[cv + 8] - matrix1[(rv -= 4) + 3] * matrix2[cv + 12]) / matrix1[rv + 2];
            matrix2[cv + 4] = (matrix2[cv + 4] - matrix1[(rv -= 4) + 2] * matrix2[cv + 8] - matrix1[rv + 3] * matrix2[cv + 12]) / matrix1[rv + 1];
            matrix2[cv + 0] = (matrix2[cv + 0] - matrix1[(rv -= 4) + 1] * matrix2[cv + 4] - matrix1[rv + 2] * matrix2[cv + 8] - matrix1[rv + 3] * matrix2[cv + 12]) / matrix1[rv + 0];
        }
    }

    public final void transform(Matrix4d m, Tuple4f vecOut) {
        float x = (float)(m.m00 * (double)vecOut.x + m.m01 * (double)vecOut.y + m.m02 * (double)vecOut.z + m.m03 * (double)vecOut.w);
        float y = (float)(m.m10 * (double)vecOut.x + m.m11 * (double)vecOut.y + m.m12 * (double)vecOut.z + m.m13 * (double)vecOut.w);
        float z = (float)(m.m20 * (double)vecOut.x + m.m21 * (double)vecOut.y + m.m22 * (double)vecOut.z + m.m23 * (double)vecOut.w);
        vecOut.w = (float)(m.m30 * (double)vecOut.x + m.m31 * (double)vecOut.y + m.m32 * (double)vecOut.z + m.m33 * (double)vecOut.w);
        vecOut.x = x;
        vecOut.y = y;
        vecOut.z = z;
    }

    public float[] toArray(Matrix4d m) {
        this.tempMat16[0] = (float)m.m00;
        this.tempMat16[1] = (float)m.m01;
        this.tempMat16[2] = (float)m.m02;
        this.tempMat16[3] = (float)m.m03;
        this.tempMat16[4] = (float)m.m10;
        this.tempMat16[5] = (float)m.m11;
        this.tempMat16[6] = (float)m.m12;
        this.tempMat16[7] = (float)m.m13;
        this.tempMat16[8] = (float)m.m20;
        this.tempMat16[9] = (float)m.m21;
        this.tempMat16[10] = (float)m.m22;
        this.tempMat16[11] = (float)m.m23;
        this.tempMat16[12] = (float)m.m30;
        this.tempMat16[13] = (float)m.m31;
        this.tempMat16[14] = (float)m.m32;
        this.tempMat16[15] = (float)m.m33;
        return this.tempMat16;
    }

    public static float[] toArray(Matrix4d m, float[] a) {
        a[0] = (float)m.m00;
        a[1] = (float)m.m01;
        a[2] = (float)m.m02;
        a[3] = (float)m.m03;
        a[4] = (float)m.m10;
        a[5] = (float)m.m11;
        a[6] = (float)m.m12;
        a[7] = (float)m.m13;
        a[8] = (float)m.m20;
        a[9] = (float)m.m21;
        a[10] = (float)m.m22;
        a[11] = (float)m.m23;
        a[12] = (float)m.m30;
        a[13] = (float)m.m31;
        a[14] = (float)m.m32;
        a[15] = (float)m.m33;
        return a;
    }

    public float[] toArray(Matrix3d m) {
        this.tempMat9[0] = (float)m.m00;
        this.tempMat9[1] = (float)m.m01;
        this.tempMat9[2] = (float)m.m02;
        this.tempMat9[3] = (float)m.m10;
        this.tempMat9[4] = (float)m.m11;
        this.tempMat9[5] = (float)m.m12;
        this.tempMat9[6] = (float)m.m20;
        this.tempMat9[7] = (float)m.m21;
        this.tempMat9[8] = (float)m.m22;
        return this.tempMat9;
    }

    public static float[] toArray(Matrix3d m, float[] a) {
        a[0] = (float)m.m00;
        a[1] = (float)m.m01;
        a[2] = (float)m.m02;
        a[3] = (float)m.m10;
        a[4] = (float)m.m11;
        a[5] = (float)m.m12;
        a[6] = (float)m.m20;
        a[7] = (float)m.m21;
        a[8] = (float)m.m22;
        return a;
    }

    public float[] toArray3x4(Matrix3d m) {
        return Jogl2es2MatrixUtil.toArray3x4(m, this.tempMat12);
    }

    public static float[] toArray3x4(Matrix3d m, float[] a) {
        a[0] = (float)m.m00;
        a[1] = (float)m.m01;
        a[2] = (float)m.m02;
        a[3] = 0.0f;
        a[4] = (float)m.m10;
        a[5] = (float)m.m11;
        a[6] = (float)m.m12;
        a[7] = 0.0f;
        a[8] = (float)m.m20;
        a[9] = (float)m.m21;
        a[10] = (float)m.m22;
        a[11] = 0.0f;
        return a;
    }

    public double[] toArray3x3(Matrix4d m) {
        return Jogl2es2MatrixUtil.toArray3x3(m, this.tempMatD9);
    }

    public static double[] toArray3x3(Matrix4d m, double[] a) {
        a[0] = m.m00;
        a[1] = m.m01;
        a[2] = m.m02;
        a[3] = m.m10;
        a[4] = m.m11;
        a[5] = m.m12;
        a[6] = m.m20;
        a[7] = m.m21;
        a[8] = m.m22;
        return a;
    }

    public void invert(Matrix3d m1) {
        try {
            this.invertGeneral3(m1, m1);
        }
        catch (Exception e) {
            m1.setIdentity();
        }
    }

    public void invert(Matrix4d m1) {
        try {
            this.invertGeneral4(m1, m1);
        }
        catch (Exception e) {
            m1.setIdentity();
        }
    }

    public Vector4f transform(Matrix4d m1, Matrix4d m2, float tx, float ty, float tz, float tw) {
        this.tmpV4f.set(tx, ty, tz, tw);
        this.transform(m1, this.tmpV4f);
        this.transform(m2, this.tmpV4f);
        return this.tmpV4f;
    }

    public FloatBuffer toFB4(float[] f) {
        if (this.matFB4x4 == null) {
            ByteBuffer bb = ByteBuffer.allocateDirect(64);
            bb.order(ByteOrder.nativeOrder());
            this.matFB4x4 = bb.asFloatBuffer();
        }
        this.matFB4x4.position(0);
        this.matFB4x4.put(f);
        this.matFB4x4.position(0);
        return this.matFB4x4;
    }

    public FloatBuffer toFB3(float[] f) {
        if (this.matFB3x3 == null) {
            ByteBuffer bb = ByteBuffer.allocateDirect(64);
            bb.order(ByteOrder.nativeOrder());
            this.matFB3x3 = bb.asFloatBuffer();
        }
        this.matFB3x3.position(0);
        this.matFB3x3.put(f);
        this.matFB3x3.position(0);
        return this.matFB3x3;
    }

    public FloatBuffer toFB(Matrix4d m) {
        if (this.matFB4x4 == null) {
            ByteBuffer bb = ByteBuffer.allocateDirect(64);
            bb.order(ByteOrder.nativeOrder());
            this.matFB4x4 = bb.asFloatBuffer();
        }
        this.matFB4x4.position(0);
        this.matFB4x4.put(this.toArray(m));
        this.matFB4x4.position(0);
        return this.matFB4x4;
    }

    public FloatBuffer toFB(Matrix3d m) {
        if (this.matFB3x3 == null) {
            ByteBuffer bb = ByteBuffer.allocateDirect(36);
            bb.order(ByteOrder.nativeOrder());
            this.matFB3x3 = bb.asFloatBuffer();
        }
        this.matFB3x3.position(0);
        this.matFB3x3.put(this.toArray(m));
        this.matFB3x3.position(0);
        return this.matFB3x3;
    }

    public static float[] transposeInPlace(float[] src) {
        if (src.length == 9) {
            float temp = src[3];
            src[3] = src[1];
            src[1] = temp;
            temp = src[6];
            src[6] = src[2];
            src[2] = temp;
            temp = src[7];
            src[7] = src[5];
            src[5] = temp;
        } else if (src.length == 16) {
            float v1 = src[1];
            float v2 = src[2];
            float v3 = src[3];
            float v6 = src[6];
            float v7 = src[7];
            float v11 = src[11];
            src[1] = src[4];
            src[2] = src[8];
            src[3] = src[12];
            src[4] = v1;
            src[6] = src[9];
            src[7] = src[13];
            src[8] = v2;
            src[9] = v6;
            src[11] = src[14];
            src[12] = v3;
            src[13] = v7;
            src[14] = v11;
        } else {
            throw new UnsupportedOperationException("Only 9 or 16 length float arrays can be transposed!");
        }
        return src;
    }

    public static float halfToFloat(int hbits) {
        int mant = hbits & 0x3FF;
        int exp = hbits & 0x7C00;
        if (exp == 31744) {
            exp = 261120;
        } else if (exp != 0) {
            if (mant == 0 && (exp += 114688) > 115712) {
                return Float.intBitsToFloat((hbits & 0x8000) << 16 | exp << 13 | 0x3FF);
            }
        } else if (mant != 0) {
            exp = 115712;
            do {
                exp -= 1024;
            } while (((mant <<= 1) & 0x400) == 0);
            mant &= 0x3FF;
        }
        return Float.intBitsToFloat((hbits & 0x8000) << 16 | (exp | mant) << 13);
    }

    public static int halfFromFloat(float fval) {
        int fbits = Float.floatToIntBits(fval);
        int sign = fbits >>> 16 & 0x8000;
        int val = (fbits & Integer.MAX_VALUE) + 4096;
        if (val >= 1199570944) {
            if ((fbits & Integer.MAX_VALUE) >= 1199570944) {
                if (val < 2139095040) {
                    return sign | 0x7C00;
                }
                return sign | 0x7C00 | (fbits & 0x7FFFFF) >>> 13;
            }
            return sign | 0x7BFF;
        }
        if (val >= 0x38800000) {
            return sign | val - 0x38000000 >>> 13;
        }
        if (val < 0x33000000) {
            return sign;
        }
        val = (fbits & Integer.MAX_VALUE) >>> 23;
        return sign | (fbits & 0x7FFFFF | 0x800000) + (0x800000 >>> val - 102) >>> 126 - val;
    }
}

