/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi.boundary;

import gnu.trove.list.array.TIntArrayList;
import net.imglib2.AbstractWrappedInterval;
import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.Localizable;
import net.imglib2.Point;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.roi.IterableRegion;
import net.imglib2.roi.Regions;
import net.imglib2.roi.boundary.BoundaryRandomAccess4;
import net.imglib2.roi.boundary.BoundaryRandomAccess8;
import net.imglib2.type.BooleanType;
import net.imglib2.type.logic.BoolType;

public final class Boundary<T extends BooleanType<T>>
extends AbstractWrappedInterval<RandomAccessibleInterval<T>>
implements IterableRegion<BoolType> {
    private StructuringElement structuringElement;
    private final int n;
    private final TIntArrayList coords;
    private final int size;
    private final BoundaryIterable inside;

    public Boundary(RandomAccessibleInterval<T> region) {
        this(region, StructuringElement.FOUR_CONNECTED);
    }

    public Boundary(RandomAccessibleInterval<T> region, StructuringElement structuringElement) {
        super(region);
        this.structuringElement = structuringElement;
        this.n = region.numDimensions();
        this.coords = new TIntArrayList();
        BoundaryConstructor<T> c = new BoundaryConstructor<T>(region, structuringElement);
        block0: while (true) {
            c.fwd();
            if (!c.isValid()) break;
            int d = 0;
            while (true) {
                if (d >= this.n) continue block0;
                this.coords.add(c.getIntPosition(d));
                ++d;
            }
            break;
        }
        this.size = this.coords.size() / this.n;
        this.inside = new BoundaryIterable();
    }

    @Override
    public IterableInterval<Void> inside() {
        return this.inside;
    }

    public RandomAccess<BoolType> randomAccess() {
        return this.structuringElement == StructuringElement.FOUR_CONNECTED ? new BoundaryRandomAccess4((RandomAccessibleInterval)this.sourceInterval) : new BoundaryRandomAccess8((RandomAccessibleInterval)this.sourceInterval);
    }

    public RandomAccess<BoolType> randomAccess(Interval interval) {
        return this.randomAccess();
    }

    public BoolType getType() {
        return new BoolType();
    }

    static final class BoundaryConstructor<T extends BooleanType<T>>
    implements Localizable {
        private final Cursor<Void> c;
        private final RandomAccess<BoolType> a;
        private boolean valid;

        public BoundaryConstructor(RandomAccessibleInterval<T> region, StructuringElement structuringElement) {
            this.c = Regions.iterable(region).inside().localizingCursor();
            this.a = structuringElement == StructuringElement.FOUR_CONNECTED ? new BoundaryRandomAccess4<T>(region) : new BoundaryRandomAccess8<T>(region);
        }

        public void fwd() {
            while (this.c.hasNext()) {
                this.c.fwd();
                this.a.setPosition(this.c);
                if (!((BoolType)this.a.get()).get()) continue;
                this.valid = true;
                return;
            }
            this.valid = false;
        }

        public boolean isValid() {
            return this.valid;
        }

        public void localize(float[] position) {
            this.c.localize(position);
        }

        public void localize(double[] position) {
            this.c.localize(position);
        }

        public float getFloatPosition(int d) {
            return this.c.getFloatPosition(d);
        }

        public double getDoublePosition(int d) {
            return this.c.getDoublePosition(d);
        }

        public int numDimensions() {
            return this.c.numDimensions();
        }

        public void localize(int[] position) {
            this.c.localize(position);
        }

        public void localize(long[] position) {
            this.c.localize(position);
        }

        public int getIntPosition(int d) {
            return this.c.getIntPosition(d);
        }

        public long getLongPosition(int d) {
            return this.c.getLongPosition(d);
        }
    }

    private final class BoundaryCursor
    extends Point
    implements Cursor<Void> {
        private int i;
        private final int size;

        BoundaryCursor() {
            super(Boundary.this.numDimensions());
            this.size = Boundary.this.coords.size();
            this.i = 0;
        }

        private BoundaryCursor(BoundaryCursor c) {
            super(new int[0]);
            this.size = Boundary.this.coords.size();
            this.i = c.i;
            this.setPosition((Localizable)c);
        }

        public Void get() {
            return null;
        }

        public Void next() {
            this.fwd();
            return null;
        }

        public boolean hasNext() {
            return this.i < this.size;
        }

        public void fwd() {
            int d = 0;
            while (d < this.n) {
                this.position[d] = Boundary.this.coords.getQuick(this.i);
                ++d;
                ++this.i;
            }
        }

        public void jumpFwd(long steps) {
            this.i = (int)((long)this.i + (long)this.n * (steps - 1L));
            this.fwd();
        }

        public void reset() {
            this.i = 0;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public BoundaryCursor copy() {
            return new BoundaryCursor(this);
        }

        public BoundaryCursor copyCursor() {
            return this.copy();
        }
    }

    private final class BoundaryIterable
    extends AbstractWrappedInterval<Interval>
    implements IterableInterval<Void> {
        BoundaryIterable() {
            super((Interval)Boundary.this);
        }

        public long size() {
            return Boundary.this.size;
        }

        public Object iterationOrder() {
            return this;
        }

        public BoundaryCursor cursor() {
            return new BoundaryCursor();
        }

        public BoundaryCursor localizingCursor() {
            return this.cursor();
        }

        public BoundaryCursor iterator() {
            return this.cursor();
        }

        public Void firstElement() {
            return this.cursor().next();
        }

        public Void getType() {
            return null;
        }
    }

    public static enum StructuringElement {
        FOUR_CONNECTED,
        EIGHT_CONNECTED;

    }
}

