/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.table.io;

import java.io.IOException;
import java.net.URISyntaxException;
import org.scijava.io.AbstractTypedIOService;
import org.scijava.io.IOPlugin;
import org.scijava.io.location.Location;
import org.scijava.plugin.Plugin;
import org.scijava.service.Service;
import org.scijava.table.Table;
import org.scijava.table.io.TableIOOptions;
import org.scijava.table.io.TableIOPlugin;
import org.scijava.table.io.TableIOService;

@Plugin(type=Service.class)
public class DefaultTableIOService
extends AbstractTypedIOService<Table<?, ?>>
implements TableIOService {
    public boolean canOpen(Location source) {
        IOPlugin opener = this.ioService().getOpener(source);
        if (opener == null) {
            return false;
        }
        return Table.class.isAssignableFrom(opener.getDataType());
    }

    @Override
    public Table<?, ?> open(String source, TableIOOptions options) throws IOException {
        try {
            return this.open(this.locationService().resolve(source), options);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Table<?, ?> open(Location source, TableIOOptions options) throws IOException {
        IOPlugin opener = this.ioService().getOpener(source);
        if (opener != null && Table.class.isAssignableFrom(opener.getDataType()) && TableIOPlugin.class.isAssignableFrom(opener.getClass())) {
            return ((TableIOPlugin)opener).open(source, options);
        }
        throw new UnsupportedOperationException("No compatible opener found.");
    }

    @Override
    public void save(Table<?, ?> table, String destination, TableIOOptions options) throws IOException {
        try {
            this.save(table, this.locationService().resolve(destination), options);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void save(Table<?, ?> table, Location destination, TableIOOptions options) throws IOException {
        IOPlugin saver = this.ioService().getSaver(table, destination);
        if (saver == null || !TableIOPlugin.class.isAssignableFrom(saver.getClass())) {
            throw new UnsupportedOperationException("No compatible saver found.");
        }
        ((TableIOPlugin)saver).save(table, destination, options);
    }
}

