/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.table.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.scijava.io.AbstractIOPlugin;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.handle.DataHandleService;
import org.scijava.io.location.FileLocation;
import org.scijava.io.location.Location;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.table.DefaultGenericTable;
import org.scijava.table.GenericTable;
import org.scijava.table.Table;
import org.scijava.table.io.ColumnTableIOOptions;
import org.scijava.table.io.TableIOOptions;
import org.scijava.table.io.TableIOPlugin;
import org.scijava.util.FileUtils;

@Plugin(type=TableIOPlugin.class, priority=-100.0)
public class DefaultTableIOPlugin
extends AbstractIOPlugin<Table>
implements TableIOPlugin {
    @Parameter
    private DataHandleService dataHandleService;
    private static final Set<String> SUPPORTED_EXTENSIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("csv", "txt", "prn", "dif", "rtf")));

    public boolean supportsOpen(Location source) {
        if (!(source instanceof FileLocation)) {
            return false;
        }
        File file = ((FileLocation)source).getFile();
        return file.exists() && this.supportsFile(file);
    }

    public boolean supportsSave(Location source) {
        if (!(source instanceof FileLocation)) {
            return false;
        }
        File file = ((FileLocation)source).getFile();
        return this.supportsFile(file);
    }

    private ArrayList<String> processRow(String line, char separator, char quote) throws IOException {
        int idx;
        ArrayList<String> row = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        int start = idx = 0;
        while (idx < line.length()) {
            if (line.charAt(idx) == quote) {
                sb.append(line, start, idx);
                boolean quoted = true;
                start = ++idx;
                while (idx < line.length()) {
                    if (line.charAt(idx) == quote) {
                        sb.append(line, start, idx);
                        if (idx + 1 < line.length() && line.charAt(idx + 1) == quote) {
                            sb.append(quote);
                            start = idx += 2;
                            continue;
                        }
                        start = ++idx;
                        quoted = false;
                        break;
                    }
                    ++idx;
                }
                if (!quoted) continue;
                throw new IOException(String.format("Unbalanced quote at position %d: %s", idx, line));
            }
            if (line.charAt(idx) == separator) {
                sb.append(line, start, idx);
                row.add(sb.toString());
                sb.setLength(0);
                start = ++idx;
                continue;
            }
            ++idx;
        }
        sb.append(line, start, idx);
        row.add(sb.toString());
        return row;
    }

    public GenericTable open(Location source, TableIOOptions options) throws IOException {
        return this.open(source, options.values);
    }

    private GenericTable open(Location source, TableIOOptions.Values options) throws IOException {
        DefaultGenericTable table = new DefaultGenericTable();
        try (DataHandle handle = (DataHandle)this.dataHandleService.create((Object)source);){
            if (!handle.exists()) {
                throw new IOException("Cannot open source");
            }
            long length = handle.length();
            byte[] buffer = new byte[(int)length];
            handle.read(buffer);
            String text = new String(buffer);
            char separator = options.columnDelimiter();
            char quote = options.quote();
            boolean readRowHeaders = options.readRowHeaders();
            boolean readColHeaders = options.readColumnHeaders();
            String[] lines = text.split("\\R");
            if (lines.length == 0) {
                DefaultGenericTable defaultGenericTable = table;
                return defaultGenericTable;
            }
            HashMap columnParsers = new HashMap();
            ArrayList<String> tokens = this.processRow(lines[0], separator, quote);
            if (readColHeaders) {
                List<String> colHeaders = readRowHeaders ? tokens.subList(1, tokens.size()) : tokens;
                String[] colHeadersArr = new String[colHeaders.size()];
                table.appendColumns(colHeaders.toArray(colHeadersArr));
            } else {
                List<String> cols;
                if (readRowHeaders) {
                    cols = tokens.subList(1, tokens.size());
                    table.appendColumns(cols.size());
                    table.appendRow(tokens.get(0));
                } else {
                    cols = tokens;
                    table.appendColumns(cols.size());
                    table.appendRow();
                }
                for (int i = 0; i < cols.size(); ++i) {
                    Function<String, ?> parser = DefaultTableIOPlugin.getParser(cols.get(i), i, options);
                    columnParsers.put(i, parser);
                    table.set(i, 0, parser.apply(cols.get(i)));
                }
            }
            for (int lineNum = 1; lineNum < lines.length; ++lineNum) {
                List<String> cols;
                String line = lines[lineNum];
                ArrayList<String> tokens2 = this.processRow(line, separator, quote);
                if (readRowHeaders) {
                    cols = tokens2.subList(1, tokens2.size());
                    table.appendRow(tokens2.get(0));
                } else {
                    cols = tokens2;
                    table.appendRow();
                }
                if (cols.size() != table.getColumnCount()) {
                    throw new IOException("Line " + table.getRowCount() + " is not the same length as the first line.");
                }
                for (int i = 0; i < cols.size(); ++i) {
                    if (lineNum == 1 && readColHeaders) {
                        columnParsers.put(i, DefaultTableIOPlugin.getParser(cols.get(i), i, options));
                    }
                    table.set(i, lineNum - 1, ((Function)columnParsers.get(i)).apply(cols.get(i)));
                }
            }
        }
        return table;
    }

    private static Function<String, ?> getParser(String content, int column, TableIOOptions.Values options) {
        ColumnTableIOOptions.Values colOptions = options.column(column);
        if (colOptions != null) {
            return colOptions.parser();
        }
        if (options.guessParser()) {
            return DefaultTableIOPlugin.guessParser(content);
        }
        return options.parser();
    }

    static Function<String, ?> guessParser(String content) {
        try {
            Function<String, Object> function = s -> Double.valueOf(s.replace("infinity", "Infinity").replace("Nan", "NaN"));
            function.apply(content);
            return function;
        }
        catch (NumberFormatException numberFormatException) {
            if (content.equalsIgnoreCase("true") || content.equalsIgnoreCase("false")) {
                return Boolean::valueOf;
            }
            return String::valueOf;
        }
    }

    public void save(Table table, Location destination, TableIOOptions options) throws IOException {
        this.save(table, destination, options.values);
    }

    private boolean supportsFile(File file) {
        if (file.isDirectory()) {
            return false;
        }
        String ext = FileUtils.getExtension((File)file).toLowerCase();
        return SUPPORTED_EXTENSIONS.contains(ext);
    }

    private void save(Table table, Location destination, TableIOOptions.Values options) throws IOException {
        try (DataHandle handle = (DataHandle)this.dataHandleService.create((Object)destination);){
            boolean writeRH = options.writeRowHeaders();
            boolean writeCH = options.writeColumnHeaders();
            char separator = options.columnDelimiter();
            String eol = options.rowDelimiter();
            char quote = options.quote();
            StringBuilder sb = new StringBuilder();
            if (writeCH) {
                if (writeRH) {
                    sb.append(this.tryQuote(options.cornerText(), separator, quote));
                    if (table.getColumnCount() > 0) {
                        sb.append(separator);
                        sb.append(this.tryQuote(table.getColumnHeader(0), separator, quote));
                    }
                } else if (table.getColumnCount() > 0) {
                    sb.append(this.tryQuote(table.getColumnHeader(0), separator, quote));
                }
                for (int col = 1; col < table.getColumnCount(); ++col) {
                    sb.append(separator);
                    sb.append(this.tryQuote(table.getColumnHeader(col), separator, quote));
                }
                sb.append(eol);
                handle.writeBytes(sb.toString());
                sb.setLength(0);
            }
            for (int row = 0; row < table.getRowCount(); ++row) {
                Function<Object, String> formatter = this.getFormatter(options, 0);
                if (writeRH) {
                    sb.append(this.tryQuote(table.getRowHeader(row), separator, quote));
                    if (table.getColumnCount() > 0) {
                        sb.append(separator);
                        sb.append(this.tryQuote(formatter.apply(table.get(0, row)), separator, quote));
                    }
                } else if (table.getColumnCount() > 0) {
                    sb.append(this.tryQuote(formatter.apply(table.get(0, row)), separator, quote));
                }
                for (int col = 1; col < table.getColumnCount(); ++col) {
                    formatter = this.getFormatter(options, col);
                    sb.append(separator);
                    sb.append(this.tryQuote(formatter.apply(table.get(col, row)), separator, quote));
                }
                sb.append(eol);
                handle.writeBytes(sb.toString());
                sb.setLength(0);
            }
        }
    }

    private Function<Object, String> getFormatter(TableIOOptions.Values options, int i) {
        ColumnTableIOOptions.Values columnOptions = options.column(i);
        if (columnOptions != null) {
            return columnOptions.formatter();
        }
        return options.formatter();
    }

    private String tryQuote(String str, char separator, char quote) {
        if (str == null || str.length() == 0) {
            return "" + quote + quote;
        }
        if (str.indexOf(quote) != -1) {
            return quote + str.replace("" + quote, "" + quote + quote) + quote;
        }
        if (str.indexOf(separator) != -1) {
            return quote + str + quote;
        }
        return str;
    }
}

