/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.kappa.gui;

import ij.CompositeImage;
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.Undo;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.gui.TrimmedButton;
import ij.measure.Calibration;
import ij.plugin.frame.PlugInFrame;
import ij.plugin.frame.Recorder;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.ShortProcessor;
import ij.process.StackStatistics;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Point;
import java.awt.Scrollbar;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import javax.swing.JPanel;
import sc.fiji.kappa.gui.ContrastPlot;
import sc.fiji.kappa.gui.KappaFrame;
import sc.fiji.kappa.gui.Panel;
import sc.fiji.kappa.gui.TrimmedLabel;

public class ContrastAdjuster
extends PlugInFrame
implements Runnable,
ActionListener,
AdjustmentListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    public static final String LOC_KEY = "b&c.loc";
    static final int AUTO_THRESHOLD = 5000;
    static final String[] channelLabels = new String[]{"Red", "Green", "Blue", "Cyan", "Magenta", "Yellow", "All"};
    static final int[] channelConstants = new int[]{4, 2, 1, 3, 5, 6, 7};
    private ContrastPlot plot = new ContrastPlot();
    private Thread thread;
    private static Frame instance;
    private int minSliderValue = -1;
    private int maxSliderValue = -1;
    private int brightnessValue = -1;
    private int contrastValue = -1;
    private int sliderRange = 256;
    private boolean doAutoAdjust;
    private boolean doReset;
    private boolean doSet;
    private boolean doApplyLut;
    private JPanel panel;
    private Panel tPanel;
    private Button autoB;
    private Button resetB;
    private int previousImageID;
    private int previousType;
    private int previousSlice = 1;
    private Object previousSnapshot;
    private ImageJ ij;
    private double min;
    private double max;
    private double previousMin;
    private double previousMax;
    private double defaultMin;
    private double defaultMax;
    private int contrast;
    private int brightness;
    private boolean RGBImage;
    private Scrollbar minSlider;
    private Scrollbar maxSlider;
    private Scrollbar contrastSlider;
    private Scrollbar brightnessSlider;
    private Label minLabel;
    private Label maxLabel;
    private Label windowLabel;
    private Label levelLabel;
    private boolean done;
    private int autoThreshold;
    private GridBagLayout gridbag;
    private GridBagConstraints c;
    private int y = 0;
    private boolean windowLevel;
    private boolean balance;
    private Font monoFont = new Font("Monospaced", 0, 12);
    private Font sanFont = new Font("SansSerif", 0, 12);
    private int channels = 7;
    private Choice choice;
    private KappaFrame frame;
    static final int RESET = 0;
    static final int AUTO = 1;
    static final int THRESHOLD = 4;
    static final int MIN = 5;
    static final int MAX = 6;
    static final int BRIGHTNESS = 7;
    static final int CONTRAST = 8;
    static final int UPDATE = 9;

    public ContrastAdjuster(KappaFrame frame) {
        super("B&C");
        this.frame = frame;
    }

    public void run(String arg) {
        this.windowLevel = arg.equals("wl");
        this.balance = arg.equals("balance");
        if (this.windowLevel) {
            this.setTitle("W&L");
        } else if (this.balance) {
            this.setTitle("Color");
            this.channels = 4;
        }
        if (instance != null) {
            if (!instance.getTitle().equals(this.getTitle())) {
                ContrastAdjuster ca = (ContrastAdjuster)((Object)instance);
                Prefs.saveLocation((String)LOC_KEY, (Point)ca.getLocation());
                ca.close();
            } else {
                WindowManager.toFront((Frame)instance);
                return;
            }
        }
        instance = this;
        IJ.register(ContrastAdjuster.class);
        WindowManager.addWindow((Frame)((Object)this));
        this.ij = IJ.getInstance();
        this.gridbag = new GridBagLayout();
        this.c = new GridBagConstraints();
        this.setLayout(this.gridbag);
        this.c.gridx = 0;
        this.y = 0;
        this.c.gridy = this.y++;
        this.c.fill = 1;
        this.c.anchor = 10;
        this.c.insets = new Insets(10, 10, 0, 10);
        this.gridbag.setConstraints(this.plot, this.c);
        this.add(this.plot);
        this.plot.addKeyListener((KeyListener)this.ij);
        if (!this.windowLevel) {
            this.panel = new JPanel();
            this.c.gridy = this.y++;
            this.c.insets = new Insets(0, 10, 0, 10);
            this.gridbag.setConstraints(this.panel, this.c);
            this.panel.setLayout(new BorderLayout());
            this.minLabel = new Label("      ", 0);
            this.minLabel.setFont(this.monoFont);
            this.panel.add("West", this.minLabel);
            this.maxLabel = new Label("      ", 2);
            this.maxLabel.setFont(this.monoFont);
            this.panel.add("East", this.maxLabel);
            this.add(this.panel);
        }
        if (!this.windowLevel) {
            this.minSlider = new Scrollbar(0, this.sliderRange / 2, 1, 0, this.sliderRange);
            this.c.gridy = this.y++;
            this.c.insets = new Insets(2, 10, 0, 10);
            this.gridbag.setConstraints(this.minSlider, this.c);
            this.add(this.minSlider);
            this.minSlider.addAdjustmentListener(this);
            this.minSlider.addKeyListener((KeyListener)this.ij);
            this.minSlider.setUnitIncrement(1);
            this.minSlider.setFocusable(false);
            this.addLabel("Minimum", null);
        }
        if (!this.windowLevel) {
            this.maxSlider = new Scrollbar(0, this.sliderRange / 2, 1, 0, this.sliderRange);
            this.c.gridy = this.y++;
            this.c.insets = new Insets(2, 10, 0, 10);
            this.gridbag.setConstraints(this.maxSlider, this.c);
            this.add(this.maxSlider);
            this.maxSlider.addAdjustmentListener(this);
            this.maxSlider.addKeyListener((KeyListener)this.ij);
            this.maxSlider.setUnitIncrement(1);
            this.maxSlider.setFocusable(false);
            this.addLabel("Maximum", null);
        }
        this.brightnessSlider = new Scrollbar(0, this.sliderRange / 2, 1, 0, this.sliderRange);
        this.c.gridy = this.y++;
        this.c.insets = new Insets(this.windowLevel ? 12 : 2, 10, 0, 10);
        this.gridbag.setConstraints(this.brightnessSlider, this.c);
        this.add(this.brightnessSlider);
        this.brightnessSlider.addAdjustmentListener(this);
        this.brightnessSlider.addKeyListener((KeyListener)this.ij);
        this.brightnessSlider.setUnitIncrement(1);
        this.brightnessSlider.setFocusable(false);
        if (this.windowLevel) {
            this.levelLabel = new TrimmedLabel("        ");
            this.addLabel("Level: ", this.levelLabel);
        } else {
            this.addLabel("Brightness", null);
        }
        if (!this.balance) {
            this.contrastSlider = new Scrollbar(0, this.sliderRange / 2, 1, 0, this.sliderRange);
            this.c.gridy = this.y++;
            this.c.insets = new Insets(2, 10, 0, 10);
            this.gridbag.setConstraints(this.contrastSlider, this.c);
            this.add(this.contrastSlider);
            this.contrastSlider.addAdjustmentListener(this);
            this.contrastSlider.addKeyListener((KeyListener)this.ij);
            this.contrastSlider.setUnitIncrement(1);
            this.contrastSlider.setFocusable(false);
            if (this.windowLevel) {
                this.windowLabel = new TrimmedLabel("        ");
                this.addLabel("Window: ", this.windowLabel);
            } else {
                this.addLabel("Contrast", null);
            }
        }
        int trim = IJ.isMacOSX() ? 20 : 0;
        this.panel = new JPanel();
        this.panel.setLayout(new GridLayout(0, 2, 0, 0));
        this.autoB = new TrimmedButton("Auto", trim);
        this.autoB.addActionListener(this);
        this.autoB.addKeyListener((KeyListener)this.ij);
        this.panel.add(this.autoB);
        this.resetB = new TrimmedButton("Reset", trim);
        this.resetB.addActionListener(this);
        this.resetB.addKeyListener((KeyListener)this.ij);
        this.panel.add(this.resetB);
        this.c.gridy = this.y++;
        this.c.insets = new Insets(8, 5, 10, 5);
        this.gridbag.setConstraints(this.panel, this.c);
        this.add(this.panel);
        this.addKeyListener((KeyListener)this.ij);
        this.pack();
        Point loc = Prefs.getLocation((String)LOC_KEY);
        if (loc != null) {
            this.setLocation(loc);
        } else {
            GUI.center((Window)((Object)this));
        }
        if (IJ.isMacOSX()) {
            this.setResizable(false);
        }
        this.setVisible(true);
        this.setAlwaysOnTop(true);
        this.thread = new Thread((Runnable)this, "ContrastAdjuster");
        this.thread.start();
        this.setup();
    }

    void addLabel(String text, Label label2) {
        if (label2 == null && IJ.isMacOSX()) {
            text = text + "    ";
        }
        this.panel = new JPanel();
        this.c.gridy = this.y++;
        int bottomInset = IJ.isMacOSX() ? 4 : 0;
        this.c.insets = new Insets(0, 10, bottomInset, 0);
        this.gridbag.setConstraints(this.panel, this.c);
        this.panel.setLayout(new FlowLayout(label2 == null ? 1 : 0, 0, 0));
        TrimmedLabel label = new TrimmedLabel(text);
        label.setFont(this.sanFont);
        this.panel.add(label);
        if (label2 != null) {
            label2.setFont(this.monoFont);
            label2.setAlignment(0);
            this.panel.add(label2);
        }
        this.add(this.panel);
    }

    void setup() {
        ImagePlus imp = this.frame.getDisplayedImageStack();
        if (imp != null) {
            this.setup(imp);
            this.updatePlot();
            this.updateLabels(imp);
            imp.updateAndDraw();
        }
    }

    @Override
    public synchronized void adjustmentValueChanged(AdjustmentEvent e) {
        Object source = e.getSource();
        if (source == this.minSlider) {
            this.minSliderValue = this.minSlider.getValue();
        } else if (source == this.maxSlider) {
            this.maxSliderValue = this.maxSlider.getValue();
        } else if (source == this.contrastSlider) {
            this.contrastValue = this.contrastSlider.getValue();
        } else {
            this.brightnessValue = this.brightnessSlider.getValue();
        }
        this.notify();
    }

    @Override
    public synchronized void actionPerformed(ActionEvent e) {
        Button b = (Button)e.getSource();
        if (b == null) {
            return;
        }
        if (b == this.resetB) {
            this.doReset = true;
        } else if (b == this.autoB) {
            this.doAutoAdjust = true;
        }
        this.notify();
    }

    ImageProcessor setup(ImagePlus imp) {
        boolean snapshotChanged;
        Roi roi = imp.getRoi();
        if (roi != null) {
            roi.endPaste();
        }
        ImageProcessor ip = imp.getProcessor();
        int type = imp.getType();
        int slice = imp.getCurrentSlice();
        this.RGBImage = type == 4;
        boolean bl = snapshotChanged = this.RGBImage && this.previousSnapshot != null && ((ColorProcessor)ip).getSnapshotPixels() != this.previousSnapshot;
        if (imp.getID() != this.previousImageID || snapshotChanged || type != this.previousType || slice != this.previousSlice) {
            this.setupNewImage(imp, ip);
        }
        this.previousImageID = imp.getID();
        this.previousType = type;
        this.previousSlice = slice;
        return ip;
    }

    void setupNewImage(ImagePlus imp, ImageProcessor ip) {
        Undo.reset();
        this.previousMin = this.min;
        this.previousMax = this.max;
        if (this.RGBImage) {
            ip.snapshot();
            this.previousSnapshot = ((ColorProcessor)ip).getSnapshotPixels();
        } else {
            this.previousSnapshot = null;
        }
        double min2 = imp.getDisplayRangeMin();
        double max2 = imp.getDisplayRangeMax();
        if (imp.getType() == 4) {
            min2 = 0.0;
            max2 = 255.0;
        }
        if (ip instanceof ShortProcessor || ip instanceof FloatProcessor) {
            imp.resetDisplayRange();
            this.defaultMin = imp.getDisplayRangeMin();
            this.defaultMax = imp.getDisplayRangeMax();
        } else {
            this.defaultMin = 0.0;
            this.defaultMax = 255.0;
        }
        this.setMinAndMax(imp, min2, max2);
        this.min = imp.getDisplayRangeMin();
        this.max = imp.getDisplayRangeMax();
        if (IJ.debugMode) {
            IJ.log((String)("min: " + this.min));
            IJ.log((String)("max: " + this.max));
            IJ.log((String)("defaultMin: " + this.defaultMin));
            IJ.log((String)("defaultMax: " + this.defaultMax));
        }
        this.plot.defaultMin = this.defaultMin;
        this.plot.defaultMax = this.defaultMax;
        int valueRange = (int)(this.defaultMax - this.defaultMin);
        int newSliderRange = valueRange;
        if (newSliderRange > 640 && newSliderRange < 1280) {
            newSliderRange /= 2;
        } else if (newSliderRange >= 1280) {
            newSliderRange /= 5;
        }
        if (newSliderRange < 256) {
            newSliderRange = 256;
        }
        if (newSliderRange > 1024) {
            newSliderRange = 1024;
        }
        double displayRange = this.max - this.min;
        if (valueRange >= 1280 && valueRange != 0 && displayRange / (double)valueRange < 0.25) {
            newSliderRange = (int)((double)newSliderRange * 1.6666);
        }
        if (newSliderRange != this.sliderRange) {
            this.sliderRange = newSliderRange;
            this.updateScrollBars(null, true);
        } else {
            this.updateScrollBars(null, false);
        }
        if (!this.doReset) {
            this.plotHistogram(imp);
        }
        this.autoThreshold = 0;
        if (imp.isComposite()) {
            IJ.setKeyUp((int)16);
        }
    }

    void setMinAndMax(ImagePlus imp, double min, double max) {
        boolean rgb;
        boolean bl = rgb = imp.getType() == 4;
        if (this.channels != 7 && rgb) {
            imp.setDisplayRange(min, max, this.channels);
        } else {
            imp.setDisplayRange(min, max);
        }
        if (!rgb) {
            imp.getProcessor().setSnapshotPixels(null);
        }
    }

    void updatePlot() {
        this.plot.min = this.min;
        this.plot.max = this.max;
        this.plot.repaint();
    }

    void updateLabels(ImagePlus imp) {
        int digits;
        boolean realValue;
        double min = imp.getDisplayRangeMin();
        double max = imp.getDisplayRangeMax();
        int type = imp.getType();
        Calibration cal = imp.getCalibration();
        boolean bl = realValue = type == 2;
        if (cal.calibrated()) {
            min = cal.getCValue((int)min);
            max = cal.getCValue((int)max);
            if (type != 1) {
                realValue = true;
            }
        }
        int n = digits = realValue ? 2 : 0;
        if (this.windowLevel) {
            double window = max - min;
            double level = min + window / 2.0;
            this.windowLabel.setText(IJ.d2s((double)window, (int)digits));
            this.levelLabel.setText(IJ.d2s((double)level, (int)digits));
        } else {
            this.minLabel.setText(IJ.d2s((double)min, (int)digits));
            this.maxLabel.setText(IJ.d2s((double)max, (int)digits));
        }
    }

    void updateScrollBars(Scrollbar sb, boolean newRange) {
        if (sb == null || sb != this.contrastSlider) {
            double mid = this.sliderRange / 2;
            double c = (this.defaultMax - this.defaultMin) / (this.max - this.min) * mid;
            if (c > mid) {
                c = (double)this.sliderRange - (this.max - this.min) / (this.defaultMax - this.defaultMin) * mid;
            }
            this.contrast = (int)c;
            if (this.contrastSlider != null) {
                if (newRange) {
                    this.contrastSlider.setValues(this.contrast, 1, 0, this.sliderRange);
                } else {
                    this.contrastSlider.setValue(this.contrast);
                }
            }
        }
        if (sb == null || sb != this.brightnessSlider) {
            double level = this.min + (this.max - this.min) / 2.0;
            double normalizedLevel = 1.0 - (level - this.defaultMin) / (this.defaultMax - this.defaultMin);
            this.brightness = (int)(normalizedLevel * (double)this.sliderRange);
            if (newRange) {
                this.brightnessSlider.setValues(this.brightness, 1, 0, this.sliderRange);
            } else {
                this.brightnessSlider.setValue(this.brightness);
            }
        }
        if (this.minSlider != null && (sb == null || sb != this.minSlider)) {
            if (newRange) {
                this.minSlider.setValues(this.scaleDown(this.min), 1, 0, this.sliderRange);
            } else {
                this.minSlider.setValue(this.scaleDown(this.min));
            }
        }
        if (this.maxSlider != null && (sb == null || sb != this.maxSlider)) {
            if (newRange) {
                this.maxSlider.setValues(this.scaleDown(this.max), 1, 0, this.sliderRange);
            } else {
                this.maxSlider.setValue(this.scaleDown(this.max));
            }
        }
    }

    int scaleDown(double v) {
        if (v < this.defaultMin) {
            v = this.defaultMin;
        }
        if (v > this.defaultMax) {
            v = this.defaultMax;
        }
        return (int)((v - this.defaultMin) * ((double)this.sliderRange - 1.0) / (this.defaultMax - this.defaultMin));
    }

    void doMasking(ImagePlus imp, ImageProcessor ip) {
        ImageProcessor mask = imp.getMask();
        if (mask != null) {
            ip.reset(mask);
        }
    }

    void adjustMin(ImagePlus imp, ImageProcessor ip, double minvalue) {
        this.min = this.defaultMin + minvalue * (this.defaultMax - this.defaultMin) / ((double)this.sliderRange - 1.0);
        if (this.max > this.defaultMax) {
            this.max = this.defaultMax;
        }
        if (this.min > this.max) {
            this.max = this.min;
        }
        this.setMinAndMax(imp, this.min, this.max);
        if (this.min == this.max) {
            this.setThreshold(ip);
        }
        if (this.RGBImage) {
            this.doMasking(imp, ip);
        }
        this.updateScrollBars(this.minSlider, false);
    }

    void adjustMax(ImagePlus imp, ImageProcessor ip, double maxvalue) {
        this.max = this.defaultMin + maxvalue * (this.defaultMax - this.defaultMin) / ((double)this.sliderRange - 1.0);
        if (this.min < this.defaultMin) {
            this.min = this.defaultMin;
        }
        if (this.max < this.min) {
            this.min = this.max;
        }
        this.setMinAndMax(imp, this.min, this.max);
        if (this.min == this.max) {
            this.setThreshold(ip);
        }
        if (this.RGBImage) {
            this.doMasking(imp, ip);
        }
        this.updateScrollBars(this.maxSlider, false);
    }

    void adjustBrightness(ImagePlus imp, ImageProcessor ip, double bvalue) {
        double center = this.defaultMin + (this.defaultMax - this.defaultMin) * (((double)this.sliderRange - bvalue) / (double)this.sliderRange);
        double width = this.max - this.min;
        this.min = center - width / 2.0;
        this.max = center + width / 2.0;
        this.setMinAndMax(imp, this.min, this.max);
        if (this.min == this.max) {
            this.setThreshold(ip);
        }
        if (this.RGBImage) {
            this.doMasking(imp, ip);
        }
        this.updateScrollBars(this.brightnessSlider, false);
    }

    void adjustContrast(ImagePlus imp, ImageProcessor ip, int cvalue) {
        double center = this.min + (this.max - this.min) / 2.0;
        double range = this.defaultMax - this.defaultMin;
        double mid = this.sliderRange / 2;
        double slope = (double)cvalue <= mid ? (double)cvalue / mid : mid / (double)(this.sliderRange - cvalue);
        if (slope > 0.0) {
            this.min = center - 0.5 * range / slope;
            this.max = center + 0.5 * range / slope;
        }
        this.setMinAndMax(imp, this.min, this.max);
        if (this.RGBImage) {
            this.doMasking(imp, ip);
        }
        this.updateScrollBars(this.contrastSlider, false);
    }

    void reset(ImagePlus imp, ImageProcessor ip) {
        if (this.RGBImage) {
            ip.reset();
        }
        if (ip instanceof ShortProcessor || ip instanceof FloatProcessor) {
            imp.resetDisplayRange();
            this.defaultMin = imp.getDisplayRangeMin();
            this.defaultMax = imp.getDisplayRangeMax();
            this.plot.defaultMin = this.defaultMin;
            this.plot.defaultMax = this.defaultMax;
        }
        this.min = this.defaultMin;
        this.max = this.defaultMax;
        this.setMinAndMax(imp, this.min, this.max);
        this.updateScrollBars(null, false);
        this.plotHistogram(imp);
        this.autoThreshold = 0;
    }

    void plotHistogram(ImagePlus imp) {
        ImageStatistics stats;
        if (this.balance && (this.channels == 4 || this.channels == 2 || this.channels == 1) && imp.getType() == 4) {
            int w = imp.getWidth();
            int h = imp.getHeight();
            byte[] r = new byte[w * h];
            byte[] g = new byte[w * h];
            byte[] b = new byte[w * h];
            ((ColorProcessor)imp.getProcessor()).getRGB(r, g, b);
            byte[] pixels = null;
            if (this.channels == 4) {
                pixels = r;
            } else if (this.channels == 2) {
                pixels = g;
            } else if (this.channels == 1) {
                pixels = b;
            }
            ByteProcessor ip = new ByteProcessor(w, h, pixels, null);
            stats = ImageStatistics.getStatistics((ImageProcessor)ip, (int)0, (Calibration)imp.getCalibration());
        } else {
            int range;
            int n = range = imp.getType() == 1 ? ImagePlus.getDefault16bitRange() : 0;
            if (range != 0 && imp.getProcessor().getMax() == Math.pow(2.0, range) - 1.0 && !imp.getCalibration().isSigned16Bit()) {
                ImagePlus imp2 = new ImagePlus("Temp", imp.getProcessor());
                stats = new StackStatistics(imp2, 256, 0.0, Math.pow(2.0, range));
            } else {
                stats = imp.getStatistics();
            }
        }
        Color color = Color.gray;
        if (imp.isComposite() && (!this.balance || this.channels != 7)) {
            color = ((CompositeImage)imp).getChannelColor();
        }
        this.plot.setHistogram(stats, color);
    }

    void setThreshold(ImageProcessor ip) {
        if (!(ip instanceof ByteProcessor)) {
            return;
        }
        if (((ByteProcessor)ip).isInvertedLut()) {
            ip.setThreshold(this.max, 255.0, 2);
        } else {
            ip.setThreshold(0.0, this.max, 2);
        }
    }

    void autoAdjust(ImagePlus imp, ImageProcessor ip) {
        int count;
        if (this.RGBImage) {
            ip.reset();
        }
        Calibration cal = imp.getCalibration();
        imp.setCalibration(null);
        ImageStatistics stats = imp.getStatistics();
        imp.setCalibration(cal);
        int limit = stats.pixelCount / 10;
        int[] histogram = stats.histogram;
        this.autoThreshold = this.autoThreshold < 10 ? 5000 : (this.autoThreshold /= 2);
        int threshold = stats.pixelCount / this.autoThreshold;
        int i = -1;
        boolean found = false;
        do {
            if ((count = histogram[++i]) > limit) {
                count = 0;
            }
            boolean bl = found = count > threshold;
        } while (!found && i < 255);
        int hmin = i;
        i = 256;
        do {
            if ((count = histogram[--i]) > limit) {
                count = 0;
            }
            boolean bl = found = count > threshold;
        } while (!found && i > 0);
        int hmax = i;
        Roi roi = imp.getRoi();
        if (hmax >= hmin) {
            if (this.RGBImage) {
                imp.deleteRoi();
            }
            this.min = stats.histMin + (double)hmin * stats.binSize;
            this.max = stats.histMin + (double)hmax * stats.binSize;
            if (this.min == this.max) {
                this.min = stats.min;
                this.max = stats.max;
            }
            this.setMinAndMax(imp, this.min, this.max);
            if (this.RGBImage && roi != null) {
                imp.setRoi(roi);
            }
        } else {
            this.reset(imp, ip);
            return;
        }
        this.updateScrollBars(null, false);
        if (Recorder.record) {
            if (Recorder.scriptMode()) {
                Recorder.recordCall((String)"IJ.run(imp, \"Enhance Contrast\", \"saturated=0.35\");");
            } else {
                Recorder.record((String)"run", (String)"Enhance Contrast", (String)"saturated=0.35");
            }
        }
    }

    public static int get16bitRangeIndex() {
        int range = ImagePlus.getDefault16bitRange();
        int index = 0;
        if (range == 8) {
            index = 1;
        } else if (range == 10) {
            index = 2;
        } else if (range == 12) {
            index = 3;
        } else if (range == 15) {
            index = 4;
        } else if (range == 16) {
            index = 5;
        }
        return index;
    }

    public int set16bitRange(int index) {
        int range = 0;
        if (index == 1) {
            range = 8;
        } else if (index == 2) {
            range = 10;
        } else if (index == 3) {
            range = 12;
        } else if (index == 4) {
            range = 15;
        } else if (index == 5) {
            range = 16;
        }
        ImagePlus.setDefault16bitRange((int)range);
        return range;
    }

    void setWindowLevel(ImagePlus imp, ImageProcessor ip) {
        this.min = imp.getDisplayRangeMin();
        this.max = imp.getDisplayRangeMax();
        Calibration cal = imp.getCalibration();
        int digits = ip instanceof FloatProcessor || cal.calibrated() ? 2 : 0;
        double minValue = cal.getCValue(this.min);
        double maxValue = cal.getCValue(this.max);
        double windowValue = maxValue - minValue;
        double levelValue = minValue + windowValue / 2.0;
        GenericDialog gd = new GenericDialog("Set W&L");
        gd.addNumericField("Window Center (Level): ", levelValue, digits);
        gd.addNumericField("Window Width: ", windowValue, digits);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        levelValue = gd.getNextNumber();
        windowValue = gd.getNextNumber();
        minValue = levelValue - windowValue / 2.0;
        maxValue = levelValue + windowValue / 2.0;
        minValue = cal.getRawValue(minValue);
        if ((maxValue = cal.getRawValue(maxValue)) >= minValue) {
            this.min = minValue;
            this.max = maxValue;
            this.setMinAndMax(imp, minValue, maxValue);
            this.updateScrollBars(null, false);
            if (this.RGBImage) {
                this.doMasking(imp, ip);
            }
            if (Recorder.record) {
                if (imp.getBitDepth() == 32) {
                    this.recordSetMinAndMax(this.min, this.max);
                } else {
                    int imin = (int)this.min;
                    int imax = (int)this.max;
                    if (cal.isSigned16Bit()) {
                        imin = (int)cal.getCValue(imin);
                        imax = (int)cal.getCValue(imax);
                    }
                    this.recordSetMinAndMax(imin, imax);
                }
            }
        }
    }

    void recordSetMinAndMax(double min, double max) {
        if ((double)((int)min) == min && (double)((int)max) == max) {
            int imin = (int)min;
            int imax = (int)max;
            if (Recorder.scriptMode()) {
                Recorder.recordCall((String)("IJ.setMinAndMax(imp, " + imin + ", " + imax + ");"));
            } else {
                Recorder.record((String)"setMinAndMax", (int)imin, (int)imax);
            }
        } else if (Recorder.scriptMode()) {
            Recorder.recordCall((String)("IJ.setMinAndMax(imp, " + min + ", " + max + ");"));
        } else {
            Recorder.record((String)"setMinAndMax", (double)min, (double)max);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.done) {
            ContrastAdjuster contrastAdjuster = this;
            synchronized (contrastAdjuster) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.doUpdate();
        }
    }

    void doUpdate() {
        int action;
        int minvalue = this.minSliderValue;
        int maxvalue = this.maxSliderValue;
        int bvalue = this.brightnessValue;
        int cvalue = this.contrastValue;
        if (this.doReset) {
            action = 0;
        } else if (this.doAutoAdjust) {
            action = 1;
        } else if (this.minSliderValue >= 0) {
            action = 5;
        } else if (this.maxSliderValue >= 0) {
            action = 6;
        } else if (this.brightnessValue >= 0) {
            action = 7;
        } else if (this.contrastValue >= 0) {
            action = 8;
        } else {
            return;
        }
        this.contrastValue = -1;
        this.brightnessValue = -1;
        this.maxSliderValue = -1;
        this.minSliderValue = -1;
        this.doApplyLut = false;
        this.doSet = false;
        this.doAutoAdjust = false;
        this.doReset = false;
        ImagePlus imp = this.frame.getDisplayedImageStack();
        if (imp == null) {
            IJ.beep();
            IJ.showStatus((String)"No image");
            return;
        }
        ImageProcessor ip = imp.getProcessor();
        if (this.RGBImage && !imp.lock()) {
            imp = null;
            return;
        }
        switch (action) {
            case 0: {
                this.reset(imp, ip);
                if (!Recorder.record) break;
                if (Recorder.scriptMode()) {
                    Recorder.recordCall((String)"IJ.resetMinAndMax(imp);");
                    break;
                }
                Recorder.record((String)"resetMinAndMax");
                break;
            }
            case 1: {
                this.autoAdjust(imp, ip);
                break;
            }
            case 5: {
                this.adjustMin(imp, ip, minvalue);
                break;
            }
            case 6: {
                this.adjustMax(imp, ip, maxvalue);
                break;
            }
            case 7: {
                this.adjustBrightness(imp, ip, bvalue);
                break;
            }
            case 8: {
                this.adjustContrast(imp, ip, cvalue);
            }
        }
        this.updatePlot();
        this.updateLabels(imp);
        if ((IJ.shiftKeyDown() || this.balance && this.channels == 7) && imp.isComposite()) {
            ((CompositeImage)imp).updateAllChannelsAndDraw();
        } else {
            imp.updateChannelAndDraw();
        }
        if (this.RGBImage) {
            imp.unlock();
        }
        this.frame.setCurrImage(this.frame.getDisplayedImageStack().getBufferedImage());
        this.frame.setScaledImage((double)this.frame.getControlPanel().getScaleSlider().getValue() / 100.0);
        this.frame.drawImageOverlay();
        this.frame.getCurves().updateIntensities();
        this.frame.updateDisplayed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        super.close();
        instance = null;
        this.done = true;
        Prefs.saveLocation((String)LOC_KEY, (Point)this.getLocation());
        ContrastAdjuster contrastAdjuster = this;
        synchronized (contrastAdjuster) {
            this.notify();
        }
    }

    public void windowActivated(WindowEvent e) {
        ImagePlus imp2;
        super.windowActivated(e);
        if (IJ.isMacro() && (imp2 = this.frame.getDisplayedImageStack()) != null && imp2.getBitDepth() == 24) {
            return;
        }
        this.previousImageID = 0;
        this.setup();
        WindowManager.setWindow((Frame)((Object)this));
    }

    @Override
    public synchronized void itemStateChanged(ItemEvent e) {
        int index = this.choice.getSelectedIndex();
        this.channels = channelConstants[index];
        ImagePlus imp = this.frame.getDisplayedImageStack();
        if (imp != null && imp.isComposite()) {
            if (index + 1 <= imp.getNChannels()) {
                imp.setPosition(index + 1, imp.getSlice(), imp.getFrame());
            } else {
                this.choice.select(channelLabels.length - 1);
                this.channels = 7;
            }
        } else {
            this.doReset = true;
        }
        this.notify();
    }

    public void updateAndDraw() {
        this.previousImageID = 0;
        this.toFront();
    }

    public static void update() {
        if (instance != null) {
            ContrastAdjuster ca = (ContrastAdjuster)((Object)instance);
            ca.previousImageID = 0;
            ca.setup();
        }
    }
}

