/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.kappa.curve;

import Jama.Matrix;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import sc.fiji.kappa.curve.BezierCurve;
import sc.fiji.kappa.curve.BezierPoint;
import sc.fiji.kappa.curve.Curve;
import sc.fiji.kappa.gui.KappaFrame;
import sc.fiji.kappa.gui.KappaMenuBar;

public class BSpline
extends Curve {
    private double[] knotVector;
    private boolean isOpen;
    private BezierCurve[] spline;
    private int noCurves;
    public static final int B_SPLINE_DEGREE = 3;
    public static final int OPEN = 0;
    public static final int CLOSED = 1;
    public static final int DEFAULT_BSPLINE_TYPE = 0;
    public static final double SMOOTHNESS_FACTOR = 10.0;
    private int[] oldFootpoints;
    private Point2D[] dataPointsCopy;

    public BSpline(List<Point2D> bsplineCtrlPts, int t, int noCtrlPts, String name, boolean open, int dataRadius, KappaFrame frame) {
        super(bsplineCtrlPts, t, noCtrlPts, name, dataRadius, frame);
        this.isOpen = open;
        this.minimumGlobalError = Double.MAX_VALUE;
        this.minimumLocalError = Double.MAX_VALUE;
        int n = 3;
        this.noCurves = open ? noCtrlPts - n : noCtrlPts;
        this.spline = new BezierCurve[this.noCurves];
        this.computeSpline(bsplineCtrlPts, t);
        this.evaluateThresholdedPixels();
    }

    public void computeSpline(List<Point2D> bsplineCtrlPts, int t) {
        int n = 3;
        this.knotVector = new double[2 * n + this.noCurves - 1];
        if (this.isOpen) {
            for (int start = 0; start < n; ++start) {
                this.knotVector[start] = 0.0;
            }
            for (int middle = n; middle < this.knotVector.length - n; ++middle) {
                this.knotVector[middle] = middle - n + 1;
            }
            for (int end = this.knotVector.length - n; end < this.knotVector.length; ++end) {
                this.knotVector[end] = this.noCurves;
            }
            for (int i = 0; i < this.knotVector.length; ++i) {
                this.knotVector[i] = this.knotVector[i] / this.knotVector[this.knotVector.length - 1];
            }
            this.fillPoints(bsplineCtrlPts, t);
        } else {
            int i;
            for (i = 0; i < this.knotVector.length; ++i) {
                this.knotVector[i] = i;
            }
            for (i = 0; i < this.knotVector.length; ++i) {
                this.knotVector[i] = this.knotVector[i] / this.knotVector[this.knotVector.length - 1];
            }
            for (i = 0; i < 3; ++i) {
                this.ctrlPts.add(new Point2D.Double(bsplineCtrlPts.get(i).getX(), bsplineCtrlPts.get(i).getY()));
            }
            this.noCtrlPts += n;
            this.fillPoints(this.ctrlPts, t);
            this.getKeyframes().add(new Curve.BControlPoints(this.ctrlPts, t));
        }
    }

    public void convertToOpen(int t) {
        int i;
        if (this.isOpen) {
            return;
        }
        int n = 3;
        this.noCurves -= 3;
        this.noCtrlPts -= n;
        this.spline = new BezierCurve[this.noCurves];
        for (i = 0; i < 3; ++i) {
            this.ctrlPts.remove(this.ctrlPts.size() - 1);
        }
        this.knotVector = new double[2 * n + this.noCurves - 1];
        for (int start = 0; start < n; ++start) {
            this.knotVector[start] = 0.0;
        }
        for (int middle = n; middle < this.knotVector.length - n; ++middle) {
            this.knotVector[middle] = middle - n + 1;
        }
        for (int end = this.knotVector.length - n; end < this.knotVector.length; ++end) {
            this.knotVector[end] = this.noCurves;
        }
        for (i = 0; i < this.knotVector.length; ++i) {
            this.knotVector[i] = this.knotVector[i] / this.knotVector[this.knotVector.length - 1];
        }
        this.isOpen = !this.isOpen;
        this.fillPoints(this.ctrlPts, t);
        this.getKeyframes().add(new Curve.BControlPoints(this.ctrlPts, t));
    }

    public void convertToClosed(int t) {
        int i;
        if (!this.isOpen) {
            return;
        }
        int n = 3;
        this.noCurves += 3;
        this.noCtrlPts += n;
        this.spline = new BezierCurve[this.noCurves];
        this.knotVector = new double[2 * n + this.noCurves - 1];
        for (i = 0; i < this.knotVector.length; ++i) {
            this.knotVector[i] = i;
        }
        for (i = 0; i < this.knotVector.length; ++i) {
            this.knotVector[i] = this.knotVector[i] / this.knotVector[this.knotVector.length - 1];
        }
        for (i = 0; i < 3; ++i) {
            this.ctrlPts.add(new Point2D.Double(((Point2D)this.ctrlPts.get(i)).getX(), ((Point2D)this.ctrlPts.get(i)).getY()));
        }
        this.isOpen = !this.isOpen;
        this.fillPoints(this.ctrlPts, t);
        this.getKeyframes().add(new Curve.BControlPoints(this.ctrlPts, t));
    }

    @Override
    protected List<Point2D> generateOffsetBounds(List<Point2D> bounds, int radius) {
        int i;
        bounds = new ArrayList<Point2D>();
        for (i = 0; i < this.noCurves; ++i) {
            this.spline[i].generateRightOffsetCurve(bounds, radius);
        }
        if (this.isOpen) {
            this.spline[this.noCurves - 1].generateRightCap(bounds, radius);
        }
        for (i = this.noCurves - 1; i >= 0; --i) {
            this.spline[i].generateLeftOffsetCurve(bounds, radius);
        }
        if (this.isOpen) {
            this.spline[0].generateLeftCap(bounds, radius);
        }
        return bounds;
    }

    @Override
    protected void fillPoints(List<Point2D> bsplineCtrlPts, int t) {
        Point2D[] arrayCtrlPts = new Point2D[bsplineCtrlPts.size()];
        for (int i = 0; i < arrayCtrlPts.length; ++i) {
            arrayCtrlPts[i] = bsplineCtrlPts.get(i);
        }
        this.fillPoints(arrayCtrlPts, t);
    }

    private Point2D subtract(Point2D v1, Point2D v2) {
        return new Point2D.Double(v1.getX() - v2.getX(), v1.getY() - v2.getY());
    }

    private Point2D multiply(Point2D v, double d) {
        return new Point2D.Double(v.getX() * d, v.getY() * d);
    }

    private Point2D add(Point2D v1, Point2D v2) {
        return new Point2D.Double(v1.getX() + v2.getX(), v1.getY() + v2.getY());
    }

    protected void fillPoints(Point2D[] bsplineCtrlPts, int t) {
        for (int i = 0; i < this.noCurves; ++i) {
            Point2D.Double[] bezierCtrlPts = new Point2D.Double[4];
            double scaleFactor = (this.knotVector[i + 2] - this.knotVector[i + 1]) / (this.knotVector[i + 4] - this.knotVector[i + 1]);
            bezierCtrlPts[1] = this.add(this.multiply(this.subtract(bsplineCtrlPts[i + 2], bsplineCtrlPts[i + 1]), scaleFactor), bsplineCtrlPts[i + 1]);
            scaleFactor = (this.knotVector[i + 3] - this.knotVector[i + 1]) / (this.knotVector[i + 4] - this.knotVector[i + 1]);
            bezierCtrlPts[2] = this.add(this.multiply(this.subtract(bsplineCtrlPts[i + 2], bsplineCtrlPts[i + 1]), scaleFactor), bsplineCtrlPts[i + 1]);
            scaleFactor = (this.knotVector[i + 2] - this.knotVector[i]) / (this.knotVector[i + 3] - this.knotVector[i]);
            Point2D tempPoint = this.add(this.multiply(this.subtract(bsplineCtrlPts[i + 1], bsplineCtrlPts[i]), scaleFactor), bsplineCtrlPts[i]);
            scaleFactor = (this.knotVector[i + 2] - this.knotVector[i + 1]) / (this.knotVector[i + 3] - this.knotVector[i + 1]);
            bezierCtrlPts[0] = this.add(this.multiply(this.subtract(bezierCtrlPts[1], tempPoint), scaleFactor), tempPoint);
            scaleFactor = (this.knotVector[i + 3] - this.knotVector[i + 2]) / (this.knotVector[i + 5] - this.knotVector[i + 2]);
            tempPoint = this.add(this.multiply(this.subtract(bsplineCtrlPts[i + 3], bsplineCtrlPts[i + 2]), scaleFactor), bsplineCtrlPts[i + 2]);
            scaleFactor = (this.knotVector[i + 3] - this.knotVector[i + 2]) / (this.knotVector[i + 4] - this.knotVector[i + 2]);
            bezierCtrlPts[3] = this.add(this.multiply(this.subtract(tempPoint, bezierCtrlPts[2]), scaleFactor), bezierCtrlPts[2]);
            ArrayList<Point2D> bCtrlPtsArray = new ArrayList<Point2D>(bezierCtrlPts.length);
            for (Point2D.Double p : bezierCtrlPts) {
                bCtrlPtsArray.add(p);
            }
            this.spline[i] = new BezierCurve(bCtrlPtsArray, t, 4, this.name, this.dataRadius, this.frame);
            this.spline[i].setSelected(this.isSelected());
        }
        this.bounds = this.generateOffsetBounds(this.bounds, 5);
        this.dataFittingBounds = this.generateOffsetBounds(this.dataFittingBounds, this.dataRadius);
    }

    protected double squaredDistanceErrorTerm(List<Point2D> dataPoints, int datapointIndex, int footpointIndex) {
        BezierPoint p = this.getSpecificPoint(footpointIndex);
        Point2D x = dataPoints.get(datapointIndex);
        Point2D.Double diff = new Point2D.Double(p.getX() - x.getX(), p.getY() - x.getY());
        double d = (double)this.getDistanceSign(footpointIndex, x) * Math.sqrt(this.squared(((Point2D)diff).getX()) + this.squared(((Point2D)diff).getY()));
        double k = this.getSpecificPoint((int)footpointIndex).k;
        Point2D.Double T = this.getUnitTangent(footpointIndex);
        Point2D.Double N = this.getUnitNormal(footpointIndex);
        if (d < 0.0) {
            return d / (d - k) * (this.squared(((Point2D)diff).getX() * ((Point2D)T).getX() + ((Point2D)diff).getY() * ((Point2D)T).getY()) + this.squared(((Point2D)diff).getX() * ((Point2D)N).getX() + ((Point2D)diff).getY() * ((Point2D)N).getY()));
        }
        return this.squared(((Point2D)diff).getX() * ((Point2D)N).getX() + ((Point2D)diff).getY() * ((Point2D)N).getY());
    }

    @Override
    public Point2D.Double getUnitTangent(int footpointIndex) {
        int n = (this.noCurves * BezierCurve.NO_CURVE_POINTS - 1) * footpointIndex / this.getNoPoints();
        return this.spline[n / BezierCurve.NO_CURVE_POINTS].getUnitTangent(n % BezierCurve.NO_CURVE_POINTS);
    }

    @Override
    public Point2D.Double getUnitNormal(int footpointIndex) {
        int n = (this.noCurves * BezierCurve.NO_CURVE_POINTS - 1) * footpointIndex / this.getNoPoints();
        return this.spline[n / BezierCurve.NO_CURVE_POINTS].getUnitNormal(n % BezierCurve.NO_CURVE_POINTS);
    }

    @Override
    public int getSign(int footpointIndex) {
        int n = (this.noCurves * BezierCurve.NO_CURVE_POINTS - 1) * footpointIndex / this.getNoPoints();
        return this.spline[n / BezierCurve.NO_CURVE_POINTS].getSign(n % BezierCurve.NO_CURVE_POINTS);
    }

    int getDistanceSign(int footpointIndex, Point2D x) {
        int n = (this.noCurves * BezierCurve.NO_CURVE_POINTS - 1) * footpointIndex / this.getNoPoints();
        return this.spline[n / BezierCurve.NO_CURVE_POINTS].getDistanceSign(n % BezierCurve.NO_CURVE_POINTS, x);
    }

    private double squared(double x) {
        return x * x;
    }

    private int[] getFootpoints(List<Point2D> dataPoints) {
        if (dataPoints.size() == 0) {
            return new int[0];
        }
        int[] footpointIndices = new int[dataPoints.size()];
        for (int n = 0; n < dataPoints.size(); ++n) {
            int minIndex = 0;
            double minDistance = Double.MAX_VALUE;
            for (int i = 0; i < this.getNoPoints(); ++i) {
                double dist = Math.sqrt(this.squared(this.getSpecificPoint(i).getX() - dataPoints.get(n).getX()) + this.squared(this.getSpecificPoint(i).getY() - dataPoints.get(n).getY()));
                if (!(dist < minDistance)) continue;
                minDistance = dist;
                minIndex = i;
            }
            footpointIndices[n] = minIndex;
        }
        boolean[] referenced = new boolean[this.noCurves];
        for (int footpointIndex : footpointIndices) {
            int curve = footpointIndex / BezierCurve.NO_CURVE_POINTS;
            if (curve == this.noCurves) {
                --curve;
            }
            referenced[curve] = true;
        }
        for (int i = 0; i < referenced.length; ++i) {
            if (referenced[i]) continue;
            int assignIndex = i * BezierCurve.NO_CURVE_POINTS + BezierCurve.NO_CURVE_POINTS / 2;
            int dataIndex = 0;
            double minDistance = Double.MAX_VALUE;
            for (int n = 0; n < dataPoints.size(); ++n) {
                double dist = Math.sqrt(this.squared(this.getSpecificPoint(assignIndex).getX() - dataPoints.get(n).getX()) + this.squared(this.getSpecificPoint(assignIndex).getY() - dataPoints.get(n).getY()));
                if (!(dist < minDistance)) continue;
                minDistance = dist;
                dataIndex = n;
            }
            footpointIndices[dataIndex] = assignIndex;
        }
        return footpointIndices;
    }

    public double fittingIteration(List<Point2D> dataPoints, List<Double> weights, int t) {
        return this.fittingIteration(dataPoints, this.getFootpoints(dataPoints), weights, t);
    }

    public double fittingIteration(List<Point2D> dataPoints, int[] footpointIndices, List<Double> weights, int t) {
        double newLocalError;
        double weighting;
        int i;
        double oldLocalError;
        if (dataPoints.size() == 0) {
            return 0.0;
        }
        double oldError = this.evaluateGlobalError(dataPoints, weights);
        if (oldError / (double)this.getNoPoints() < this.minimumGlobalError) {
            this.minimumGlobalError = oldError / (double)this.getNoPoints();
        }
        if ((oldLocalError = this.evaluateMaxLocalError(dataPoints, weights)) / (double)BezierCurve.NO_CURVE_POINTS < this.minimumLocalError) {
            this.minimumLocalError = oldLocalError / (double)BezierCurve.NO_CURVE_POINTS;
        }
        ArrayList<Point2D> oldCtrlPts = new ArrayList<Point2D>(this.ctrlPts.size());
        for (Point2D p : this.ctrlPts) {
            oldCtrlPts.add(p);
        }
        double[][] xvals = new double[dataPoints.size()][1];
        double[][] yvals = new double[dataPoints.size()][1];
        if (this.frame.getFittingAlgorithm().equals(KappaFrame.FITTING_ALGORITHMS[0])) {
            for (i = 0; i < dataPoints.size(); ++i) {
                weighting = weights != null ? Math.sqrt(weights.get(i)) : 1.0;
                xvals[i][0] = weighting * dataPoints.get(i).getX();
                yvals[i][0] = weighting * dataPoints.get(i).getY();
            }
        } else if (this.frame.getFittingAlgorithm().equals(KappaFrame.FITTING_ALGORITHMS[1])) {
            for (i = 0; i < dataPoints.size(); ++i) {
                weighting = weights != null ? Math.sqrt(weights.get(i)) : 1.0;
                double sdterm = this.squaredDistanceErrorTerm(dataPoints, i, footpointIndices[i]);
                xvals[i][0] = this.getSpecificPoint(footpointIndices[i]).getX() < dataPoints.get(i).getX() ? weighting * (this.getSpecificPoint(footpointIndices[i]).getX() + Math.sqrt(sdterm / 2.0)) : weighting * (this.getSpecificPoint(footpointIndices[i]).getX() - Math.sqrt(sdterm / 2.0));
                yvals[i][0] = this.getSpecificPoint(footpointIndices[i]).getY() < dataPoints.get(i).getY() ? weighting * (this.getSpecificPoint(footpointIndices[i]).getY() + Math.sqrt(sdterm / 2.0)) : weighting * (this.getSpecificPoint(footpointIndices[i]).getY() - Math.sqrt(sdterm / 2.0));
            }
        }
        Matrix X = new Matrix(xvals);
        Matrix Y = new Matrix(yvals);
        int m = dataPoints.size();
        int n = this.noCtrlPts;
        if (!this.isOpen) {
            n = this.noCtrlPts - 3;
        }
        double[][] vals = new double[m][n];
        for (int r = 0; r < m; ++r) {
            double[] coefficients = this.evaluateBasisFunction(footpointIndices[r]);
            for (int c = 0; c < n; ++c) {
                vals[r][c] = Math.sqrt(weights.get(r)) * coefficients[c];
            }
        }
        Matrix A = new Matrix(vals);
        Matrix ATA = A.transpose().times(A);
        ATA = ATA.plus(Matrix.identity((int)n, (int)n).times(10.0));
        Matrix X1 = ATA.solve(A.transpose().times(X));
        Matrix Y1 = ATA.solve(A.transpose().times(Y));
        ArrayList<Point2D.Double> newCtrlPts = new ArrayList<Point2D.Double>(this.noCtrlPts);
        for (int i2 = 0; i2 < n; ++i2) {
            newCtrlPts.add(new Point2D.Double(X1.get(i2, 0), Y1.get(i2, 0)));
        }
        this.ctrlPts = newCtrlPts;
        this.fillPoints(this.ctrlPts, t);
        double newError = this.evaluateGlobalError(dataPoints, weights);
        if (newError / (double)this.getNoPoints() < this.minimumGlobalError) {
            this.minimumGlobalError = newError / (double)this.getNoPoints();
        }
        if ((newLocalError = this.evaluateMaxLocalError(dataPoints, weights)) / (double)BezierCurve.NO_CURVE_POINTS < this.minimumLocalError) {
            this.minimumLocalError = newLocalError / (double)BezierCurve.NO_CURVE_POINTS;
        }
        if (newError >= oldError) {
            this.ctrlPts = oldCtrlPts;
            this.fillPoints(this.ctrlPts, t);
            this.getKeyframes().add(new Curve.BControlPoints(this.ctrlPts, t));
            return oldError / (double)this.getNoPoints();
        }
        this.getKeyframes().add(new Curve.BControlPoints(this.ctrlPts, t));
        return newError / (double)this.getNoPoints();
    }

    public void adjustControlPoints(List<Point2D> dataPoints, List<Double> weights, int t) {
        boolean changed;
        ArrayList<Point2D> oldCtrlPts;
        boolean wasReduced;
        double localError;
        double globalError;
        if (dataPoints.size() == 0) {
            return;
        }
        do {
            double[] redundancyEstimates = new double[this.getNoCtrlPts()];
            for (int i = 0; i < redundancyEstimates.length; ++i) {
                redundancyEstimates[i] = this.getLocalCtrlPtDensity(i);
            }
            double maxRedundancy = 0.0;
            int maxRedundancyIndex = 0;
            for (int i = 0; i < redundancyEstimates.length; ++i) {
                if (!(redundancyEstimates[i] > maxRedundancy)) continue;
                maxRedundancy = redundancyEstimates[i];
                maxRedundancyIndex = i;
            }
            oldCtrlPts = new ArrayList<Point2D>(this.ctrlPts.size());
            for (Point2D p : this.ctrlPts) {
                oldCtrlPts.add(p);
            }
            wasReduced = this.reduceCurve(maxRedundancyIndex, t);
            globalError = this.fittingIteration(dataPoints, weights, t);
            localError = this.evaluateMaxLocalError(dataPoints, weights) / (double)BezierCurve.NO_CURVE_POINTS;
        } while (globalError < this.minimumGlobalError * (1.0 + this.frame.getGlobalThreshold()) && localError < this.minimumLocalError * (1.0 + this.frame.getLocalThreshold()) && wasReduced);
        if (wasReduced) {
            this.augmentCurve(t, oldCtrlPts);
        }
        do {
            changed = false;
            double minimumError = Double.MAX_VALUE;
            int minimumErrorIndex = -1;
            for (int i = 1; i < this.getNoCtrlPts() - 1; ++i) {
                oldCtrlPts = new ArrayList(this.ctrlPts.size());
                for (Point2D p : this.ctrlPts) {
                    oldCtrlPts.add(p);
                }
                if (!this.reduceCurve(i, t)) break;
                this.fittingIteration(dataPoints, weights, t);
                double reducedError = this.evaluateMaxLocalError(dataPoints, weights) / (double)BezierCurve.NO_CURVE_POINTS;
                if (reducedError < minimumError) {
                    minimumError = reducedError;
                    minimumErrorIndex = i;
                }
                this.augmentCurve(t, oldCtrlPts);
            }
            if (minimumErrorIndex == -1 || !(minimumError < this.minimumLocalError * (1.0 + this.frame.getLocalThreshold()))) continue;
            this.reduceCurve(minimumErrorIndex, t);
            globalError = this.fittingIteration(dataPoints, weights, t);
            localError = this.evaluateMaxLocalError(dataPoints, weights) / (double)BezierCurve.NO_CURVE_POINTS;
            changed = true;
        } while (changed);
        this.minimumGlobalError = globalError;
        this.minimumLocalError = localError;
    }

    private double getLocalCtrlPtDensity(int i) {
        double dik;
        if (i == 0 || i == this.getNoCtrlPts() - 1) {
            return 0.0;
        }
        Point2D pi = (Point2D)this.ctrlPts.get(i);
        Point2D pj = (Point2D)this.ctrlPts.get(i - 1);
        Point2D pk = (Point2D)this.ctrlPts.get(i + 1);
        double dij = Math.sqrt(this.squared(pi.getX() - pj.getX()) + this.squared(pi.getY() - pj.getY()));
        if (dij < (dik = Math.sqrt(this.squared(pi.getX() - pk.getX()) + this.squared(pi.getY() - pk.getY())))) {
            return 1.0 / dij;
        }
        return 1.0 / dik;
    }

    public boolean reduceCurve(int i, int t) {
        if (this.isOpen && this.noCurves == 1) {
            return false;
        }
        if (!this.isOpen && this.noCurves == 4) {
            return false;
        }
        --this.noCtrlPts;
        --this.noCurves;
        this.spline = new BezierCurve[this.noCurves];
        if (i == this.getNoCtrlPts() - 1) {
            --i;
        }
        Point2D.Double midPoint = new Point2D.Double((((Point2D)this.ctrlPts.get(i)).getX() + ((Point2D)this.ctrlPts.get(i + 1)).getX()) / 2.0, (((Point2D)this.ctrlPts.get(i)).getY() + ((Point2D)this.ctrlPts.get(i + 1)).getY()) / 2.0);
        this.ctrlPts.set(i, midPoint);
        this.ctrlPts.remove(i + 1);
        this.computeSpline(this.ctrlPts, t);
        this.fillPoints(this.ctrlPts, t);
        this.getKeyframes().add(new Curve.BControlPoints(this.ctrlPts, t));
        return true;
    }

    public void augmentCurve(int t, List<Point2D> oldCtrlPts) {
        ++this.noCtrlPts;
        ++this.noCurves;
        this.spline = new BezierCurve[this.noCurves];
        this.ctrlPts = oldCtrlPts;
        this.computeSpline(this.ctrlPts, t);
        this.fillPoints(this.ctrlPts, t);
        this.getKeyframes().add(new Curve.BControlPoints(this.ctrlPts, t));
    }

    public double evaluateGlobalError(List<Point2D> dataPoints, List<Double> weights) {
        double error = 0.0;
        for (int i = 0; i < this.getNoPoints(); ++i) {
            double minDistance = Double.MAX_VALUE;
            for (int j = 0; j < dataPoints.size(); ++j) {
                double dist = 1.0 / (weights.get(j) * 1.0) * Math.sqrt(this.squared(this.getSpecificPoint(i).getX() - dataPoints.get(j).getX()) + this.squared(this.getSpecificPoint(i).getY() - dataPoints.get(j).getY()));
                if (!(dist < minDistance)) continue;
                minDistance = dist;
            }
            error += minDistance;
        }
        return error;
    }

    public double evaluateMaxLocalError(List<Point2D> dataPoints, List<Double> weights) {
        double maxLocalError = 0.0;
        for (int n = 0; n < this.noCurves; ++n) {
            double pieceError = 0.0;
            for (int i = n * BezierCurve.NO_CURVE_POINTS; i < (n + 1) * BezierCurve.NO_CURVE_POINTS; ++i) {
                double minDistance = Double.MAX_VALUE;
                for (int j = 0; j < dataPoints.size(); ++j) {
                    double dist = 1.0 / (weights.get(j) * 1.0) * Math.sqrt(this.squared(this.getSpecificPoint(i).getX() - dataPoints.get(j).getX()) + this.squared(this.getSpecificPoint(i).getY() - dataPoints.get(j).getY()));
                    if (!(dist < minDistance)) continue;
                    minDistance = dist;
                }
                pieceError += minDistance;
            }
            if (!(pieceError > maxLocalError)) continue;
            maxLocalError = pieceError;
        }
        return maxLocalError;
    }

    private double[] evaluateBasisFunction(int footpointIndex) {
        int knotIndex = footpointIndex / BezierCurve.NO_CURVE_POINTS + 3;
        double t = this.knotVector[knotIndex - 1] + (this.knotVector[knotIndex] - this.knotVector[knotIndex - 1]) * (double)(footpointIndex % BezierCurve.NO_CURVE_POINTS) / (1.0 * (double)(BezierCurve.NO_CURVE_POINTS - 1));
        double[] coefficients = new double[this.noCtrlPts];
        if (t == this.knotVector[0]) {
            coefficients[0] = 1.0;
            return coefficients;
        }
        if (t == this.knotVector[this.knotVector.length - 1]) {
            coefficients[this.noCtrlPts - 1] = 1.0;
            return coefficients;
        }
        coefficients[knotIndex] = 1.0;
        for (int degree = 1; degree <= 3; ++degree) {
            coefficients[knotIndex - degree] = (this.knotVector[knotIndex] - t) / (this.knotVector[knotIndex] - this.knotVector[knotIndex - degree]) * coefficients[knotIndex - degree + 1];
            for (int i = knotIndex - degree + 1; i < knotIndex; ++i) {
                coefficients[i] = (t - this.knotVector[i - 1]) / (this.knotVector[i + degree - 1] - this.knotVector[i - 1]) * coefficients[i] + (this.knotVector[i + degree] - t) / (this.knotVector[i + degree] - this.knotVector[i]) * coefficients[i + 1];
            }
            coefficients[knotIndex] = (t - this.knotVector[knotIndex - 1]) / (this.knotVector[knotIndex + degree - 1] - this.knotVector[knotIndex - 1]) * coefficients[knotIndex];
        }
        return coefficients;
    }

    @Override
    public void addKeyFrame(Point2D newCtrlPt, int t) {
        if (this.isOpen) {
            super.addKeyFrame(newCtrlPt, t);
        } else {
            if (this.selectedCtrlPtIndex < 0) {
                return;
            }
            if (this.selectedCtrlPtIndex >= 3 && this.selectedCtrlPtIndex < this.noCtrlPts - 3) {
                super.addKeyFrame(newCtrlPt, t);
            } else {
                this.ctrlPts.set(this.selectedCtrlPtIndex, newCtrlPt);
                if (this.selectedCtrlPtIndex <= 3) {
                    this.ctrlPts.set(this.ctrlPts.size() - 3 + this.selectedCtrlPtIndex, newCtrlPt);
                } else {
                    this.ctrlPts.set(this.selectedCtrlPtIndex - this.ctrlPts.size() + 3, newCtrlPt);
                }
                this.getKeyframes().add(new Curve.BControlPoints(this.ctrlPts, t));
                this.fillPoints(this.ctrlPts, t);
                this.boundingBox = this.getKeyframes().getBounds(t);
            }
        }
    }

    @Override
    public void printValues(PrintWriter out, double[][] averaged, boolean exportAllDataPoints) {
        int i = 0;
        for (BezierCurve c : this.spline) {
            double curveLength = this.getApproxCurveLength();
            double curvature = this.getAverageCurvature();
            double curvatureStd = this.getCurvatureStdDev();
            if (!exportAllDataPoints) {
                out.print(this.name);
                out.print("," + curveLength);
                out.print("," + curvature);
                out.print("," + curvatureStd);
                c.printValues(out, averaged, exportAllDataPoints);
                out.println();
            } else {
                c.printValuesAll(out, curveLength, curvature, curvatureStd);
            }
            ++i;
        }
    }

    @Override
    void draw(double scale, Graphics2D g, int currentPoint, boolean showBoundingBox, boolean scaleCurveStrokes, boolean showTangent, boolean showThresholdedRegion) {
        if (scaleCurveStrokes) {
            g.setStroke(new BasicStroke((int)this.frame.getStrokeThickness(scale)));
        } else {
            g.setStroke(new BasicStroke(0.0f));
        }
        if (this.selected) {
            g.setColor(Color.GRAY);
            for (int i = 0; i < this.noCtrlPts - 1; ++i) {
                g.drawLine((int)(((Point2D)this.ctrlPts.get(i)).getX() * scale), (int)(((Point2D)this.ctrlPts.get(i)).getY() * scale), (int)(((Point2D)this.ctrlPts.get(i + 1)).getX() * scale), (int)(((Point2D)this.ctrlPts.get(i + 1)).getY() * scale));
            }
        }
        for (BezierCurve c : this.spline) {
            c.draw(scale, g, scaleCurveStrokes);
        }
        if (showBoundingBox) {
            g.setColor(Color.GRAY);
            Rectangle2D.Double b = this.getScaledBounds(this.boundingBox, scale);
            g.drawRect((int)((RectangularShape)b).getX(), (int)((RectangularShape)b).getY(), (int)((RectangularShape)b).getWidth(), (int)((RectangularShape)b).getHeight());
        }
        if (showThresholdedRegion) {
            this.scaledBounds.reset();
            for (Point2D p : this.dataFittingBounds) {
                this.scaledBounds.addPoint((int)(p.getX() * scale), (int)(p.getY() * scale));
            }
            if (scaleCurveStrokes) {
                g.setStroke(new BasicStroke((int)(this.frame.getStrokeThickness(scale) * 0.75)));
                g.setColor(Curve.THRESHOLD_DATA_CONTOUR_COLOR);
                g.drawPolygon(this.scaledBounds);
            }
        }
        if (this.selected) {
            g.setColor(Curve.CTRL_PT_COLOR);
            for (int i = 0; i < this.ctrlPts.size(); ++i) {
                if (i == this.selectedCtrlPtIndex) {
                    g.fillRect((int)((((Point2D)this.ctrlPts.get(i)).getX() - 1.5 * this.frame.getSelectedCtrlPointSize()) * scale), (int)((((Point2D)this.ctrlPts.get(i)).getY() - 1.5 * this.frame.getSelectedCtrlPointSize()) * scale), (int)(3.0 * this.frame.getSelectedCtrlPointSize() * scale), (int)(3.0 * this.frame.getSelectedCtrlPointSize() * scale));
                    g.setColor(new Color(230, 230, 230));
                    continue;
                }
                if (i == this.hoveredCtrlPt) {
                    g.fillRect((int)((((Point2D)this.ctrlPts.get(i)).getX() - this.frame.getSelectedCtrlPointSize()) * scale), (int)((((Point2D)this.ctrlPts.get(i)).getY() - this.frame.getSelectedCtrlPointSize()) * scale), (int)(2.0 * this.frame.getSelectedCtrlPointSize() * scale), (int)(2.0 * this.frame.getSelectedCtrlPointSize() * scale));
                    continue;
                }
                g.fillRect((int)((((Point2D)this.ctrlPts.get(i)).getX() - this.frame.getCtrlPointSize()) * scale), (int)((((Point2D)this.ctrlPts.get(i)).getY() - this.frame.getCtrlPointSize()) * scale), (int)(2.0 * this.frame.getCtrlPointSize() * scale), (int)(2.0 * this.frame.getCtrlPointSize() * scale));
            }
            Point2D.Double p = this.getPoint(currentPoint);
            int n = (this.noCurves * BezierCurve.NO_CURVE_POINTS - 1) * currentPoint / this.frame.getNumberOfPointsPerCurve();
            Point2D.Double dp = this.spline[n / BezierCurve.NO_CURVE_POINTS].getHodographPoint(n % BezierCurve.NO_CURVE_POINTS);
            if (showTangent) {
                g.setColor(new Color(50, 100, 50));
                g.drawLine((int)((((Point2D)p).getX() - ((Point2D)dp).getX() * 1.0) * scale), (int)((((Point2D)p).getY() - ((Point2D)dp).getY() * 1.0) * scale), (int)((((Point2D)p).getX() + ((Point2D)dp).getX() * 1.0) * scale), (int)((((Point2D)p).getY() + ((Point2D)dp).getY() * 1.0) * scale));
                g.setColor(new Color(100, 50, 50));
                g.drawLine((int)((((Point2D)p).getX() - ((Point2D)dp).getY() * 1.0) * scale), (int)((((Point2D)p).getY() + ((Point2D)dp).getX() * 1.0) * scale), (int)((((Point2D)p).getX() + ((Point2D)dp).getY() * 1.0) * scale), (int)((((Point2D)p).getY() - ((Point2D)dp).getX() * 1.0) * scale));
            }
            g.setColor(Color.YELLOW);
            g.fillRect((int)((((Point2D)p).getX() - this.frame.getCtrlPointSize()) * scale), (int)((((Point2D)p).getY() - this.frame.getCtrlPointSize()) * scale), (int)(2.0 * this.frame.getCtrlPointSize() * scale), (int)(2.0 * this.frame.getCtrlPointSize() * scale));
            List<Point2D> thresholdedPixels = this.getThresholdedPixels();
            int[] nArray = this.getFootpoints(thresholdedPixels);
        }
    }

    @Override
    public double getPointCurvature(int percentage) {
        int n = (this.noCurves * BezierCurve.NO_CURVE_POINTS - 1) * percentage / this.frame.getNumberOfPointsPerCurve();
        int curve = n / BezierCurve.NO_CURVE_POINTS;
        int point = n % BezierCurve.NO_CURVE_POINTS;
        return this.spline[curve].getExactPointCurvature(point);
    }

    @Override
    public boolean isPointOnCurve(Point2D p, int t, double scale) {
        for (BezierCurve c : this.spline) {
            if (!c.isPointOnCurve(p, t, scale)) continue;
            return true;
        }
        return false;
    }

    @Override
    public double getAverageCurvature() {
        double total = 0.0;
        for (BezierCurve c : this.spline) {
            total += c.getAverageCurvature();
        }
        return total / (double)this.noCurves;
    }

    @Override
    public double getApproxCurveLength() {
        double length = 0.0;
        for (BezierCurve c : this.spline) {
            length += c.getApproxCurveLength();
        }
        return length;
    }

    @Override
    public double getCurvatureStdDev() {
        double variance = 0.0;
        double mu = this.getAverageCurvature();
        for (BezierCurve c : this.spline) {
            for (Point2D point : c.getCurveData()) {
                variance += (point.getY() - mu) * (point.getY() - mu);
            }
        }
        return Math.sqrt(variance /= (double)(this.noCurves * BezierCurve.NO_CURVE_POINTS - 1));
    }

    @Override
    public List<Point2D> getIntensityDataRed() {
        ArrayList<Point2D> splineData = new ArrayList<Point2D>();
        double currentPt = 0.0;
        for (BezierCurve c : this.spline) {
            List<Point2D> curveData = c.getIntensityDataRed();
            if (KappaMenuBar.distributionDisplay == 0) {
                splineData.addAll(curveData);
                continue;
            }
            if (KappaMenuBar.distributionDisplay == 1) {
                for (Point2D p : curveData) {
                    splineData.add(new Point2D.Double(p.getX() + currentPt, p.getY()));
                }
                currentPt += curveData.get(BezierCurve.NO_CURVE_POINTS - 1).getX();
                continue;
            }
            for (Point2D p : curveData) {
                splineData.add(new Point2D.Double(p.getX() + currentPt, p.getY()));
            }
            currentPt += (double)(BezierCurve.NO_CURVE_POINTS - 1);
        }
        return splineData;
    }

    @Override
    public List<Point2D> getIntensityDataGreen() {
        ArrayList<Point2D> splineData = new ArrayList<Point2D>();
        double currentPt = 0.0;
        for (BezierCurve c : this.spline) {
            List<Point2D> curveData = c.getIntensityDataGreen();
            if (KappaMenuBar.distributionDisplay == 0) {
                splineData.addAll(curveData);
                continue;
            }
            if (KappaMenuBar.distributionDisplay == 1) {
                for (Point2D p : curveData) {
                    splineData.add(new Point2D.Double(p.getX() + currentPt, p.getY()));
                }
                currentPt += curveData.get(BezierCurve.NO_CURVE_POINTS - 1).getX();
                continue;
            }
            for (Point2D p : curveData) {
                splineData.add(new Point2D.Double(p.getX() + currentPt, p.getY()));
            }
            currentPt += (double)(BezierCurve.NO_CURVE_POINTS - 1);
        }
        return splineData;
    }

    @Override
    public List<Point2D> getIntensityDataBlue() {
        ArrayList<Point2D> splineData = new ArrayList<Point2D>();
        double currentPt = 0.0;
        for (BezierCurve c : this.spline) {
            List<Point2D> curveData = c.getIntensityDataBlue();
            if (KappaMenuBar.distributionDisplay == 0) {
                splineData.addAll(curveData);
                continue;
            }
            if (KappaMenuBar.distributionDisplay == 1) {
                for (Point2D p : curveData) {
                    splineData.add(new Point2D.Double(p.getX() + currentPt, p.getY()));
                }
                currentPt += curveData.get(BezierCurve.NO_CURVE_POINTS - 1).getX();
                continue;
            }
            for (Point2D p : curveData) {
                splineData.add(new Point2D.Double(p.getX() + currentPt, p.getY()));
            }
            currentPt += (double)(BezierCurve.NO_CURVE_POINTS - 1);
        }
        return splineData;
    }

    @Override
    public void updateIntensities() {
        for (BezierCurve c : this.spline) {
            c.updateIntensities();
        }
    }

    @Override
    public List<Point2D> getCurveData() {
        ArrayList<Point2D> splineData = new ArrayList<Point2D>();
        double currentPt = 0.0;
        for (BezierCurve c : this.spline) {
            List<Point2D> curveData = c.getCurveData();
            if (KappaMenuBar.distributionDisplay == 0) {
                splineData.addAll(curveData);
                continue;
            }
            if (KappaMenuBar.distributionDisplay == 1) {
                for (Point2D p : curveData) {
                    splineData.add(new Point2D.Double(p.getX() + currentPt, p.getY()));
                }
                currentPt += curveData.get(BezierCurve.NO_CURVE_POINTS - 1).getX();
                continue;
            }
            for (Point2D p : curveData) {
                splineData.add(new Point2D.Double(p.getX() + currentPt, p.getY()));
            }
            currentPt += (double)(BezierCurve.NO_CURVE_POINTS - 1);
        }
        return splineData;
    }

    @Override
    public List<Point2D> getDebugCurveData() {
        ArrayList<Point2D> splineData = new ArrayList<Point2D>();
        for (BezierCurve c : this.spline) {
            splineData.addAll(c.getDebugCurveData());
        }
        return splineData;
    }

    @Override
    public List<BezierPoint> getPoints() {
        ArrayList<BezierPoint> curvePoints = new ArrayList<BezierPoint>();
        for (BezierCurve c : this.spline) {
            curvePoints.addAll(c.getPoints());
        }
        return curvePoints;
    }

    @Override
    public List<BezierPoint> getDigitizedPoints() {
        ArrayList<BezierPoint> digitizedPoints = new ArrayList<BezierPoint>();
        for (BezierCurve c : this.spline) {
            digitizedPoints.addAll(c.getDigitizedPoints());
        }
        return digitizedPoints;
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
        for (BezierCurve c : this.spline) {
            c.setSelected(selected);
        }
    }

    @Override
    public int getNoPoints() {
        return this.noCurves * BezierCurve.NO_CURVE_POINTS;
    }

    @Override
    public Point2D.Double getPoint(int percentage) {
        int n = (this.noCurves * BezierCurve.NO_CURVE_POINTS - 1) * percentage / this.frame.getNumberOfPointsPerCurve();
        return this.spline[n / BezierCurve.NO_CURVE_POINTS].getExactPoint(n % BezierCurve.NO_CURVE_POINTS);
    }

    public BezierPoint getSpecificPoint(int index) {
        int n = (this.noCurves * BezierCurve.NO_CURVE_POINTS - 1) * index / this.getNoPoints();
        return this.spline[n / BezierCurve.NO_CURVE_POINTS].getExactPoint(n % BezierCurve.NO_CURVE_POINTS);
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public void evaluateThresholdedPixels() {
        for (BezierCurve c : this.spline) {
            c.setDataRadius(this.dataRadius);
            c.evaluateThresholdedPixels();
        }
    }

    @Override
    public void drawThresholdedPixels(Graphics2D g, double scale) {
        for (BezierCurve c : this.spline) {
            c.drawThresholdedPixels(g, scale);
        }
    }

    @Override
    public List<Point2D> getThresholdedPixels() {
        this.thresholdedPixels = new ArrayList();
        HashSet<Point2D> uniquePixels = new HashSet<Point2D>();
        for (BezierCurve c : this.spline) {
            for (Point2D p : c.getThresholdedPixels()) {
                uniquePixels.add(p);
            }
        }
        this.thresholdedPixels.addAll(uniquePixels);
        return this.thresholdedPixels;
    }

    @Override
    public double getMaximum(double start, double end) {
        double max = Double.MIN_VALUE;
        for (BezierCurve c : this.spline) {
            double pieceMax = c.getMaximum(start, end);
            if (!(pieceMax > max)) continue;
            max = pieceMax;
        }
        return max;
    }
}

