/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation;

import java.math.BigDecimal;
import org.ojalgo.access.Structure1D;
import org.ojalgo.constant.BigMath;
import org.ojalgo.netio.BasicLogger;
import org.ojalgo.optimisation.ModelEntity;
import org.ojalgo.type.TypeUtils;
import org.ojalgo.type.context.NumberContext;

public final class Variable
extends ModelEntity<Variable> {
    private Structure1D.IntIndex myIndex = null;
    private boolean myInteger = false;
    private transient boolean myUnbounded = false;
    private BigDecimal myValue = null;

    public static Variable make(String name) {
        return new Variable(name);
    }

    public static Variable makeBinary(String name) {
        return Variable.make(name).binary();
    }

    public Variable(String name) {
        super(name);
    }

    protected Variable(Variable variableToCopy) {
        super(variableToCopy);
        this.myIndex = null;
        this.myInteger = variableToCopy.isInteger();
        this.myValue = variableToCopy.getValue();
    }

    public Variable binary() {
        return ((Variable)((Variable)this.lower(BigMath.ZERO)).upper(BigMath.ONE)).integer(true);
    }

    @Override
    public final int compareTo(Variable obj) {
        return this.getIndex().compareTo(obj.getIndex());
    }

    public Variable copy() {
        return new Variable(this);
    }

    public BigDecimal getLowerSlack() {
        BigDecimal retVal = null;
        if (this.getLowerLimit() != null) {
            retVal = this.myValue != null ? this.getLowerLimit().subtract(this.myValue) : this.getLowerLimit();
        }
        if (retVal != null && this.isInteger()) {
            retVal = retVal.setScale(0, 2);
        }
        return retVal;
    }

    public BigDecimal getUpperSlack() {
        BigDecimal retVal = null;
        if (this.getUpperLimit() != null) {
            retVal = this.myValue != null ? this.getUpperLimit().subtract(this.myValue) : this.getUpperLimit();
        }
        if (retVal != null && this.isInteger()) {
            retVal = retVal.setScale(0, 3);
        }
        return retVal;
    }

    public BigDecimal getValue() {
        if (this.myValue == null && this.isEqualityConstraint()) {
            this.myValue = this.getLowerLimit();
        }
        return this.myValue;
    }

    public Variable integer(boolean integer) {
        this.setInteger(integer);
        return this;
    }

    public boolean isBinary() {
        boolean retVal = this.isInteger();
        retVal &= this.isLowerConstraint() && this.getLowerLimit().compareTo(BigMath.ZERO) == 0;
        return retVal &= this.isUpperConstraint() && this.getUpperLimit().compareTo(BigMath.ONE) == 0;
    }

    public boolean isInteger() {
        return this.myInteger;
    }

    public boolean isNegative() {
        return !this.isLowerLimitSet() || this.getLowerLimit().signum() < 0;
    }

    public boolean isPositive() {
        return !this.isUpperLimitSet() || this.getUpperLimit().signum() > 0;
    }

    public boolean isValueSet() {
        return this.myValue != null;
    }

    public BigDecimal quantifyContribution() {
        BigDecimal retVal = BigMath.ZERO;
        BigDecimal tmpContributionWeight = this.getContributionWeight();
        if (tmpContributionWeight != null && this.myValue != null) {
            retVal = tmpContributionWeight.multiply(this.myValue);
        }
        return retVal;
    }

    public Variable relax() {
        return this.integer(false);
    }

    public void setInteger(boolean integer) {
        this.myInteger = integer;
    }

    public void setValue(Number value) {
        BigDecimal tmpValue = null;
        if (value != null) {
            tmpValue = TypeUtils.toBigDecimal(value);
            if (this.isUpperLimitSet()) {
                tmpValue = tmpValue.min(this.getUpperLimit());
            }
            if (this.isLowerLimitSet()) {
                tmpValue = tmpValue.max(this.getLowerLimit());
            }
        }
        this.myValue = tmpValue;
    }

    @Override
    protected void appendMiddlePart(StringBuilder aStringBuilder) {
        aStringBuilder.append(this.getName());
        if (this.myValue != null) {
            aStringBuilder.append(": ");
            aStringBuilder.append(ModelEntity.DISPLAY.enforce(this.myValue).toPlainString());
        }
        if (this.isObjective()) {
            aStringBuilder.append(" (");
            aStringBuilder.append(ModelEntity.DISPLAY.enforce(this.getContributionWeight()).toPlainString());
            aStringBuilder.append(")");
        }
    }

    @Override
    protected void destroy() {
        super.destroy();
        this.myIndex = null;
        this.myValue = null;
    }

    @Override
    protected boolean validate(BigDecimal value, NumberContext context, BasicLogger.Printer appender) {
        boolean retVal = super.validate(value, context, appender);
        if (retVal && this.myInteger) {
            try {
                context.enforce(value).longValueExact();
            }
            catch (ArithmeticException ex) {
                if (appender != null) {
                    appender.println(value + " ! Integer: " + this.getName());
                }
                retVal = false;
            }
        }
        return retVal;
    }

    Structure1D.IntIndex getIndex() {
        return this.myIndex;
    }

    boolean isFixed() {
        return this.isEqualityConstraint();
    }

    boolean isUnbounded() {
        return this.myUnbounded;
    }

    void setFixed(BigDecimal value) {
        ((Variable)this.level(value)).setValue(value);
    }

    void setIndex(Structure1D.IntIndex index) {
        if (index == null) {
            throw new IllegalArgumentException("The index cannot be null!");
        }
        if (this.myIndex != null && this.myIndex.index != index.index) {
            throw new IllegalStateException("Cannot change a variable's index, or add a variable to more than one model!");
        }
        this.myIndex = index;
    }

    void setUnbounded(boolean uncorrelated) {
        this.myUnbounded = uncorrelated;
    }
}

