/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.RecoverableCondition;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.access.Structure2D;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.blas.AXPY;
import org.ojalgo.array.blas.DOT;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.matrix.decomposition.DiagonalArray1D;
import org.ojalgo.matrix.decomposition.RawDecomposition;
import org.ojalgo.matrix.decomposition.SingularValue;
import org.ojalgo.matrix.decomposition.SingularValueDecomposition;
import org.ojalgo.matrix.decomposition.function.ExchangeColumns;
import org.ojalgo.matrix.decomposition.function.NegateColumn;
import org.ojalgo.matrix.decomposition.function.RotateRight;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.matrix.store.RawStore;

final class RawSingularValue
extends RawDecomposition
implements SingularValue<Double> {
    private double[] e;
    private int m;
    private int n;
    private transient PrimitiveDenseStore myPseudoinverse = null;
    private boolean myTransposed;
    private double[][] myUt;
    private double[][] myVt;
    private double[] s;
    private double[] w;

    RawSingularValue() {
    }

    @Override
    public boolean computeValuesOnly(Access2D.Collectable<Double, ? super PhysicalStore<Double>> matrix) {
        return this.doDecompose(matrix, false);
    }

    @Override
    public boolean decompose(Access2D.Collectable<Double, ? super PhysicalStore<Double>> matrix) {
        return this.doDecompose(matrix, true);
    }

    @Override
    public double getCondition() {
        return this.s[0] / this.s[this.n - 1];
    }

    @Override
    public MatrixStore<Double> getD() {
        DiagonalArray1D<Double> tmpDiagonal = new DiagonalArray1D<Double>(this.getSingularValues(), null, null, Double.valueOf(PrimitiveMath.ZERO));
        return MatrixStore.PRIMITIVE.makeWrapper(tmpDiagonal).get();
    }

    @Override
    public double getFrobeniusNorm() {
        double retVal = PrimitiveMath.ZERO;
        for (int i = this.n - 1; i >= 0; --i) {
            double tmpVal = this.s[i];
            retVal += tmpVal * tmpVal;
        }
        return PrimitiveFunction.SQRT.invoke(retVal);
    }

    @Override
    public MatrixStore<Double> getInverse() {
        return this.doGetInverse(this.allocate(this.getColDim(), this.getRowDim()));
    }

    @Override
    public MatrixStore<Double> getInverse(PhysicalStore<Double> preallocated) {
        return this.doGetInverse((PrimitiveDenseStore)preallocated);
    }

    @Override
    public double getKyFanNorm(int k) {
        double retVal = PrimitiveMath.ZERO;
        for (int i = Math.min(this.s.length, k) - 1; i >= 0; --i) {
            retVal += this.s[i];
        }
        return retVal;
    }

    @Override
    public double getOperatorNorm() {
        return this.s[0];
    }

    @Override
    public MatrixStore<Double> getQ1() {
        return this.myTransposed ? ((MatrixStore.LogicalBuilder)new RawStore(this.myVt, this.n, this.n).logical().transpose()).get() : ((MatrixStore.LogicalBuilder)new RawStore(this.myUt, this.n, this.m).logical().transpose()).get();
    }

    @Override
    public MatrixStore<Double> getQ2() {
        return this.myTransposed ? ((MatrixStore.LogicalBuilder)new RawStore(this.myUt, this.n, this.m).logical().transpose()).get() : ((MatrixStore.LogicalBuilder)new RawStore(this.myVt, this.n, this.n).logical().transpose()).get();
    }

    @Override
    public int getRank() {
        double tolerance = this.s[0] * this.getDimensionalEpsilon();
        int rank = 0;
        for (int i = 0; i < this.s.length; ++i) {
            if (!(this.s[i] > tolerance)) continue;
            ++rank;
        }
        return rank;
    }

    @Override
    public Array1D<Double> getSingularValues() {
        return Array1D.PRIMITIVE64.copy(this.s);
    }

    @Override
    public void getSingularValues(double[] values) {
        System.arraycopy(this.s, 0, values, 0, Math.min(this.s.length, values.length));
    }

    @Override
    public MatrixStore<Double> getSolution(Access2D.Collectable<Double, ? super PhysicalStore<Double>> rhs) {
        PrimitiveDenseStore tmpPreallocated = this.allocate(rhs.countRows(), rhs.countRows());
        return this.getSolution(rhs, tmpPreallocated);
    }

    @Override
    public MatrixStore<Double> getSolution(Access2D.Collectable<Double, ? super PhysicalStore<Double>> rhs, PhysicalStore<Double> preallocated) {
        return this.doGetInverse((PrimitiveDenseStore)preallocated).multiply((Double)((Object)this.collect(rhs)));
    }

    @Override
    public double getTraceNorm() {
        return this.getKyFanNorm(this.s.length);
    }

    @Override
    public MatrixStore<Double> invert(Access2D<?> original, PhysicalStore<Double> preallocated) throws RecoverableCondition {
        this.doDecompose(original.asCollectable2D(), true);
        if (this.isSolvable()) {
            return this.getInverse(preallocated);
        }
        throw RecoverableCondition.newMatrixNotInvertible();
    }

    @Override
    public boolean isFullRank() {
        double tolerance = this.s[0] * this.getDimensionalEpsilon();
        return this.s[this.s.length - 1] > tolerance;
    }

    @Override
    public boolean isFullSize() {
        return false;
    }

    @Override
    public boolean isOrdered() {
        return true;
    }

    @Override
    public PhysicalStore<Double> preallocate(Structure2D template) {
        return this.allocate(template.countColumns(), template.countRows());
    }

    @Override
    public PhysicalStore<Double> preallocate(Structure2D templateBody, Structure2D templateRHS) {
        return this.allocate(templateBody.countColumns(), templateBody.countRows());
    }

    @Override
    public MatrixStore<Double> reconstruct() {
        return SingularValue.reconstruct(this);
    }

    @Override
    public void reset() {
        super.reset();
        this.myPseudoinverse = null;
    }

    @Override
    public MatrixStore<Double> solve(Access2D<?> body, Access2D<?> rhs, PhysicalStore<Double> preallocated) throws RecoverableCondition {
        this.doDecompose(body.asCollectable2D(), true);
        if (this.isSolvable()) {
            Object tmpRHS = MatrixStore.PRIMITIVE.makeWrapper(rhs).get();
            return this.doGetInverse((PrimitiveDenseStore)preallocated).multiply((Double)tmpRHS);
        }
        throw RecoverableCondition.newEquationSystemNotSolvable();
    }

    @Override
    protected boolean checkSolvability() {
        return true;
    }

    boolean doDecompose(Access2D.Collectable<Double, ? super PhysicalStore<Double>> matrix, boolean factors) {
        int j;
        int k;
        int i;
        double tmpVal;
        int j2;
        double[] tmpArr;
        this.myTransposed = matrix.countRows() < matrix.countColumns();
        double[][] input = this.reset(matrix, !this.myTransposed);
        if (this.myTransposed) {
            matrix.supplyTo(this.getRawInPlaceStore());
        } else {
            this.collect(matrix).transpose().supplyTo(this.getRawInPlaceStore());
        }
        this.m = this.getMaxDim();
        this.n = this.getMinDim();
        if (this.s == null || this.s.length != this.n) {
            this.s = new double[this.n];
            this.e = new double[this.n];
        }
        if (this.w == null || this.w.length != this.m) {
            this.w = new double[this.m];
        }
        if (factors) {
            this.myUt = input;
            if (this.myVt == null || this.myVt.length != this.n || this.myVt[0].length != this.n) {
                this.myVt = new double[this.n][this.n];
            }
        } else {
            this.myUt = null;
            this.myVt = null;
        }
        double nrm = PrimitiveMath.ZERO;
        int nct = Math.min(this.m - 1, this.n);
        int nrt = Math.max(0, this.n - 2);
        int limit = Math.max(nct, nrt);
        for (int k2 = 0; k2 < limit; ++k2) {
            int i2;
            tmpArr = input[k2];
            if (k2 < nct) {
                nrm = PrimitiveMath.ZERO;
                for (i2 = k2; i2 < this.m; ++i2) {
                    nrm = PrimitiveFunction.HYPOT.invoke(nrm, tmpArr[i2]);
                }
                if (nrm != PrimitiveMath.ZERO) {
                    if (tmpArr[k2] < PrimitiveMath.ZERO) {
                        nrm = -nrm;
                    }
                    i2 = k2;
                    while (i2 < this.m) {
                        int n = i2++;
                        tmpArr[n] = tmpArr[n] / nrm;
                    }
                    int n = k2;
                    tmpArr[n] = tmpArr[n] + PrimitiveMath.ONE;
                    for (j2 = k2 + 1; j2 < this.n; ++j2) {
                        tmpVal = DOT.invoke(tmpArr, 0, input[j2], 0, k2, this.m);
                        AXPY.invoke(input[j2], 0, -(tmpVal /= tmpArr[k2]), tmpArr, 0, k2, this.m);
                    }
                }
                this.s[k2] = -nrm;
            }
            for (j2 = k2 + 1; j2 < this.n; ++j2) {
                this.e[j2] = input[j2][k2];
            }
            if (factors && k2 < nct) {
                for (i2 = k2; i2 < this.m; ++i2) {
                    this.myUt[k2][i2] = tmpArr[i2];
                }
            }
            if (k2 >= nrt) continue;
            nrm = PrimitiveMath.ZERO;
            for (i2 = k2 + 1; i2 < this.n; ++i2) {
                nrm = PrimitiveFunction.HYPOT.invoke(nrm, this.e[i2]);
            }
            if (nrm != PrimitiveMath.ZERO) {
                if (this.e[k2 + 1] < PrimitiveMath.ZERO) {
                    nrm = -nrm;
                }
                i2 = k2 + 1;
                while (i2 < this.n) {
                    int n = i2++;
                    this.e[n] = this.e[n] / nrm;
                }
                int n = k2 + 1;
                this.e[n] = this.e[n] + PrimitiveMath.ONE;
                for (i2 = k2 + 1; i2 < this.m; ++i2) {
                    this.w[i2] = PrimitiveMath.ZERO;
                }
                for (j2 = k2 + 1; j2 < this.n; ++j2) {
                    AXPY.invoke(this.w, 0, this.e[j2], input[j2], 0, k2 + 1, this.m);
                }
                for (j2 = k2 + 1; j2 < this.n; ++j2) {
                    AXPY.invoke(input[j2], 0, -(this.e[j2] / this.e[k2 + 1]), this.w, 0, k2 + 1, this.m);
                }
            }
            this.e[k2] = -nrm;
            if (!factors) continue;
            for (i2 = k2 + 1; i2 < this.n; ++i2) {
                this.myVt[k2][i2] = this.e[i2];
            }
        }
        int p = this.n;
        if (nct < this.n) {
            this.s[nct] = input[nct][nct];
        }
        if (nrt + 1 < p) {
            this.e[nrt] = input[p - 1][nrt];
        }
        this.e[p - 1] = PrimitiveMath.ZERO;
        if (factors) {
            for (j2 = nct; j2 < this.n; ++j2) {
                tmpArr = this.myUt[j2];
                for (i = 0; i < this.m; ++i) {
                    tmpArr[i] = PrimitiveMath.ZERO;
                }
                tmpArr[j2] = PrimitiveMath.ONE;
            }
            for (k = nct - 1; k >= 0; --k) {
                tmpArr = this.myUt[k];
                if (this.s[k] != PrimitiveMath.ZERO) {
                    for (j = k + 1; j < this.n; ++j) {
                        tmpVal = DOT.invoke(tmpArr, 0, this.myUt[j], 0, k, this.m);
                        AXPY.invoke(this.myUt[j], 0, -(tmpVal /= tmpArr[k]), tmpArr, 0, k, this.m);
                    }
                    for (i = 0; i < k; ++i) {
                        tmpArr[i] = PrimitiveMath.ZERO;
                    }
                    tmpArr[k] = PrimitiveMath.ONE - tmpArr[k];
                    for (i = k + 1; i < this.m; ++i) {
                        tmpArr[i] = -tmpArr[i];
                    }
                    continue;
                }
                for (i = 0; i < this.m; ++i) {
                    tmpArr[i] = PrimitiveMath.ZERO;
                }
                tmpArr[k] = PrimitiveMath.ONE;
            }
        }
        if (factors) {
            for (k = this.n - 1; k >= 0; --k) {
                tmpArr = this.myVt[k];
                if (k < nrt && this.e[k] != PrimitiveMath.ZERO) {
                    for (j = k + 1; j < this.n; ++j) {
                        tmpVal = DOT.invoke(tmpArr, 0, this.myVt[j], 0, k + 1, this.n);
                        AXPY.invoke(this.myVt[j], 0, -(tmpVal /= tmpArr[k + 1]), tmpArr, 0, k + 1, this.n);
                    }
                }
                for (i = 0; i < this.n; ++i) {
                    tmpArr[i] = PrimitiveMath.ZERO;
                }
                tmpArr[k] = PrimitiveMath.ONE;
            }
        }
        RotateRight q1RotR = factors ? new RotateRight(){

            @Override
            public void rotateRight(int low, int high, double cos, double sin) {
                double[] colLow = RawSingularValue.this.myUt[low];
                double[] colHigh = RawSingularValue.this.myUt[high];
                for (int i = 0; i < RawSingularValue.this.m; ++i) {
                    double valLow = colLow[i];
                    double valHigh = colHigh[i];
                    colLow[i] = -sin * valHigh + cos * valLow;
                    colHigh[i] = cos * valHigh + sin * valLow;
                }
            }
        } : RotateRight.NULL;
        RotateRight q2RotR = factors ? new RotateRight(){

            @Override
            public void rotateRight(int low, int high, double cos, double sin) {
                double[] colLow = RawSingularValue.this.myVt[low];
                double[] colHigh = RawSingularValue.this.myVt[high];
                for (int i = 0; i < RawSingularValue.this.n; ++i) {
                    double valLow = colLow[i];
                    double valHigh = colHigh[i];
                    colLow[i] = -sin * valHigh + cos * valLow;
                    colHigh[i] = cos * valHigh + sin * valLow;
                }
            }
        } : RotateRight.NULL;
        ExchangeColumns q1XchgCols = factors ? new ExchangeColumns(){

            @Override
            public void exchangeColumns(int colA, int colB) {
                double[] col1 = RawSingularValue.this.myUt[colA];
                double[] col2 = RawSingularValue.this.myUt[colB];
                for (int i = 0; i < RawSingularValue.this.m; ++i) {
                    double tmp = col1[i];
                    col1[i] = col2[i];
                    col2[i] = tmp;
                }
            }
        } : ExchangeColumns.NULL;
        ExchangeColumns q2XchgCols = factors ? new ExchangeColumns(){

            @Override
            public void exchangeColumns(int colA, int colB) {
                double[] col1 = RawSingularValue.this.myVt[colA];
                double[] col2 = RawSingularValue.this.myVt[colB];
                for (int i = 0; i < RawSingularValue.this.n; ++i) {
                    double tmp = col1[i];
                    col1[i] = col2[i];
                    col2[i] = tmp;
                }
            }
        } : ExchangeColumns.NULL;
        NegateColumn q2NegCol = factors ? new NegateColumn(){

            @Override
            public void negateColumn(int col) {
                double[] column = RawSingularValue.this.myVt[col];
                for (int i = 0; i < column.length; ++i) {
                    column[i] = -column[i];
                }
            }
        } : NegateColumn.NULL;
        SingularValueDecomposition.toDiagonal(this.s, this.e, q1RotR, q2RotR, q1XchgCols, q2XchgCols, q2NegCol);
        return this.computed(true);
    }

    MatrixStore<Double> doGetInverse(PrimitiveDenseStore preallocated) {
        if (this.myPseudoinverse == null) {
            double[][] tmpQ1t = this.myTransposed ? this.myVt : this.myUt;
            double[] tmpSingular = this.s;
            RawStore tmpMtrx = new RawStore(tmpSingular.length, tmpQ1t[0].length);
            double[][] tmpMtrxData = tmpMtrx.data;
            double tmpEps = tmpSingular[0] * PrimitiveMath.MACHINE_EPSILON * (double)tmpSingular.length;
            for (int i = 0; i < tmpSingular.length; ++i) {
                double tmpVal = tmpSingular[i];
                if (!(tmpVal > tmpEps)) continue;
                double[] tmpRow = tmpMtrxData[i];
                for (int j = 0; j < tmpRow.length; ++j) {
                    tmpRow[j] = tmpQ1t[i][j] / tmpVal;
                }
            }
            preallocated.fillByMultiplying((Access1D<Double>)this.getQ2(), tmpMtrx);
            this.myPseudoinverse = preallocated;
        }
        return this.myPseudoinverse;
    }
}

