/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import java.math.BigDecimal;
import java.util.Optional;
import org.ojalgo.ProgrammingError;
import org.ojalgo.RecoverableCondition;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.access.Structure1D;
import org.ojalgo.access.Structure2D;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.Primitive64Array;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.function.aggregator.ComplexAggregator;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.decomposition.DeferredTridiagonal;
import org.ojalgo.matrix.decomposition.DiagonalBasicArray;
import org.ojalgo.matrix.decomposition.EigenvalueDecomposition;
import org.ojalgo.matrix.decomposition.MatrixDecomposition;
import org.ojalgo.matrix.decomposition.SimultaneousTridiagonal;
import org.ojalgo.matrix.decomposition.TridiagonalDecomposition;
import org.ojalgo.matrix.decomposition.function.ExchangeColumns;
import org.ojalgo.matrix.decomposition.function.RotateRight;
import org.ojalgo.matrix.store.BigDenseStore;
import org.ojalgo.matrix.store.GenericDenseStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.RationalNumber;

public abstract class HermitianEvD<N extends Number>
extends EigenvalueDecomposition<N>
implements MatrixDecomposition.Solver<N> {
    private double[] d;
    private double[] e;
    private transient MatrixStore<N> myInverse;
    private final TridiagonalDecomposition<N> myTridiagonal;

    static void tql2(double[] d, double[] e, RotateRight mtrxV) {
        int size = d.length;
        double shift = PrimitiveMath.ZERO;
        double magnitude = PrimitiveMath.ZERO;
        for (int l = 0; l < size; ++l) {
            int m;
            double d_l = d[l];
            double e_l = e[l];
            magnitude = PrimitiveFunction.MAX.invoke(magnitude, PrimitiveFunction.ABS.invoke(d_l) + PrimitiveFunction.ABS.invoke(e_l));
            double epsilon = PrimitiveMath.MACHINE_EPSILON * magnitude;
            for (m = l; m < size && PrimitiveFunction.ABS.invoke(e[m]) > epsilon; ++m) {
            }
            if (m > l) {
                do {
                    double p = (d[l + 1] - d_l) / (e_l + e_l);
                    double r = PrimitiveFunction.HYPOT.invoke(p, PrimitiveMath.ONE);
                    if (p < PrimitiveMath.ZERO) {
                        r = -r;
                    }
                    d[l + 1] = e_l * (p + r);
                    d[l] = e_l / (p + r);
                    double increment = d_l - d[l];
                    int i = l + 2;
                    while (i < size) {
                        int n = i++;
                        d[n] = d[n] - increment;
                    }
                    shift += increment;
                    double cos1 = PrimitiveMath.ONE;
                    double sin1 = PrimitiveMath.ZERO;
                    double cos2 = cos1;
                    p = d[m];
                    for (int i2 = m - 1; i2 >= l; --i2) {
                        double d_i = d[i2];
                        double e_i = e[i2];
                        r = PrimitiveFunction.HYPOT.invoke(p, e_i);
                        e[i2 + 1] = sin1 * r;
                        cos2 = cos1;
                        cos1 = p / r;
                        sin1 = e_i / r;
                        d[i2 + 1] = cos2 * p + sin1 * (cos1 * cos2 * e_i + sin1 * d_i);
                        p = cos1 * d_i - sin1 * cos2 * e_i;
                        mtrxV.rotateRight(i2, i2 + 1, cos1, sin1);
                    }
                    d_l = d[l] = cos1 * p;
                    e_l = e[l] = sin1 * p;
                } while (PrimitiveFunction.ABS.invoke(e[l]) > epsilon);
            }
            int n = l;
            d[n] = d[n] + shift;
            e[l] = PrimitiveMath.ZERO;
        }
    }

    private HermitianEvD(PhysicalStore.Factory<N, ? extends DecompositionStore<N>> aFactory) {
        this(aFactory, null);
    }

    protected HermitianEvD(PhysicalStore.Factory<N, ? extends DecompositionStore<N>> aFactory, TridiagonalDecomposition<N> tridiagonal) {
        super(aFactory);
        this.myTridiagonal = tridiagonal;
    }

    @Override
    public final N getDeterminant() {
        AggregatorFunction<ComplexNumber> tmpVisitor = ComplexAggregator.getSet().product();
        this.getEigenvalues().visitAll(tmpVisitor);
        return this.scalar().cast((Number)tmpVisitor.get());
    }

    @Override
    public void getEigenvalues(double[] realParts, Optional<double[]> imaginaryParts) {
        int length = realParts.length;
        System.arraycopy(this.d, 0, realParts, 0, length);
        if (imaginaryParts.isPresent()) {
            System.arraycopy(this.e, 0, imaginaryParts.get(), 0, length);
        }
    }

    @Override
    public final MatrixStore<N> getInverse() {
        if (this.myInverse == null) {
            MatrixStore tmpV = this.getV();
            MatrixStore tmpD = this.getD();
            int tmpDim = (int)tmpD.countRows();
            PhysicalStore tmpMtrx = tmpV.conjugate().copy();
            Object tmpZero = this.scalar().zero().get();
            BinaryFunction tmpDivide = this.function().divide();
            for (int i = 0; i < tmpDim; ++i) {
                if (tmpD.isSmall(i, i, PrimitiveMath.ONE)) {
                    tmpMtrx.fillRow((long)i, 0L, tmpZero);
                    continue;
                }
                tmpMtrx.modifyRow(i, 0L, tmpDivide.second(tmpD.get(i, i)));
            }
            this.myInverse = tmpV.multiply(tmpMtrx);
        }
        return this.myInverse;
    }

    @Override
    public final MatrixStore<N> getInverse(PhysicalStore<N> preallocated) {
        if (this.myInverse == null) {
            MatrixStore<PhysicalStore<N>> tmpV = this.getV();
            MatrixStore tmpD = this.getD();
            int tmpDim = (int)tmpD.countRows();
            PhysicalStore tmpMtrx = preallocated;
            tmpMtrx.fillMatching((Access1D<?>)((Object)tmpV.transpose()));
            Object tmpZero = this.scalar().zero().get();
            BinaryFunction tmpDivide = this.function().divide();
            for (int i = 0; i < tmpDim; ++i) {
                if (tmpD.isSmall(i, i, PrimitiveMath.ONE)) {
                    tmpMtrx.fillRow((long)i, 0L, tmpZero);
                    continue;
                }
                tmpMtrx.modifyRow(i, 0L, tmpDivide.second(tmpD.get(i, i)));
            }
            this.myInverse = tmpV.multiply(tmpMtrx);
        }
        return this.myInverse;
    }

    @Override
    public final MatrixStore<N> getSolution(Access2D.Collectable<N, ? super PhysicalStore<N>> rhs) {
        return this.getInverse().multiply(this.collect(rhs));
    }

    @Override
    public final MatrixStore<N> getSolution(Access2D.Collectable<N, ? super PhysicalStore<N>> rhs, PhysicalStore<N> preallocated) {
        preallocated.fillByMultiplying(this.getInverse(), this.collect(rhs));
        return preallocated;
    }

    @Override
    public final ComplexNumber getTrace() {
        AggregatorFunction<ComplexNumber> tmpVisitor = ComplexAggregator.getSet().sum();
        this.getEigenvalues().visitAll(tmpVisitor);
        return (ComplexNumber)tmpVisitor.get();
    }

    @Override
    public final MatrixStore<N> invert(Access2D<?> original) throws RecoverableCondition {
        this.decompose(this.wrap(original));
        if (this.isSolvable()) {
            return this.getInverse();
        }
        throw RecoverableCondition.newMatrixNotInvertible();
    }

    @Override
    public final MatrixStore<N> invert(Access2D<?> original, PhysicalStore<N> preallocated) throws RecoverableCondition {
        this.decompose(this.wrap(original));
        if (this.isSolvable()) {
            return this.getInverse(preallocated);
        }
        throw RecoverableCondition.newMatrixNotInvertible();
    }

    @Override
    public final boolean isHermitian() {
        return true;
    }

    @Override
    public boolean isOrdered() {
        return false;
    }

    @Override
    public PhysicalStore<N> preallocate(Structure2D template) {
        long tmpCountRows = template.countRows();
        return this.allocate(tmpCountRows, tmpCountRows);
    }

    @Override
    public PhysicalStore<N> preallocate(Structure2D templateBody, Structure2D templateRHS) {
        return this.allocate(templateRHS.countRows(), templateRHS.countColumns());
    }

    @Override
    public void reset() {
        super.reset();
        this.myTridiagonal.reset();
        this.myInverse = null;
    }

    @Override
    public MatrixStore<N> solve(Access2D<?> body, Access2D<?> rhs) throws RecoverableCondition {
        this.decompose(this.wrap(body));
        if (this.isSolvable()) {
            return this.getSolution(this.wrap(rhs));
        }
        throw RecoverableCondition.newEquationSystemNotSolvable();
    }

    @Override
    public MatrixStore<N> solve(Access2D<?> body, Access2D<?> rhs, PhysicalStore<N> preallocated) throws RecoverableCondition {
        this.decompose(this.wrap(body));
        if (this.isSolvable()) {
            return this.getSolution(this.wrap(rhs), preallocated);
        }
        throw RecoverableCondition.newEquationSystemNotSolvable();
    }

    @Override
    protected boolean checkSolvability() {
        return this.isComputed() && this.isHermitian();
    }

    @Override
    protected final boolean doGeneral(Access2D.Collectable<N, ? super PhysicalStore<N>> matrix, boolean eigenvaluesOnly) {
        ProgrammingError.throwForUnsupportedOptionalOperation();
        return false;
    }

    @Override
    protected final boolean doHermitian(Access2D.Collectable<N, ? super PhysicalStore<N>> matrix, boolean valuesOnly) {
        int size = (int)matrix.countRows();
        this.myTridiagonal.decompose(matrix);
        if (this.d == null || this.d.length != size) {
            this.d = new double[size];
            this.e = new double[size];
        }
        this.myTridiagonal.supplyDiagonalTo(this.d, this.e);
        DecompositionStore<N> tmpRotateRight = valuesOnly ? RotateRight.NULL : this.myTridiagonal.getDecompositionQ();
        HermitianEvD.tql2(this.d, this.e, tmpRotateRight);
        if (this.isOrdered()) {
            DecompositionStore<N> tmpExchangeColumns = valuesOnly ? ExchangeColumns.NULL : this.myTridiagonal.getDecompositionQ();
            EigenvalueDecomposition.sort(this.d, tmpExchangeColumns);
        }
        if (!valuesOnly) {
            this.setV(this.myTridiagonal.getDecompositionQ());
        }
        return this.computed(true);
    }

    @Override
    protected double getDimensionalEpsilon() {
        return (double)this.d.length * PrimitiveMath.MACHINE_EPSILON;
    }

    @Override
    protected MatrixStore<N> makeD() {
        DiagonalBasicArray<Double> tmpDiagonal = new DiagonalBasicArray<Double>(Primitive64Array.wrap(this.d), null, null, Double.valueOf(PrimitiveMath.ZERO));
        return this.wrap(tmpDiagonal).diagonal(false).get();
    }

    @Override
    protected Array1D<ComplexNumber> makeEigenvalues() {
        int length = this.d.length;
        Structure1D retVal = Array1D.COMPLEX.makeZero(length);
        for (int ij = 0; ij < length; ++ij) {
            ((Array1D)retVal).set(ij, (Object)ComplexNumber.valueOf(this.d[ij]));
        }
        return retVal;
    }

    @Override
    protected MatrixStore<N> makeV() {
        return this.myTridiagonal.getQ();
    }

    static final class SimultaneousPrimitive
    extends HermitianEvD<Double> {
        SimultaneousPrimitive() {
            super(PrimitiveDenseStore.FACTORY, new SimultaneousTridiagonal());
        }
    }

    static final class Rational
    extends HermitianEvD<RationalNumber> {
        Rational() {
            super(GenericDenseStore.RATIONAL, new DeferredTridiagonal.Rational());
        }
    }

    static final class Quat
    extends HermitianEvD<Quaternion> {
        Quat() {
            super(GenericDenseStore.QUATERNION, new DeferredTridiagonal.Quat());
        }
    }

    static final class DeferredPrimitive
    extends HermitianEvD<Double> {
        DeferredPrimitive() {
            super(PrimitiveDenseStore.FACTORY, new DeferredTridiagonal.Primitive());
        }
    }

    static final class Complex
    extends HermitianEvD<ComplexNumber> {
        Complex() {
            super(GenericDenseStore.COMPLEX, new DeferredTridiagonal.Complex());
        }
    }

    static final class Big
    extends HermitianEvD<BigDecimal> {
        Big() {
            super(BigDenseStore.FACTORY, new DeferredTridiagonal.Big());
        }
    }
}

