/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import org.ojalgo.ProgrammingError;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.access.Factory2D;
import org.ojalgo.access.Mutate2D;
import org.ojalgo.access.Structure2D;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.BasicArray;
import org.ojalgo.array.BigArray;
import org.ojalgo.array.BufferArray;
import org.ojalgo.array.ComplexArray;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.Primitive32Array;
import org.ojalgo.array.Primitive64Array;
import org.ojalgo.array.QuaternionArray;
import org.ojalgo.array.RationalArray;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.scalar.Scalar;

public final class Array2D<N extends Number>
implements Access2D<N>,
Access2D.Elements,
Access2D.IndexOf,
Access2D.Sliceable<N>,
Access2D.Visitable<N>,
Access2D.Aggregatable<N>,
Structure2D.ReducibleTo1D<Array1D<N>>,
Mutate2D.Receiver<N>,
Mutate2D.Exchangeable,
Mutate2D.Mixable<N>,
Mutate2D.Modifiable<N>,
Mutate2D.BiModifiable<N>,
Serializable {
    public static final Factory<BigDecimal> BIG = new Factory<BigDecimal>(BigArray.FACTORY);
    public static final Factory<ComplexNumber> COMPLEX = new Factory<ComplexNumber>(ComplexArray.FACTORY);
    public static final Factory<Double> DIRECT32 = new Factory<Double>(BufferArray.DIRECT32);
    public static final Factory<Double> DIRECT64 = new Factory<Double>(BufferArray.DIRECT64);
    public static final Factory<Double> PRIMITIVE32 = new Factory<Double>(Primitive32Array.FACTORY);
    public static final Factory<Double> PRIMITIVE64 = new Factory<Double>(Primitive64Array.FACTORY);
    public static final Factory<Quaternion> QUATERNION = new Factory<Quaternion>(QuaternionArray.FACTORY);
    public static final Factory<RationalNumber> RATIONAL = new Factory<RationalNumber>(RationalArray.FACTORY);
    private final long myColumnsCount;
    private final BasicArray<N> myDelegate;
    private final long myRowsCount;

    public static <N extends Number> Factory<N> factory(DenseArray.Factory<N> denseArray) {
        return new Factory<N>(denseArray);
    }

    private Array2D() {
        this(null, 0L);
    }

    Array2D(BasicArray<N> delegate, long structure) {
        this.myDelegate = delegate;
        this.myRowsCount = structure;
        this.myColumnsCount = structure == 0L ? 0L : delegate.count() / structure;
    }

    @Override
    public void add(long index, double addend) {
        this.myDelegate.add(index, addend);
    }

    @Override
    public void add(long row, long col, double addend) {
        this.myDelegate.add(Structure2D.index(this.myRowsCount, row, col), addend);
    }

    @Override
    public void add(long row, long col, Number addend) {
        this.myDelegate.add(Structure2D.index(this.myRowsCount, row, col), addend);
    }

    @Override
    public void add(long index, Number addend) {
        this.myDelegate.add(index, addend);
    }

    @Override
    public N aggregateColumn(long row, long col, Aggregator aggregator) {
        AggregatorFunction<N> visitor = aggregator.getFunction(this.myDelegate.factory().aggregator());
        this.visitColumn(row, col, visitor);
        return visitor.get();
    }

    @Override
    public N aggregateDiagonal(long row, long col, Aggregator aggregator) {
        AggregatorFunction<N> visitor = aggregator.getFunction(this.myDelegate.factory().aggregator());
        this.visitDiagonal(row, col, visitor);
        return visitor.get();
    }

    @Override
    public N aggregateRange(long first, long limit, Aggregator aggregator) {
        AggregatorFunction<N> visitor = aggregator.getFunction(this.myDelegate.factory().aggregator());
        this.visitRange(first, limit, visitor);
        return visitor.get();
    }

    @Override
    public N aggregateRow(long row, long col, Aggregator aggregator) {
        AggregatorFunction<N> visitor = aggregator.getFunction(this.myDelegate.factory().aggregator());
        this.visitRow(row, col, visitor);
        return visitor.get();
    }

    @Deprecated
    public Array1D<N> asArray1D() {
        return this.myDelegate.wrapInArray1D();
    }

    public void clear() {
        this.myDelegate.reset();
    }

    @Override
    public long count() {
        return this.myDelegate.count();
    }

    @Override
    public long countColumns() {
        return this.myColumnsCount;
    }

    @Override
    public long countRows() {
        return this.myRowsCount;
    }

    @Override
    public double doubleValue(long index) {
        return this.myDelegate.doubleValue(index);
    }

    @Override
    public double doubleValue(long row, long col) {
        return this.myDelegate.doubleValue(Structure2D.index(this.myRowsCount, row, col));
    }

    public boolean equals(Object obj) {
        if (obj instanceof Array2D) {
            Array2D tmpObj = (Array2D)obj;
            return this.myRowsCount == tmpObj.countRows() && this.myColumnsCount == tmpObj.countColumns() && this.myDelegate.equals(tmpObj.getDelegate());
        }
        return super.equals(obj);
    }

    @Override
    public void exchangeColumns(long colA, long colB) {
        this.myDelegate.exchange(colA * this.myRowsCount, colB * this.myRowsCount, 1L, this.myRowsCount);
    }

    @Override
    public void exchangeRows(long rowA, long rowB) {
        this.myDelegate.exchange(rowA, rowB, this.myRowsCount, this.myColumnsCount);
    }

    @Override
    public void fillAll(N value) {
        this.myDelegate.fill(0L, this.count(), 1L, value);
    }

    @Override
    public void fillAll(NullaryFunction<N> supplier) {
        this.myDelegate.fill(0L, this.count(), 1L, supplier);
    }

    @Override
    public void fillColumn(long row, long col, Access1D<N> values) {
        long offset = Structure2D.index(this.myRowsCount, row, col);
        long limit = Math.min(this.countRows() - row, values.count());
        if (this.myDelegate.isPrimitive()) {
            for (long i = 0L; i < limit; ++i) {
                this.set(offset + i, values.doubleValue(i));
            }
        } else {
            for (long i = 0L; i < limit; ++i) {
                this.fillOne(offset + i, values.get(i));
            }
        }
    }

    @Override
    public void fillColumn(long row, long col, N value) {
        this.myDelegate.fill(Structure2D.index(this.myRowsCount, row, col), Structure2D.index(this.myRowsCount, this.myRowsCount, col), 1L, value);
    }

    @Override
    public void fillColumn(long row, long col, NullaryFunction<N> supplier) {
        this.myDelegate.fill(Structure2D.index(this.myRowsCount, row, col), Structure2D.index(this.myRowsCount, this.myRowsCount, col), 1L, supplier);
    }

    @Override
    public void fillDiagonal(long row, long col, N value) {
        long tmpCount = Math.min(this.myRowsCount - row, this.myColumnsCount - col);
        this.myDelegate.fill(Structure2D.index(this.myRowsCount, row, col), Structure2D.index(this.myRowsCount, row + tmpCount, col + tmpCount), 1L + this.myRowsCount, value);
    }

    @Override
    public void fillDiagonal(long row, long col, NullaryFunction<N> supplier) {
        long tmpCount = Math.min(this.myRowsCount - row, this.myColumnsCount - col);
        this.myDelegate.fill(Structure2D.index(this.myRowsCount, row, col), Structure2D.index(this.myRowsCount, row + tmpCount, col + tmpCount), 1L + this.myRowsCount, supplier);
    }

    @Override
    public void fillOne(long index, Access1D<?> values, long valueIndex) {
        this.myDelegate.fillOne(index, values, valueIndex);
    }

    @Override
    public void fillOne(long row, long col, Access1D<?> values, long valueIndex) {
        this.myDelegate.fillOne(Structure2D.index(this.myRowsCount, row, col), values, valueIndex);
    }

    @Override
    public void fillOne(long row, long col, N value) {
        this.myDelegate.fillOne(Structure2D.index(this.myRowsCount, row, col), value);
    }

    @Override
    public void fillOne(long row, long col, NullaryFunction<N> supplier) {
        this.myDelegate.fillOne(Structure2D.index(this.myRowsCount, row, col), supplier);
    }

    @Override
    public void fillOne(long index, N value) {
        this.myDelegate.fillOne(index, value);
    }

    @Override
    public void fillOne(long index, NullaryFunction<N> supplier) {
        this.myDelegate.fillOne(index, supplier);
    }

    @Override
    public void fillRange(long first, long limit, N value) {
        this.myDelegate.fill(first, limit, 1L, value);
    }

    @Override
    public void fillRange(long first, long limit, NullaryFunction<N> supplier) {
        this.myDelegate.fill(first, limit, 1L, supplier);
    }

    @Override
    public void fillRow(long row, long col, Access1D<N> values) {
        long offset = Structure2D.index(this.myRowsCount, row, col);
        long limit = Math.min(this.countColumns() - col, values.count());
        if (this.myDelegate.isPrimitive()) {
            for (long i = 0L; i < limit; ++i) {
                this.set(offset + i * this.myRowsCount, values.doubleValue(i));
            }
        } else {
            for (long i = 0L; i < limit; ++i) {
                this.fillOne(offset + i * this.myRowsCount, values.get(i));
            }
        }
    }

    @Override
    public void fillRow(long row, long col, N value) {
        this.myDelegate.fill(Structure2D.index(this.myRowsCount, row, col), Structure2D.index(this.myRowsCount, row, this.myColumnsCount), this.myRowsCount, value);
    }

    @Override
    public void fillRow(long row, long col, NullaryFunction<N> supplier) {
        this.myDelegate.fill(Structure2D.index(this.myRowsCount, row, col), Structure2D.index(this.myRowsCount, row, this.myColumnsCount), this.myRowsCount, supplier);
    }

    @Override
    public N get(long index) {
        return this.myDelegate.get(index);
    }

    @Override
    public N get(long row, long col) {
        return this.myDelegate.get(Structure2D.index(this.myRowsCount, row, col));
    }

    public int hashCode() {
        return (int)(this.myRowsCount * this.myColumnsCount * (long)this.myDelegate.hashCode());
    }

    @Override
    public long indexOfLargest() {
        return this.myDelegate.indexOfLargest();
    }

    @Override
    public long indexOfLargestInColumn(long row, long col) {
        return this.myDelegate.indexOfLargest(Structure2D.index(this.myRowsCount, row, col), Structure2D.index(this.myRowsCount, this.myRowsCount, col), 1L) % this.myRowsCount;
    }

    @Override
    public long indexOfLargestInRange(long first, long limit) {
        return this.myDelegate.indexOfLargestInRange(first, limit);
    }

    @Override
    public long indexOfLargestInRow(long row, long col) {
        return this.myDelegate.indexOfLargest(Structure2D.index(this.myRowsCount, row, col), Structure2D.index(this.myRowsCount, row, this.myColumnsCount), this.myRowsCount) / this.myRowsCount;
    }

    @Override
    public long indexOfLargestOnDiagonal(long first) {
        long tmpMinCount = Math.min(this.myRowsCount, this.myColumnsCount);
        long tmpFirst = Structure2D.index(this.myRowsCount, first, first);
        long tmpLimit = Structure2D.index(this.myRowsCount, tmpMinCount, tmpMinCount);
        long tmpStep = 1L + this.myRowsCount;
        return this.myDelegate.indexOfLargest(tmpFirst, tmpLimit, tmpStep) / this.myRowsCount;
    }

    @Override
    public boolean isAbsolute(long index) {
        return this.myDelegate.isAbsolute(index);
    }

    @Override
    public boolean isAbsolute(long row, long col) {
        return this.myDelegate.isAbsolute(Structure2D.index(this.myRowsCount, row, col));
    }

    @Override
    public boolean isAllSmall(double comparedTo) {
        return this.myDelegate.isSmall(0L, this.count(), 1L, comparedTo);
    }

    @Override
    public boolean isColumnSmall(long row, long col, double comparedTo) {
        return this.myDelegate.isSmall(Structure2D.index(this.myRowsCount, row, col), Structure2D.index(this.myRowsCount, this.myRowsCount, col), 1L, comparedTo);
    }

    @Override
    public boolean isRowSmall(long row, long col, double comparedTo) {
        return this.myDelegate.isSmall(Structure2D.index(this.myRowsCount, row, col), Structure2D.index(this.myRowsCount, row, this.myColumnsCount), this.myRowsCount, comparedTo);
    }

    @Override
    public boolean isSmall(long index, double comparedTo) {
        return this.myDelegate.isSmall(index, comparedTo);
    }

    @Override
    public boolean isSmall(long row, long col, double comparedTo) {
        return this.myDelegate.isSmall(Structure2D.index(this.myRowsCount, row, col), comparedTo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double mix(long row, long col, BinaryFunction<N> mixer, double addend) {
        ProgrammingError.throwIfNull(mixer);
        BasicArray<N> basicArray = this.myDelegate;
        synchronized (basicArray) {
            double oldValue = this.doubleValue(row, col);
            double newValue = mixer.invoke(oldValue, addend);
            this.set(row, col, newValue);
            return newValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public N mix(long row, long col, BinaryFunction<N> mixer, N addend) {
        ProgrammingError.throwIfNull(mixer);
        BasicArray<N> basicArray = this.myDelegate;
        synchronized (basicArray) {
            N oldValue = this.get(row, col);
            N newValue = mixer.invoke(oldValue, addend);
            this.set(row, col, (Number)newValue);
            return newValue;
        }
    }

    @Override
    public void modifyAll(UnaryFunction<N> modifier) {
        this.myDelegate.modify(0L, this.count(), 1L, modifier);
    }

    @Override
    public void modifyColumn(long row, long col, UnaryFunction<N> modifier) {
        this.myDelegate.modify(Structure2D.index(this.myRowsCount, row, col), Structure2D.index(this.myRowsCount, this.myRowsCount, col), 1L, modifier);
    }

    @Override
    public void modifyDiagonal(long row, long col, UnaryFunction<N> modifier) {
        long tmpCount = Math.min(this.myRowsCount - row, this.myColumnsCount - col);
        this.myDelegate.modify(Structure2D.index(this.myRowsCount, row, col), Structure2D.index(this.myRowsCount, row + tmpCount, col + tmpCount), 1L + this.myRowsCount, modifier);
    }

    @Override
    public void modifyMatching(Access1D<N> left, BinaryFunction<N> function) {
        this.myDelegate.modify(0L, this.count(), 1L, left, function);
    }

    @Override
    public void modifyMatching(BinaryFunction<N> function, Access1D<N> right) {
        this.myDelegate.modify(0L, this.count(), 1L, function, right);
    }

    @Override
    public void modifyOne(long row, long col, UnaryFunction<N> modifier) {
        this.myDelegate.modifyOne(Structure2D.index(this.myRowsCount, row, col), modifier);
    }

    @Override
    public void modifyOne(long index, UnaryFunction<N> modifier) {
        this.myDelegate.modifyOne(index, modifier);
    }

    @Override
    public void modifyRange(long first, long limit, UnaryFunction<N> modifier) {
        this.myDelegate.modify(first, limit, 1L, modifier);
    }

    @Override
    public void modifyRow(long row, long col, UnaryFunction<N> modifier) {
        this.myDelegate.modify(Structure2D.index(this.myRowsCount, row, col), Structure2D.index(this.myRowsCount, row, this.myColumnsCount), this.myRowsCount, modifier);
    }

    @Override
    public Array1D<N> reduceColumns(Aggregator aggregator) {
        Array1D retVal = ((BasicArray)this.myDelegate.factory().makeZero(this.myColumnsCount)).wrapInArray1D();
        this.reduceColumns(aggregator, retVal);
        return retVal;
    }

    @Override
    public Array1D<N> reduceRows(Aggregator aggregator) {
        Array1D retVal = ((BasicArray)this.myDelegate.factory().makeZero(this.myRowsCount)).wrapInArray1D();
        this.reduceRows(aggregator, retVal);
        return retVal;
    }

    @Override
    public void set(long index, double value) {
        this.myDelegate.set(index, value);
    }

    @Override
    public void set(long row, long col, double value) {
        this.myDelegate.set(Structure2D.index(this.myRowsCount, row, col), value);
    }

    @Override
    public void set(long row, long col, Number value) {
        this.myDelegate.set(Structure2D.index(this.myRowsCount, row, col), value);
    }

    @Override
    public void set(long index, Number value) {
        this.myDelegate.set(index, value);
    }

    @Override
    public Array1D<N> sliceColumn(long col) {
        return this.sliceColumn(0L, col);
    }

    @Override
    public Array1D<N> sliceColumn(long row, long col) {
        return new Array1D<N>(this.myDelegate, Structure2D.index(this.myRowsCount, row, col), Structure2D.index(this.myRowsCount, this.myRowsCount, col), 1L);
    }

    @Override
    public Array1D<N> sliceDiagonal(long row, long col) {
        long tmpCount = Math.min(this.myRowsCount - row, this.myColumnsCount - col);
        return new Array1D<N>(this.myDelegate, Structure2D.index(this.myRowsCount, row, col), Structure2D.index(this.myRowsCount, row + tmpCount, col + tmpCount), 1L + this.myRowsCount);
    }

    @Override
    public Array1D<N> sliceRange(long first, long limit) {
        return this.myDelegate.wrapInArray1D().sliceRange(first, limit);
    }

    @Override
    public Array1D<N> sliceRow(long row) {
        return this.sliceRow(row, 0L);
    }

    @Override
    public Array1D<N> sliceRow(long row, long col) {
        return new Array1D<N>(this.myDelegate, Structure2D.index(this.myRowsCount, row, col), Structure2D.index(this.myRowsCount, row, this.myColumnsCount), this.myRowsCount);
    }

    public String toString() {
        return this.myDelegate.toString();
    }

    @Override
    public void visitAll(VoidFunction<N> visitor) {
        this.myDelegate.visit(0L, this.count(), 1L, visitor);
    }

    @Override
    public void visitColumn(long row, long col, VoidFunction<N> visitor) {
        this.myDelegate.visit(Structure2D.index(this.myRowsCount, row, col), Structure2D.index(this.myRowsCount, this.myRowsCount, col), 1L, visitor);
    }

    @Override
    public void visitDiagonal(long row, long col, VoidFunction<N> visitor) {
        long tmpCount = Math.min(this.myRowsCount - row, this.myColumnsCount - col);
        this.myDelegate.visit(Structure2D.index(this.myRowsCount, row, col), Structure2D.index(this.myRowsCount, row + tmpCount, col + tmpCount), 1L + this.myRowsCount, visitor);
    }

    @Override
    public void visitOne(long row, long col, VoidFunction<N> visitor) {
        this.myDelegate.visitOne(Structure2D.index(this.myRowsCount, row, col), visitor);
    }

    @Override
    public void visitOne(long index, VoidFunction<N> visitor) {
        this.myDelegate.visitOne(index, visitor);
    }

    @Override
    public void visitRange(long first, long limit, VoidFunction<N> visitor) {
        this.myDelegate.visit(first, limit, 1L, visitor);
    }

    @Override
    public void visitRow(long row, long col, VoidFunction<N> visitor) {
        this.myDelegate.visit(Structure2D.index(this.myRowsCount, row, col), Structure2D.index(this.myRowsCount, row, this.myColumnsCount), this.myRowsCount, visitor);
    }

    BasicArray<N> getDelegate() {
        return this.myDelegate;
    }

    public static final class Factory<N extends Number>
    implements Factory2D<Array2D<N>> {
        private final BasicArray.Factory<N> myDelegate;

        Factory(DenseArray.Factory<N> denseArray) {
            this.myDelegate = BasicArray.factory(denseArray);
        }

        @Override
        public final Array2D<N> columns(Access1D<?> ... source) {
            int tmpColumns = source.length;
            long tmpRows = source[0].count();
            BasicArray<N> tmpDelegate = this.myDelegate.makeToBeFilled(tmpRows, tmpColumns);
            if (tmpDelegate.isPrimitive()) {
                long tmpIndex = 0L;
                for (int j = 0; j < tmpColumns; ++j) {
                    Access1D<?> tmpColumn = source[j];
                    for (long i = 0L; i < tmpRows; ++i) {
                        tmpDelegate.set(tmpIndex++, tmpColumn.doubleValue(i));
                    }
                }
            } else {
                long tmpIndex = 0L;
                for (int j = 0; j < tmpColumns; ++j) {
                    Access1D<?> tmpColumn = source[j];
                    for (long i = 0L; i < tmpRows; ++i) {
                        tmpDelegate.set(tmpIndex++, (Number)tmpColumn.get(i));
                    }
                }
            }
            return tmpDelegate.wrapInArray2D(tmpRows);
        }

        @Override
        public final Array2D<N> columns(double[] ... source) {
            int tmpColumns = source.length;
            int tmpRows = source[0].length;
            BasicArray<N> tmpDelegate = this.myDelegate.makeToBeFilled(tmpRows, tmpColumns);
            long tmpIndex = 0L;
            for (int j = 0; j < tmpColumns; ++j) {
                double[] tmpColumn = source[j];
                for (int i = 0; i < tmpRows; ++i) {
                    tmpDelegate.set(tmpIndex++, tmpColumn[i]);
                }
            }
            return tmpDelegate.wrapInArray2D(tmpRows);
        }

        @Override
        @SafeVarargs
        public final Array2D<N> columns(List<? extends Number> ... source) {
            int tmpColumns = source.length;
            int tmpRows = source[0].size();
            BasicArray<N> tmpDelegate = this.myDelegate.makeToBeFilled(tmpRows, tmpColumns);
            long tmpIndex = 0L;
            for (int j = 0; j < tmpColumns; ++j) {
                List<? extends Number> tmpColumn = source[j];
                for (int i = 0; i < tmpRows; ++i) {
                    tmpDelegate.set(tmpIndex++, tmpColumn.get(i));
                }
            }
            return tmpDelegate.wrapInArray2D(tmpRows);
        }

        @Override
        public final Array2D<N> columns(Number[] ... source) {
            int tmpColumns = source.length;
            int tmpRows = source[0].length;
            BasicArray<N> tmpDelegate = this.myDelegate.makeToBeFilled(tmpRows, tmpColumns);
            long tmpIndex = 0L;
            for (int j = 0; j < tmpColumns; ++j) {
                Number[] tmpColumn = source[j];
                for (int i = 0; i < tmpRows; ++i) {
                    tmpDelegate.set(tmpIndex++, tmpColumn[i]);
                }
            }
            return tmpDelegate.wrapInArray2D(tmpRows);
        }

        @Override
        public final Array2D<N> copy(Access2D<?> source) {
            return ((BasicArray)this.myDelegate.copy(source)).wrapInArray2D(source.countRows());
        }

        public final FunctionSet<N> function() {
            return this.myDelegate.function();
        }

        @Override
        public final Array2D<N> makeEye(long rows, long columns) {
            BasicArray<N> tmpDelegate = this.myDelegate.makeStructuredZero(rows, columns);
            long tmpLimit = Math.min(rows, columns);
            long tmpIncr = rows + 1L;
            for (long ij = 0L; ij < tmpLimit; ++ij) {
                tmpDelegate.set(ij * tmpIncr, 1.0);
            }
            return tmpDelegate.wrapInArray2D(rows);
        }

        @Override
        public final Array2D<N> makeFilled(long rows, long columns, NullaryFunction<?> supplier) {
            BasicArray<N> tmpDelegate = this.myDelegate.makeToBeFilled(rows, columns);
            long tmpIndex = 0L;
            for (long j = 0L; j < columns; ++j) {
                for (long i = 0L; i < rows; ++i) {
                    tmpDelegate.set(tmpIndex++, (Number)supplier.get());
                }
            }
            return tmpDelegate.wrapInArray2D(rows);
        }

        @Override
        public final Array2D<N> makeZero(long rows, long columns) {
            return this.myDelegate.makeStructuredZero(rows, columns).wrapInArray2D(rows);
        }

        @Override
        public final Array2D<N> rows(Access1D<?> ... source) {
            int tmpRows = source.length;
            long tmpColumns = source[0].count();
            BasicArray<N> tmpDelegate = this.myDelegate.makeToBeFilled(tmpRows, tmpColumns);
            if (tmpDelegate.isPrimitive()) {
                for (int i = 0; i < tmpRows; ++i) {
                    Access1D<?> tmpRow = source[i];
                    for (long j = 0L; j < tmpColumns; ++j) {
                        tmpDelegate.set((long)i + j * (long)tmpRows, tmpRow.doubleValue(j));
                    }
                }
            } else {
                for (int i = 0; i < tmpRows; ++i) {
                    Access1D<?> tmpRow = source[i];
                    for (long j = 0L; j < tmpColumns; ++j) {
                        tmpDelegate.set((long)i + j * (long)tmpRows, (Number)tmpRow.get(j));
                    }
                }
            }
            return tmpDelegate.wrapInArray2D(tmpRows);
        }

        @Override
        public final Array2D<N> rows(double[] ... source) {
            int tmpRows = source.length;
            int tmpColumns = source[0].length;
            BasicArray<N> tmpDelegate = this.myDelegate.makeToBeFilled(tmpRows, tmpColumns);
            for (int i = 0; i < tmpRows; ++i) {
                double[] tmpRow = source[i];
                for (int j = 0; j < tmpColumns; ++j) {
                    tmpDelegate.set((long)(i + j * tmpRows), tmpRow[j]);
                }
            }
            return tmpDelegate.wrapInArray2D(tmpRows);
        }

        @Override
        public final Array2D<N> rows(List<? extends Number> ... source) {
            int tmpRows = source.length;
            int tmpColumns = source[0].size();
            BasicArray<N> tmpDelegate = this.myDelegate.makeToBeFilled(tmpRows, tmpColumns);
            for (int i = 0; i < tmpRows; ++i) {
                List<? extends Number> tmpRow = source[i];
                for (int j = 0; j < tmpColumns; ++j) {
                    tmpDelegate.set((long)(i + j * tmpRows), tmpRow.get(j));
                }
            }
            return tmpDelegate.wrapInArray2D(tmpRows);
        }

        @Override
        public final Array2D<N> rows(Number[] ... source) {
            int tmpRows = source.length;
            int tmpColumns = source[0].length;
            BasicArray<N> tmpDelegate = this.myDelegate.makeToBeFilled(tmpRows, tmpColumns);
            for (int i = 0; i < tmpRows; ++i) {
                Number[] tmpRow = source[i];
                for (int j = 0; j < tmpColumns; ++j) {
                    tmpDelegate.set((long)(i + j * tmpRows), tmpRow[j]);
                }
            }
            return tmpDelegate.wrapInArray2D(tmpRows);
        }

        public final Scalar.Factory<N> scalar() {
            return this.myDelegate.scalar();
        }
    }
}

