/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.it.jacs.shared.ffmpeg;

import ch.systemsx.cisd.hdf5.HDF5DataTypeInformation;
import ch.systemsx.cisd.hdf5.HDF5Factory;
import ch.systemsx.cisd.hdf5.IHDF5DoubleReader;
import ch.systemsx.cisd.hdf5.IHDF5LongReader;
import ch.systemsx.cisd.hdf5.IHDF5OpaqueReader;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import ch.systemsx.cisd.hdf5.IHDF5ReaderConfigurator;
import ch.systemsx.cisd.hdf5.IHDF5StringReader;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import org.janelia.it.jacs.shared.ffmpeg.FFMpegLoader;
import org.janelia.it.jacs.shared.ffmpeg.ImageStack;

public class H5JLoader {
    private static final String VX_SIZE_ATTRIB = "voxel_size";
    private static final String UNIT_ATTRIB = "unit";
    private static final String PAD_RIGHT_ATTRIB = "pad_right";
    private static final String PAD_BOTTOM_ATTRIB = "pad_bottom";
    private static final String CHANNELS_QUERY_PATH = "/Channels";
    private String _filename;
    private IHDF5Reader _reader;
    private ImageStack _image;

    public H5JLoader(String filename) {
        this._filename = filename;
        IHDF5ReaderConfigurator conf = HDF5Factory.configureForReading((String)filename);
        conf.performNumericConversions();
        this._reader = conf.reader();
    }

    public void close() throws Exception {
        this._reader.close();
    }

    public int numberOfChannels() {
        return this._reader.object().getAllGroupMembers(CHANNELS_QUERY_PATH).size();
    }

    public List<String> channelNames() {
        return this._reader.object().getAllGroupMembers(CHANNELS_QUERY_PATH);
    }

    public ImageStack extractAllChannels() {
        if (this._image == null) {
            this._image = new ImageStack();
        }
        List<String> channels = this.channelNames();
        int ch_count = 0;
        ListIterator<String> iter = channels.listIterator();
        while (iter.hasNext()) {
            String channel_id = iter.next();
            try {
                ImageStack frames = this.extract(channel_id, ch_count);
                this._image.merge(frames);
                this.extractAttributes(this._image);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++ch_count;
        }
        return this._image;
    }

    public ImageStack extract(String channelID) throws Exception {
        IHDF5OpaqueReader channel = this._reader.opaque();
        byte[] data = channel.readArray("/Channels/" + channelID);
        FFMpegLoader movie = new FFMpegLoader(data);
        movie.start();
        movie.grab();
        ImageStack stack = movie.getImage();
        this.extractAttributes(stack);
        movie.close();
        return stack;
    }

    public ImageStack extract(String channelID, int chcount) throws Exception {
        IHDF5OpaqueReader channel = this._reader.opaque();
        byte[] data = channel.readArray("/Channels/" + channelID);
        FFMpegLoader movie = new FFMpegLoader(data);
        movie.setChannelNum(this.numberOfChannels());
        movie.setChannelCount(chcount);
        movie.start();
        movie.grab();
        ImageStack stack = movie.getImage();
        this.extractAttributes(stack);
        movie.close();
        return stack;
    }

    private void extractAttributes(ImageStack image) {
        IHDF5LongReader ihdf5LongReader;
        IHDF5Reader ihdf5reader;
        if (image == null) {
            image = new ImageStack();
        }
        if ((ihdf5reader = this._reader).object().hasAttribute(CHANNELS_QUERY_PATH, PAD_BOTTOM_ATTRIB)) {
            ihdf5LongReader = ihdf5reader.int64();
            int paddingBottom = (int)ihdf5LongReader.getAttr(CHANNELS_QUERY_PATH, PAD_BOTTOM_ATTRIB);
            image.setPaddingBottom(paddingBottom);
        } else {
            image.setPaddingBottom(-1);
        }
        if (ihdf5reader.object().hasAttribute(CHANNELS_QUERY_PATH, PAD_RIGHT_ATTRIB)) {
            ihdf5LongReader = ihdf5reader.int64();
            int paddingRight = (int)ihdf5LongReader.getAttr(CHANNELS_QUERY_PATH, PAD_RIGHT_ATTRIB);
            image.setPaddingRight(paddingRight);
        } else {
            image.setPaddingRight(-1);
        }
        double[] vxsize = null;
        if (ihdf5reader.object().hasAttribute("/", VX_SIZE_ATTRIB)) {
            IHDF5DoubleReader ihdf5DoubleReader = ihdf5reader.float64();
            vxsize = ihdf5DoubleReader.getArrayAttr("/", VX_SIZE_ATTRIB);
        }
        if (vxsize != null && vxsize.length == 3) {
            image.setSpacings(vxsize[0], vxsize[1], vxsize[2]);
        }
        if (ihdf5reader.object().hasAttribute("/", UNIT_ATTRIB)) {
            IHDF5StringReader ihdf5StringReader = ihdf5reader.string();
            String unit = ihdf5StringReader.getAttr("/", UNIT_ATTRIB);
            image.setUnit(unit);
        }
    }

    public String getAllAttributeString(String path) {
        String attrs = "";
        List names = this._reader.object().getAllAttributeNames(path);
        for (String n : names) {
            attrs = attrs + this.getAttributeString(this._reader, path, n) + System.getProperty("line.separator");
        }
        return attrs;
    }

    public String getAttributeString(IHDF5Reader reader, String object, String attribute) {
        String rtnVal = "";
        if (!reader.exists(object)) {
            return rtnVal;
        }
        if (!reader.object().hasAttribute(object, attribute)) {
            return rtnVal;
        }
        HDF5DataTypeInformation attributeInfo = reader.object().getAttributeInformation(object, attribute);
        Class type = attributeInfo.tryGetJavaType();
        if (type.isAssignableFrom(long[].class)) {
            if (attributeInfo.isSigned()) {
                rtnVal = Arrays.stream(reader.int64().getArrayAttr(object, attribute)).mapToObj(String::valueOf).collect(Collectors.joining(", "));
                return attribute + ": [ " + rtnVal + " ]";
            }
            rtnVal = Arrays.stream(reader.uint64().getArrayAttr(object, attribute)).mapToObj(String::valueOf).collect(Collectors.joining(", "));
            return attribute + ": [ " + rtnVal + " ]";
        }
        if (type.isAssignableFrom(int[].class)) {
            if (attributeInfo.isSigned()) {
                rtnVal = Arrays.stream(reader.int32().getArrayAttr(object, attribute)).mapToObj(String::valueOf).collect(Collectors.joining(", "));
                return attribute + ": [ " + rtnVal + " ]";
            }
            rtnVal = Arrays.stream(reader.uint32().getArrayAttr(object, attribute)).mapToObj(String::valueOf).collect(Collectors.joining(", "));
            return attribute + ": [ " + rtnVal + " ]";
        }
        if (type.isAssignableFrom(short[].class)) {
            if (attributeInfo.isSigned()) {
                short[] s = reader.int16().getArrayAttr(object, attribute);
                int[] ia = new int[s.length];
                for (int i = 0; i < s.length; ++i) {
                    ia[i] = s[i];
                }
                rtnVal = Arrays.stream(ia).mapToObj(String::valueOf).collect(Collectors.joining(", "));
                return attribute + ": [ " + rtnVal + " ]";
            }
            short[] s = reader.int16().getArrayAttr(object, attribute);
            int[] ia = new int[s.length];
            for (int i = 0; i < s.length; ++i) {
                ia[i] = s[i];
            }
            rtnVal = Arrays.stream(ia).mapToObj(String::valueOf).collect(Collectors.joining(", "));
            return attribute + ": [ " + rtnVal + " ]";
        }
        if (type.isAssignableFrom(byte[].class)) {
            if (attributeInfo.isSigned()) {
                byte[] s = reader.int8().getArrayAttr(object, attribute);
                int[] ia = new int[s.length];
                for (int i = 0; i < s.length; ++i) {
                    ia[i] = s[i];
                }
                rtnVal = Arrays.stream(ia).mapToObj(String::valueOf).collect(Collectors.joining(", "));
                return attribute + ": [ " + rtnVal + " ]";
            }
            byte[] s = reader.uint8().getArrayAttr(object, attribute);
            int[] ia = new int[s.length];
            for (int i = 0; i < s.length; ++i) {
                ia[i] = s[i];
            }
            rtnVal = Arrays.stream(ia).mapToObj(String::valueOf).collect(Collectors.joining(", "));
            return attribute + ": [ " + rtnVal + " ]";
        }
        if (type.isAssignableFrom(double[].class)) {
            rtnVal = Arrays.stream(reader.float64().getArrayAttr(object, attribute)).mapToObj(String::valueOf).collect(Collectors.joining(", "));
            return attribute + ": [ " + rtnVal + " ]";
        }
        if (type.isAssignableFrom(float[].class)) {
            float[] s = reader.float32().getArrayAttr(object, attribute);
            double[] ia = new double[s.length];
            for (int i = 0; i < s.length; ++i) {
                ia[i] = s[i];
            }
            rtnVal = Arrays.stream(ia).mapToObj(String::valueOf).collect(Collectors.joining(", "));
            return attribute + ": [ " + rtnVal + " ]";
        }
        if (type.isAssignableFrom(String[].class)) {
            return attribute + ": [ " + String.join((CharSequence)", ", reader.string().getArrayAttr(object, attribute)) + " ]";
        }
        if (type.isAssignableFrom(Long.TYPE)) {
            if (attributeInfo.isSigned()) {
                return attribute + ": " + String.valueOf(reader.int64().getAttr(object, attribute));
            }
            return attribute + ": " + String.valueOf(reader.uint64().getAttr(object, attribute));
        }
        if (type.isAssignableFrom(Integer.TYPE)) {
            if (attributeInfo.isSigned()) {
                return attribute + ": " + String.valueOf(reader.int32().getAttr(object, attribute));
            }
            return attribute + ": " + String.valueOf(reader.uint32().getAttr(object, attribute));
        }
        if (type.isAssignableFrom(Short.TYPE)) {
            if (attributeInfo.isSigned()) {
                return attribute + ": " + String.valueOf(reader.int16().getAttr(object, attribute));
            }
            return attribute + ": " + String.valueOf(reader.uint16().getAttr(object, attribute));
        }
        if (type.isAssignableFrom(Byte.TYPE)) {
            if (attributeInfo.isSigned()) {
                return attribute + ": " + String.valueOf(reader.int8().getAttr(object, attribute));
            }
            return attribute + ": " + String.valueOf(reader.uint8().getAttr(object, attribute));
        }
        if (type.isAssignableFrom(Double.TYPE)) {
            return attribute + ": " + String.valueOf(reader.float64().getAttr(object, attribute));
        }
        if (type.isAssignableFrom(Float.TYPE)) {
            return attribute + ": " + String.valueOf(reader.float32().getAttr(object, attribute));
        }
        if (type.isAssignableFrom(String.class)) {
            return attribute + ": " + reader.string().getAttr(object, attribute);
        }
        return rtnVal;
    }

    public void saveFrame(int iFrame, DataAcceptor acceptor) throws Exception {
        int width = this._image.width();
        int height = this._image.height();
        byte[] data = this._image.interleave(iFrame, 0, 3);
        int linesize = this._image.linesize(iFrame);
        acceptor.accept(data, linesize, width, height);
    }

    public static interface DataAcceptor {
        public void accept(byte[] var1, int var2, int var3, int var4);
    }
}

