/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.it.jacs.shared.ffmpeg;

import ij.IJ;
import ij.macro.Interpreter;
import org.bytedeco.ffmpeg.avcodec.AVCodec;
import org.bytedeco.ffmpeg.avcodec.AVCodecContext;
import org.bytedeco.ffmpeg.avcodec.AVCodecParameters;
import org.bytedeco.ffmpeg.avcodec.AVPacket;
import org.bytedeco.ffmpeg.avformat.AVFormatContext;
import org.bytedeco.ffmpeg.avformat.AVIOContext;
import org.bytedeco.ffmpeg.avformat.AVStream;
import org.bytedeco.ffmpeg.avformat.Read_packet_Pointer_BytePointer_int;
import org.bytedeco.ffmpeg.avformat.Seek_Pointer_long_int;
import org.bytedeco.ffmpeg.avutil.AVComponentDescriptor;
import org.bytedeco.ffmpeg.avutil.AVDictionary;
import org.bytedeco.ffmpeg.avutil.AVFrame;
import org.bytedeco.ffmpeg.avutil.AVPixFmtDescriptor;
import org.bytedeco.ffmpeg.avutil.AVRational;
import org.bytedeco.ffmpeg.global.avcodec;
import org.bytedeco.ffmpeg.global.avdevice;
import org.bytedeco.ffmpeg.global.avformat;
import org.bytedeco.ffmpeg.global.avutil;
import org.bytedeco.ffmpeg.global.swscale;
import org.bytedeco.ffmpeg.swscale.SwsContext;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerPointer;
import org.janelia.it.jacs.shared.ffmpeg.FFMPGByteAcceptor;
import org.janelia.it.jacs.shared.ffmpeg.Frame;
import org.janelia.it.jacs.shared.ffmpeg.ImageStack;
import org.janelia.it.jacs.shared.ffmpeg.ReadInput;

public class FFMpegLoader {
    private String _filename;
    private AVFormatContext _format_context;
    private AVStream _video_stream;
    private AVCodecContext _video_codec;
    private AVFrame picture = null;
    private AVFrame picture_rgb = null;
    private BytePointer _buffer_rgb;
    private AVPacket pkt;
    private AVPacket pkt2;
    private int[] got_frame;
    private SwsContext img_convert_ctx;
    private ImageStack _image;
    private boolean _frame_grabbed;
    private long _time_stamp;
    private int frameNumber;
    private boolean deinterlace = false;
    private int _components_per_frame;
    private long _frame_count = 0L;
    private long _frame_num = 0L;
    private boolean _flush = false;
    private BytePointer _buffer = null;
    private int channel_num = 1;
    private int channel_count = 0;

    public FFMpegLoader(String filename) {
        this._filename = filename;
        this._format_context = new AVFormatContext(null);
    }

    public FFMpegLoader(final byte[] ibytes) {
        this._filename = "";
        int BUFFER_SIZE = ibytes.length;
        this._buffer = new BytePointer(avutil.av_malloc((long)BUFFER_SIZE));
        this._format_context = avformat.avformat_alloc_context();
        Seek_Pointer_long_int seeker = new Seek_Pointer_long_int(){

            public long call(Pointer pointer, long offset, int whence) {
                return ibytes.length;
            }
        };
        this._format_context.pb(avformat.avio_alloc_context((BytePointer)this._buffer, (int)BUFFER_SIZE, (int)0, null, (Read_packet_Pointer_BytePointer_int)new ReadInput(ibytes), null, (Seek_Pointer_long_int)seeker));
        this._format_context.flags(this._format_context.flags() | 0x80);
    }

    public ImageStack getImage() {
        return this._image;
    }

    public void close() throws Exception {
        if (this.pkt != null && this.pkt2 != null) {
            if (this.pkt2.size() > 0) {
                avcodec.av_packet_unref((AVPacket)this.pkt);
            }
            this.pkt2 = null;
            this.pkt = null;
        }
        if (this._video_codec != null) {
            avcodec.avcodec_free_context((AVCodecContext)this._video_codec);
            this._video_codec = null;
        }
        if (this._format_context != null && !this._format_context.isNull()) {
            avutil.av_free((Pointer)this._format_context.pb().buffer());
            avformat.avio_context_free((AVIOContext)this._format_context.pb());
            avformat.avformat_free_context((AVFormatContext)this._format_context);
            this._format_context = null;
        }
        if (this.img_convert_ctx != null) {
            swscale.sws_freeContext((SwsContext)this.img_convert_ctx);
            this.img_convert_ctx = null;
        }
        avutil.av_frame_free((AVFrame)this.picture_rgb);
        this.got_frame = null;
        this._frame_grabbed = false;
        this._time_stamp = 0L;
        this.frameNumber = 0;
    }

    public void release() throws Exception {
        this._image.release();
        this._image = null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public int getImageWidth() {
        return this._image == null ? -1 : this._image.width();
    }

    public int getImageHeight() {
        return this._image == null ? -1 : this._image.height();
    }

    public boolean isDeinterlace() {
        return this.deinterlace;
    }

    public void setDeinterlace(boolean deinterlace) {
        this.deinterlace = deinterlace;
    }

    public void setChannelNum(int chnum) {
        this.channel_num = chnum;
    }

    public void setChannelCount(int chcount) {
        this.channel_count = chcount;
    }

    public int getPixelFormat() {
        int result = -1;
        if (this._components_per_frame == 1) {
            result = this._image.getBytesPerPixel() == 1 ? 8 : (this._image.getBytesPerPixel() == 2 ? 29 : -1);
        } else if (this._components_per_frame == 3) {
            result = 3;
        } else if (this._components_per_frame == 4) {
            result = 28;
        } else if (this._video_codec != null) {
            result = this._video_codec.pix_fmt();
        }
        return result;
    }

    public double getFrameRate() {
        if (this._video_stream == null) {
            return 0.0;
        }
        AVRational r = this._video_stream.r_frame_rate();
        return (double)r.num() / (double)r.den();
    }

    public void setFrameNumber(int frameNumber) throws Exception {
        this.setTimestamp(Math.round((double)(1000000L * (long)frameNumber) / this.getFrameRate()));
    }

    public void setTimestamp(long time_stamp) throws Exception {
        if (this._format_context != null) {
            int ret;
            time_stamp = time_stamp * 1000000L / 1000000L;
            if (this._format_context.start_time() != avutil.AV_NOPTS_VALUE) {
                time_stamp += this._format_context.start_time();
            }
            if ((ret = avformat.avformat_seek_file((AVFormatContext)this._format_context, (int)-1, (long)Long.MIN_VALUE, (long)time_stamp, (long)Long.MAX_VALUE, (int)1)) < 0) {
                throw new Exception("avformat_seek_file() error " + ret + ": Could not seek file to time_stamp " + time_stamp + ".");
            }
            if (this._video_codec != null) {
                avcodec.avcodec_flush_buffers((AVCodecContext)this._video_codec);
            }
            if (this.pkt2.size() > 0) {
                this.pkt2.size(0);
                avcodec.av_packet_unref((AVPacket)this.pkt);
            }
            while (this._time_stamp > time_stamp + 1L && this.grabFrame() != null) {
            }
            while (this._time_stamp < time_stamp - 1L && this.grabFrame() != null) {
            }
            if (this._video_codec != null) {
                this._frame_grabbed = true;
            }
        }
    }

    public int getLengthInFrames() {
        return (int)((double)this.getLengthInTime() * this.getFrameRate() / 1000000.0);
    }

    public long getLengthInTime() {
        return this._format_context.duration() * 1000000L / 1000000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        Class<avcodec> clazz = avcodec.class;
        synchronized (avcodec.class) {
            this.startUnsafe();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void startUnsafe() throws Exception {
        this.img_convert_ctx = null;
        this._video_codec = null;
        this.pkt = new AVPacket();
        this.pkt2 = new AVPacket();
        this.got_frame = new int[1];
        this._image = new ImageStack();
        this._frame_grabbed = false;
        this._time_stamp = 0L;
        this.frameNumber = 0;
        int thread = Runtime.getRuntime().availableProcessors();
        this.pkt2.size(0);
        AVDictionary options = new AVDictionary(null);
        int ret = avformat.avformat_open_input((AVFormatContext)this._format_context, (String)this._filename, null, (AVDictionary)options);
        if (ret < 0) {
            avutil.av_dict_set((AVDictionary)options, (String)"pixel_format", null, (int)0);
            ret = avformat.avformat_open_input((AVFormatContext)this._format_context, (String)this._filename, null, (AVDictionary)options);
            if (ret < 0) {
                throw new Exception("avformat_open_input() error " + ret + ": Could not open input \"" + this._filename + "\". (Has setFormat() been called?)");
            }
        }
        avutil.av_dict_free((AVDictionary)options);
        ret = avformat.avformat_find_stream_info((AVFormatContext)this._format_context, (PointerPointer)null);
        if (ret < 0) {
            throw new Exception("avformat_find_stream_info() error " + ret + ": Could not find stream information.");
        }
        avformat.av_dump_format((AVFormatContext)this._format_context, (int)0, (String)this._filename, (int)0);
        this._video_stream = null;
        int nb_streams = this._format_context.nb_streams();
        for (int i = 0; i < nb_streams; ++i) {
            AVStream st = this._format_context.streams(i);
            if (this._video_stream != null || st.codecpar().codec_type() != 0) continue;
            this._video_stream = st;
            AVCodec decoder = avcodec.avcodec_find_decoder((int)this._video_stream.codecpar().codec_id());
            if (decoder == null) {
                throw new Exception("Unexpected decorder: " + this._video_stream.codecpar().codec_id());
            }
            this._video_codec = avcodec.avcodec_alloc_context3((AVCodec)decoder);
            if (avcodec.avcodec_parameters_to_context((AVCodecContext)this._video_codec, (AVCodecParameters)this._video_stream.codecpar()) < 0) {
                throw new Exception("avcodec_parameters_to_context failed.");
            }
            this._video_codec.thread_count(thread);
            ret = avcodec.avcodec_open2((AVCodecContext)this._video_codec, (AVCodec)decoder, (PointerPointer)null);
            if (ret < 0) {
                throw new Exception("avcodec_open2() error " + ret + ": Could not open video codec.");
            }
            if (this._video_codec.time_base().num() <= 1000 || this._video_codec.time_base().den() != 1) break;
            this._video_codec.time_base().den(1000);
            break;
        }
        if (this._video_stream == null) {
            throw new Exception("Did not find a video stream inside \"" + this._filename + "\".");
        }
        int pix_fmt = this._video_codec.pix_fmt();
        AVPixFmtDescriptor fmt = avutil.av_pix_fmt_desc_get((int)pix_fmt);
        byte comps = fmt.nb_components();
        this._components_per_frame = comps;
        AVComponentDescriptor desc = fmt.comp();
        if (desc.depth() == 8) {
            this._components_per_frame = 3;
            this._image.setBytesPerPixel(1);
        } else {
            this._components_per_frame = 1;
            this._image.setBytesPerPixel(2);
        }
        this.img_convert_ctx = swscale.sws_getContext((int)this._video_codec.width(), (int)this._video_codec.height(), (int)this._video_codec.pix_fmt(), (int)this._video_codec.width(), (int)this._video_codec.height(), (int)this.getPixelFormat(), (int)4, null, null, (DoublePointer)null);
        if (this.img_convert_ctx == null) {
            throw new Exception("sws_getContext() error: Cannot initialize the conversion context.");
        }
        if (!Interpreter.isBatchMode()) {
            IJ.showStatus((String)"Loading H5J...");
            IJ.showProgress((double)((double)this.channel_count / (double)this.channel_num));
        }
    }

    public void stop() throws Exception {
        this.release();
    }

    private void allocateFrame(Frame f) throws Exception {
        this.picture = avutil.av_frame_alloc();
        if (this.picture == null) {
            throw new Exception("avcodec_alloc_frame() error: Could not allocate raw picture frame.");
        }
        int width = this.getImageWidth() > 0 ? this.getImageWidth() : this._video_codec.width();
        int height = this.getImageHeight() > 0 ? this.getImageHeight() : this._video_codec.height();
        this._image.setHeight(height);
        this._image.setWidth(width);
        int fmt = this.getPixelFormat();
        f.imageBytes.add(new byte[width * height * this._image.getBytesPerPixel()]);
    }

    private void extractBytes(Frame frameOutput, BytePointer imageBytesInput) {
        int width = this._video_codec.width();
        int height = this._video_codec.height();
        int linesize = this._image.getBytesPerPixel() == 1 ? this.picture_rgb.linesize().get(0L) / 3 : this.picture_rgb.linesize().get(0L) / 2;
        int padding = linesize - this._video_codec.width();
        if (padding < 0) {
            padding = 0;
        }
        if (this._image.getBytesPerPixel() == 1) {
            byte[] outputBytes = frameOutput.imageBytes.get(0);
            byte[] inputBytes = new byte[linesize * height * 3];
            imageBytesInput.get(inputBytes);
            int inputOffset = 0;
            int outputOffset = 0;
            for (int rows = 0; rows < height; ++rows) {
                for (int cols = 0; cols < width; ++cols) {
                    outputBytes[outputOffset] = inputBytes[3 * inputOffset];
                    ++inputOffset;
                    ++outputOffset;
                }
                inputOffset += padding;
            }
        } else {
            byte[] outputBytes = frameOutput.imageBytes.get(0);
            byte[] inputBytes = new byte[linesize * height * this._image.getBytesPerPixel()];
            imageBytesInput.get(inputBytes);
            int inputOffset = 0;
            int outputOffset = 0;
            int colnum = width * this._image.getBytesPerPixel();
            for (int rows = 0; rows < height; ++rows) {
                for (int cols = 0; cols < colnum; ++cols) {
                    outputBytes[outputOffset] = inputBytes[inputOffset];
                    ++inputOffset;
                    ++outputOffset;
                }
                inputOffset += padding * this._image.getBytesPerPixel();
            }
        }
    }

    private void processImage(Frame frame) throws Exception {
        if (this.picture_rgb == null) {
            this.picture_rgb = avutil.av_frame_alloc();
            if (this.picture_rgb == null) {
                throw new Exception("avcodec_alloc_frame() error: Could not allocate rbg picture frame.");
            }
            avutil.av_frame_copy_props((AVFrame)this.picture_rgb, (AVFrame)this.picture);
            this.picture_rgb.width(this.getImageWidth());
            this.picture_rgb.height(this.getImageHeight());
            this.picture_rgb.format(this.getPixelFormat());
            this.picture_rgb.nb_samples(0);
            avutil.av_frame_get_buffer((AVFrame)this.picture_rgb, (int)0);
        }
        swscale.sws_scale((SwsContext)this.img_convert_ctx, (PointerPointer)this.picture.data(), (IntPointer)this.picture.linesize(), (int)0, (int)this._video_codec.height(), (PointerPointer)this.picture_rgb.data(), (IntPointer)this.picture_rgb.linesize());
        this.extractBytes(frame, this.picture_rgb.data(0));
        avutil.av_frame_free((AVFrame)this.picture);
    }

    public void grab() throws Exception {
        boolean done = false;
        this._frame_count = 0L;
        this._frame_num = this._video_stream.nb_frames() > 0L ? this._video_stream.nb_frames() : Long.MAX_VALUE;
        this._flush = false;
        while (!done) {
            Frame f = this.grabFrame();
            if (f != null) {
                this._image.add(f);
            } else {
                done = true;
            }
            if (Interpreter.isBatchMode()) continue;
            IJ.showStatus((String)"Loading H5J...");
            IJ.showProgress((double)((double)((long)this.channel_count * this._frame_num + this._frame_count) / (double)((long)this.channel_num * this._frame_num)));
        }
        if (this._video_stream.nb_frames() > 0L && (long)this._image.getNumFrames() < this._video_stream.nb_frames()) {
            int count = this._image.getNumFrames();
            Frame lastframe = this._image.frame(count - 1);
            while ((long)count < this._video_stream.nb_frames()) {
                System.err.println("The last frame was dropped. Duplicating the second frame before the last... (Channel " + this.channel_count + ")");
                this._image.add(lastframe);
                ++count;
            }
            this._frame_count = count;
            if (!Interpreter.isBatchMode()) {
                IJ.showStatus((String)"Loading H5J...");
                IJ.showProgress((double)((double)((long)this.channel_count * this._frame_num + this._frame_count) / (double)((long)this.channel_num * this._frame_num)));
            }
        }
    }

    public Frame grabFrame() throws Exception {
        if (this._format_context == null || this._format_context.isNull()) {
            throw new Exception("Could not grab: No AVFormatContext. (Has start() been called?)");
        }
        Frame frame = new Frame();
        if (this._frame_grabbed) {
            this._frame_grabbed = false;
            frame.keyFrame = this.picture.key_frame() != 0;
            this.processImage(frame);
            return frame;
        }
        boolean done = false;
        if (!this._flush) {
            while (!done) {
                if (this._frame_count >= this._frame_num || avformat.av_read_frame((AVFormatContext)this._format_context, (AVPacket)this.pkt) < 0) {
                    if (this._video_stream != null) {
                        this.pkt.stream_index(this._video_stream.index());
                        this.pkt.flags(1);
                        this.pkt.data(null);
                        this.pkt.size(0);
                        this._flush = true;
                    } else {
                        return null;
                    }
                }
                if (this.pkt.stream_index() == this._video_stream.index()) {
                    if (avcodec.avcodec_send_packet((AVCodecContext)this._video_codec, (AVPacket)this.pkt) < 0) {
                        throw new Exception("avcodec_send_packet failed");
                    }
                    this.allocateFrame(frame);
                    int ret = avcodec.avcodec_receive_frame((AVCodecContext)this._video_codec, (AVFrame)this.picture);
                    if (ret >= 0) {
                        long pts = this.picture.best_effort_timestamp();
                        AVRational time_base = this._video_stream.time_base();
                        this._time_stamp = 1000000L * pts * (long)time_base.num() / (long)time_base.den();
                        this.frameNumber = (int)((double)this._time_stamp * this.getFrameRate() / 1000000.0);
                        frame.keyFrame = this.picture.key_frame() != 0;
                        this.processImage(frame);
                        ++this._frame_count;
                        done = true;
                    } else if (ret == avutil.AVERROR_EAGAIN()) {
                        avutil.av_frame_free((AVFrame)this.picture);
                        frame.release();
                    } else {
                        return null;
                    }
                }
                avcodec.av_packet_unref((AVPacket)this.pkt);
            }
        } else {
            this.allocateFrame(frame);
            int ret = avcodec.avcodec_receive_frame((AVCodecContext)this._video_codec, (AVFrame)this.picture);
            if (ret >= 0) {
                long pts = this.picture.best_effort_timestamp();
                AVRational time_base = this._video_stream.time_base();
                this._time_stamp = 1000000L * pts * (long)time_base.num() / (long)time_base.den();
                this.frameNumber = (int)((double)this._time_stamp * this.getFrameRate() / 1000000.0);
                frame.keyFrame = this.picture.key_frame() != 0;
                this.processImage(frame);
                ++this._frame_count;
                done = true;
            } else {
                return null;
            }
        }
        return frame;
    }

    public void saveFrame(int iFrame, FFMPGByteAcceptor acceptor) throws Exception {
        int width = this._image.width();
        int height = this._image.height();
        byte[] data = this._image.image(iFrame, 0);
        int linesize = this._image.linesize(iFrame);
        acceptor.accept(data, linesize, width, height);
    }

    static {
        avdevice.avdevice_register_all();
        avformat.avformat_network_init();
    }

    public static enum ImageMode {
        COLOR,
        GRAY,
        RAW;

    }
}

