/*
 * Decompiled with CFR 0.152.
 */
package io.scif.ome.translators;

import io.scif.Metadata;
import io.scif.formats.EPSFormat;
import io.scif.ome.OMEMetadata;
import io.scif.ome.translators.FromOMETranslator;
import loci.formats.ome.OMEXMLMetadata;
import net.imagej.axis.Axes;
import org.scijava.plugin.Plugin;

public class EPSTranslator {

    @Plugin(type=FromOMETranslator.class, priority=100.0)
    public static class OMEEPSTranslator
    extends FromOMETranslator<EPSFormat.Metadata> {
        public Class<? extends Metadata> source() {
            return OMEMetadata.class;
        }

        public Class<? extends Metadata> dest() {
            return EPSFormat.Metadata.class;
        }

        protected void translateFormatMetadata(OMEMetadata source, EPSFormat.Metadata dest) {
            OMEXMLMetadata meta = source.getRoot();
            int sizeX = (Integer)meta.getPixelsSizeX(0).getValue();
            int sizeY = (Integer)meta.getPixelsSizeY(0).getValue();
            int sizeC = (Integer)meta.getChannelSamplesPerPixel(0, 0).getValue();
            dest.get(0).setAxisLength(Axes.X, (long)sizeX);
            dest.get(0).setAxisLength(Axes.Y, (long)sizeY);
            dest.get(0).setAxisLength(Axes.CHANNEL, (long)sizeC);
        }
    }
}

