/*
 * Decompiled with CFR 0.152.
 */
package io.scif.ome.translators;

import io.scif.Metadata;
import io.scif.common.DateTools;
import io.scif.formats.DICOMFormat;
import io.scif.ome.OMEMetadata;
import io.scif.ome.translators.ToOMETranslator;
import loci.formats.ome.OMEXMLMetadata;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.xml.model.primitives.Timestamp;
import org.scijava.plugin.Plugin;

public class DICOMTranslator {

    @Plugin(type=ToOMETranslator.class, priority=100.0)
    public static class DICOMOMETranslator
    extends ToOMETranslator<DICOMFormat.Metadata> {
        public Class<? extends Metadata> source() {
            return DICOMFormat.Metadata.class;
        }

        public Class<? extends Metadata> dest() {
            return OMEMetadata.class;
        }

        protected void translateFormatMetadata(DICOMFormat.Metadata source, OMEMetadata dest) {
            int i;
            String stamp = null;
            OMEXMLMetadata store = dest.getRoot();
            String date = source.getDate();
            String time = source.getTime();
            String imageType = source.getImageType();
            String pixelSizeX = source.getPixelSizeX();
            String pixelSizeY = source.getPixelSizeY();
            Double pixelSizeZ = source.getPixelSizeZ();
            if (date != null && time != null) {
                stamp = date + " " + time;
                stamp = DateTools.formatDate((String)stamp, (String)"yyyy.MM.dd HH:mm:ss.SSSSSS");
            }
            if (stamp == null || stamp.trim().equals("")) {
                stamp = null;
            }
            for (i = 0; i < source.getImageCount(); ++i) {
                if (stamp != null) {
                    store.setImageAcquisitionDate(new Timestamp(stamp), i);
                }
                store.setImageName("Series " + i, i);
            }
            for (i = 0; i < source.getImageCount(); ++i) {
                store.setImageDescription(imageType, i);
                if (pixelSizeX != null) {
                    Double sizeX = new Double(pixelSizeX);
                    if (sizeX > 0.0) {
                        store.setPixelsPhysicalSizeX(new Length((Number)sizeX, UNITS.MICROMETER), i);
                    } else {
                        this.log().warn((Object)("Expected positive value for PhysicalSizeX; got " + sizeX));
                    }
                }
                if (pixelSizeY != null) {
                    Double sizeY = new Double(pixelSizeY);
                    if (sizeY > 0.0) {
                        store.setPixelsPhysicalSizeY(new Length((Number)sizeY, UNITS.MICROMETER), i);
                    } else {
                        this.log().warn((Object)("Expected positive value for PhysicalSizeY; got " + sizeY));
                    }
                }
                if (pixelSizeZ != null && pixelSizeZ > 0.0) {
                    store.setPixelsPhysicalSizeZ(new Length((Number)pixelSizeZ, UNITS.MICROMETER), i);
                    continue;
                }
                this.log().warn((Object)("Expected positive value for PhysicalSizeZ; got " + pixelSizeZ));
            }
        }
    }
}

