/*
 * Decompiled with CFR 0.152.
 */
package io.scif.ome.services;

import io.scif.FormatException;
import io.scif.ImageMetadata;
import io.scif.Metadata;
import io.scif.Reader;
import io.scif.ome.services.OMEMetadataService;
import io.scif.ome.services.OMEXMLService;
import io.scif.services.FormatService;
import io.scif.util.FormatTools;
import java.util.Arrays;
import java.util.List;
import loci.common.services.ServiceException;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import net.imagej.axis.CalibratedAxis;
import net.imagej.axis.DefaultLinearAxis;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.quantity.Time;
import ome.xml.model.enums.Binning;
import ome.xml.model.enums.Correction;
import ome.xml.model.enums.DetectorType;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.ExperimentType;
import ome.xml.model.enums.Immersion;
import ome.xml.model.enums.LaserMedium;
import ome.xml.model.enums.LaserType;
import ome.xml.model.enums.handlers.BinningEnumHandler;
import ome.xml.model.enums.handlers.CorrectionEnumHandler;
import ome.xml.model.enums.handlers.DetectorTypeEnumHandler;
import ome.xml.model.enums.handlers.ExperimentTypeEnumHandler;
import ome.xml.model.enums.handlers.ImmersionEnumHandler;
import ome.xml.model.enums.handlers.LaserMediumEnumHandler;
import ome.xml.model.enums.handlers.LaserTypeEnumHandler;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.PositiveInteger;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;

@Plugin(type=Service.class)
public class DefaultOMEMetadataService
extends AbstractService
implements OMEMetadataService {
    @Parameter
    private FormatService formatService;
    @Parameter
    private OMEXMLService omexmlService;
    @Parameter
    private LogService logService;

    @Override
    public void populatePixels(MetadataStore store, Metadata meta) {
        this.populatePixels(store, meta, false, true);
    }

    @Override
    public void populatePixels(MetadataStore store, Metadata meta, boolean doPlane) {
        this.populatePixels(store, meta, doPlane, true);
    }

    @Override
    public void populatePixels(MetadataStore store, Metadata meta, boolean doPlane, boolean doImageName) {
        this.populatePixels(store, meta.getAll(), doPlane, doImageName ? meta.getDatasetName() : null);
    }

    @Override
    public void populatePixels(MetadataStore store, List<ImageMetadata> imageMeta, boolean doPlane, String imageName) {
        if (store == null || imageMeta == null) {
            return;
        }
        for (int i = 0; i < imageMeta.size(); ++i) {
            AxisType type;
            if (imageName != null) {
                // empty if block
            }
            String pixelType = FormatTools.getPixelTypeString((int)imageMeta.get(i).getPixelType());
            String order = this.findDimensionOrder(imageMeta.get(i));
            int xSize = (int)imageMeta.get(i).getAxisLength(Axes.X);
            int ySize = (int)imageMeta.get(i).getAxisLength(Axes.Y);
            int zSize = (int)imageMeta.get(i).getAxisLength(Axes.Z);
            int cSize = (int)imageMeta.get(i).getAxisLength(Axes.CHANNEL);
            int tSize = (int)imageMeta.get(i).getAxisLength(Axes.TIME);
            double calX = FormatTools.getScale((ImageMetadata)imageMeta.get(i), (AxisType)Axes.X);
            double calY = FormatTools.getScale((ImageMetadata)imageMeta.get(i), (AxisType)Axes.Y);
            double calZ = FormatTools.getScale((ImageMetadata)imageMeta.get(i), (AxisType)Axes.Z);
            double calC = FormatTools.getScale((ImageMetadata)imageMeta.get(i), (AxisType)Axes.CHANNEL);
            double calT = FormatTools.getScale((ImageMetadata)imageMeta.get(i), (AxisType)Axes.TIME);
            int rgbCCount = 1;
            if (imageMeta.get(i).isMultichannel()) {
                rgbCCount = cSize;
            }
            for (CalibratedAxis axis : imageMeta.get(i).getAxesPlanar()) {
                type = axis.type();
                if (type == Axes.X || type == Axes.Y || type == Axes.CHANNEL) continue;
                ySize = (int)((long)ySize * imageMeta.get(i).getAxisLength(type));
            }
            for (CalibratedAxis axis : imageMeta.get(i).getAxesNonPlanar()) {
                type = axis.type();
                if (type == Axes.Z || type == Axes.TIME || type == Axes.CHANNEL) continue;
                tSize = (int)((long)tSize * imageMeta.get(i).getAxisLength(type));
            }
            this.populateMetadata(store, imageName, i, imageName, imageMeta.get(i).isLittleEndian(), order, pixelType, xSize, ySize, zSize, cSize, tSize, calX, calY, calZ, calC, calT, rgbCCount);
            if (this.omexmlService.isOMEXMLRoot(store.getRoot()) && this.omexmlService.isOMEXMLMetadata(store)) {
                try {
                    OMEXMLMetadata omeMeta = this.omexmlService.getOMEMetadata(this.omexmlService.asRetrieve(store));
                    omeMeta.resolveReferences();
                }
                catch (ServiceException e) {
                    this.logService.warn((Object)"Failed to resolve references", (Throwable)e);
                }
            }
            if (!doPlane) continue;
            int q = 0;
            while ((long)q < imageMeta.get(i).getPlaneCount()) {
                long[] coords = FormatTools.rasterToPosition((long[])imageMeta.get(i).getAxesLengthsNonPlanar(), (long)q);
                store.setPlaneTheZ(new NonNegativeInteger(Integer.valueOf((int)coords[0])), i, q);
                store.setPlaneTheC(new NonNegativeInteger(Integer.valueOf((int)coords[1])), i, q);
                store.setPlaneTheT(new NonNegativeInteger(Integer.valueOf((int)coords[2])), i, q);
                ++q;
            }
        }
    }

    @Override
    public void populateMetadata(MetadataStore store, int imageIndex, String imageName, boolean littleEndian, String dimensionOrder, String pixelType, int sizeX, int sizeY, int sizeZ, int sizeC, int sizeT, double calX, double calY, double calZ, double calC, double calT, int samplesPerPixel) {
        this.populateMetadata(store, null, imageIndex, imageName, littleEndian, dimensionOrder, pixelType, sizeX, sizeY, sizeZ, sizeC, sizeT, calX, calY, calZ, calC, calT, samplesPerPixel);
    }

    @Override
    public void populateMetadata(MetadataStore store, int imageIndex, String imageName, Metadata meta) {
        this.populateMetadata(store, imageIndex, imageName, meta.get(imageIndex));
    }

    @Override
    public void populateMetadata(MetadataStore store, int imageIndex, String imageName, ImageMetadata iMeta) {
        AxisType type;
        int sizeX = (int)iMeta.getAxisLength(Axes.X);
        int sizeY = (int)iMeta.getAxisLength(Axes.Y);
        int sizeZ = (int)iMeta.getAxisLength(Axes.Z);
        int sizeC = (int)iMeta.getAxisLength(Axes.CHANNEL);
        int sizeT = (int)iMeta.getAxisLength(Axes.TIME);
        double calX = FormatTools.getScale((ImageMetadata)iMeta, (AxisType)Axes.X);
        double calY = FormatTools.getScale((ImageMetadata)iMeta, (AxisType)Axes.Y);
        double calZ = FormatTools.getScale((ImageMetadata)iMeta, (AxisType)Axes.Z);
        double calC = FormatTools.getScale((ImageMetadata)iMeta, (AxisType)Axes.CHANNEL);
        double calT = FormatTools.getScale((ImageMetadata)iMeta, (AxisType)Axes.TIME);
        for (CalibratedAxis axis : iMeta.getAxesPlanar()) {
            type = axis.type();
            if (type == Axes.X || type == Axes.Y || type == Axes.CHANNEL) continue;
            sizeY = (int)((long)sizeY * iMeta.getAxisLength(type));
        }
        for (CalibratedAxis axis : iMeta.getAxesNonPlanar()) {
            type = axis.type();
            if (type == Axes.Z || type == Axes.TIME || type == Axes.CHANNEL) continue;
            sizeT = (int)((long)sizeT * iMeta.getAxisLength(type));
        }
        String pixelType = FormatTools.getPixelTypeString((int)iMeta.getPixelType());
        int effSizeC = (int)(iMeta.getPlaneCount() / (long)sizeZ / (long)sizeT);
        int samplesPerPixel = sizeC / effSizeC;
        this.populateMetadata(store, null, imageIndex, imageName, iMeta.isLittleEndian(), this.findDimensionOrder(iMeta), pixelType, sizeX, sizeY, sizeZ, sizeC, sizeT, calX, calY, calZ, calC, calT, samplesPerPixel);
    }

    @Override
    public void populateMetadata(MetadataStore store, String file, int imageIndex, String imageName, boolean littleEndian, String dimensionOrder, String pixelType, int sizeX, int sizeY, int sizeZ, int sizeC, int sizeT, double calX, double calY, double calZ, double calC, double calT, int samplesPerPixel) {
        MetadataTools.populateMetadata((MetadataStore)store, (int)imageIndex, (String)imageName, (boolean)littleEndian, (String)dimensionOrder, (String)pixelType, (int)sizeX, (int)sizeY, (int)sizeZ, (int)sizeC, (int)sizeT, (int)samplesPerPixel);
        this.populateCalibrations(store, imageIndex, calX, calY, calZ, calC, calT);
    }

    @Override
    public void populatePixelsOnly(MetadataStore store, Reader r) {
        Metadata meta = r.getMetadata();
        for (int imageIndex = 0; imageIndex < r.getImageCount(); ++imageIndex) {
            AxisType type;
            ImageMetadata imageMeta = meta.get(imageIndex);
            String pixelType = FormatTools.getPixelTypeString((int)imageMeta.getPixelType());
            int xSize = (int)imageMeta.getAxisLength(Axes.X);
            int ySize = (int)imageMeta.getAxisLength(Axes.Y);
            int zSize = (int)imageMeta.getAxisLength(Axes.Z);
            int cSize = (int)imageMeta.getAxisLength(Axes.CHANNEL);
            int tSize = (int)imageMeta.getAxisLength(Axes.TIME);
            double calX = FormatTools.getScale((Metadata)meta, (int)imageIndex, (AxisType)Axes.X);
            double calY = FormatTools.getScale((Metadata)meta, (int)imageIndex, (AxisType)Axes.Y);
            double calZ = FormatTools.getScale((Metadata)meta, (int)imageIndex, (AxisType)Axes.Z);
            double calC = FormatTools.getScale((Metadata)meta, (int)imageIndex, (AxisType)Axes.CHANNEL);
            double calT = FormatTools.getScale((Metadata)meta, (int)imageIndex, (AxisType)Axes.TIME);
            int rgbCCount = 1;
            if (imageMeta.isMultichannel()) {
                rgbCCount = cSize;
            }
            for (CalibratedAxis axis : imageMeta.getAxesPlanar()) {
                type = axis.type();
                if (type == Axes.X || type == Axes.Y || type == Axes.CHANNEL) continue;
                ySize = (int)((long)ySize * imageMeta.getAxisLength(type));
            }
            for (CalibratedAxis axis : imageMeta.getAxesNonPlanar()) {
                type = axis.type();
                if (type == Axes.Z || type == Axes.TIME || type == Axes.CHANNEL) continue;
                tSize = (int)((long)tSize * imageMeta.getAxisLength(type));
            }
            this.populatePixelsOnly(store, imageIndex, imageMeta.isLittleEndian(), this.findDimensionOrder(meta, imageIndex), pixelType, xSize, ySize, zSize, cSize, tSize, calX, calY, calZ, calC, calT, rgbCCount);
        }
    }

    @Override
    public void populatePixelsOnly(MetadataStore store, int imageIndex, boolean littleEndian, String dimensionOrder, String pixelType, int sizeX, int sizeY, int sizeZ, int sizeC, int sizeT, double calX, double calY, double calZ, double calC, double calT, int samplesPerPixel) {
        MetadataTools.populatePixelsOnly((MetadataStore)store, (int)imageIndex, (boolean)littleEndian, (String)dimensionOrder, (String)pixelType, (int)sizeX, (int)sizeY, (int)sizeZ, (int)sizeC, (int)sizeT, (int)samplesPerPixel);
        this.populateCalibrations(store, imageIndex, calX, calY, calZ, calC, calT);
    }

    @Override
    public void setDefaultDateEnabled(boolean enabled) {
        MetadataTools.setDefaultDateEnabled((boolean)enabled);
    }

    @Override
    public void setDefaultCreationDate(MetadataStore store, String id, int imageIndex) {
        MetadataTools.setDefaultCreationDate((MetadataStore)store, (String)id, (int)imageIndex);
    }

    @Override
    public void verifyMinimumPopulated(MetadataRetrieve src) throws FormatException {
        try {
            MetadataTools.verifyMinimumPopulated((MetadataRetrieve)src);
        }
        catch (loci.formats.FormatException exc) {
            throw new FormatException((Throwable)exc);
        }
    }

    @Override
    public void verifyMinimumPopulated(MetadataRetrieve src, int n) throws FormatException {
        try {
            MetadataTools.verifyMinimumPopulated((MetadataRetrieve)src, (int)n);
        }
        catch (loci.formats.FormatException exc) {
            throw new FormatException((Throwable)exc);
        }
    }

    @Override
    public String findDimensionOrder(Metadata meta, int imageIndex) {
        return this.findDimensionOrder(meta.get(imageIndex));
    }

    @Override
    public String findDimensionOrder(ImageMetadata imageMeta) {
        String dimOrder = "";
        for (CalibratedAxis axis : imageMeta.getAxes()) {
            dimOrder = dimOrder + axis.type().getLabel().charAt(0);
        }
        return this.makeSaneDimensionOrder(dimOrder);
    }

    @Override
    public AxisType[] findDimensionList(String dimensionOrder) {
        AxisType[] axes = new AxisType[dimensionOrder.length()];
        int index = 0;
        for (char d : dimensionOrder.toUpperCase().toCharArray()) {
            switch (d) {
                case 'X': {
                    axes[index] = Axes.X;
                    break;
                }
                case 'Y': {
                    axes[index] = Axes.Y;
                    break;
                }
                case 'Z': {
                    axes[index] = Axes.Z;
                    break;
                }
                case 'C': {
                    axes[index] = Axes.CHANNEL;
                    break;
                }
                case 'T': {
                    axes[index] = Axes.TIME;
                    break;
                }
                default: {
                    axes[index] = Axes.unknown();
                }
            }
            ++index;
        }
        return axes;
    }

    @Override
    public long[] zctToArray(String order, int z, int c, int t) {
        long[] zct = new long[3];
        int index = 0;
        block5: for (char dim : order.toUpperCase().toCharArray()) {
            switch (dim) {
                case 'C': {
                    zct[index] = c;
                    ++index;
                    continue block5;
                }
                case 'Z': {
                    zct[index] = z;
                    ++index;
                    continue block5;
                }
                case 'T': {
                    zct[index] = t;
                    ++index;
                }
            }
        }
        return zct;
    }

    @Override
    public String makeSaneDimensionOrder(String dimensionOrder) {
        return MetadataTools.makeSaneDimensionOrder((String)dimensionOrder);
    }

    @Override
    public String createLSID(String type, int ... indices) {
        return MetadataTools.createLSID((String)type, (int[])indices);
    }

    @Override
    public ExperimentType getExperimentType(String value) throws FormatException {
        ExperimentTypeEnumHandler handler = new ExperimentTypeEnumHandler();
        try {
            return (ExperimentType)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("ExperimentType creation failed", (Throwable)e);
        }
    }

    @Override
    public LaserType getLaserType(String value) throws FormatException {
        LaserTypeEnumHandler handler = new LaserTypeEnumHandler();
        try {
            return (LaserType)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("LaserType creation failed", (Throwable)e);
        }
    }

    @Override
    public LaserMedium getLaserMedium(String value) throws FormatException {
        LaserMediumEnumHandler handler = new LaserMediumEnumHandler();
        try {
            return (LaserMedium)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("LaserMedium creation failed", (Throwable)e);
        }
    }

    @Override
    public Immersion getImmersion(String value) throws FormatException {
        ImmersionEnumHandler handler = new ImmersionEnumHandler();
        try {
            return (Immersion)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("Immersion creation failed", (Throwable)e);
        }
    }

    @Override
    public Correction getCorrection(String value) throws FormatException {
        CorrectionEnumHandler handler = new CorrectionEnumHandler();
        try {
            return (Correction)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("Correction creation failed", (Throwable)e);
        }
    }

    @Override
    public DetectorType getDetectorType(String value) throws FormatException {
        DetectorTypeEnumHandler handler = new DetectorTypeEnumHandler();
        try {
            return (DetectorType)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("DetectorType creation failed", (Throwable)e);
        }
    }

    @Override
    public Binning getBinning(String value) throws FormatException {
        BinningEnumHandler handler = new BinningEnumHandler();
        try {
            return (Binning)handler.getEnumeration(value);
        }
        catch (EnumerationException e) {
            throw new FormatException("Binning creation failed", (Throwable)e);
        }
    }

    @Override
    public void populateMetadata(MetadataRetrieve retrieve, Metadata meta) {
        int numImages = retrieve.getImageCount();
        if (numImages > 0) {
            meta.setDatasetName(retrieve.getImageName(0));
        }
        meta.createImageMetadata(numImages);
        for (int i = 0; i < numImages; ++i) {
            this.populateImageMetadata(retrieve, i, meta.get(i));
        }
    }

    @Override
    public void populateImageMetadata(MetadataRetrieve retrieve, int imageIndex, ImageMetadata iMeta) {
        int sizeX = (Integer)retrieve.getPixelsSizeX(imageIndex).getValue();
        int sizeY = (Integer)retrieve.getPixelsSizeY(imageIndex).getValue();
        int sizeZ = (Integer)retrieve.getPixelsSizeZ(imageIndex).getValue();
        int sizeC = (Integer)retrieve.getPixelsSizeC(imageIndex).getValue();
        int sizeT = (Integer)retrieve.getPixelsSizeT(imageIndex).getValue();
        Length physX = retrieve.getPixelsPhysicalSizeX(imageIndex);
        Length physY = retrieve.getPixelsPhysicalSizeY(imageIndex);
        Length physZ = retrieve.getPixelsPhysicalSizeZ(imageIndex);
        Time physT = retrieve.getPixelsTimeIncrement(imageIndex);
        double calX = physX == null ? 1.0 : physX.value().doubleValue();
        double calY = physY == null ? 1.0 : physY.value().doubleValue();
        double calZ = physZ == null ? 1.0 : physZ.value().doubleValue();
        double calT = physT == null ? 1.0 : physT.value().doubleValue();
        String dimensionOrder = retrieve.getPixelsDimensionOrder(imageIndex).getValue();
        PositiveInteger spp = retrieve.getChannelCount(imageIndex) <= 0 ? null : retrieve.getChannelSamplesPerPixel(imageIndex, 0);
        boolean little = retrieve.getPixelsBigEndian(imageIndex) == false;
        int pType = FormatTools.pixelTypeFromString((String)retrieve.getPixelsType(imageIndex).getValue());
        int rgbCCount = spp == null ? 1 : (Integer)spp.getValue();
        int axisCount = rgbCCount == 1 ? 5 : 6;
        long[] lengths = new long[axisCount];
        CalibratedAxis[] axes = new CalibratedAxis[axisCount];
        iMeta.setPlanarAxisCount(2);
        int i = 0;
        for (char d : dimensionOrder.toUpperCase().toCharArray()) {
            if (axisCount == 6 && i > 0 && axes[i - 1].type() == Axes.Y) {
                sizeC /= rgbCCount;
                lengths[i] = rgbCCount;
                axes[i] = new DefaultLinearAxis(Axes.CHANNEL, "um", 1.0);
                iMeta.setPlanarAxisCount(++i);
            }
            switch (d) {
                case 'X': {
                    lengths[i] = sizeX;
                    axes[i] = new DefaultLinearAxis(Axes.X, "um", calX);
                    break;
                }
                case 'Y': {
                    lengths[i] = sizeY;
                    axes[i] = new DefaultLinearAxis(Axes.Y, "um", calY);
                    break;
                }
                case 'Z': {
                    lengths[i] = sizeZ;
                    axes[i] = new DefaultLinearAxis(Axes.Z, "um", calZ);
                    break;
                }
                case 'C': {
                    lengths[i] = sizeC;
                    if (rgbCCount == 1) {
                        axes[i] = new DefaultLinearAxis(Axes.CHANNEL, "um", 1.0);
                        break;
                    }
                    axes[i] = new DefaultLinearAxis(Axes.get((String)"cPlanes"), "um", 1.0);
                    break;
                }
                case 'T': {
                    lengths[i] = sizeT;
                    axes[i] = new DefaultLinearAxis(Axes.TIME, "um", calT);
                }
            }
            ++i;
        }
        iMeta.populate(iMeta.getName(), Arrays.asList(axes), lengths, pType, FormatTools.getBitsPerPixel((int)pType), true, little, false, false, true);
    }

    private void populateCalibrations(MetadataStore store, int imageIndex, double calX, double calY, double calZ, double calC, double calT) {
        store.setPixelsPhysicalSizeX(new Length((Number)calX, UNITS.MICROMETER), imageIndex);
        store.setPixelsPhysicalSizeY(new Length((Number)calY, UNITS.MICROMETER), imageIndex);
        store.setPixelsPhysicalSizeZ(new Length((Number)calZ, UNITS.MICROMETER), imageIndex);
        store.setPixelsTimeIncrement(new Time((Number)calT, UNITS.SECOND), imageIndex);
    }
}

