/*
 * Decompiled with CFR 0.152.
 */
package io.scif.ome.commands;

import io.scif.FormatException;
import io.scif.Metadata;
import io.scif.SCIFIO;
import io.scif.cli.AbstractSCIFIOToolCommand;
import io.scif.cli.SCIFIOToolCommand;
import io.scif.config.SCIFIOConfig;
import io.scif.filters.PlaneSeparator;
import io.scif.filters.ReaderFilter;
import io.scif.ome.OMEMetadata;
import io.scif.services.InitializeService;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import loci.common.xml.XMLTools;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import net.imagej.axis.CalibratedAxis;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.scijava.io.location.Location;
import org.scijava.io.location.LocationService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=SCIFIOToolCommand.class)
public class OMEXMLToolCommand
extends AbstractSCIFIOToolCommand {
    @Parameter
    private InitializeService initializeService;
    @Argument(metaVar="file", index=0, usage="image dataset to parse")
    private String file;
    @Argument(metaVar="indent", index=1, required=false, usage="indentation for xml nesting")
    private Integer xmlIndent = 3;
    @Argument(index=2, multiValued=true)
    private final List<String> arguments = new ArrayList<String>();
    @Parameter
    private LocationService locationService;

    protected void run() throws CmdLineException {
        try {
            Location loc = this.locationService.resolve(this.file);
            ReaderFilter reader = this.initializeService.initializeReader(loc, new SCIFIOConfig().checkerSetOpen(true));
            ((PlaneSeparator)reader.enable(PlaneSeparator.class)).separate(this.axesToSplit(reader));
            Metadata meta = reader.getMetadata();
            this.printOMEXML(meta);
        }
        catch (FormatException | IOException | URISyntaxException e) {
            throw new CmdLineException(null, e.getMessage());
        }
    }

    protected String description() {
        return "command line tool for printing OME-XML from a dataset";
    }

    protected String getName() {
        return "omexml";
    }

    protected List<String> getExtraArguments() {
        return this.arguments;
    }

    protected void validateParams() throws CmdLineException {
        if (this.file == null) {
            throw new CmdLineException(null, "Argument \"file\" is required");
        }
    }

    private void printOMEXML(Metadata meta) {
        SCIFIO scifio = new SCIFIO(meta.getContext());
        OMEMetadata omexml = new OMEMetadata(scifio.getContext());
        scifio.translator().translate(meta, (Metadata)omexml, false);
        this.log().info((Object)XMLTools.indentXML((String)omexml.getRoot().dumpXML(), (int)this.xmlIndent, (boolean)true));
    }

    private AxisType[] axesToSplit(ReaderFilter r) {
        HashSet<AxisType> axes = new HashSet<AxisType>();
        Metadata meta = r.getTail().getMetadata();
        for (CalibratedAxis t : meta.get(0).getAxesPlanar()) {
            AxisType type = t.type();
            if (type == Axes.X || type == Axes.Y) continue;
            axes.add(type);
        }
        return axes.toArray(new AxisType[axes.size()]);
    }

    public String commandName() {
        return "omexml";
    }
}

