/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.visualization.trackscheme;

import fiji.plugin.trackmate.gui.Fonts;
import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.util.Threads;
import fiji.plugin.trackmate.visualization.trackscheme.SaveAction;
import fiji.plugin.trackmate.visualization.trackscheme.TrackScheme;
import fiji.plugin.trackmate.visualization.trackscheme.TrackSchemeStylist;
import fiji.plugin.trackmate.visualization.trackscheme.utils.SearchBar;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JToolBar;

public class TrackSchemeToolbar
extends JToolBar {
    private static final long serialVersionUID = 3442140463984241266L;
    private final TrackScheme trackScheme;

    public TrackSchemeToolbar(TrackScheme trackScheme) {
        super("Track Scheme toolbar", 0);
        this.trackScheme = trackScheme;
        this.init();
    }

    private void init() {
        this.setFloatable(false);
        boolean defaultLinkingEnabled = false;
        AbstractAction toggleLinkingAction = new AbstractAction(null, Icons.LINKING_OFF_ICON){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isEnabled = TrackSchemeToolbar.this.trackScheme.toggleLinking();
                ImageIcon connectIcon = !isEnabled ? Icons.LINKING_OFF_ICON : Icons.LINKING_ON_ICON;
                this.putValue("SmallIcon", connectIcon);
            }
        };
        JButton toggleLinkingButton = new JButton(toggleLinkingAction);
        toggleLinkingButton.setToolTipText("Toggle linking");
        boolean defaultThumbnailsEnabled = false;
        AbstractAction toggleThumbnailAction = new AbstractAction(null, Icons.THUMBNAIL_OFF_ICON){

            @Override
            public void actionPerformed(ActionEvent e) {
                Threads.run("TrackScheme creating thumbnails thread", () -> {
                    boolean isEnabled = TrackSchemeToolbar.this.trackScheme.toggleThumbnail();
                    ImageIcon thumbnailIcon = !isEnabled ? Icons.THUMBNAIL_OFF_ICON : Icons.THUMBNAIL_ON_ICON;
                    this.putValue("SmallIcon", thumbnailIcon);
                });
            }
        };
        JButton toggleThumbnailsButton = new JButton(toggleThumbnailAction);
        toggleThumbnailsButton.setToolTipText("<html>If enabled, spot thumnails will be captured <br/>Can take long for large models.</html>");
        JButton zoomInButton = new JButton();
        JButton zoomOutButton = new JButton();
        JButton resetZoomButton = new JButton();
        AbstractAction zoomInAction = new AbstractAction(null, Icons.ZOOM_IN_ICON){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackSchemeToolbar.this.trackScheme.zoomIn();
            }
        };
        AbstractAction zoomOutAction = new AbstractAction(null, Icons.ZOOM_OUT_ICON){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackSchemeToolbar.this.trackScheme.zoomOut();
            }
        };
        AbstractAction resetZoomAction = new AbstractAction(null, Icons.RESET_ZOOM_ICON){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackSchemeToolbar.this.trackScheme.resetZoom();
            }
        };
        zoomInButton.setAction(zoomInAction);
        zoomOutButton.setAction(zoomOutAction);
        resetZoomButton.setAction(resetZoomAction);
        zoomInButton.setToolTipText("Zoom in 2x");
        zoomOutButton.setToolTipText("Zoom out 2x");
        resetZoomButton.setToolTipText("Reset zoom");
        JButton redoLayoutButton = new JButton("Layout", Icons.REFRESH_ICON);
        redoLayoutButton.setFont(Fonts.FONT);
        redoLayoutButton.setToolTipText("Re-arrange the tracks.");
        redoLayoutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackSchemeToolbar.this.trackScheme.doTrackLayout();
                TrackSchemeToolbar.this.trackScheme.refresh();
            }
        });
        AbstractAction captureUndecoratedAction = new AbstractAction(null, Icons.CAPTURE_UNDECORATED_ICON){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackSchemeToolbar.this.trackScheme.captureUndecorated();
            }
        };
        AbstractAction captureDecoratedAction = new AbstractAction(null, Icons.CAPTURE_DECORATED_ICON){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackSchemeToolbar.this.trackScheme.captureDecorated();
            }
        };
        SaveAction saveAction = new SaveAction(this.trackScheme);
        JButton captureUndecoratedButton = new JButton(captureUndecoratedAction);
        JButton captureDecoratedButton = new JButton(captureDecoratedAction);
        JButton saveButton = new JButton(saveAction);
        captureUndecoratedButton.setToolTipText("Capture undecorated TrackScheme (zoom=1).");
        captureDecoratedButton.setToolTipText("Capture TrackScheme with decorations.");
        saveButton.setToolTipText("Export to...");
        AbstractAction toggleDisplayDecorations = new AbstractAction(null, Icons.DISPLAY_DECORATIONS_ON_ICON){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((TrackSchemeToolbar)TrackSchemeToolbar.this).trackScheme.getGUI().graphComponent.loopPaintDecorationLevel();
            }
        };
        JButton loopDisplayDecorationsButton = new JButton(toggleDisplayDecorations);
        loopDisplayDecorationsButton.setToolTipText("Loop display decorations.");
        JButton selectStyleButton = new JButton("Style:", Icons.SELECT_STYLE_ICON);
        selectStyleButton.setFont(Fonts.FONT);
        selectStyleButton.setToolTipText("Re-apply current style after model changes.");
        selectStyleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Threads.run("TrackScheme re-applying style thread", () -> {
                    TrackSchemeToolbar.this.trackScheme.doTrackStyle();
                    TrackSchemeToolbar.this.trackScheme.refresh();
                });
            }
        });
        final JComboBox<String> selectStyleBox = new JComboBox<String>(TrackSchemeStylist.VERTEX_STYLE_NAMES.toArray(new String[0]));
        selectStyleBox.setPreferredSize(new Dimension(80, 20));
        selectStyleBox.setSelectedIndex(0);
        selectStyleBox.setMaximumSize(new Dimension(200, 30));
        selectStyleBox.setFont(Fonts.FONT);
        selectStyleBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String selectedStyle = (String)selectStyleBox.getSelectedItem();
                Threads.run("TrackScheme changing style thread", () -> {
                    ((TrackSchemeToolbar)TrackSchemeToolbar.this).trackScheme.stylist.setStyle(selectedStyle);
                    TrackSchemeToolbar.this.trackScheme.doTrackStyle();
                    TrackSchemeToolbar.this.trackScheme.refresh();
                });
            }
        });
        this.add(redoLayoutButton);
        this.addSeparator();
        this.add(selectStyleButton);
        this.add(selectStyleBox);
        this.addSeparator();
        this.add(toggleThumbnailsButton);
        this.addSeparator();
        this.add(toggleLinkingButton);
        this.addSeparator();
        this.add(zoomInButton);
        this.add(zoomOutButton);
        this.add(resetZoomButton);
        this.addSeparator();
        this.add(captureUndecoratedButton);
        this.add(captureDecoratedButton);
        this.add(saveButton);
        this.addSeparator();
        this.add(loopDisplayDecorationsButton);
        this.addSeparator();
        this.add(new SearchBar(this.trackScheme.getModel(), this.trackScheme));
        this.add(Box.createHorizontalGlue());
        Dimension dim = new Dimension(100, 30);
        this.setPreferredSize(dim);
    }
}

