/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.util;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class FileChooser {
    public static boolean useJFileChooser = !FileChooser.isMac();

    public static File chooseFile(Component parent, String selectedFile, DialogType dialogType) {
        return FileChooser.chooseFile(parent, selectedFile, null, null, dialogType);
    }

    public static File chooseFile(Component parent, String selectedFile, FileFilter fileFilter, String dialogTitle, DialogType dialogType) {
        return FileChooser.chooseFile(parent, selectedFile, fileFilter, dialogTitle, dialogType, SelectionMode.FILES_ONLY);
    }

    public static File chooseFile(Component parent, String selectedFile, FileFilter fileFilter, String dialogTitle, DialogType dialogType, SelectionMode selectionMode) {
        return FileChooser.chooseFile(useJFileChooser, parent, selectedFile, fileFilter, dialogTitle, dialogType, selectionMode);
    }

    public static File chooseFile(boolean useJFileChooser, Component parent, String selectedFile, final FileFilter fileFilter, String dialogTitle, DialogType dialogType, SelectionMode selectionMode) {
        String title;
        boolean isDirectoriesOnly;
        boolean isSaveDialog = dialogType == DialogType.SAVE;
        boolean bl = isDirectoriesOnly = selectionMode == SelectionMode.DIRECTORIES_ONLY;
        if (isSaveDialog && isDirectoriesOnly) {
            useJFileChooser = true;
        }
        if ((title = dialogTitle) == null) {
            title = (isSaveDialog ? "Save" : "Open") + (fileFilter == null ? "" : " " + fileFilter.getDescription());
        }
        File file = null;
        if (useJFileChooser) {
            int returnVal;
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle(title);
            if (selectedFile != null) {
                fileChooser.setSelectedFile(new File(selectedFile));
            }
            switch (selectionMode) {
                case FILES_ONLY: {
                    fileChooser.setFileSelectionMode(0);
                    break;
                }
                case DIRECTORIES_ONLY: {
                    fileChooser.setFileSelectionMode(1);
                    break;
                }
                case FILES_AND_DIRECTORIES: {
                    fileChooser.setFileSelectionMode(2);
                }
            }
            fileChooser.setFileFilter(fileFilter);
            int n = returnVal = isSaveDialog ? fileChooser.showSaveDialog(parent) : fileChooser.showOpenDialog(parent);
            if (returnVal == 0) {
                file = fileChooser.getSelectedFile();
            }
        } else {
            String filename;
            int fdMode;
            int n = fdMode = isSaveDialog ? 1 : 0;
            FileDialog fd = parent != null && parent instanceof Frame ? new FileDialog((Frame)parent, title, fdMode) : (parent != null && parent instanceof Dialog ? new FileDialog((Dialog)parent, title, fdMode) : new FileDialog((Frame)null, title, fdMode));
            if (selectedFile != null) {
                if (isDirectoriesOnly) {
                    fd.setDirectory(selectedFile);
                    fd.setFile(null);
                } else {
                    fd.setDirectory(new File(selectedFile).getParent());
                    fd.setFile(new File(selectedFile).getName());
                }
            }
            System.setProperty("apple.awt.fileDialogForDirectories", isDirectoriesOnly ? "true" : "false");
            final AtomicBoolean workedWithFilenameFilter = new AtomicBoolean(false);
            if (fileFilter != null) {
                FilenameFilter filenameFilter = new FilenameFilter(){
                    private boolean firstTime = true;

                    @Override
                    public boolean accept(File dir, String name) {
                        if (this.firstTime) {
                            workedWithFilenameFilter.set(true);
                            this.firstTime = false;
                        }
                        return fileFilter.accept(new File(dir, name));
                    }
                };
                fd.setFilenameFilter(filenameFilter);
                fd.setVisible(true);
            }
            if (fileFilter == null || FileChooser.isMac() && !workedWithFilenameFilter.get()) {
                fd.setFilenameFilter(null);
                fd.setVisible(true);
            }
            if ((filename = fd.getFile()) != null) {
                file = new File(fd.getDirectory() + filename);
            }
        }
        return file;
    }

    private static boolean isMac() {
        String OS = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
        return OS.indexOf("mac") >= 0 || OS.indexOf("darwin") >= 0;
    }

    public static enum SelectionMode {
        FILES_ONLY,
        DIRECTORIES_ONLY,
        FILES_AND_DIRECTORIES;

    }

    public static enum DialogType {
        LOAD,
        SAVE;

    }
}

