/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.tracking.jaqaman;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.tracking.SpotTracker;
import fiji.plugin.trackmate.tracking.jaqaman.JaqamanLinker;
import fiji.plugin.trackmate.tracking.jaqaman.LAPUtils;
import fiji.plugin.trackmate.tracking.jaqaman.costmatrix.JaqamanSegmentCostMatrixCreator;
import fiji.plugin.trackmate.util.TMUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.imglib2.algorithm.Benchmark;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.SimpleWeightedGraph;

public class SegmentTracker
implements SpotTracker,
Benchmark {
    private static final String BASE_ERROR_MESSAGE = "[SegmentTracker] ";
    private final SimpleWeightedGraph<Spot, DefaultWeightedEdge> graph;
    private final Map<String, Object> settings;
    private String errorMessage;
    private Logger logger = Logger.VOID_LOGGER;
    private long processingTime;
    private int numThreads;

    public SegmentTracker(SimpleWeightedGraph<Spot, DefaultWeightedEdge> graph, Map<String, Object> settings) {
        this.graph = graph;
        this.settings = settings;
        this.setNumThreads();
    }

    public SegmentTracker(SimpleWeightedGraph<Spot, DefaultWeightedEdge> graph, Map<String, Object> fullsettings, Logger logger) {
        Logger.SlaveLogger slLogger = new Logger.SlaveLogger(logger, 0.5, 0.5);
        this.logger = slLogger;
        this.setNumThreads();
        this.graph = graph;
        HashMap<String, Object> slSettings = new HashMap<String, Object>();
        slSettings.put("ALLOW_GAP_CLOSING", fullsettings.get("ALLOW_GAP_CLOSING"));
        slSettings.put("GAP_CLOSING_FEATURE_PENALTIES", fullsettings.get("GAP_CLOSING_FEATURE_PENALTIES"));
        slSettings.put("GAP_CLOSING_MAX_DISTANCE", fullsettings.get("GAP_CLOSING_MAX_DISTANCE"));
        slSettings.put("MAX_FRAME_GAP", fullsettings.get("MAX_FRAME_GAP"));
        slSettings.put("ALLOW_TRACK_SPLITTING", fullsettings.get("ALLOW_TRACK_SPLITTING"));
        slSettings.put("SPLITTING_FEATURE_PENALTIES", fullsettings.get("SPLITTING_FEATURE_PENALTIES"));
        slSettings.put("SPLITTING_MAX_DISTANCE", fullsettings.get("SPLITTING_MAX_DISTANCE"));
        slSettings.put("ALLOW_TRACK_MERGING", fullsettings.get("ALLOW_TRACK_MERGING"));
        slSettings.put("MERGING_FEATURE_PENALTIES", fullsettings.get("MERGING_FEATURE_PENALTIES"));
        slSettings.put("MERGING_MAX_DISTANCE", fullsettings.get("MERGING_MAX_DISTANCE"));
        slSettings.put("ALTERNATIVE_LINKING_COST_FACTOR", fullsettings.get("ALTERNATIVE_LINKING_COST_FACTOR"));
        slSettings.put("CUTOFF_PERCENTILE", fullsettings.get("CUTOFF_PERCENTILE"));
        this.settings = slSettings;
    }

    public SimpleWeightedGraph<Spot, DefaultWeightedEdge> getResult() {
        return this.graph;
    }

    public boolean checkInput() {
        return true;
    }

    public boolean process() {
        if (null == this.graph) {
            this.errorMessage = "[SegmentTracker] The input graph is null.";
            return false;
        }
        StringBuilder errorHolder = new StringBuilder();
        if (!SegmentTracker.checkSettingsValidity(this.settings, errorHolder)) {
            this.errorMessage = BASE_ERROR_MESSAGE + errorHolder.toString();
            return false;
        }
        long start = System.currentTimeMillis();
        this.logger.setProgress(0.0);
        this.logger.setStatus("Creating the segment linking cost matrix...");
        JaqamanSegmentCostMatrixCreator costMatrixCreator = new JaqamanSegmentCostMatrixCreator((Graph<Spot, DefaultWeightedEdge>)this.graph, this.settings);
        costMatrixCreator.setNumThreads(this.numThreads);
        Logger.SlaveLogger jlLogger = new Logger.SlaveLogger(this.logger, 0.0, 0.9);
        JaqamanLinker<Spot, Spot> linker = new JaqamanLinker<Spot, Spot>(costMatrixCreator, jlLogger);
        if (!linker.checkInput() || !linker.process()) {
            this.errorMessage = linker.getErrorMessage();
            return false;
        }
        this.logger.setProgress(0.9);
        this.logger.setStatus("Creating links...");
        Object assignment = linker.getResult();
        Map<Spot, Double> costs = linker.getAssignmentCosts();
        for (Spot source : assignment.keySet()) {
            Spot target = (Spot)assignment.get(source);
            DefaultWeightedEdge edge = (DefaultWeightedEdge)this.graph.addEdge((Object)source, (Object)target);
            double cost = costs.get(source);
            this.graph.setEdgeWeight((Object)edge, cost);
        }
        this.logger.setProgress(1.0);
        this.logger.setStatus("");
        long end = System.currentTimeMillis();
        this.processingTime = end - start;
        return true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    private static final boolean checkSettingsValidity(Map<String, Object> settings, StringBuilder str) {
        if (null == settings) {
            str.append("Settings map is null.\n");
            return false;
        }
        boolean ok = true;
        ok &= TMUtils.checkParameter(settings, "ALLOW_GAP_CLOSING", Boolean.class, str);
        ok &= TMUtils.checkParameter(settings, "GAP_CLOSING_MAX_DISTANCE", Double.class, str);
        ok &= TMUtils.checkParameter(settings, "MAX_FRAME_GAP", Integer.class, str);
        ok &= LAPUtils.checkFeatureMap(settings, "GAP_CLOSING_FEATURE_PENALTIES", str);
        ok &= TMUtils.checkParameter(settings, "ALLOW_TRACK_SPLITTING", Boolean.class, str);
        ok &= TMUtils.checkParameter(settings, "SPLITTING_MAX_DISTANCE", Double.class, str);
        ok &= LAPUtils.checkFeatureMap(settings, "SPLITTING_FEATURE_PENALTIES", str);
        ok &= TMUtils.checkParameter(settings, "ALLOW_TRACK_MERGING", Boolean.class, str);
        ok &= TMUtils.checkParameter(settings, "MERGING_MAX_DISTANCE", Double.class, str);
        ok &= LAPUtils.checkFeatureMap(settings, "MERGING_FEATURE_PENALTIES", str);
        ok &= TMUtils.checkParameter(settings, "CUTOFF_PERCENTILE", Double.class, str);
        ok &= TMUtils.checkParameter(settings, "ALTERNATIVE_LINKING_COST_FACTOR", Double.class, str);
        ArrayList<String> mandatoryKeys = new ArrayList<String>();
        mandatoryKeys.add("ALLOW_GAP_CLOSING");
        mandatoryKeys.add("GAP_CLOSING_MAX_DISTANCE");
        mandatoryKeys.add("MAX_FRAME_GAP");
        mandatoryKeys.add("ALLOW_TRACK_SPLITTING");
        mandatoryKeys.add("SPLITTING_MAX_DISTANCE");
        mandatoryKeys.add("ALLOW_TRACK_MERGING");
        mandatoryKeys.add("MERGING_MAX_DISTANCE");
        mandatoryKeys.add("ALTERNATIVE_LINKING_COST_FACTOR");
        mandatoryKeys.add("CUTOFF_PERCENTILE");
        ArrayList<String> optionalKeys = new ArrayList<String>();
        optionalKeys.add("GAP_CLOSING_FEATURE_PENALTIES");
        optionalKeys.add("SPLITTING_FEATURE_PENALTIES");
        optionalKeys.add("MERGING_FEATURE_PENALTIES");
        optionalKeys.add("BLOCKING_VALUE");
        return ok &= TMUtils.checkMapKeys(settings, mandatoryKeys, optionalKeys, str);
    }

    public void setNumThreads() {
        this.numThreads = Runtime.getRuntime().availableProcessors();
    }

    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    public int getNumThreads() {
        return this.numThreads;
    }
}

