/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.io;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.gui.Icons;
import fiji.util.NumberParser;
import ij.IJ;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.io.File;
import java.io.FilenameFilter;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jdom2.Attribute;
import org.jdom2.DataConversionException;
import org.jdom2.Element;

public class IOUtils {
    public static final boolean canReadFile(String path, StringBuilder errorHolder) {
        if (path.isEmpty()) {
            errorHolder.append("The path to the file is empty.");
            return false;
        }
        File file = new File(path);
        if (!file.exists()) {
            errorHolder.append("The file " + path + " does not exist.");
            return false;
        }
        if (!file.isFile()) {
            errorHolder.append("The path" + path + " is not a file.");
            return false;
        }
        if (!file.canRead()) {
            errorHolder.append("The file" + path + " cannot be read.");
            return false;
        }
        return true;
    }

    public static File askForFileForSaving(File file, Frame parent) {
        if (IJ.isMacintosh() && parent != null) {
            FileDialog dialog = new FileDialog(parent, "Save to a XML file", 1);
            dialog.setIconImage(Icons.TRACKMATE_ICON.getImage());
            dialog.setDirectory(file.getParent());
            dialog.setFile(file.getName());
            FilenameFilter filter = (dir, name) -> name.endsWith(".xml");
            dialog.setFilenameFilter(filter);
            dialog.setVisible(true);
            String selectedFile = dialog.getFile();
            if (null == selectedFile) {
                return null;
            }
            if (!selectedFile.endsWith(".xml")) {
                selectedFile = selectedFile + ".xml";
            }
            return new File(dialog.getDirectory(), selectedFile);
        }
        JFileChooser fileChooser = new JFileChooser(file.getParent()){
            private static final long serialVersionUID = 1L;

            @Override
            protected JDialog createDialog(Component lParent) throws HeadlessException {
                JDialog dialog = super.createDialog(lParent);
                dialog.setIconImage(Icons.TRACKMATE_ICON.getImage());
                return dialog;
            }
        };
        fileChooser.setSelectedFile(file);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("XML files", "xml");
        fileChooser.setFileFilter(filter);
        int returnVal = fileChooser.showSaveDialog(parent);
        if (returnVal == 0) {
            return fileChooser.getSelectedFile();
        }
        return null;
    }

    public static File askForFileForLoading(File file, String title, Frame parent, Logger logger) {
        if (IJ.isMacintosh()) {
            FileDialog dialog = new FileDialog(parent, title, 0);
            dialog.setIconImage(Icons.TRACKMATE_ICON.getImage());
            dialog.setDirectory(file.getParent());
            dialog.setFile(file.getName());
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".xml");
                }
            };
            dialog.setFilenameFilter(filter);
            dialog.setVisible(true);
            String selectedFile = dialog.getFile();
            if (null == selectedFile) {
                logger.log("Load data aborted.\n");
                return null;
            }
            if (!selectedFile.endsWith(".xml")) {
                selectedFile = selectedFile + ".xml";
            }
            file = new File(dialog.getDirectory(), selectedFile);
        } else {
            JFileChooser fileChooser = new JFileChooser(file.getParent()){
                private static final long serialVersionUID = 1L;

                @Override
                protected JDialog createDialog(Component lParent) throws HeadlessException {
                    JDialog dialog = super.createDialog(lParent);
                    dialog.setIconImage(Icons.TRACKMATE_ICON.getImage());
                    return dialog;
                }
            };
            fileChooser.setName(title);
            fileChooser.setSelectedFile(file);
            FileNameExtensionFilter filter = new FileNameExtensionFilter("XML files", "xml");
            fileChooser.setFileFilter(filter);
            int returnVal = fileChooser.showOpenDialog(parent);
            if (returnVal == 0) {
                file = fileChooser.getSelectedFile();
            } else {
                logger.log("Load data aborted.\n");
                return null;
            }
        }
        return file;
    }

    public static File askForFolder(File file, String title, Frame parent, Logger logger) {
        if (IJ.isMacintosh()) {
            System.setProperty("apple.awt.fileDialogForDirectories", "true");
            FileDialog dialog = new FileDialog(parent, title, 0);
            dialog.setIconImage(Icons.TRACKMATE_ICON.getImage());
            dialog.setDirectory(file.getParent());
            dialog.setFile(file.getName());
            dialog.setVisible(true);
            String selectedFile = dialog.getFile();
            System.setProperty("apple.awt.fileDialogForDirectories", "false");
            if (null == selectedFile) {
                logger.log("Load data aborted.\n");
                return null;
            }
            file = new File(dialog.getDirectory(), dialog.getFile());
        } else {
            JFileChooser fileChooser = new JFileChooser(file.getParent()){
                private static final long serialVersionUID = 1L;

                @Override
                protected JDialog createDialog(Component lParent) throws HeadlessException {
                    JDialog dialog = super.createDialog(lParent);
                    dialog.setIconImage(Icons.TRACKMATE_ICON.getImage());
                    return dialog;
                }
            };
            fileChooser.setFileSelectionMode(1);
            fileChooser.setName(title);
            fileChooser.setSelectedFile(file);
            int returnVal = fileChooser.showOpenDialog(parent);
            if (returnVal == 0) {
                file = fileChooser.getSelectedFile();
            } else {
                logger.log("Load data aborted.\n");
                return null;
            }
        }
        return file;
    }

    public static final int readIntAttribute(Element element, String name, Logger logger) {
        return IOUtils.readIntAttribute(element, name, logger, 0);
    }

    public static final int readIntAttribute(Element element, String name, Logger logger, int defaultValue) {
        int val = defaultValue;
        Attribute att = element.getAttribute(name);
        if (null == att) {
            logger.error("Could not find attribute " + name + " for element " + element.getName() + ", substituting default value: " + defaultValue + ".\n");
            return val;
        }
        try {
            val = att.getIntValue();
        }
        catch (DataConversionException e) {
            logger.error("Cannot read the attribute " + name + " of the element " + element.getName() + ", substituting default value: " + defaultValue + ".\n");
        }
        return val;
    }

    public static final double readFloatAttribute(Element element, String name, Logger logger) {
        double val = 0.0;
        Attribute att = element.getAttribute(name);
        if (null == att) {
            logger.error("Could not find attribute " + name + " for element " + element.getName() + ", substituting default value.\n");
            return val;
        }
        try {
            val = att.getFloatValue();
        }
        catch (DataConversionException e) {
            logger.error("Cannot read the attribute " + name + " of the element " + element.getName() + ", substituting default value.\n");
        }
        return val;
    }

    public static final double readDoubleAttribute(Element element, String name, Logger logger) {
        return IOUtils.readDoubleAttribute(element, name, logger, 0.0);
    }

    public static final double readDoubleAttribute(Element element, String name, Logger logger, double defaultValue) {
        double val = defaultValue;
        Attribute att = element.getAttribute(name);
        if (null == att) {
            logger.error("Could not find attribute " + name + " for element " + element.getName() + ", substituting default value.\n");
            return val;
        }
        try {
            val = att.getDoubleValue();
        }
        catch (DataConversionException e) {
            logger.error("Cannot read the attribute " + name + " of the element " + element.getName() + ", substituting default value.\n");
        }
        return val;
    }

    public static final boolean readBooleanAttribute(Element element, String name, Logger logger) {
        return IOUtils.readBooleanAttribute(element, name, logger, false);
    }

    public static final boolean readBooleanAttribute(Element element, String name, Logger logger, boolean defaultValue) {
        boolean val = defaultValue;
        Attribute att = element.getAttribute(name);
        if (null == att) {
            logger.error("Could not find attribute " + name + " for element " + element.getName() + ", substituting default value.\n");
            return val;
        }
        try {
            val = att.getBooleanValue();
        }
        catch (DataConversionException e) {
            logger.error("Cannot read the attribute " + name + " of the element " + element.getName() + ", substituting default value.\n");
        }
        return val;
    }

    public static final boolean readDoubleAttribute(Element element, Map<String, Object> settings, String parameterKey, StringBuilder errorHolder) {
        String str = element.getAttributeValue(parameterKey);
        if (null == str) {
            errorHolder.append("Attribute " + parameterKey + " could not be found in XML element.\n");
            return false;
        }
        try {
            double val = NumberParser.parseDouble(str);
            settings.put(parameterKey, val);
        }
        catch (NumberFormatException nfe) {
            errorHolder.append("Could not read " + parameterKey + " attribute as a double value. Got " + str + ".\n");
            return false;
        }
        return true;
    }

    public static final boolean readIntegerAttribute(Element element, Map<String, Object> settings, String parameterKey, StringBuilder errorHolder) {
        String str = element.getAttributeValue(parameterKey);
        if (null == str) {
            errorHolder.append("Attribute " + parameterKey + " could not be found in XML element.\n");
            return false;
        }
        try {
            int val = NumberParser.parseInteger(str);
            settings.put(parameterKey, val);
        }
        catch (NumberFormatException nfe) {
            errorHolder.append("Could not read " + parameterKey + " attribute as an integer value. Got " + str + ".\n");
            return false;
        }
        return true;
    }

    public static final boolean readBooleanAttribute(Element element, Map<String, Object> settings, String parameterKey, StringBuilder errorHolder) {
        String str = element.getAttributeValue(parameterKey);
        if (null == str) {
            errorHolder.append("Attribute " + parameterKey + " could not be found in XML element.\n");
            return false;
        }
        try {
            boolean val = Boolean.parseBoolean(str);
            settings.put(parameterKey, val);
        }
        catch (NumberFormatException nfe) {
            errorHolder.append("Could not read " + parameterKey + " attribute as an boolean value. Got " + str + ".");
            return false;
        }
        return true;
    }

    public static final boolean readStringAttribute(Element element, Map<String, Object> settings, String parameterKey, StringBuilder errorHolder) {
        String str = element.getAttributeValue(parameterKey);
        if (null == str) {
            errorHolder.append("Attribute " + parameterKey + " could not be found in XML element.\n");
            return false;
        }
        settings.put(parameterKey, str);
        return true;
    }

    public static boolean unmarshallMap(Element element, Map<String, Double> map, StringBuilder errorHolder) {
        boolean ok = true;
        List attributes = element.getAttributes();
        for (Attribute att : attributes) {
            String key = att.getName();
            try {
                double val = att.getDoubleValue();
                map.put(key, val);
            }
            catch (DataConversionException e) {
                errorHolder.append("Could not convert the " + key + " attribute to double. Got " + att.getValue() + ".\n");
                ok = false;
            }
        }
        return ok;
    }

    public static final boolean writeTargetChannel(Map<String, Object> settings, Element element, StringBuilder errorHolder) {
        return IOUtils.writeAttribute(settings, element, "TARGET_CHANNEL", Integer.class, errorHolder);
    }

    public static final boolean writeRadius(Map<String, Object> settings, Element element, StringBuilder errorHolder) {
        return IOUtils.writeAttribute(settings, element, "RADIUS", Double.class, errorHolder);
    }

    public static final boolean writeThreshold(Map<String, Object> settings, Element element, StringBuilder errorHolder) {
        return IOUtils.writeAttribute(settings, element, "THRESHOLD", Double.class, errorHolder);
    }

    public static final boolean writeDoMedian(Map<String, Object> settings, Element element, StringBuilder errorHolder) {
        return IOUtils.writeAttribute(settings, element, "DO_MEDIAN_FILTERING", Boolean.class, errorHolder);
    }

    public static final boolean writeDoSubPixel(Map<String, Object> settings, Element element, StringBuilder errorHolder) {
        return IOUtils.writeAttribute(settings, element, "DO_SUBPIXEL_LOCALIZATION", Boolean.class, errorHolder);
    }

    public static final boolean writeDownsamplingFactor(Map<String, Object> settings, Element element, StringBuilder errorHolder) {
        return IOUtils.writeAttribute(settings, element, "DOWNSAMPLE_FACTOR", Integer.class, errorHolder);
    }

    public static final boolean writeAttribute(Map<String, Object> settings, Element element, String parameterKey, Class<?> expectedClass, StringBuilder errorHolder) {
        Object obj = settings.get(parameterKey);
        if (null == obj) {
            errorHolder.append("Could not find parameter " + parameterKey + " in settings map.\n");
            return false;
        }
        if (!expectedClass.isInstance(obj)) {
            errorHolder.append("Expected " + parameterKey + " parameter to be a " + expectedClass.getName() + " but was a " + obj.getClass().getName() + ".\n");
            return false;
        }
        element.setAttribute(parameterKey, "" + obj);
        return true;
    }

    public static void marshallMap(Map<String, Double> map, Element element) {
        for (String key : map.keySet()) {
            element.setAttribute(key, map.get(key).toString());
        }
    }
}

