/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.wizard.descriptors;

import fiji.plugin.trackmate.SelectionModel;
import fiji.plugin.trackmate.TrackMate;
import fiji.plugin.trackmate.features.FeatureUtils;
import fiji.plugin.trackmate.gui.components.FeaturePlotSelectionPanel;
import fiji.plugin.trackmate.gui.components.GrapherPanel;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import fiji.plugin.trackmate.gui.wizard.WizardPanelDescriptor;
import java.util.Map;
import java.util.Set;

public class GrapherDescriptor
extends WizardPanelDescriptor {
    private static final String KEY = "GraphFeatures";
    private final TrackMate trackmate;

    public GrapherDescriptor(TrackMate trackmate, SelectionModel selectionModel, DisplaySettings displaySettings) {
        super(KEY);
        this.trackmate = trackmate;
        this.targetPanel = new GrapherPanel(trackmate, selectionModel, displaySettings);
    }

    @Override
    public void aboutToDisplayPanel() {
        GrapherPanel panel = (GrapherPanel)this.targetPanel;
        Map<String, String> spotFeatureNames = FeatureUtils.collectFeatureKeys(DisplaySettings.TrackMateObject.SPOTS, this.trackmate.getModel(), this.trackmate.getSettings());
        Set<String> spotFeatures = spotFeatureNames.keySet();
        FeaturePlotSelectionPanel spotFeatureSelectionPanel = panel.getSpotFeatureSelectionPanel();
        spotFeatureSelectionPanel.setFeatures(spotFeatures, spotFeatureNames);
        Map<String, String> edgeFeatureNames = FeatureUtils.collectFeatureKeys(DisplaySettings.TrackMateObject.EDGES, this.trackmate.getModel(), this.trackmate.getSettings());
        Set<String> edgeFeatures = edgeFeatureNames.keySet();
        FeaturePlotSelectionPanel edgeFeatureSelectionPanel = panel.getEdgeFeatureSelectionPanel();
        edgeFeatureSelectionPanel.setFeatures(edgeFeatures, edgeFeatureNames);
        Map<String, String> trackFeatureNames = FeatureUtils.collectFeatureKeys(DisplaySettings.TrackMateObject.TRACKS, this.trackmate.getModel(), this.trackmate.getSettings());
        Set<String> trackFeatures = trackFeatureNames.keySet();
        FeaturePlotSelectionPanel trackFeatureSelectionPanel = panel.getTrackFeatureSelectionPanel();
        trackFeatureSelectionPanel.setFeatures(trackFeatures, trackFeatureNames);
    }
}

