/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.components.tracker;

import fiji.plugin.trackmate.gui.Fonts;
import fiji.plugin.trackmate.gui.GuiUtils;
import fiji.plugin.trackmate.gui.components.ConfigurationPanel;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;

public class NearestNeighborTrackerSettingsPanel
extends ConfigurationPanel {
    private static final long serialVersionUID = 1L;
    private JFormattedTextField maxDistField;
    private JLabel labelTrackerDescription;
    private JLabel labelUnits;
    private JLabel labelTracker;
    private final String infoText;
    private final String trackerName;
    private final String spaceUnits;

    public NearestNeighborTrackerSettingsPanel(String trackerName, String infoText, String spaceUnits) {
        this.trackerName = trackerName;
        this.infoText = infoText;
        this.spaceUnits = spaceUnits;
        this.initGUI();
    }

    @Override
    public Map<String, Object> getSettings() {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("LINKING_MAX_DISTANCE", ((Number)this.maxDistField.getValue()).doubleValue());
        return settings;
    }

    @Override
    public void setSettings(Map<String, Object> settings) {
        this.maxDistField.setValue(settings.get("LINKING_MAX_DISTANCE"));
    }

    private void initGUI() {
        this.setLayout(null);
        JLabel lblSettingsForTracker = new JLabel("Settings for tracker:");
        lblSettingsForTracker.setBounds(10, 11, 280, 20);
        lblSettingsForTracker.setFont(Fonts.FONT);
        this.add(lblSettingsForTracker);
        this.labelTracker = new JLabel(this.trackerName);
        this.labelTracker.setFont(Fonts.BIG_FONT);
        this.labelTracker.setHorizontalAlignment(0);
        this.labelTracker.setBounds(10, 42, 280, 20);
        this.add(this.labelTracker);
        this.labelTrackerDescription = new JLabel("<tracker description>");
        this.labelTrackerDescription.setFont(Fonts.FONT.deriveFont(2));
        this.labelTrackerDescription.setBounds(10, 67, 280, 225);
        this.labelTrackerDescription.setText(this.infoText.replace("<br>", "").replace("<p>", "<p align=\"justify\">").replace("<html>", "<html><p align=\"justify\">"));
        this.add(this.labelTrackerDescription);
        JLabel lblMaximalLinkingDistance = new JLabel("Maximal linking distance: ");
        lblMaximalLinkingDistance.setFont(Fonts.FONT);
        lblMaximalLinkingDistance.setBounds(10, 314, 164, 20);
        this.add(lblMaximalLinkingDistance);
        this.maxDistField = new JFormattedTextField(15.0);
        this.maxDistField.setFont(Fonts.FONT);
        this.maxDistField.setBounds(184, 316, 62, 16);
        this.maxDistField.setSize(Fonts.TEXTFIELD_DIMENSION);
        this.add(this.maxDistField);
        this.labelUnits = new JLabel(this.spaceUnits);
        this.labelUnits.setFont(Fonts.FONT);
        this.labelUnits.setBounds(236, 314, 34, 20);
        this.add(this.labelUnits);
        GuiUtils.selectAllOnFocus(this.maxDistField);
    }

    @Override
    public void clean() {
    }
}

