/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.features.spot;

import fiji.plugin.trackmate.Dimension;
import fiji.plugin.trackmate.features.spot.SpotAnalyzer;
import fiji.plugin.trackmate.features.spot.SpotAnalyzerFactory;
import fiji.plugin.trackmate.features.spot.SpotIntensityMultiCAnalyzer;
import fiji.plugin.trackmate.util.TMUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import net.imagej.ImgPlus;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import org.scijava.plugin.Plugin;

@Plugin(type=SpotAnalyzerFactory.class)
public class SpotIntensityMultiCAnalyzerFactory<T extends RealType<T> & NativeType<T>>
implements SpotAnalyzerFactory<T> {
    private static final String KEY = "Spot intensity";
    static final String MEAN_INTENSITY = "MEAN_INTENSITY_CH";
    static final String MEDIAN_INTENSITY = "MEDIAN_INTENSITY_CH";
    static final String MIN_INTENSITY = "MIN_INTENSITY_CH";
    static final String MAX_INTENSITY = "MAX_INTENSITY_CH";
    static final String TOTAL_INTENSITY = "TOTAL_INTENSITY_CH";
    static final String STD_INTENSITY = "STD_INTENSITY_CH";
    private static final String MEAN_SHORT_NAME = "Mean ch";
    private static final String MEAN_NAME = "Mean intensity ch";
    private static final String MEDIAN_SHORT_NAME = "Median ch";
    private static final String MEDIAN_NAME = "Median intensity ch";
    private static final String MIN_SHORT_NAME = "Min ch";
    private static final String MIN_NAME = "Min intensity ch";
    private static final String MAX_SHORT_NAME = "Max ch";
    private static final String MAX_NAME = "Max intensity ch";
    private static final String SUM_SHORT_NAME = "Sum ch";
    private static final String SUM_NAME = "Sum intensity ch";
    private static final String STD_SHORT_NAME = "Std ch";
    private static final String STD_NAME = "Std intensity ch";
    private static final List<String> FEATURES = Arrays.asList("MEAN_INTENSITY_CH", "MEDIAN_INTENSITY_CH", "MIN_INTENSITY_CH", "MAX_INTENSITY_CH", "TOTAL_INTENSITY_CH", "STD_INTENSITY_CH");
    private static final List<String> FEATURE_SHORTNAMES = Arrays.asList("Mean ch", "Median ch", "Min ch", "Max ch", "Sum ch", "Std ch");
    private static final List<String> FEATURE_NAMES = Arrays.asList("Mean intensity ch", "Median intensity ch", "Min intensity ch", "Max intensity ch", "Sum intensity ch", "Std intensity ch");
    private int nChannels = 1;

    @Override
    public void setNChannels(int nChannels) {
        this.nChannels = nChannels;
    }

    @Override
    public SpotAnalyzer<T> getAnalyzer(ImgPlus<T> img, int frame, int channel) {
        ImgPlus<T> imgTC = TMUtils.hyperSlice(img, channel, frame);
        return new SpotIntensityMultiCAnalyzer<T>(imgTC, channel);
    }

    static final String makeFeatureKey(String feature, int c) {
        return feature + (c + 1);
    }

    @Override
    public List<String> getFeatures() {
        ArrayList<String> features = new ArrayList<String>(this.nChannels * FEATURES.size());
        for (int c = 0; c < this.nChannels; ++c) {
            for (String feature : FEATURES) {
                features.add(SpotIntensityMultiCAnalyzerFactory.makeFeatureKey(feature, c));
            }
        }
        return features;
    }

    @Override
    public Map<String, String> getFeatureShortNames() {
        LinkedHashMap<String, String> names = new LinkedHashMap<String, String>(this.nChannels * FEATURES.size());
        for (int c = 0; c < this.nChannels; ++c) {
            for (int i = 0; i < FEATURES.size(); ++i) {
                String feature = FEATURES.get(i);
                String shortName = FEATURE_SHORTNAMES.get(i);
                names.put(SpotIntensityMultiCAnalyzerFactory.makeFeatureKey(feature, c), SpotIntensityMultiCAnalyzerFactory.makeFeatureKey(shortName, c));
            }
        }
        return names;
    }

    @Override
    public Map<String, String> getFeatureNames() {
        LinkedHashMap<String, String> names = new LinkedHashMap<String, String>(this.nChannels * FEATURES.size());
        for (int c = 0; c < this.nChannels; ++c) {
            for (int i = 0; i < FEATURES.size(); ++i) {
                String feature = FEATURES.get(i);
                String shortName = FEATURE_NAMES.get(i);
                names.put(SpotIntensityMultiCAnalyzerFactory.makeFeatureKey(feature, c), SpotIntensityMultiCAnalyzerFactory.makeFeatureKey(shortName, c));
            }
        }
        return names;
    }

    @Override
    public Map<String, Dimension> getFeatureDimensions() {
        List<String> features = this.getFeatures();
        LinkedHashMap<String, Dimension> dimensions = new LinkedHashMap<String, Dimension>(features.size());
        for (String feature : features) {
            dimensions.put(feature, Dimension.INTENSITY);
        }
        return dimensions;
    }

    @Override
    public Map<String, Boolean> getIsIntFeature() {
        List<String> features = this.getFeatures();
        LinkedHashMap<String, Boolean> isints = new LinkedHashMap<String, Boolean>(features.size());
        for (String feature : features) {
            isints.put(feature, Boolean.FALSE);
        }
        return isints;
    }

    @Override
    public boolean isManualFeature() {
        return false;
    }

    @Override
    public String getInfoText() {
        return null;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public String getName() {
        return KEY;
    }
}

