/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.detection.util;

import java.util.NoSuchElementException;
import net.imglib2.Cursor;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.outofbounds.Bounded;
import net.imglib2.outofbounds.OutOfBounds;
import net.imglib2.view.ExtendedRandomAccessibleInterval;

public class SquareNeighborhoodCursor3x3<T>
implements Cursor<T>,
Bounded {
    private final ExtendedRandomAccessibleInterval<T, RandomAccessibleInterval<T>> source;
    private final long[] center;
    private final OutOfBounds<T> ra;
    private int index = -1;
    private boolean hasNext;

    public SquareNeighborhoodCursor3x3(ExtendedRandomAccessibleInterval<T, RandomAccessibleInterval<T>> extendedSource, long[] center) {
        this.source = extendedSource;
        this.center = center;
        this.ra = extendedSource.randomAccess();
        this.reset();
    }

    public void localize(float[] position) {
        this.ra.localize(position);
    }

    public void localize(double[] position) {
        this.ra.localize(position);
    }

    public float getFloatPosition(int d) {
        return this.ra.getFloatPosition(d);
    }

    public double getDoublePosition(int d) {
        return this.ra.getDoublePosition(d);
    }

    public int numDimensions() {
        return this.source.numDimensions();
    }

    public T get() {
        return (T)this.ra.get();
    }

    public Cursor<T> copy() {
        return new SquareNeighborhoodCursor3x3<T>(this.source, this.center);
    }

    public void jumpFwd(long steps) {
        int i = 0;
        while ((long)i < steps) {
            this.fwd();
            ++i;
        }
    }

    public void fwd() {
        ++this.index;
        switch (this.index) {
            case 0: {
                break;
            }
            case 1: {
                this.ra.bck(1);
                break;
            }
            case 2: {
                this.ra.bck(0);
                break;
            }
            case 3: {
                this.ra.fwd(1);
                break;
            }
            case 4: {
                this.ra.fwd(1);
                break;
            }
            case 5: {
                this.ra.fwd(0);
                break;
            }
            case 6: {
                this.ra.fwd(0);
                break;
            }
            case 7: {
                this.ra.bck(1);
                break;
            }
            case 8: {
                this.ra.bck(1);
                this.hasNext = false;
                break;
            }
            default: {
                throw new NoSuchElementException("SquareNeighborhood3x3 exhausted");
            }
        }
    }

    public void reset() {
        this.index = -1;
        this.hasNext = true;
        this.ra.setPosition(this.center);
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public T next() {
        this.fwd();
        return (T)this.ra.get();
    }

    public void remove() {
        throw new UnsupportedOperationException("remove() is not implemented for SquareNeighborhoodCursor");
    }

    public void localize(int[] position) {
        this.ra.localize(position);
    }

    public void localize(long[] position) {
        this.ra.localize(position);
    }

    public int getIntPosition(int d) {
        return this.ra.getIntPosition(d);
    }

    public long getLongPosition(int d) {
        return this.ra.getLongPosition(d);
    }

    public boolean isOutOfBounds() {
        return this.ra.isOutOfBounds();
    }
}

