/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.detection.util;

import java.util.Arrays;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.BenchmarkAlgorithm;
import net.imglib2.algorithm.OutputAlgorithm;
import net.imglib2.algorithm.neighborhood.Neighborhood;
import net.imglib2.algorithm.neighborhood.RectangleShape;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Util;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

public class MedianFilter2D<T extends RealType<T> & NativeType<T>>
extends BenchmarkAlgorithm
implements OutputAlgorithm<Img<T>> {
    private static final String BASE_ERROR_MSG = "[MedianFiler2D] ";
    private final RandomAccessibleInterval<T> source;
    private Img<T> output;
    private final int radius;

    public MedianFilter2D(RandomAccessibleInterval<T> source, int radius) {
        this.source = source;
        this.radius = radius;
    }

    public boolean checkInput() {
        if (this.source.numDimensions() > 3) {
            this.errorMessage = "[MedianFiler2D]  Can only operate on 1D, 2D or 3D images. Got " + this.source.numDimensions() + "D.";
            return false;
        }
        if (this.radius < 1) {
            this.errorMessage = "[MedianFiler2D] Radius cannot be smaller than 1. Got " + this.radius + ".";
            return false;
        }
        return true;
    }

    public boolean process() {
        long start = System.currentTimeMillis();
        RealType type = (RealType)((RealType)this.source.randomAccess().get()).createVariable();
        ImgFactory factory = Util.getArrayOrCellImgFactory(this.source, (NativeType)((NativeType)type));
        this.output = factory.create(this.source);
        if (this.source.numDimensions() > 2) {
            long nz = this.source.dimension(2);
            for (long z = 0L; z < nz; ++z) {
                IntervalView slice = Views.hyperSlice(this.source, (int)2, (long)z);
                IntervalView outputSlice = Views.hyperSlice(this.output, (int)2, (long)z);
                this.processSlice((RandomAccessibleInterval<T>)slice, (IterableInterval<T>)outputSlice);
            }
        } else {
            this.processSlice(this.source, (IterableInterval<T>)this.output);
        }
        this.processingTime = System.currentTimeMillis() - start;
        return true;
    }

    private void processSlice(RandomAccessibleInterval<T> in, IterableInterval<T> out) {
        Cursor cursor = out.localizingCursor();
        RectangleShape shape = new RectangleShape(this.radius, false);
        RectangleShape.NeighborhoodsAccessible nracessible = shape.neighborhoodsRandomAccessible((RandomAccessible)Views.extendZero(in));
        RandomAccess nra = nracessible.randomAccess(in);
        int size = (int)((Neighborhood)nra.get()).size();
        double[] values = new double[size];
        while (cursor.hasNext()) {
            cursor.fwd();
            nra.setPosition((Localizable)cursor);
            int index = 0;
            for (RealType pixel : (Neighborhood)nra.get()) {
                values[index++] = pixel.getRealDouble();
            }
            Arrays.sort(values, 0, index);
            ((RealType)cursor.get()).setReal(values[(index - 1) / 2]);
        }
    }

    public Img<T> getResult() {
        return this.output;
    }
}

