/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.detection;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.Settings;
import fiji.plugin.trackmate.detection.DetectionUtils;
import fiji.plugin.trackmate.detection.SpotDetector;
import fiji.plugin.trackmate.detection.SpotDetectorFactory;
import fiji.plugin.trackmate.detection.ThresholdDetector;
import fiji.plugin.trackmate.detection.ThresholdDetectorFactory;
import fiji.plugin.trackmate.gui.components.ConfigurationPanel;
import fiji.plugin.trackmate.gui.components.detector.MaskDetectorConfigurationPanel;
import fiji.plugin.trackmate.io.IOUtils;
import fiji.plugin.trackmate.util.TMUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import net.imagej.ImgPlusMetadata;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import org.jdom2.Element;
import org.scijava.plugin.Plugin;

@Plugin(type=SpotDetectorFactory.class)
public class MaskDetectorFactory<T extends RealType<T> & NativeType<T>>
extends ThresholdDetectorFactory<T> {
    public static final String DETECTOR_KEY = "MASK_DETECTOR";
    public static final String NAME = "Mask detector";
    public static final String INFO_TEXT = "<html>This detector creates spots from a black and white mask.<p>More precisely, all the pixels in the designated channel that have a value strictly larger than 0 are considered as part of the foreground, and used to build connected regions. In 2D, spots are created with the (possibly simplified) contour of the region. In 3D, a spherical spot is created for each region in its center, with a volume equal to the region volume.<p>The spot quality stores the object area or volume in pixels.</html>";

    @Override
    public boolean has2Dsegmentation() {
        return true;
    }

    @Override
    public SpotDetector<T> getDetector(Interval interval, int frame) {
        double intensityThreshold = 0.0;
        boolean simplifyContours = (Boolean)this.settings.get("SIMPLIFY_CONTOURS");
        double[] calibration = TMUtils.getSpatialCalibration((ImgPlusMetadata)this.img);
        int channel = (Integer)this.settings.get("TARGET_CHANNEL") - 1;
        RandomAccessibleInterval imFrame = DetectionUtils.prepareFrameImg(this.img, channel, frame);
        ThresholdDetector detector = new ThresholdDetector(imFrame, interval, calibration, 0.0, simplifyContours);
        detector.setNumThreads(1);
        return detector;
    }

    @Override
    public String getKey() {
        return DETECTOR_KEY;
    }

    @Override
    public boolean checkSettings(Map<String, Object> lSettings) {
        boolean ok = true;
        StringBuilder errorHolder = new StringBuilder();
        ok &= TMUtils.checkParameter(lSettings, "TARGET_CHANNEL", Integer.class, errorHolder);
        ok &= TMUtils.checkParameter(lSettings, "SIMPLIFY_CONTOURS", Boolean.class, errorHolder);
        ArrayList<String> mandatoryKeys = new ArrayList<String>();
        mandatoryKeys.add("TARGET_CHANNEL");
        mandatoryKeys.add("SIMPLIFY_CONTOURS");
        if (!(ok &= TMUtils.checkMapKeys(lSettings, mandatoryKeys, null, errorHolder))) {
            this.errorMessage = errorHolder.toString();
        }
        return ok;
    }

    @Override
    public boolean marshall(Map<String, Object> lSettings, Element element) {
        boolean ok;
        StringBuilder errorHolder = new StringBuilder();
        boolean bl = ok = IOUtils.writeTargetChannel(lSettings, element, errorHolder) && IOUtils.writeAttribute(lSettings, element, "SIMPLIFY_CONTOURS", Boolean.class, errorHolder);
        if (!ok) {
            this.errorMessage = errorHolder.toString();
        }
        return ok;
    }

    @Override
    public boolean unmarshall(Element element, Map<String, Object> lSettings) {
        lSettings.clear();
        StringBuilder errorHolder = new StringBuilder();
        boolean ok = true;
        ok &= IOUtils.readIntegerAttribute(element, lSettings, "TARGET_CHANNEL", errorHolder);
        if (!(ok &= IOUtils.readBooleanAttribute(element, lSettings, "SIMPLIFY_CONTOURS", errorHolder))) {
            this.errorMessage = errorHolder.toString();
            return false;
        }
        return this.checkSettings(lSettings);
    }

    @Override
    public ConfigurationPanel getDetectorConfigurationPanel(Settings lSettings, Model model) {
        return new MaskDetectorConfigurationPanel(lSettings, model);
    }

    @Override
    public String getInfoText() {
        return INFO_TEXT;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Map<String, Object> getDefaultSettings() {
        HashMap<String, Object> lSettings = new HashMap<String, Object>();
        lSettings.put("TARGET_CHANNEL", 1);
        lSettings.put("SIMPLIFY_CONTOURS", true);
        return lSettings;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public MaskDetectorFactory<T> copy() {
        return new MaskDetectorFactory<T>();
    }
}

