/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.action.fit;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.ModelChangeEvent;
import fiji.plugin.trackmate.SelectionModel;
import fiji.plugin.trackmate.Settings;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.TrackMate;
import fiji.plugin.trackmate.action.fit.AbstractSpotFitter;
import fiji.plugin.trackmate.action.fit.SpotFitterPanel;
import fiji.plugin.trackmate.action.fit.SpotGaussianFitter2D;
import fiji.plugin.trackmate.action.fit.SpotGaussianFitter2DFixedRadius;
import fiji.plugin.trackmate.action.fit.SpotGaussianFitter3D;
import fiji.plugin.trackmate.action.fit.SpotGaussianFitter3DFixedRadius;
import fiji.plugin.trackmate.detection.DetectionUtils;
import fiji.plugin.trackmate.gui.GuiUtils;
import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.util.EverythingDisablerAndReenabler;
import fiji.plugin.trackmate.util.Threads;
import ij.ImagePlus;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class SpotFitterController {
    private final TrackMate trackmate;
    private final SelectionModel selectionModel;
    private final SpotFitterPanel gui;
    private final Logger logger;
    private final Map<Spot, double[]> undo;

    public SpotFitterController(TrackMate trackmate, SelectionModel selectionModel, Logger logger) {
        this.trackmate = trackmate;
        this.selectionModel = selectionModel;
        this.logger = logger;
        this.undo = new HashMap<Spot, double[]>();
        Settings settings = trackmate.getSettings();
        List<String> fits = this.getAvailableFits(DetectionUtils.is2D(settings.imp));
        List<String> docs = this.getDocs(DetectionUtils.is2D(settings.imp));
        this.gui = new SpotFitterPanel(fits, docs, settings.imp.getNChannels());
        this.gui.btnFit.addActionListener(e -> this.fit());
        this.gui.btnUndo.addActionListener(e -> this.undo());
    }

    private void undo() {
        EverythingDisablerAndReenabler disabler = new EverythingDisablerAndReenabler(this.gui, new Class[]{JLabel.class});
        disabler.disable();
        Threads.run("SpotFitterControllerUndoThread", () -> {
            try {
                this.logger.log("Undoing last fit.\n");
                this.logger.setStatus("Undoing");
                int progress = 0;
                for (Spot spot : this.undo.keySet()) {
                    double[] arr = this.undo.get(spot);
                    spot.putFeature("POSITION_X", arr[0]);
                    spot.putFeature("POSITION_Y", arr[1]);
                    spot.putFeature("POSITION_Z", arr[2]);
                    spot.putFeature("RADIUS", arr[3]);
                    this.logger.setProgress((double)progress++ / (double)this.undo.size());
                }
                this.logger.setProgress(0.0);
                this.trackmate.computeSpotFeatures(true);
                this.trackmate.computeEdgeFeatures(true);
                this.trackmate.computeTrackFeatures(true);
                this.logger.log("Undoing done.\n");
                this.trackmate.getModel().getModelChangeListener().forEach(l -> l.modelChanged(new ModelChangeEvent(this, 8)));
            }
            finally {
                disabler.reenable();
            }
        });
    }

    private void fit() {
        EverythingDisablerAndReenabler disabler = new EverythingDisablerAndReenabler(this.gui, new Class[]{JLabel.class});
        disabler.disable();
        Threads.run("SpotFitterControllerFitterThread", () -> {
            try {
                Iterable<Spot> spots;
                AbstractSpotFitter fitter;
                ImagePlus imp = this.trackmate.getSettings().imp;
                int channel = this.gui.getSelectedChannel() - 1;
                int index = this.gui.getSelectedFitIndex();
                if (DetectionUtils.is2D(imp)) {
                    if (index == 0) {
                        fitter = new SpotGaussianFitter2D(imp, channel);
                    } else {
                        if (index != 1) throw new IllegalArgumentException("Index points to an unknown fit model: " + index);
                        fitter = new SpotGaussianFitter2DFixedRadius(imp, channel);
                    }
                } else if (index == 0) {
                    fitter = new SpotGaussianFitter3D(imp, channel);
                } else {
                    if (index != 1) throw new IllegalArgumentException("Index points to an unknown fit model: " + index);
                    fitter = new SpotGaussianFitter3DFixedRadius(imp, channel);
                }
                fitter.setNumThreads(this.trackmate.getNumThreads());
                if (this.gui.rdbtnAll.isSelected()) {
                    spots = this.trackmate.getModel().getSpots().iterable(true);
                } else if (this.gui.rdbtnSelection.isSelected()) {
                    spots = this.selectionModel.getSpotSelection();
                } else {
                    this.selectionModel.selectTrack(this.selectionModel.getSpotSelection(), this.selectionModel.getEdgeSelection(), 0);
                    spots = this.selectionModel.getSpotSelection();
                }
                this.undo.clear();
                for (Spot spot : spots) {
                    this.undo.put(spot, new double[]{spot.getDoublePosition(0), spot.getDoublePosition(1), spot.getDoublePosition(2), spot.getFeature("RADIUS")});
                }
                fitter.process(spots, this.logger);
                this.trackmate.computeSpotFeatures(true);
                this.trackmate.computeEdgeFeatures(true);
                this.trackmate.computeTrackFeatures(true);
                this.trackmate.getModel().getModelChangeListener().forEach(l -> l.modelChanged(new ModelChangeEvent(this, 8)));
                return;
            }
            finally {
                disabler.reenable();
            }
        });
    }

    public void show() {
        if (this.gui.getParent() != null && this.gui.getParent().isVisible()) {
            return;
        }
        JFrame frame = new JFrame("TrackMate spot fitting");
        frame.setIconImage(Icons.SPOT_ICON.getImage());
        frame.setSize(300, 300);
        frame.getContentPane().add(this.gui);
        GuiUtils.positionWindow(frame, (Component)this.trackmate.getSettings().imp.getCanvas());
        frame.setVisible(true);
    }

    private List<String> getDocs(boolean is2d) {
        ArrayList<String> docs = new ArrayList<String>();
        if (is2d) {
            docs.add("<html>Fit a 2D circular Gaussian on each spot, allowing for the radius to vary.</html>");
            docs.add("<html>Fit a 2D circular Gaussian on each spot, but blocking its sigma value. The radius of the spotis not updated.</html>");
        } else {
            docs.add("<html>Fit a 3D anisotropic Gaussian on each spot. The Z sigma can be different from the sigmas in X and Y, which are forced to be identical. The radius of the spot is set from the sigma in XY.</html>");
            docs.add("<html>Fit a 3D anisotropic Gaussian on each spot. We only allow X, Y, Z and the amplitude to adjust in the fit. The spot radius is left unchanged.</html>");
        }
        return docs;
    }

    private List<String> getAvailableFits(boolean is2d) {
        ArrayList<String> fits = new ArrayList<String>();
        if (is2d) {
            fits.add("Gaussian 2D");
            fits.add("Gaussian 2D with fixed radius");
        } else {
            fits.add("Elliptical orthogonal Gaussian 3D");
            fits.add("Gaussian 3D with fixed radius");
        }
        return fits;
    }
}

