/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.action;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.SelectionModel;
import fiji.plugin.trackmate.TrackMate;
import fiji.plugin.trackmate.action.AbstractTMAction;
import fiji.plugin.trackmate.action.TrackMateAction;
import fiji.plugin.trackmate.action.TrackMateActionFactory;
import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import fiji.plugin.trackmate.util.TMUtils;
import fiji.plugin.trackmate.visualization.table.TrackTableView;
import java.awt.Frame;
import javax.swing.ImageIcon;
import org.scijava.plugin.Plugin;

public class ExportStatsTablesAction
extends AbstractTMAction {
    public static final String NAME = "Export statistics to tables";
    public static final String KEY = "EXPORT_STATS";
    public static final String INFO_TEXT = "<html>Compute and export all statistics to 3 tables. Statistics are separated in features computed for: <ol> \t<li> spots in visible tracks; \t<li> edges between those spots; \t<li> visible tracks. </ol> Note that spots and edges that are not in visible tracks won't be displayed in the tables.</html>";

    @Override
    public void execute(TrackMate trackmate, SelectionModel selectionModel, DisplaySettings displaySettings, Frame parent) {
        ExportStatsTablesAction.createTrackTables(trackmate.getModel(), selectionModel, displaySettings, TMUtils.getImagePathWithoutExtension(trackmate.getSettings())).render();
    }

    public static TrackTableView createTrackTables(Model model, SelectionModel selectionModel, DisplaySettings displaySettings, String imageFileName) {
        return new TrackTableView(model, selectionModel, displaySettings, imageFileName);
    }

    @Plugin(type=TrackMateActionFactory.class, visible=false)
    public static class Factory
    implements TrackMateActionFactory {
        @Override
        public String getInfoText() {
            return ExportStatsTablesAction.INFO_TEXT;
        }

        @Override
        public String getKey() {
            return ExportStatsTablesAction.KEY;
        }

        @Override
        public TrackMateAction create() {
            return new ExportStatsTablesAction();
        }

        @Override
        public ImageIcon getIcon() {
            return Icons.CALCULATOR_ICON;
        }

        @Override
        public String getName() {
            return ExportStatsTablesAction.NAME;
        }
    }
}

