/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.patcher;

import ij.ImagePlus;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;
import net.imagej.patcher.EssentialLegacyHooks;
import net.imagej.patcher.HeadlessGenericDialog;
import net.imagej.patcher.LegacyHooks;
import net.imagej.patcher.LegacyInjector;
import net.imagej.patcher.Utils;

public class LegacyClassLoader
extends URLClassLoader {
    private static final Map<String, Class<?>> knownClasses;
    private static final Map<String, Class<?>> sharedClasses;

    public LegacyClassLoader(boolean headless) throws ClassNotFoundException {
        this();
        new LegacyInjector().injectHooks(this, headless);
    }

    public LegacyClassLoader() throws ClassNotFoundException {
        super(LegacyClassLoader.getImageJ1Jar(), LegacyClassLoader.determineParent());
    }

    @Override
    public URL getResource(String name) {
        Class<?> knownClass;
        Class<?> clazz = knownClass = !name.endsWith(".class") ? null : knownClasses.get(name.substring(0, name.length() - 6).replace('/', '.'));
        if (knownClass != null) {
            return knownClass.getResource("/" + name);
        }
        return super.getResource(name);
    }

    @Override
    public Class<?> findClass(String className) throws ClassNotFoundException {
        Class<?> knownClass = knownClasses.get(className);
        if (knownClass != null) {
            try {
                int count;
                Class<?> sharedClass = sharedClasses.get(className);
                if (sharedClass != null) {
                    return sharedClass;
                }
                ProtectionDomain domain = knownClass.getProtectionDomain();
                InputStream in = knownClass.getResourceAsStream("/" + className.replace('.', '/') + ".class");
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] buffer = new byte[65536];
                while ((count = in.read(buffer)) >= 0) {
                    out.write(buffer, 0, count);
                }
                in.close();
                buffer = out.toByteArray();
                out.close();
                return this.defineClass(className, buffer, 0, buffer.length, domain);
            }
            catch (IOException e) {
                throw new ClassNotFoundException("Could not read bytecode for " + className, e);
            }
        }
        return super.findClass(className);
    }

    private static ClassLoader determineParent() {
        ClassLoader loader = ClassLoader.getSystemClassLoader();
        try {
            do {
                if (loader.loadClass("ij.IJ") != null) continue;
                return loader;
            } while ((loader = loader.getParent()) != null);
            throw new RuntimeException("Cannot find bootstrap class loader");
        }
        catch (ClassNotFoundException e) {
            return loader;
        }
    }

    private static URL[] getImageJ1Jar() {
        return new URL[]{Utils.getLocation(ImagePlus.class)};
    }

    static {
        sharedClasses = new HashMap();
        sharedClasses.put(LegacyHooks.class.getName(), LegacyHooks.class);
        for (Class<?> clazz : LegacyHooks.class.getClasses()) {
            sharedClasses.put(clazz.getName(), clazz);
        }
        knownClasses = new HashMap(sharedClasses);
        knownClasses.put(EssentialLegacyHooks.class.getName(), EssentialLegacyHooks.class);
        knownClasses.put(HeadlessGenericDialog.class.getName(), HeadlessGenericDialog.class);
    }
}

