/*
 * Decompiled with CFR 0.152.
 */
package imagej.patcher;

import ij.IJ;
import imagej.patcher.LegacyHooks;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedHashSet;

@Deprecated
public class EssentialLegacyHooks
extends LegacyHooks {
    @Override
    public void error(Throwable t) {
        IJ.handleException((Throwable)t);
    }

    @Override
    public boolean handleNoSuchMethodError(NoSuchMethodError error) {
        String message = error.getMessage();
        int paren = message.indexOf("(");
        if (paren < 0) {
            return false;
        }
        int dot = message.lastIndexOf(".", paren);
        if (dot < 0) {
            return false;
        }
        String path = message.substring(0, dot).replace('.', '/') + ".class";
        LinkedHashSet<String> urls = new LinkedHashSet<String>();
        try {
            Enumeration<URL> e = IJ.getClassLoader().getResources(path);
            while (e.hasMoreElements()) {
                urls.add(e.nextElement().toString());
            }
            e = IJ.getClassLoader().getResources("/" + path);
            while (e.hasMoreElements()) {
                urls.add(e.nextElement().toString());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
        if (urls.size() == 0) {
            return false;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("There was a problem with the class ");
        buffer.append(message.substring(0, dot));
        buffer.append(" which can be found here:\n");
        for (String url : urls) {
            int bang;
            if (url.startsWith("jar:")) {
                url = url.substring(4);
            }
            if (url.startsWith("file:")) {
                url = url.substring(5);
            }
            if ((bang = url.indexOf("!")) < 0) {
                buffer.append(url);
            } else {
                buffer.append(url.substring(0, bang));
            }
            buffer.append("\n");
        }
        if (urls.size() > 1) {
            buffer.append("\nWARNING: multiple locations found!\n");
        }
        StringWriter writer = new StringWriter();
        error.printStackTrace(new PrintWriter(writer));
        buffer.append(writer.toString());
        IJ.log((String)buffer.toString());
        IJ.error((String)("Could not find method " + message + "\n(See Log for details)\n"));
        return true;
    }

    @Override
    public void initialized() {
        String property = System.getProperty("ij1.patcher.initializer");
        try {
            Class<?> runClass;
            ClassLoader loader = IJ.getClassLoader();
            Thread.currentThread().setContextClassLoader(loader);
            if (property != null) {
                runClass = loader.loadClass(property);
            } else {
                try {
                    runClass = loader.loadClass("net.imagej.legacy.plugin.LegacyInitializer");
                }
                catch (ClassNotFoundException e) {
                    runClass = loader.loadClass("imagej.legacy.plugin.LegacyInitializer");
                }
            }
            Runnable run = (Runnable)runClass.newInstance();
            run.run();
        }
        catch (ClassNotFoundException loader) {
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public Object interceptRunPlugIn(String className, String arg) {
        if ("org.scijava.Context".equals(className)) {
            try {
                Class<?> contextClass = IJ.getClassLoader().loadClass(className);
                try {
                    return contextClass.newInstance();
                }
                catch (Throwable t) {
                    Class<?> legacyServiceClass;
                    t.printStackTrace();
                    try {
                        legacyServiceClass = IJ.getClassLoader().loadClass("net.imagej.legacy.DefaultLegacyService");
                    }
                    catch (Throwable t2) {
                        legacyServiceClass = IJ.getClassLoader().loadClass("imagej.legacy.DefaultLegacyService");
                    }
                    Constructor<?> ctor = contextClass.getConstructor(Class[].class);
                    return ctor.newInstance(new Object[]{new Class[]{legacyServiceClass}});
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                System.err.println("Giving up to create a SciJava Context!");
            }
        }
        return null;
    }
}

