/*
 * Decompiled with CFR 0.152.
 */
package trainableSegmentation.metrics;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import ij.util.ThreadUtil;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import trainableSegmentation.metrics.InformationStatistics;
import trainableSegmentation.metrics.Metrics;
import trainableSegmentation.utils.Utils;
import trainableSegmentation.utils.WatershedTransform2D;

public class VariationOfInformation
extends Metrics {
    public VariationOfInformation(ImagePlus originalLabels, ImagePlus proposedLabels) {
        super(originalLabels, proposedLabels);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getMetricValue(double binaryThreshold) {
        ImageStack labelSlices = this.originalLabels.getImageStack();
        ImageStack proposalSlices = this.proposedLabels.getImageStack();
        double vi = 0.0;
        ExecutorService exe = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        ArrayList<Future<Double>> futures = new ArrayList<Future<Double>>();
        try {
            for (int i = 1; i <= labelSlices.getSize(); ++i) {
                futures.add(exe.submit(this.getVIConcurrent(labelSlices.getProcessor(i).convertToFloat(), proposalSlices.getProcessor(i).convertToFloat(), binaryThreshold)));
            }
            for (Future future : futures) {
                vi += ((Double)future.get()).doubleValue();
            }
        }
        catch (Exception ex) {
            IJ.log((String)"Error when calculating variation of information in a concurrent way.");
            ex.printStackTrace();
        }
        finally {
            exe.shutdown();
        }
        return vi / (double)labelSlices.getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getForegroundRestrictedMetricValue(double binaryThreshold) {
        ImageStack labelSlices = this.originalLabels.getImageStack();
        ImageStack proposalSlices = this.proposedLabels.getImageStack();
        double vi = 0.0;
        ExecutorService exe = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        ArrayList<Future<Double>> futures = new ArrayList<Future<Double>>();
        try {
            for (int i = 1; i <= labelSlices.getSize(); ++i) {
                futures.add(exe.submit(this.getForegroundRestrictedVIConcurrent(labelSlices.getProcessor(i).convertToFloat(), proposalSlices.getProcessor(i).convertToFloat(), binaryThreshold)));
            }
            for (Future future : futures) {
                vi += ((Double)future.get()).doubleValue();
            }
        }
        catch (Exception ex) {
            IJ.log((String)"Error when calculating foreground-restricted variation of information in a concurrent way.");
            ex.printStackTrace();
        }
        finally {
            exe.shutdown();
        }
        return vi / (double)labelSlices.getSize();
    }

    public double getMinimumForegroundRestrictedMetricValue(double minThreshold, double maxThreshold, double stepThreshold) {
        double min = Double.MAX_VALUE;
        double bestTh = minThreshold;
        for (double th = minThreshold; th <= maxThreshold; th += stepThreshold) {
            double error;
            if (this.verbose) {
                IJ.log((String)("  Calculating foreground-restricted VI value for threshold " + String.format("%.3f", th) + "..."));
            }
            if (min > (error = this.getForegroundRestrictedMetricValue(th))) {
                min = error;
                bestTh = th;
            }
            if (!this.verbose) continue;
            IJ.log((String)("    Error = " + error));
        }
        if (this.verbose) {
            IJ.log((String)(" ** Minimum foreground-restricted VI value = " + min + ", with threshold = " + bestTh + " **\n"));
        }
        return min;
    }

    public Callable<Double> getVIConcurrent(final ImageProcessor image1, final ImageProcessor image2, final double binaryThreshold) {
        return new Callable<Double>(){

            @Override
            public Double call() {
                return VariationOfInformation.this.variationOfInformationN2(image1, image2, binaryThreshold);
            }
        };
    }

    public Callable<Double> getForegroundRestrictedVIConcurrent(final ImageProcessor image1, final ImageProcessor image2, final double binaryThreshold) {
        return new Callable<Double>(){

            @Override
            public Double call() {
                return VariationOfInformation.this.foregroundRestrictedVIN2(image1, image2, binaryThreshold);
            }
        };
    }

    public double variationOfInformationN2(ImageProcessor label, ImageProcessor proposal, double binaryThreshold) {
        ByteProcessor binaryLabel = new ByteProcessor(label.getWidth(), label.getHeight());
        ByteProcessor binaryProposal = new ByteProcessor(label.getWidth(), label.getHeight());
        for (int x = 0; x < label.getWidth(); ++x) {
            for (int y = 0; y < label.getHeight(); ++y) {
                binaryLabel.set(x, y, (double)label.getPixelValue(x, y) > binaryThreshold ? 255 : 0);
                binaryProposal.set(x, y, (double)proposal.getPixelValue(x, y) > binaryThreshold ? 255 : 0);
            }
        }
        ShortProcessor components1 = (ShortProcessor)Utils.connectedComponents((ImagePlus)new ImagePlus((String)"binary labels", (ImageProcessor)binaryLabel), (int)4).allRegions.getProcessor();
        ShortProcessor components2 = (ShortProcessor)Utils.connectedComponents((ImagePlus)new ImagePlus((String)"proposal labels", (ImageProcessor)binaryProposal), (int)4).allRegions.getProcessor();
        return this.getVI(components1, components2);
    }

    public double foregroundRestrictedVIN2(ImageProcessor label, ImageProcessor proposal, double binaryThreshold) {
        ByteProcessor binaryLabel = new ByteProcessor(label.getWidth(), label.getHeight());
        ByteProcessor binaryProposal = new ByteProcessor(label.getWidth(), label.getHeight());
        for (int x = 0; x < label.getWidth(); ++x) {
            for (int y = 0; y < label.getHeight(); ++y) {
                binaryLabel.set(x, y, (double)label.getPixelValue(x, y) > binaryThreshold ? 255 : 0);
                binaryProposal.set(x, y, (double)proposal.getPixelValue(x, y) > binaryThreshold ? 255 : 0);
            }
        }
        ShortProcessor components1 = (ShortProcessor)Utils.connectedComponents((ImagePlus)new ImagePlus((String)"binary labels", (ImageProcessor)binaryLabel), (int)4).allRegions.getProcessor();
        ShortProcessor components2 = (ShortProcessor)Utils.connectedComponents((ImagePlus)new ImagePlus((String)"proposal labels", (ImageProcessor)binaryProposal), (int)4).allRegions.getProcessor();
        return this.foregroundRestrictedVI(components1, components2);
    }

    public double getVI(ShortProcessor cluster1, ShortProcessor cluster2) {
        int j;
        short[] pixels1 = (short[])cluster1.getPixels();
        short[] pixels2 = (short[])cluster2.getPixels();
        double n = pixels1.length;
        cluster1.resetMinAndMax();
        cluster2.resetMinAndMax();
        int nLabelsA = (int)cluster1.getMax();
        int nLabelsB = (int)cluster2.getMax();
        double[][] pij = new double[nLabelsA + 1][nLabelsB + 1];
        int i = 0;
        while ((double)i < n) {
            double[] dArray = pij[pixels1[i] & 0xFFFF];
            int n2 = pixels2[i] & 0xFFFF;
            dArray[n2] = dArray[n2] + 1.0;
            ++i;
        }
        for (i = 0; i < nLabelsA + 1; ++i) {
            int j2 = 0;
            while (j2 < nLabelsB + 1) {
                double[] dArray = pij[i];
                int n3 = j2++;
                dArray[n3] = dArray[n3] / n;
            }
        }
        double[] ai = new double[pij.length];
        for (int i2 = 0; i2 < pij.length; ++i2) {
            for (j = 0; j < pij[0].length; ++j) {
                int n4 = i2;
                ai[n4] = ai[n4] + pij[i2][j];
            }
        }
        double[] bj = new double[pij[0].length];
        for (j = 0; j < pij[0].length; ++j) {
            for (int i3 = 0; i3 < pij.length; ++i3) {
                int n5 = j;
                bj[n5] = bj[n5] + pij[i3][j];
            }
        }
        double sumA = 0.0;
        for (int i4 = 0; i4 < ai.length; ++i4) {
            if (ai[i4] == 0.0) continue;
            sumA += ai[i4] * Math.log(ai[i4]);
        }
        double sumB = 0.0;
        for (int j3 = 0; j3 < bj.length; ++j3) {
            if (bj[j3] == 0.0) continue;
            sumB += bj[j3] * Math.log(bj[j3]);
        }
        double sumAB = 0.0;
        for (int i5 = 1; i5 < pij.length; ++i5) {
            for (int j4 = 1; j4 < pij[0].length; ++j4) {
                if (pij[i5][j4] == 0.0) continue;
                sumAB += pij[i5][j4] * Math.log(pij[i5][j4]);
            }
        }
        return sumA + sumB - 2.0 * sumAB;
    }

    public double foregroundRestrictedVI(ShortProcessor cluster1, ShortProcessor cluster2) {
        int j;
        int i;
        short[] pixels1 = (short[])cluster1.getPixels();
        short[] pixels2 = (short[])cluster2.getPixels();
        double n = 0.0;
        for (int i2 = 0; i2 < pixels1.length; ++i2) {
            if (pixels1[i2] == 0) continue;
            n += 1.0;
        }
        cluster1.resetMinAndMax();
        cluster2.resetMinAndMax();
        int nLabelsA = (int)cluster1.getMax();
        int nLabelsB = (int)cluster2.getMax();
        double[][] pij = new double[nLabelsA + 1][nLabelsB + 1];
        for (i = 0; i < pixels1.length; ++i) {
            double[] dArray = pij[pixels1[i] & 0xFFFF];
            int n2 = pixels2[i] & 0xFFFF;
            dArray[n2] = dArray[n2] + 1.0;
        }
        for (i = 0; i < nLabelsA + 1; ++i) {
            int j2 = 0;
            while (j2 < nLabelsB + 1) {
                double[] dArray = pij[i];
                int n3 = j2++;
                dArray[n3] = dArray[n3] / n;
            }
        }
        double[] ai = new double[pij.length];
        for (int i3 = 1; i3 < pij.length; ++i3) {
            for (j = 0; j < pij[0].length; ++j) {
                int n4 = i3;
                ai[n4] = ai[n4] + pij[i3][j];
            }
        }
        double[] bj = new double[pij[0].length];
        for (j = 1; j < pij[0].length; ++j) {
            for (int i4 = 1; i4 < pij.length; ++i4) {
                int n5 = j;
                bj[n5] = bj[n5] + pij[i4][j];
            }
        }
        double[] pi0 = new double[pij.length];
        double aux = 0.0;
        for (int i5 = 1; i5 < pij.length; ++i5) {
            pi0[i5] = pij[i5][0];
            aux += pi0[i5];
        }
        double sumA = 0.0;
        for (int i6 = 0; i6 < ai.length; ++i6) {
            if (ai[i6] == 0.0) continue;
            sumA += ai[i6] * Math.log(ai[i6]);
        }
        double sumB = 0.0;
        for (int j3 = 0; j3 < bj.length; ++j3) {
            if (bj[j3] == 0.0) continue;
            sumB += bj[j3] * Math.log(bj[j3]);
        }
        sumB -= aux * Math.log(n);
        double sumAB = 0.0;
        for (int i7 = 1; i7 < pij.length; ++i7) {
            for (int j4 = 1; j4 < pij[0].length; ++j4) {
                if (pij[i7][j4] == 0.0) continue;
                sumAB += pij[i7][j4] * Math.log(pij[i7][j4]);
            }
        }
        return sumA + sumB - 2.0 * (sumAB -= aux * Math.log(n));
    }

    public double[] getForegroundRestrictedGroundTruthDisagreements(ShortProcessor cluster1, ShortProcessor cluster2) {
        int j;
        int i;
        short[] pixels1 = (short[])cluster1.getPixels();
        short[] pixels2 = (short[])cluster2.getPixels();
        double n = 0.0;
        for (int i2 = 0; i2 < pixels1.length; ++i2) {
            if (pixels1[i2] == 0) continue;
            n += 1.0;
        }
        cluster1.resetMinAndMax();
        cluster2.resetMinAndMax();
        int nLabelsA = (int)cluster1.getMax();
        int nLabelsB = (int)cluster2.getMax();
        double[][] pij = new double[nLabelsA + 1][nLabelsB + 1];
        for (i = 0; i < pixels1.length; ++i) {
            double[] dArray = pij[pixels1[i] & 0xFFFF];
            int n2 = pixels2[i] & 0xFFFF;
            dArray[n2] = dArray[n2] + 1.0;
        }
        for (i = 0; i < nLabelsA + 1; ++i) {
            j = 0;
            while (j < nLabelsB + 1) {
                double[] dArray = pij[i];
                int n3 = j++;
                dArray[n3] = dArray[n3] / n;
            }
        }
        double[] bj = new double[pij[0].length];
        for (j = 1; j < pij[0].length; ++j) {
            for (int i3 = 1; i3 < pij.length; ++i3) {
                int n4 = j;
                bj[n4] = bj[n4] + pij[i3][j];
            }
        }
        double[] dis = new double[pij[0].length];
        for (int j2 = 0; j2 < bj.length; ++j2) {
            double sum = 0.0;
            for (int i4 = 1; i4 < pij.length; ++i4) {
                double aux = pij[i4][j2] * Math.log(pij[i4][j2]);
                if (Double.isNaN(aux)) continue;
                sum += aux;
            }
            double aux = bj[j2] * Math.log(bj[j2]);
            if (Double.isNaN(aux)) continue;
            dis[j2] = aux - sum;
        }
        return dis;
    }

    public double[] getForegroundRestrictedPredictionDisagreements(ShortProcessor cluster1, ShortProcessor cluster2) {
        int i;
        int i2;
        short[] pixels1 = (short[])cluster1.getPixels();
        short[] pixels2 = (short[])cluster2.getPixels();
        double n = 0.0;
        for (int i3 = 0; i3 < pixels1.length; ++i3) {
            if (pixels1[i3] == 0) continue;
            n += 1.0;
        }
        cluster1.resetMinAndMax();
        cluster2.resetMinAndMax();
        int nLabelsA = (int)cluster1.getMax();
        int nLabelsB = (int)cluster2.getMax();
        double[][] pij = new double[nLabelsA + 1][nLabelsB + 1];
        for (i2 = 0; i2 < pixels1.length; ++i2) {
            double[] dArray = pij[pixels1[i2] & 0xFFFF];
            int n2 = pixels2[i2] & 0xFFFF;
            dArray[n2] = dArray[n2] + 1.0;
        }
        for (i2 = 0; i2 < nLabelsA + 1; ++i2) {
            int j = 0;
            while (j < nLabelsB + 1) {
                double[] dArray = pij[i2];
                int n3 = j++;
                dArray[n3] = dArray[n3] / n;
            }
        }
        double[] dis = new double[pij.length];
        double[] ai = new double[pij.length];
        for (i = 1; i < pij.length; ++i) {
            for (int j = 0; j < pij[0].length; ++j) {
                int n4 = i;
                ai[n4] = ai[n4] + pij[i][j];
            }
        }
        for (i = 0; i < ai.length; ++i) {
            double sum = 0.0;
            for (int j = 0; j < pij[0].length; ++j) {
                double aux = pij[i][j] * Math.log(pij[i][j]);
                if (Double.isNaN(aux)) continue;
                sum += aux;
            }
            double aux = ai[i] * Math.log(ai[i]);
            if (Double.isNaN(aux)) continue;
            dis[i] = aux - sum;
        }
        return dis;
    }

    public double getForegroundRestrictedMaximalFScore(double minThreshold, double maxThreshold, double stepThreshold) {
        ArrayList<Double> fscores = this.getForegroundRestrictedFscores(minThreshold, maxThreshold, stepThreshold);
        double maxFScore = 0.0;
        for (double f : fscores) {
            if (!(f > maxFScore)) continue;
            maxFScore = f;
        }
        return maxFScore;
    }

    public double getMaximalVInfoAfterThinning(double minThreshold, double maxThreshold, double stepThreshold) {
        ArrayList<Double> scores = this.getForegroundRestrictedScoresAfterThinning(minThreshold, maxThreshold, stepThreshold);
        double maxScore = 0.0;
        for (double f : scores) {
            if (!(f > maxScore)) continue;
            maxScore = f;
        }
        return maxScore;
    }

    public double getMaximalFScore(double minThreshold, double maxThreshold, double stepThreshold) {
        ArrayList<Double> fscores = this.getFscores(minThreshold, maxThreshold, stepThreshold);
        double maxFScore = 0.0;
        for (double f : fscores) {
            if (!(f > maxFScore)) continue;
            maxFScore = f;
        }
        return maxFScore;
    }

    public ArrayList<Double> getForegroundRestrictedFscores(double minThreshold, double maxThreshold, double stepThreshold) {
        if (minThreshold < 0.0 || minThreshold > maxThreshold || maxThreshold > 1.0) {
            IJ.log((String)"Error: unvalid threshold values.");
            return null;
        }
        double bestFscore = 0.0;
        double bestTh = minThreshold;
        ArrayList<Double> fscores = new ArrayList<Double>();
        for (double th = minThreshold; th <= maxThreshold; th += stepThreshold) {
            if (this.verbose) {
                IJ.log((String)("  Calculating foreground-restricted variation of information F-score for threshold value " + String.format("%.3f", th) + "..."));
            }
            double fScore = this.getForegroundRestrictedFscore(th);
            fscores.add(fScore);
            if (fScore > bestFscore) {
                bestFscore = fScore;
                bestTh = th;
            }
            if (!this.verbose) continue;
            IJ.log((String)("    F-score = " + fScore));
        }
        if (this.verbose) {
            IJ.log((String)(" ** Best F-score = " + bestFscore + ", with threshold = " + bestTh + " **\n"));
        }
        return fscores;
    }

    public ArrayList<Double> getForegroundRestrictedScoresAfterThinning(double minThreshold, double maxThreshold, double stepThreshold) {
        if (minThreshold < 0.0 || minThreshold > maxThreshold || maxThreshold > 1.0) {
            IJ.log((String)"Error: unvalid threshold values.");
            return null;
        }
        double bestFscore = 0.0;
        double bestTh = minThreshold;
        ArrayList<Double> fscores = new ArrayList<Double>();
        for (double th = minThreshold; th <= maxThreshold; th += stepThreshold) {
            if (this.verbose) {
                IJ.log((String)("  Calculating foreground-restricted information theoretic score after border thinning for threshold value " + String.format("%.3f", th) + "..."));
            }
            double fScore = this.getForegroundRestrictedScoreAfterThinning(th);
            fscores.add(fScore);
            if (fScore > bestFscore) {
                bestFscore = fScore;
                bestTh = th;
            }
            if (!this.verbose) continue;
            IJ.log((String)("    V_info = " + fScore));
        }
        if (this.verbose) {
            IJ.log((String)(" ** Best V_info = " + bestFscore + ", with threshold = " + String.format("%.3f", bestTh) + " **\n"));
        }
        return fscores;
    }

    public ArrayList<Double> getFscores(double minThreshold, double maxThreshold, double stepThreshold) {
        if (minThreshold < 0.0 || minThreshold > maxThreshold || maxThreshold > 1.0) {
            IJ.log((String)"Error: unvalid threshold values.");
            return null;
        }
        double bestFscore = 0.0;
        double bestTh = minThreshold;
        ArrayList<Double> fscores = new ArrayList<Double>();
        for (double th = minThreshold; th <= maxThreshold; th += stepThreshold) {
            if (this.verbose) {
                IJ.log((String)("  Calculating variation of information F-score for threshold value " + String.format("%.3f", th) + "..."));
            }
            double fScore = this.getFscore(th);
            fscores.add(fScore);
            if (fScore > bestFscore) {
                bestFscore = fScore;
                bestTh = th;
            }
            if (!this.verbose) continue;
            IJ.log((String)("    F-score = " + fScore));
        }
        if (this.verbose) {
            IJ.log((String)(" ** Best F-score = " + bestFscore + ", with threshold = " + bestTh + " **\n"));
        }
        return fscores;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getForegroundRestrictedFscore(double th) {
        ImageStack labelSlices = this.originalLabels.getImageStack();
        ImageStack proposalSlices = this.proposedLabels.getImageStack();
        double fScore = 0.0;
        ExecutorService exe = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        ArrayList<Future<Double>> futures = new ArrayList<Future<Double>>();
        try {
            for (int i = 1; i <= labelSlices.getSize(); ++i) {
                futures.add(exe.submit(this.getforegroundRestrictedFscoreConcurrent(labelSlices.getProcessor(i).convertToFloat(), proposalSlices.getProcessor(i).convertToFloat(), th)));
            }
            for (Future future : futures) {
                fScore += ((Double)future.get()).doubleValue();
            }
        }
        catch (Exception ex) {
            IJ.log((String)"Error when calculating the F-score of variation of information in a concurrent way.");
            ex.printStackTrace();
        }
        finally {
            exe.shutdown();
        }
        return fScore / (double)labelSlices.getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getForegroundRestrictedScoreAfterThinning(double th) {
        ImageStack labelSlices = this.originalLabels.getImageStack();
        ImageStack proposalSlices = this.proposedLabels.getImageStack();
        double fScore = 0.0;
        ExecutorService exe = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        ArrayList<Future<Double>> futures = new ArrayList<Future<Double>>();
        try {
            for (int i = 1; i <= labelSlices.getSize(); ++i) {
                futures.add(exe.submit(this.getforegroundRestrictedScoreAfterThinningConcurrent(labelSlices.getProcessor(i).convertToFloat(), proposalSlices.getProcessor(i).convertToFloat(), th)));
            }
            for (Future future : futures) {
                fScore += ((Double)future.get()).doubleValue();
            }
        }
        catch (Exception ex) {
            IJ.log((String)"Error when calculating the foreground-restricted informationtheoretic score after thinning in a concurrent way.");
            ex.printStackTrace();
        }
        finally {
            exe.shutdown();
        }
        return fScore / (double)labelSlices.getSize();
    }

    public InformationStatistics[] getForegroundRestrictedStatsPerSlice(final double binaryThreshold) {
        final ImageStack labelSlices = this.originalLabels.getImageStack();
        final ImageStack proposalSlices = this.proposedLabels.getImageStack();
        final InformationStatistics[] is = new InformationStatistics[this.originalLabels.getImageStackSize()];
        final AtomicInteger ai = new AtomicInteger(0);
        final int n_cpus = Prefs.getThreads();
        final int depth = is.length;
        final int dec = (int)Math.ceil((double)depth / (double)n_cpus);
        Thread[] threads = ThreadUtil.createThreadArray((int)n_cpus);
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(){

                @Override
                public void run() {
                    int k = ai.getAndIncrement();
                    while (k < n_cpus) {
                        int zmin = dec * k;
                        int zmax = dec * (k + 1);
                        if (zmin < 0) {
                            zmin = 0;
                        }
                        if (zmax > depth) {
                            zmax = depth;
                        }
                        for (int i = zmin; i < zmax; ++i) {
                            if (zmin == 0) {
                                IJ.showProgress((int)(i + 1), (int)zmax);
                            }
                            is[i] = VariationOfInformation.this.foregroundRestrictedStats(labelSlices.getProcessor(i + 1).convertToFloat(), proposalSlices.getProcessor(i + 1).convertToFloat(), binaryThreshold);
                        }
                        k = ai.getAndIncrement();
                    }
                }
            };
        }
        ThreadUtil.startAndJoin((Thread[])threads);
        IJ.showProgress((double)1.0);
        return is;
    }

    public InformationStatistics foregroundRestrictedStats(ImageProcessor gt, ImageProcessor proposal, double binaryThreshold) {
        ByteProcessor binaryLabel = new ByteProcessor(gt.getWidth(), gt.getHeight());
        ByteProcessor binaryProposal = new ByteProcessor(gt.getWidth(), gt.getHeight());
        for (int x = 0; x < gt.getWidth(); ++x) {
            for (int y = 0; y < gt.getHeight(); ++y) {
                binaryLabel.set(x, y, (double)gt.getPixelValue(x, y) > binaryThreshold ? 255 : 0);
                binaryProposal.set(x, y, (double)proposal.getPixelValue(x, y) > binaryThreshold ? 255 : 0);
            }
        }
        ShortProcessor components1 = (ShortProcessor)Utils.connectedComponents((ImagePlus)new ImagePlus((String)"ground truth labels", (ImageProcessor)binaryLabel), (int)4).allRegions.getProcessor();
        ShortProcessor components2 = (ShortProcessor)Utils.connectedComponents((ImagePlus)new ImagePlus((String)"proposal labels", (ImageProcessor)binaryProposal), (int)4).allRegions.getProcessor();
        return this.foregroundRestrictedStats(components1, components2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getFscore(double th) {
        ImageStack labelSlices = this.originalLabels.getImageStack();
        ImageStack proposalSlices = this.proposedLabels.getImageStack();
        double fScore = 0.0;
        ExecutorService exe = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        ArrayList<Future<Double>> futures = new ArrayList<Future<Double>>();
        try {
            for (int i = 1; i <= labelSlices.getSize(); ++i) {
                futures.add(exe.submit(this.getFscoreConcurrent(labelSlices.getProcessor(i).convertToFloat(), proposalSlices.getProcessor(i).convertToFloat(), th)));
            }
            for (Future future : futures) {
                fScore += ((Double)future.get()).doubleValue();
            }
        }
        catch (Exception ex) {
            IJ.log((String)"Error when calculating the F-score of variation of information in a concurrent way.");
            ex.printStackTrace();
        }
        finally {
            exe.shutdown();
        }
        return fScore / (double)labelSlices.getSize();
    }

    public Callable<Double> getFscoreConcurrent(final ImageProcessor image1, final ImageProcessor image2, final double binaryThreshold) {
        return new Callable<Double>(){

            @Override
            public Double call() {
                return VariationOfInformation.this.fScoreN2(image1, image2, binaryThreshold);
            }
        };
    }

    public Callable<Double> getforegroundRestrictedFscoreConcurrent(final ImageProcessor image1, final ImageProcessor image2, final double binaryThreshold) {
        return new Callable<Double>(){

            @Override
            public Double call() {
                return VariationOfInformation.this.foregroundRestrictedFScoreN2(image1, image2, binaryThreshold);
            }
        };
    }

    public Callable<Double> getforegroundRestrictedScoreAfterThinningConcurrent(final ImageProcessor image1, final ImageProcessor image2, final double binaryThreshold) {
        return new Callable<Double>(){

            @Override
            public Double call() {
                return VariationOfInformation.this.foregroundRestrictedScoreAfterThinningN2(image1, image2, binaryThreshold);
            }
        };
    }

    public double fScoreN2(ImageProcessor label, ImageProcessor proposal, double binaryThreshold) {
        ByteProcessor binaryLabel = new ByteProcessor(label.getWidth(), label.getHeight());
        ByteProcessor binaryProposal = new ByteProcessor(label.getWidth(), label.getHeight());
        for (int x = 0; x < label.getWidth(); ++x) {
            for (int y = 0; y < label.getHeight(); ++y) {
                binaryLabel.set(x, y, (double)label.getPixelValue(x, y) > binaryThreshold ? 255 : 0);
                binaryProposal.set(x, y, (double)proposal.getPixelValue(x, y) > binaryThreshold ? 255 : 0);
            }
        }
        ShortProcessor components1 = (ShortProcessor)Utils.connectedComponents((ImagePlus)new ImagePlus((String)"binary labels", (ImageProcessor)binaryLabel), (int)4).allRegions.getProcessor();
        ShortProcessor components2 = (ShortProcessor)Utils.connectedComponents((ImagePlus)new ImagePlus((String)"proposal labels", (ImageProcessor)binaryProposal), (int)4).allRegions.getProcessor();
        return this.fscore(components1, components2);
    }

    public double foregroundRestrictedFScoreN2(ImageProcessor label, ImageProcessor proposal, double binaryThreshold) {
        ByteProcessor binaryLabel = new ByteProcessor(label.getWidth(), label.getHeight());
        ByteProcessor binaryProposal = new ByteProcessor(label.getWidth(), label.getHeight());
        for (int x = 0; x < label.getWidth(); ++x) {
            for (int y = 0; y < label.getHeight(); ++y) {
                binaryLabel.set(x, y, (double)label.getPixelValue(x, y) > binaryThreshold ? 255 : 0);
                binaryProposal.set(x, y, (double)proposal.getPixelValue(x, y) > binaryThreshold ? 255 : 0);
            }
        }
        ShortProcessor components1 = (ShortProcessor)Utils.connectedComponents((ImagePlus)new ImagePlus((String)"binary labels", (ImageProcessor)binaryLabel), (int)4).allRegions.getProcessor();
        ShortProcessor components2 = (ShortProcessor)Utils.connectedComponents((ImagePlus)new ImagePlus((String)"proposal labels", (ImageProcessor)binaryProposal), (int)4).allRegions.getProcessor();
        return this.foregroundRestrictedFscore(components1, components2);
    }

    public double foregroundRestrictedScoreAfterThinningN2(ImageProcessor label, ImageProcessor proposal, double binaryThreshold) {
        ByteProcessor binaryLabel = new ByteProcessor(label.getWidth(), label.getHeight());
        ByteProcessor binaryProposal = new ByteProcessor(label.getWidth(), label.getHeight());
        for (int x = 0; x < label.getWidth(); ++x) {
            for (int y = 0; y < label.getHeight(); ++y) {
                binaryLabel.set(x, y, (double)label.getPixelValue(x, y) > binaryThreshold ? 255 : 0);
                binaryProposal.set(x, y, (double)proposal.getPixelValue(x, y) > binaryThreshold ? 0 : 255);
            }
        }
        ShortProcessor components1 = (ShortProcessor)Utils.connectedComponents((ImagePlus)new ImagePlus((String)"binary labels", (ImageProcessor)binaryLabel), (int)4).allRegions.getProcessor();
        WatershedTransform2D wt = new WatershedTransform2D((ImageProcessor)binaryProposal, 4);
        ShortProcessor components2 = wt.apply().convertToShortProcessor(false);
        return this.foregroundRestrictedFscore(components1, components2);
    }

    public double foregroundRestrictedFscore(ShortProcessor cluster1, ShortProcessor cluster2) {
        int j;
        int i;
        short[] pixels1 = (short[])cluster1.getPixels();
        short[] pixels2 = (short[])cluster2.getPixels();
        double n = 0.0;
        for (int i2 = 0; i2 < pixels1.length; ++i2) {
            if (pixels1[i2] == 0) continue;
            n += 1.0;
        }
        cluster1.resetMinAndMax();
        cluster2.resetMinAndMax();
        int nLabelsA = (int)cluster1.getMax();
        int nLabelsB = (int)cluster2.getMax();
        double[][] pij = new double[nLabelsA + 1][nLabelsB + 1];
        for (i = 0; i < pixels1.length; ++i) {
            double[] dArray = pij[pixels1[i] & 0xFFFF];
            int n2 = pixels2[i] & 0xFFFF;
            dArray[n2] = dArray[n2] + 1.0;
        }
        for (i = 0; i < nLabelsA + 1; ++i) {
            int j2 = 0;
            while (j2 < nLabelsB + 1) {
                double[] dArray = pij[i];
                int n3 = j2++;
                dArray[n3] = dArray[n3] / n;
            }
        }
        double[] ai = new double[pij.length];
        for (int i3 = 1; i3 < pij.length; ++i3) {
            for (j = 0; j < pij[0].length; ++j) {
                int n4 = i3;
                ai[n4] = ai[n4] + pij[i3][j];
            }
        }
        double[] bj = new double[pij[0].length];
        for (j = 1; j < pij[0].length; ++j) {
            for (int i4 = 1; i4 < pij.length; ++i4) {
                int n5 = j;
                bj[n5] = bj[n5] + pij[i4][j];
            }
        }
        double[] pi0 = new double[pij.length];
        double aux = 0.0;
        for (int i5 = 1; i5 < pij.length; ++i5) {
            pi0[i5] = pij[i5][0];
            aux += pi0[i5];
        }
        double sumA = 0.0;
        for (int i6 = 0; i6 < ai.length; ++i6) {
            if (ai[i6] == 0.0) continue;
            sumA += ai[i6] * Math.log(ai[i6]);
        }
        double sumB = 0.0;
        for (int j3 = 0; j3 < bj.length; ++j3) {
            if (bj[j3] == 0.0) continue;
            sumB += bj[j3] * Math.log(bj[j3]);
        }
        sumB -= aux * Math.log(n);
        double sumAB = 0.0;
        for (int i7 = 1; i7 < pij.length; ++i7) {
            for (int j4 = 1; j4 < pij[0].length; ++j4) {
                if (pij[i7][j4] == 0.0) continue;
                sumAB += pij[i7][j4] * Math.log(pij[i7][j4]);
            }
        }
        double ha = -sumA;
        double hb = -sumB;
        double hab = sumB - (sumAB -= aux * Math.log(n));
        double hba = sumA - sumAB;
        double prec = (ha - hab) / ha;
        double rec = (hb - hba) / hb;
        if (ha == 0.0) {
            prec = 0.0;
            rec = 1.0;
        }
        if (hb == 0.0) {
            prec = 1.0;
            rec = 0.0;
        }
        return 2.0 * prec * rec / (prec + rec);
    }

    public InformationStatistics foregroundRestrictedStats(ShortProcessor cluster1, ShortProcessor cluster2) {
        int j;
        int i;
        short[] pixels1 = (short[])cluster1.getPixels();
        short[] pixels2 = (short[])cluster2.getPixels();
        double n = 0.0;
        for (int i2 = 0; i2 < pixels1.length; ++i2) {
            if (pixels1[i2] == 0) continue;
            n += 1.0;
        }
        cluster1.resetMinAndMax();
        cluster2.resetMinAndMax();
        int nLabelsA = (int)cluster1.getMax();
        int nLabelsB = (int)cluster2.getMax();
        double[][] pij = new double[nLabelsA + 1][nLabelsB + 1];
        for (i = 0; i < pixels1.length; ++i) {
            double[] dArray = pij[pixels1[i] & 0xFFFF];
            int n2 = pixels2[i] & 0xFFFF;
            dArray[n2] = dArray[n2] + 1.0;
        }
        for (i = 0; i < nLabelsA + 1; ++i) {
            int j2 = 0;
            while (j2 < nLabelsB + 1) {
                double[] dArray = pij[i];
                int n3 = j2++;
                dArray[n3] = dArray[n3] / n;
            }
        }
        double[] ai = new double[pij.length];
        for (int i3 = 1; i3 < pij.length; ++i3) {
            for (j = 0; j < pij[0].length; ++j) {
                int n4 = i3;
                ai[n4] = ai[n4] + pij[i3][j];
            }
        }
        double[] bj = new double[pij[0].length];
        for (j = 1; j < pij[0].length; ++j) {
            for (int i4 = 1; i4 < pij.length; ++i4) {
                int n5 = j;
                bj[n5] = bj[n5] + pij[i4][j];
            }
        }
        double[] pi0 = new double[pij.length];
        double aux = 0.0;
        for (int i5 = 1; i5 < pij.length; ++i5) {
            pi0[i5] = pij[i5][0];
            aux += pi0[i5];
        }
        double sumA = 0.0;
        for (int i6 = 0; i6 < ai.length; ++i6) {
            if (ai[i6] == 0.0) continue;
            sumA += ai[i6] * Math.log(ai[i6]);
        }
        double sumB = 0.0;
        for (int j3 = 0; j3 < bj.length; ++j3) {
            if (bj[j3] == 0.0) continue;
            sumB += bj[j3] * Math.log(bj[j3]);
        }
        sumB -= aux * Math.log(n);
        double sumAB = 0.0;
        for (int i7 = 1; i7 < pij.length; ++i7) {
            for (int j4 = 1; j4 < pij[0].length; ++j4) {
                if (pij[i7][j4] == 0.0) continue;
                sumAB += pij[i7][j4] * Math.log(pij[i7][j4]);
            }
        }
        double hab = sumB - (sumAB -= aux * Math.log(n));
        double hba = sumA - sumAB;
        double ha = -sumA;
        double hb = -sumB;
        double vi = sumA + sumB - 2.0 * sumAB;
        return new InformationStatistics(ha, hb, hab, hba, vi);
    }

    public double fscore(ShortProcessor cluster1, ShortProcessor cluster2) {
        int j;
        short[] pixels1 = (short[])cluster1.getPixels();
        short[] pixels2 = (short[])cluster2.getPixels();
        double n = pixels1.length;
        cluster1.resetMinAndMax();
        cluster2.resetMinAndMax();
        int nLabelsA = (int)cluster1.getMax();
        int nLabelsB = (int)cluster2.getMax();
        double[][] pij = new double[nLabelsA + 1][nLabelsB + 1];
        int i = 0;
        while ((double)i < n) {
            double[] dArray = pij[pixels1[i] & 0xFFFF];
            int n2 = pixels2[i] & 0xFFFF;
            dArray[n2] = dArray[n2] + 1.0;
            ++i;
        }
        for (i = 0; i < nLabelsA + 1; ++i) {
            int j2 = 0;
            while (j2 < nLabelsB + 1) {
                double[] dArray = pij[i];
                int n3 = j2++;
                dArray[n3] = dArray[n3] / n;
            }
        }
        double[] ai = new double[pij.length];
        for (int i2 = 0; i2 < pij.length; ++i2) {
            for (j = 0; j < pij[0].length; ++j) {
                int n4 = i2;
                ai[n4] = ai[n4] + pij[i2][j];
            }
        }
        double[] bj = new double[pij[0].length];
        for (j = 0; j < pij[0].length; ++j) {
            for (int i3 = 0; i3 < pij.length; ++i3) {
                int n5 = j;
                bj[n5] = bj[n5] + pij[i3][j];
            }
        }
        double sumA = 0.0;
        for (int i4 = 0; i4 < ai.length; ++i4) {
            if (ai[i4] == 0.0) continue;
            sumA += ai[i4] * Math.log(ai[i4]);
        }
        double sumB = 0.0;
        for (int j3 = 0; j3 < bj.length; ++j3) {
            if (bj[j3] == 0.0) continue;
            sumB += bj[j3] * Math.log(bj[j3]);
        }
        double sumAB = 0.0;
        for (int i5 = 1; i5 < pij.length; ++i5) {
            for (int j4 = 1; j4 < pij[0].length; ++j4) {
                if (pij[i5][j4] == 0.0) continue;
                sumAB += pij[i5][j4] * Math.log(pij[i5][j4]);
            }
        }
        double hab = sumB - sumAB;
        double hba = sumA - sumAB;
        double ha = -sumA;
        double hb = -sumB;
        double prec = (ha - hab) / ha;
        double rec = (hb - hba) / hb;
        if (ha == 0.0) {
            prec = 0.0;
            rec = 1.0;
        }
        if (hb == 0.0) {
            prec = 1.0;
            rec = 0.0;
        }
        return 2.0 * prec * rec / (prec + rec);
    }
}

