/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler;

import com.google.common.collect.Lists;
import java.util.List;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.renjin.compiler.ConstantGeneratingVisitor;
import org.renjin.compiler.SexpPool;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.SEXP;

public class FieldSexpPool
implements Opcodes,
SexpPool {
    protected String className;
    protected List<Entry> entries = Lists.newArrayList();

    public FieldSexpPool(String className) {
        this.className = className;
    }

    protected String add(SEXP sexp, String type) {
        Entry entry = new Entry(sexp, type, "sexp" + this.entries.size());
        this.entries.add(entry);
        return entry.getFieldName();
    }

    public List<Entry> entries() {
        return this.entries;
    }

    @Override
    public void writeFields(ClassVisitor cv) {
        for (Entry entry : this.entries()) {
            cv.visitField(2, entry.getFieldName(), entry.getType(), null, null);
        }
    }

    @Override
    public void writeConstructorBody(MethodVisitor mv) {
        ConstantGeneratingVisitor cgv = new ConstantGeneratingVisitor(mv);
        for (Entry entry : this.entries) {
            mv.visitVarInsn(25, 0);
            entry.getSexp().accept(cgv);
            mv.visitFieldInsn(181, this.className, entry.getFieldName(), entry.getType());
        }
    }

    @Override
    public void pushSexp(MethodVisitor mv, FunctionCall call2, String string) {
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.className, this.add(call2, "Lorg/renjin/sexp/FunctionCall;"), "Lorg/renjin/sexp/FunctionCall;");
    }

    @Override
    public void writeStaticInitializerBody(MethodVisitor mv) {
    }

    public static class Entry {
        private SEXP sexp;
        private String type;
        private String fieldName;

        public Entry(SEXP sexp, String className, String fieldName) {
            this.sexp = sexp;
            this.type = className;
            this.fieldName = fieldName;
        }

        public SEXP getSexp() {
            return this.sexp;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String getType() {
            return this.type;
        }
    }
}

