/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ui.swing.updater;

import java.awt.Frame;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import net.imagej.updater.util.UpdaterUserInterface;
import net.miginfocom.swing.MigLayout;
import org.scijava.app.StatusService;
import org.scijava.log.LogService;
import org.scijava.util.Prefs;

public class SwingUserInterface
extends UpdaterUserInterface {
    protected final LogService log;
    protected final StatusService statusService;

    public SwingUserInterface(LogService log, StatusService statusService) {
        this.log = log;
        this.statusService = statusService;
    }

    public void error(String message) {
        this.log.error((Object)message);
        JOptionPane.showMessageDialog(null, message, "ImageJ Updater", 0);
    }

    public void info(String message, String title) {
        this.log.info((Object)message);
        JOptionPane.showMessageDialog(null, message, "ImageJ Updater", 1);
    }

    public void log(String message) {
        this.log.info((Object)message);
    }

    public void debug(String message) {
        this.log.debug((Object)message);
    }

    public OutputStream getOutputStream() {
        return System.err;
    }

    public void showStatus(String message) {
        if (this.statusService != null) {
            this.statusService.showStatus(message);
        }
    }

    public void handleException(Throwable exception) {
        this.log.error(exception);
    }

    public boolean isBatchMode() {
        return false;
    }

    public int optionDialog(String message, String title, Object[] options, int def) {
        return JOptionPane.showOptionDialog(null, message, title, 1, 3, null, options, options[def]);
    }

    public String getPref(String key) {
        return Prefs.get(((Object)((Object)this)).getClass(), (String)key);
    }

    public void setPref(String key, String value) {
        Prefs.put(((Object)((Object)this)).getClass(), (String)key, (String)value);
    }

    public void savePreferences() {
    }

    public void openURL(String url) throws IOException {
    }

    public String getString(String title) {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout());
        panel.add(new JLabel("User"));
        JTextField user = new JTextField(){
            private static final long serialVersionUID = 1L;
            int counter = 5;

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                if (this.counter > 0) {
                    this.requestFocusInWindow();
                    --this.counter;
                }
            }
        };
        user.setColumns(20);
        panel.add(user);
        if (JOptionPane.showConfirmDialog(null, panel, title, 2) == 0) {
            return user.getText();
        }
        return null;
    }

    public String getPassword(String title) {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout());
        panel.add(new JLabel("Password:"));
        JPasswordField password = new JPasswordField(){
            private static final long serialVersionUID = 1L;
            int counter = 15;

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                if (this.counter > 0) {
                    this.requestFocusInWindow();
                    --this.counter;
                }
            }
        };
        password.setColumns(20);
        panel.add(password);
        int option = JOptionPane.showConfirmDialog(null, panel, title, 2);
        if (option == 2 || option < 0) {
            return null;
        }
        return new String(password.getPassword());
    }

    public void addWindow(Frame window) {
    }

    public void removeWindow(Frame window) {
    }

    public boolean promptYesNo(String message, String title) {
        return JOptionPane.showConfirmDialog(null, message, title, 0) == 0;
    }
}

