/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ui.swing.updater;

import java.awt.Window;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import net.imagej.ui.swing.updater.ImageJUpdater;
import net.imagej.ui.swing.updater.ProgressDialog;
import net.imagej.ui.swing.updater.PropsProbe;
import net.imagej.ui.swing.updater.ResolveDependencies;
import net.imagej.updater.Conflicts;
import net.imagej.updater.FileObject;
import net.imagej.updater.FilesCollection;
import net.imagej.updater.Installer;
import net.imagej.updater.UpdateSite;
import net.imagej.updater.util.Platforms;
import net.imagej.updater.util.Progress;
import org.scijava.Context;
import org.scijava.app.AppService;
import org.scijava.launcher.Java;
import org.scijava.launcher.Versions;
import org.scijava.log.LogService;
import org.scijava.log.Logger;
import org.scijava.ui.ApplicationFrame;
import org.scijava.ui.DialogPrompt;
import org.scijava.ui.UIService;
import org.scijava.ui.UserInterface;
import org.scijava.util.FileUtils;
import org.scijava.util.Types;
import org.scijava.widget.UIComponent;
import org.xml.sax.SAXException;

class LauncherMigrator {
    private static final List<String> ARM32 = Arrays.asList("aarch32", "arm32");
    private static final List<String> ARM64 = Arrays.asList("aarch64", "arm64");
    private static final List<String> X32 = Arrays.asList("i386", "i486", "i586", "i686", "x86-32", "x86_32", "x86");
    private static final List<String> X64 = Arrays.asList("amd64", "x86-64", "x86_64", "x64");
    private static final boolean OS_WIN;
    private static final boolean OS_MACOS;
    private static final boolean OS_LINUX;
    private static final String OS;
    private static final String ARCH;
    private static final String FIJI_LATEST_URL = "https://sites.imagej.net/Fiji/";
    private static final String FIJI_LATEST_EURO_URL = "https://downloads.micron.ox.ac.uk/fiji_update/mirrors/sites-fiji/";
    private AppService appService;
    private UIService uiService;
    private LogService log;

    LauncherMigrator(Context ctx) {
        if (ctx == null) {
            return;
        }
        this.appService = (AppService)ctx.getService(AppService.class);
        this.uiService = (UIService)ctx.getService(UIService.class);
        this.log = (LogService)ctx.getService(LogService.class);
    }

    void checkLaunchStatus() {
        boolean launcherUsed;
        if (ARCH.equals("x32") || ARCH.equals("arm32") || OS_WIN && ARCH.equals("arm64")) {
            return;
        }
        boolean bl = launcherUsed = System.getProperty("ij.executable") != null || System.getProperty("fiji.executable") != null;
        if (!launcherUsed) {
            return;
        }
        FilesCollection files = new FilesCollection(this.log, ImageJUpdater.getAppDirectory());
        try {
            files.tryLoadingCollection();
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
        boolean fijiSiteActive = false;
        for (UpdateSite site : files.getUpdateSites(false)) {
            if (!site.getURL().equals(FIJI_LATEST_URL) && !site.getURL().equals(FIJI_LATEST_EURO_URL)) continue;
            fijiSiteActive = true;
            break;
        }
        if (!fijiSiteActive && System.getenv("UPGRADE_IMAGEJ") != null) {
            this.switchToFijiLatest(files);
        }
    }

    private void warnAboutShortcuts(Path oldExePath, String newExePath) {
        this.uiService.showDialog("As part of this update, the Fiji launcher is being upgraded\nto a completely new version. Therefore any shortcuts referring\nto the old launcher will need to be updated.\n(e.g. start menu entries, taskbar pins, desktop shortcuts, etc...)\n\nOld launcher path:\n" + oldExePath + "\n\nNew launcher path:\n" + newExePath, "Reminder: update shortcuts!", DialogPrompt.MessageType.WARNING_MESSAGE);
    }

    private void warnAboutMacFolder() {
        this.uiService.showDialog("As part of this upgrade, the Fiji launcher is now signed for security.\nTo accomplish this, we must put the Fiji.app directory in its own dedicated subfolder.\nThis means your old .app folder will be automatically renamed to remove the \".app\".\nWe apologize for the inconvenience, but believe the improved security and user experience\nis a worthy trade-off.", "Notice: renamed application folder!", DialogPrompt.MessageType.WARNING_MESSAGE);
    }

    private void switchToFijiLatest(FilesCollection files) {
        List<String> lines;
        String nljv;
        File appDir;
        String prefKey = "skipFijiLatestUpgradePrompt";
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        boolean skipPrompt = prefs.getBoolean(prefKey, false);
        if (skipPrompt) {
            if (this.log != null) {
                this.log.debug((Object)"Skipping launcher upgrade due to user preference");
            }
            return;
        }
        String appTitle = "Fiji";
        File file = appDir = this.appService == null ? ImageJUpdater.getAppDirectory() : this.appService.getApp().getBaseDirectory();
        if (appDir == null) {
            if (this.log != null) {
                this.log.debug((Object)"Cannot glean base directory");
            }
            return;
        }
        appDir = appDir.getAbsoluteFile();
        String appSlug = appTitle.toLowerCase();
        File configDir = appDir.toPath().resolve("config").resolve("jaunch").toFile();
        String platform = Platforms.current();
        File exeFile = LauncherMigrator.exeFile(appSlug, appDir);
        if (OS_MACOS) {
            if (LauncherMigrator.isMacArm64()) {
                platform = "macos-arm64";
                exeFile = LauncherMigrator.exeFile(appSlug, appDir, "arm64");
            } else {
                platform = "macos64";
                exeFile = LauncherMigrator.exeFile(appSlug, appDir, "x64");
            }
            files.setActivePlatforms(new String[]{platform});
        }
        try {
            nljv = this.probeJavaVersion(exeFile);
            if (this.log != null) {
                this.log.debug((Object)("Java from new launcher BEFORE: " + nljv));
            }
        }
        catch (IOException exc) {
            this.askForBugReport((Logger)this.log, appTitle, appSlug, exc);
            return;
        }
        catch (UnsupportedOperationException exc) {
            if (this.log != null) {
                this.log.debug((Throwable)exc);
            }
            return;
        }
        String message = "<html><style>table {border-top: 1px solid gray;border-bottom: 1px solid gray;}tr th { font-size: large }tr td { background-color: #eeeeee }tr.odd td { background-color: #dddddd }.shiny { color: #5599aa; font-weight: bold }</style><center><span class=\"shiny\">&#x2728;</span> Heads up: " + appTitle + " is receiving some major updates under the hood! <span class=\"shiny\">&#x2728;</span></center><br><p>You are currently running the <b>stable</b> version of " + appTitle + ", but you now have the option to switch<br>to the <b>latest</b> version. To help you decide, here is a table summarizing the differences:</p><br><center><table><tr><th>Feature</th>                           <th>" + appTitle + " Stable</th>         <th>" + appTitle + " Latest</th></tr><tr class=\"odd\"><td>Stability</td>           <td>More</td>                            <td>Less</td></tr><tr              ><td>Java version</td>        <td>OpenJDK 8</td>                       <td>OpenJDK 21</td></tr><tr class=\"odd\"><td>Launcher</td>            <td>ImageJ Launcher (deprecated)</td>    <td>Jaunch</td></tr><tr              ><td>Executable</td>          <td>ImageJ-*(.exe)</td>                  <td>fiji-*-*(.exe)</td></tr><tr class=\"odd\"><td>Core update site(s)</td> <td>ImageJ+Fiji+Java-8</td>              <td>sites.imagej.net/Fiji</td></tr><tr              ><td>Apple silicon?</td>      <td>Emulated/x86 mode</td>               <td>Native!</td></tr><tr class=\"odd\"><td>Receives updates?</td>   <td>Security only</td>                   <td>Latest features</td></tr><tr              ><td>Minimum Windows</td>     <td>Windows XP</td>                      <td>Windows 10</td></tr><tr class=\"odd\"><td>Minimum macOS</td>       <td>Mac OS X 10.8 'Mountain Lion'</td>   <td>macOS 11 'Big Sur'</td></tr><tr              ><td>Minimum Ubuntu</td>      <td>Ubuntu 12.04 'Precise Pangolin'</td> <td>Ubuntu 22.04 'Jammy Jellyfish'</td></tr></table></center><br>In short: updating to Latest will let you <i>continue receiving updates</i>, but because it is still<br>new and less well tested, it also <b><i>might break your " + appTitle + " installation or favorite plugins</i></b>.<br><br>How would you like to proceed?";
        int optionType = -1;
        int messageType = 3;
        ImageIcon icon = new ImageIcon(appDir.toPath().resolve("images").resolve("icon.png").toString());
        int w = icon.getIconWidth();
        int maxWidth = 120;
        if (w > maxWidth) {
            icon = new ImageIcon(icon.getImage().getScaledInstance(maxWidth, icon.getIconHeight() * maxWidth / w, 4));
        }
        String yes = "<html><center>Update to Latest!<br>\u203b\\(^o^)/\u203b</center>";
        String no = "<html><center>Keep stable for now<br>\u22b9\u2570(~\u029f~)\u256f\u22b9</center>";
        String never = "<html><center>Stable, and never ask again<br>\u0b67/0\u76ca0\\\u0b68</center>";
        Object[] options = new Object[]{yes, no, never};
        Window parent = this.getApplicationWindow();
        int rval = JOptionPane.showOptionDialog(parent, message, appTitle, optionType, messageType, icon, options, no);
        if (rval != 0) {
            if (rval == 2) {
                prefs.putBoolean(prefKey, true);
            }
            return;
        }
        File appConfigFile = new File(configDir, appSlug + ".toml");
        try {
            lines = Files.readAllLines(appConfigFile.toPath());
        }
        catch (IOException exc) {
            this.log.debug((Throwable)exc);
            lines = new ArrayList<String>();
        }
        boolean oldLauncherUsed = System.getProperty("scijava.app.name") == null;
        LauncherMigrator.setPropertyIfNull("scijava.app.name", appTitle);
        LauncherMigrator.setPropertyIfNull("scijava.app.directory", appDir.getPath());
        Path splashImage = appDir.toPath().resolve("images").resolve("icon.png");
        LauncherMigrator.setPropertyIfNull("scijava.app.splash-image", splashImage.toString());
        LauncherMigrator.extractAndSetProperty("scijava.app.java-links", lines, "https://downloads.imagej.net/java/jdk-urls.txt");
        LauncherMigrator.extractAndSetProperty("scijava.app.java-version-minimum", lines, "8");
        LauncherMigrator.extractAndSetProperty("scijava.app.config-file", lines, new File(configDir, appSlug + ".cfg").getPath());
        System.setProperty("scijava.app.java-platform", platform);
        System.setProperty("scijava.app.java-root", appDir.toPath().resolve("java").resolve(platform).toString());
        System.setProperty("scijava.app.java-version-recommended", "21");
        if (nljv == null || Versions.compare((String)nljv, (String)Java.recommendedVersion()) < 0) {
            Java.upgrade((boolean)Java.isHeadless(), (boolean)false);
            try {
                nljv = this.probeJavaVersion(exeFile);
                if (this.log != null) {
                    this.log.debug((Object)("Java from new launcher AFTER: " + nljv));
                }
            }
            catch (IOException | UnsupportedOperationException exc) {
                this.askForBugReport((Logger)this.log, appTitle, appSlug, exc);
                return;
            }
            if (nljv == null || Versions.compare((String)nljv, (String)Java.recommendedVersion()) < 0) {
                if (this.log != null) {
                    Path cfgPath = appDir.toPath().resolve(Paths.get("config", "jaunch", appSlug + ".cfg"));
                    this.log.warn((Object)("Congratulations on upgrading Java.\n\tUnfortunately, the Java version chosen by the new launcher after the upgrade is " + nljv + ", which is still less than the recommended Java version of " + Java.recommendedVersion() + ".\n\tThis should not be the case of course; it seems to be a bug.\n\tWould you please visit https://forum.image.sc/ and report this problem?\n\tClick 'New Topic', choose 'Usage & Issues' category, and use tag '" + appSlug + "'.\n\tTo fix it locally for now, you can try editing the " + cfgPath + " file by hand to point to a newer Java installation."));
                }
                return;
            }
        }
        this.migrateUpdateSites(files);
        Path appPath = appDir.toPath();
        try {
            Path checkExe;
            Path backupExe;
            Path oldExe;
            Path originalExe;
            String exePath = exeFile.getCanonicalPath();
            if (OS_WIN) {
                String arch = "win64";
                if (ARCH.equals("x32")) {
                    arch = "win32";
                }
                originalExe = appPath.resolve("ImageJ-" + arch + ".exe");
                oldExe = appPath.resolve("ImageJ-" + arch + ".old.exe");
                backupExe = appPath.resolve("ImageJ-" + arch + ".backup.exe");
            } else if (OS_LINUX) {
                originalExe = appPath.resolve("ImageJ-linux64");
                oldExe = appPath.resolve("ImageJ-linux64.old");
                backupExe = appPath.resolve("ImageJ-linux64.backup");
            } else if (OS_MACOS) {
                originalExe = appPath.resolve("Contents").resolve("MacOS").resolve("ImageJ-macosx");
                oldExe = appPath.resolve("Contents").resolve("MacOS").resolve("ImageJ-macosx.old");
                backupExe = appPath.resolve("Contents").resolve("MacOS").resolve("ImageJ-macosx.backup");
            } else {
                throw new RuntimeException("Unknown operating system");
            }
            Files.copy(oldExe, backupExe, new CopyOption[0]);
            if (oldLauncherUsed) {
                this.warnAboutShortcuts(originalExe, exePath);
                checkExe = oldExe;
            } else {
                checkExe = LauncherMigrator.exeFile(appSlug, appDir).toPath();
            }
            if (OS_MACOS) {
                this.warnAboutMacFolder();
            }
            this.uiService.showDialog("Upgrade to Fiji-Latest complete!\nAfter closing this message, Fiji will automatically restart\nwith the appropriate launcher.\nPlease allow a few moments for the restart to complete.\n\nIf the restart fails, please check the logs directory for details." + (oldLauncherUsed ? "\nYou can also try the backup launcher:" + backupExe.toFile().getName() : ""), "Upgrade complete!", DialogPrompt.MessageType.INFORMATION_MESSAGE);
            LauncherMigrator.queueRestart(appPath, exePath, checkExe);
            this.appService.getContext().dispose();
            System.exit(0);
        }
        catch (IOException exc) {
            this.askForBugReport((Logger)this.log, appTitle, appSlug, exc);
        }
    }

    private void migrateUpdateSites(FilesCollection files) {
        String fijiSiteUrl;
        String fijiSiteName;
        if (files.getUpdateSite("Java-8 (Europe mirror)", false) != null) {
            fijiSiteName = "Fiji-Latest (Europe mirror)";
            fijiSiteUrl = FIJI_LATEST_EURO_URL;
        } else {
            fijiSiteName = "Fiji-Latest";
            fijiSiteUrl = FIJI_LATEST_URL;
        }
        ArrayList<String> siteList = new ArrayList<String>();
        for (String site : new String[]{"Java-8", "ImageJ", "Fiji"}) {
            for (String suffix : new String[]{"", " (Europe mirror)"}) {
                siteList.add(site + suffix);
            }
        }
        HashSet<String> legacyFiles = new HashSet<String>();
        File ijDir = ImageJUpdater.getAppDirectory();
        try {
            files.addUpdateSite(fijiSiteName, fijiSiteUrl, null, null, 0L);
            for (String siteName : siteList) {
                UpdateSite site = files.getUpdateSite(siteName, false);
                if (site == null) continue;
                for (FileObject file : files.forUpdateSite(siteName, true)) {
                    legacyFiles.add(file.getFilename());
                }
                files.deactivateUpdateSite(site);
            }
            files.write();
            files.reloadCollectionAndChecksum((Progress)new ProgressDialog(null, "Updating..."));
            for (Object file : files.values()) {
                if (!legacyFiles.contains(file.getFilename())) continue;
                switch (file.getStatus()) {
                    case LOCAL_ONLY: 
                    case OBSOLETE: 
                    case OBSOLETE_MODIFIED: {
                        file.stageForUninstall(files);
                    }
                }
            }
            block14: for (Object file : files.forUpdateSite(fijiSiteName)) {
                FileObject.Status status = file.getStatus();
                switch (status) {
                    case LOCAL_ONLY: 
                    case OBSOLETE: 
                    case OBSOLETE_MODIFIED: {
                        file.stageForUninstall(files);
                        continue block14;
                    }
                    case INSTALLED: {
                        continue block14;
                    }
                }
                if (file.stageForUpdate(files, true)) continue;
                this.log.warn((Object)("Skipping " + ((FileObject)file).filename + " with status " + file.getStatus()));
            }
            Conflicts conflicts = new Conflicts(files);
            block15: for (Conflicts.Conflict c : conflicts.getConflicts(false)) {
                for (Conflicts.Resolution r : c.getResolutions()) {
                    if (!r.getDescription().startsWith("Update")) continue;
                    r.resolve();
                    continue block15;
                }
            }
            ResolveDependencies resolver = new ResolveDependencies(null, files);
            if (!resolver.resolve()) {
                // empty if block
            }
            Installer i = new Installer(files, (Progress)new ProgressDialog(null, "Downloading updates..."));
            i.start();
        }
        catch (IOException | TransformerConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
    }

    private static void queueRestart(Path appDir, String launchExe, Path checkExe) throws IOException {
        ProcessBuilder pb;
        Path tempScript;
        String scriptContent;
        int checkIntervalMs = 500;
        int numTries = 30;
        String pathToCheck = checkExe.toFile().getAbsolutePath();
        if (OS_WIN) {
            String processToCheck = checkExe.toFile().getName();
            processToCheck = processToCheck.substring(0, processToCheck.lastIndexOf(45));
            scriptContent = String.join((CharSequence)"\n", "$tries = 0; ", "while ((Test-Path '" + pathToCheck + "') -and ($tries -lt " + 30 + ")) { ", "   if (Get-Process -Name \"" + processToCheck + "*\" -ErrorAction SilentlyContinue) { ", "       Write-Host \"Attempt $tries of 30 - File is locked.\"; ", "   } else { ", "       break; ", "   }", "   $tries++;", "   if ($tries -eq 30) { Write-Host 'Max attempts reached. Exiting.'; break; }", "   Start-Sleep -Milliseconds 500", "}", "Start-Process -FilePath " + launchExe, "Start-Sleep -Seconds 5");
            tempScript = Files.createTempFile("check_lock_", ".ps1", new FileAttribute[0]);
            Files.write(tempScript, scriptContent.getBytes(), new OpenOption[0]);
            tempScript = tempScript.toAbsolutePath();
            pb = new ProcessBuilder("powershell.exe", "-Command", "& '" + tempScript + "'; Remove-Item -Path '" + tempScript + "' -Force");
            pb.redirectOutput(new File("NUL"));
        } else {
            String renameMacFolder = "";
            if (OS_MACOS && appDir.toString().endsWith(".app")) {
                String appDirString = appDir.toString();
                String nonAppString = appDirString.substring(0, appDirString.length() - 4);
                launchExe = launchExe.substring(appDirString.length());
                launchExe = nonAppString + File.separator + launchExe;
                renameMacFolder = "mv \"" + appDirString + "\" \"" + nonAppString + "\"\n";
            }
            scriptContent = String.join((CharSequence)"\n", "#!/bin/bash", "tries=0", "while [ -f \"" + pathToCheck + "\" ] && [ $tries -lt " + 30 + " ]; do", "   if ! lsof " + pathToCheck + " >/dev/null; then", "      echo \"File is not locked.\"", "      break", "   else       tries=$((tries+1))", "      echo \"Attempt $tries of 30 - File is locked\"", "      if [ $tries -eq 30 ]; then", "         echo \"Max attempts reached. Exiting.\"", "         break", "      fi", "   fi", "   sleep 0.5", "done", renameMacFolder + launchExe + " &");
            tempScript = Files.createTempFile("check_lock_", ".sh", new FileAttribute[0]);
            Files.write(tempScript, scriptContent.getBytes(), new OpenOption[0]);
            tempScript.toFile().setExecutable(true);
            tempScript = tempScript.toAbsolutePath();
            pb = new ProcessBuilder("bash", "-c", tempScript + " ; rm -f " + tempScript);
            pb.redirectOutput(new File("/dev/null"));
        }
        File logsDir = appDir.resolve("logs").toFile();
        if (!logsDir.exists()) {
            logsDir.mkdir();
        }
        String timestamp = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date());
        File errFile = new File(logsDir, "restart-err-" + timestamp + ".log");
        pb.redirectError(errFile);
        Process process = pb.start();
    }

    private void askForBugReport(Logger log, String appTitle, String appSlug, Exception exc) {
        if (log == null) {
            return;
        }
        log.error((Object)("Argh! " + appTitle + "'s fancy new launcher is not working on your system!\nIt might be a bug in the new launcher, or your operating system may be too old to support it.\n" + (OS_LINUX ? "On Linux you may also need to upgrade your glibc version.\n" : "") + "Would you please visit https://forum.image.sc/ and report this problem?\nClick 'New Topic', choose 'Usage & Issues' category, and use tag '" + appSlug + "'.\n Please copy+paste the technical information below into your report. Thank you!\n\n* os.name=" + System.getProperty("os.name") + "\n* os.arch=" + System.getProperty("os.arch") + "\n* os.version=" + System.getProperty("os.version") + "\n"), (Throwable)exc);
    }

    private String probeJavaVersion(File exeFile) throws IOException {
        int exitCode;
        List<String> output;
        try {
            File propsJar = FileUtils.urlToFile((URL)Types.location(PropsProbe.class));
            File propsOut = File.createTempFile("props", ".txt");
            File propsErr = File.createTempFile("props", ".err");
            propsOut.deleteOnExit();
            propsErr.deleteOnExit();
            Object[] args = new String[]{exeFile.getPath(), "--headless", "-Djava.class.path=" + propsJar.getPath(), "--main-class", "net.imagej.ui.swing.updater.PropsProbe", propsOut.getAbsolutePath()};
            this.log.debug((Object)Arrays.toString(args));
            Process p = new ProcessBuilder((String[])args).redirectError(propsErr).start();
            output = LauncherMigrator.collectProcessOutput(p, propsOut, propsErr);
            exitCode = p.exitValue();
        }
        catch (InterruptedException exc) {
            throw new IOException(exc);
        }
        String noJavas = "No matching Java installations found.";
        if (!output.isEmpty() && output.get(0).startsWith(noJavas)) {
            return null;
        }
        if (exitCode != 0) {
            throw new IOException("Launcher exited with non-zero value: " + exitCode);
        }
        String propKey = "java.version=";
        return output.stream().filter(line -> line.startsWith(propKey)).map(line -> line.substring(propKey.length())).findFirst().orElse(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isMacArm64() {
        try {
            ProcessBuilder pb = new ProcessBuilder("sysctl", "-n", "hw.optional.arm64");
            Process p = pb.start();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));){
                String line = reader.readLine();
                if (line == null) return false;
                boolean bl = line.trim().equals("1");
                return bl;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static File exeFile(String appPrefix, File appDir) {
        return LauncherMigrator.exeFile(appPrefix, appDir, null);
    }

    private static File exeFile(String appPrefix, File appDir, String archOverride) {
        String exe;
        String effectiveArch;
        String string = effectiveArch = archOverride == null || archOverride.isEmpty() ? ARCH : archOverride;
        if (OS_WIN) {
            exe = appPrefix + "-windows-" + effectiveArch + ".exe";
        } else if (OS_MACOS) {
            exe = "Fiji.app/Contents/MacOS/" + appPrefix + "-macos-" + effectiveArch;
        } else if (OS_LINUX) {
            exe = appPrefix + "-linux-" + effectiveArch;
        } else {
            throw new UnsupportedOperationException("Unsupported OS: " + OS);
        }
        File exeFile = new File(appDir, exe);
        if (!exeFile.isFile()) {
            throw new UnsupportedOperationException("Launcher is missing: " + exe);
        }
        if (!exeFile.canExecute()) {
            exeFile.setExecutable(true);
        }
        if (!exeFile.canExecute()) {
            throw new UnsupportedOperationException("Launcher is not executable: " + exeFile);
        }
        return exeFile;
    }

    private static void setPropertyIfNull(String name, String value) {
        if (System.getProperty(name) == null) {
            System.setProperty(name, value);
        }
    }

    private static void extractAndSetProperty(String name, List<String> lines, String fallbackValue) {
        String escaped = name.replaceAll("\\.", "\\\\.");
        Pattern p = Pattern.compile(".*'-D" + escaped + "=['\"]?(.*?)['\"]?,$");
        String value = fallbackValue;
        for (String line : lines) {
            Matcher m = p.matcher(line);
            if (!m.matches()) continue;
            value = m.group(1);
            break;
        }
        if (value != null) {
            LauncherMigrator.setPropertyIfNull(name, value);
        }
    }

    private static List<String> collectProcessOutput(Process p, File outFile, File errFile) throws IOException, InterruptedException {
        boolean completed = p.waitFor(15L, TimeUnit.SECONDS);
        if (!completed) {
            p.destroyForcibly();
            throw new IOException("Process took too long to complete.");
        }
        List<String> lines = Files.readAllLines(outFile.toPath());
        if (lines.isEmpty()) {
            lines = Files.readAllLines(errFile.toPath());
        }
        return lines;
    }

    private Window getApplicationWindow() {
        if (this.uiService == null) {
            return null;
        }
        return this.uiService.getVisibleUIs().stream().map(this::getApplicationWindow).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private Window getApplicationWindow(UserInterface ui) {
        Object component;
        ApplicationFrame appFrame = ui.getApplicationFrame();
        if (appFrame instanceof Window) {
            return (Window)appFrame;
        }
        if (appFrame instanceof UIComponent && (component = ((UIComponent)appFrame).getComponent()) instanceof Window) {
            return (Window)component;
        }
        return null;
    }

    static {
        OS = System.getProperty("os.name");
        OS_WIN = OS.toLowerCase().contains("windows");
        OS_MACOS = OS.toLowerCase().contains("mac");
        OS_LINUX = OS.toLowerCase().contains("linux");
        String osArch = System.getProperty("os.arch").toLowerCase();
        ARCH = ARM32.contains(osArch) ? "arm32" : (ARM64.contains(osArch) ? "arm64" : (X32.contains(osArch) ? "x32" : (X64.contains(osArch) ? "x64" : osArch)));
    }
}

