/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ui.swing.updater;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import net.imagej.ui.swing.updater.SwingTools;
import org.scijava.util.LineOutputStream;
import org.scijava.util.ProcessUtils;

public class DiffView
extends JScrollPane {
    private static final long serialVersionUID = 1L;
    protected static final String ACTION_ATTRIBUTE = "ACTION";
    protected static final String FONT = "Monospaced";
    protected static final int FONT_SIZE = SwingTools.defaultFontSize();
    protected static final int BIG_FONT_SIZE = 1 * FONT_SIZE;
    protected JPanel panel;
    protected JTextPane textPane;
    protected Cursor normalCursor;
    protected Cursor handCursor;
    protected SimpleAttributeSet normal;
    protected SimpleAttributeSet bigBold;
    protected SimpleAttributeSet bold;
    protected SimpleAttributeSet italic;
    protected SimpleAttributeSet red;
    protected SimpleAttributeSet green;
    protected StyledDocument document;
    protected int adds;
    protected int removes;
    protected boolean inHeader = true;

    public DiffView() {
        super(20, 30);
        this.setPreferredSize(new Dimension(800, 600));
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.getViewport().setView(this.panel);
        this.normal = DiffView.getStyle(null, false, false, FONT, FONT_SIZE);
        this.bigBold = DiffView.getStyle(Color.blue, false, true, FONT, BIG_FONT_SIZE);
        this.bold = DiffView.getStyle(null, false, true, FONT, FONT_SIZE);
        this.italic = DiffView.getStyle(null, true, false, FONT, FONT_SIZE);
        this.red = DiffView.getStyle(Color.red, false, false, FONT, FONT_SIZE);
        this.green = DiffView.getStyle(new Color(0, 128, 32), false, false, FONT, FONT_SIZE);
        this.textPane = new JTextPane();
        this.normalCursor = this.textPane.getCursor();
        this.handCursor = new Cursor(12);
        this.textPane.setEditable(false);
        this.document = this.textPane.getStyledDocument();
        this.panel.add(this.textPane);
        this.getVerticalScrollBar().setUnitIncrement(10);
        this.textPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                ActionListener action = DiffView.this.getAction(event);
                if (action != null) {
                    action.actionPerformed(new ActionEvent(DiffView.this, 0, "action"));
                }
            }
        });
    }

    private ActionListener getAction(MouseEvent event) {
        Element e = this.document.getCharacterElement(this.textPane.viewToModel(event.getPoint()));
        ActionListener action = (ActionListener)e.getAttributes().getAttribute(ACTION_ATTRIBUTE);
        return action;
    }

    public static SimpleAttributeSet getStyle(Color color, boolean italic, boolean bold, String fontName, int fontSize) {
        SimpleAttributeSet style = new SimpleAttributeSet();
        if (color != null) {
            StyleConstants.setForeground(style, color);
        }
        StyleConstants.setItalic(style, italic);
        StyleConstants.setBold(style, bold);
        StyleConstants.setFontFamily(style, fontName);
        StyleConstants.setFontSize(style, fontSize);
        return style;
    }

    public void styled(String text, AttributeSet set) {
        this.styled(this.document.getLength(), text, set);
    }

    public void styled(int position, String text, AttributeSet set) {
        try {
            this.document.insertString(position, text, set);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void normal(String text) {
        this.styled(text, this.normal);
    }

    public void warn(String warning) {
        this.red("Warning: ");
        this.styled(warning, this.italic);
    }

    public void red(String text) {
        this.styled(text, this.red);
    }

    public void green(String text) {
        this.styled(text, this.green);
    }

    public void red(int position, String text) {
        this.styled(position, text, this.red);
    }

    public void green(int position, String text) {
        this.styled(position, text, this.green);
    }

    public static SimpleAttributeSet getActionStyle(ActionListener action) {
        SimpleAttributeSet style = new SimpleAttributeSet();
        StyleConstants.setForeground(style, Color.blue);
        StyleConstants.setUnderline(style, true);
        StyleConstants.setFontFamily(style, FONT);
        StyleConstants.setFontSize(style, FONT_SIZE);
        style.addAttribute(ACTION_ATTRIBUTE, action);
        return style;
    }

    public void link(String text, ActionListener action) {
        JButton button = new JButton(text);
        button.addActionListener(action);
        this.textPane.insertComponent(button);
        button.setCursor(this.handCursor);
    }

    public int getAdds() {
        return this.adds;
    }

    public int getRemoves() {
        return this.removes;
    }

    public int getChanges() {
        return this.adds + this.removes;
    }

    public void println(String line) {
        if (line.startsWith("diff")) {
            this.styled(line, this.bold);
            this.inHeader = false;
        } else if (line.startsWith(" ")) {
            this.styled(line, this.inHeader && line.startsWith("    ") ? this.bigBold : this.normal);
        } else if (line.startsWith("+")) {
            ++this.adds;
            this.styled(line, this.green);
        } else if (line.startsWith("-")) {
            ++this.removes;
            this.styled(line, this.red);
        } else {
            if (line.startsWith("commit")) {
                this.inHeader = true;
            }
            this.styled(line, this.italic);
        }
        this.styled("\n", this.normal);
    }

    public PrintStream getPrintStream() {
        LineOutputStream out = new LineOutputStream(){

            public void println(String line) {
                DiffView.this.println(line);
            }
        };
        return new PrintStream((OutputStream)out){

            @Override
            public void println(String line) {
                DiffView.this.println(line);
            }
        };
    }

    protected Document getDocument() {
        return this.document;
    }

    public static void main(String[] args) {
        final DiffView diff = new DiffView();
        final Thread thread = new Thread(){

            @Override
            public void run() {
                block2: {
                    try {
                        String git = System.getProperty("imagej.updater.git.command", "git");
                        ProcessUtils.exec(null, (PrintStream)diff.getPrintStream(), (PrintStream)diff.getPrintStream(), (String[])new String[]{git, "show"});
                    }
                    catch (RuntimeException e) {
                        if (e.getCause() instanceof InterruptedException) break block2;
                        e.printStackTrace();
                    }
                }
            }
        };
        JFrame frame = new JFrame("git show");
        frame.setDefaultCloseOperation(2);
        frame.setSize(640, 480);
        frame.getContentPane().add(diff);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                thread.interrupt();
            }
        });
        frame.pack();
        frame.setVisible(true);
        thread.start();
    }
}

