/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.log;

public final class LogLevel {
    public static final int NONE = 0;
    public static final int ERROR = 1;
    public static final int WARN = 2;
    public static final int INFO = 3;
    public static final int DEBUG = 4;
    public static final int TRACE = 5;

    private LogLevel() {
    }

    public static String prefix(int level) {
        switch (level) {
            case 1: {
                return "ERROR";
            }
            case 2: {
                return "WARNING";
            }
            case 3: {
                return "INFO";
            }
            case 4: {
                return "DEBUG";
            }
            case 5: {
                return "TRACE";
            }
        }
        return "LEVEL" + level;
    }

    public static int value(String s) {
        if (s == null) {
            return -1;
        }
        String log = s.trim().toLowerCase();
        if (log.startsWith("n")) {
            return 0;
        }
        if (log.startsWith("e")) {
            return 1;
        }
        if (log.startsWith("w")) {
            return 2;
        }
        if (log.startsWith("i")) {
            return 3;
        }
        if (log.startsWith("d")) {
            return 4;
        }
        if (log.startsWith("t")) {
            return 5;
        }
        try {
            return Integer.parseInt(log);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }
}

