/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.io.handle;

import java.io.IOException;
import java.io.InputStream;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.location.Location;

public class DataHandleInputStream<L extends Location>
extends InputStream {
    private final DataHandle<L> handle;
    private long mark = -1L;

    public DataHandleInputStream(DataHandle<L> handle) {
        this.handle = handle;
    }

    public DataHandle<L> getDataHandle() {
        return this.handle;
    }

    @Override
    public int read() throws IOException {
        return this.handle.read();
    }

    @Override
    public int read(byte[] array, int offset, int n) throws IOException {
        return this.handle.read(array, offset, n);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.handle.skip(n);
    }

    @Override
    public int available() throws IOException {
        long remain = this.handle.length() - this.handle.offset();
        if (remain > Integer.MAX_VALUE) {
            remain = Integer.MAX_VALUE;
        }
        return (int)remain;
    }

    @Override
    public synchronized void mark(int readLimit) {
        try {
            this.mark = this.handle.offset();
        }
        catch (IOException exc) {
            throw new IllegalStateException(exc);
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.mark < 0L) {
            throw new IOException("No mark set");
        }
        this.handle.seek(this.mark);
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void close() throws IOException {
        this.handle.close();
        this.mark = -1L;
    }
}

