/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.event.bushe;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

class Logger {
    private java.util.logging.Logger utilLogger;
    private Object commonsLogger;
    private Map<String, Method> METHOD_CACHE_NO_PARAMS;
    private Map<String, Method> METHOD_CACHE_ONE_PARAM;
    private Map<String, Method> METHOD_CACHE_TWO_PARAMS;
    private static Class<?> logFactoryClass;
    private static Class<?> logClass;
    private static Method getLogMethod;
    private static final Object[] EMPTY_ARGS;
    private static final Class[] CLASS_ARGS_EMPTY;
    private static final Class[] CLASS_ARGS_ONE;
    private static final Class[] CLASS_ARGS_TWO;
    public static LoggerType LOGGER_TYPE;

    public static Logger getLogger(String name) {
        if (LOGGER_TYPE == null) {
            LOGGER_TYPE = Logger.getLoggerType();
        }
        if (LOGGER_TYPE == LoggerType.COMMONS) {
            try {
                Object logger = getLogMethod.invoke(null, name);
                return new Logger(logger);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return new Logger(java.util.logging.Logger.getLogger(name));
    }

    private static LoggerType getLoggerType() {
        Object result = null;
        try {
            logFactoryClass = Class.forName("org.apache.commons.logging.LogFactory");
            getLogMethod = logFactoryClass.getMethod("getLog", String.class);
            logClass = Class.forName("org.apache.commons.logging.Log");
            return LoggerType.COMMONS;
        }
        catch (Throwable throwable) {
            return LoggerType.JAVA;
        }
    }

    public Logger(java.util.logging.Logger utilLogger) {
        this.utilLogger = utilLogger;
    }

    public Logger(Object commonsLogger) {
        this.commonsLogger = commonsLogger;
    }

    public boolean isLoggable(Level level) {
        if (this.utilLogger != null) {
            java.util.logging.Level javaLevel = this.getJavaLevelFor(level);
            return javaLevel != null && this.utilLogger.isLoggable(javaLevel);
        }
        if (this.commonsLogger != null) {
            switch (level) {
                case ERROR: {
                    return (Boolean)this.callCommonsLogger("isErrorEnabled");
                }
                case FATAL: {
                    return (Boolean)this.callCommonsLogger("isFatalEnabled");
                }
                case WARN: {
                    return (Boolean)this.callCommonsLogger("isWarnEnabled");
                }
                case INFO: {
                    return (Boolean)this.callCommonsLogger("isInfoEnabled");
                }
                case DEBUG: {
                    return (Boolean)this.callCommonsLogger("isDebugEnabled");
                }
                case TRACE: {
                    return (Boolean)this.callCommonsLogger("isTraceEnabled");
                }
            }
        }
        return false;
    }

    private java.util.logging.Level getJavaLevelFor(Level level) {
        switch (level) {
            case FATAL: {
                return java.util.logging.Level.SEVERE;
            }
            case ERROR: {
                return java.util.logging.Level.SEVERE;
            }
            case WARN: {
                return java.util.logging.Level.WARNING;
            }
            case INFO: {
                return java.util.logging.Level.INFO;
            }
            case DEBUG: {
                return java.util.logging.Level.FINE;
            }
            case TRACE: {
                return java.util.logging.Level.FINEST;
            }
        }
        return null;
    }

    public void debug(String message) {
        this.log(Level.DEBUG, message);
    }

    public void log(Level level, String message) {
        this.log(level, message, null);
    }

    public void log(Level level, String message, Throwable throwable) {
        if (!this.isLoggable(level)) {
            return;
        }
        if (this.utilLogger != null) {
            java.util.logging.Level javaLevel = this.getJavaLevelFor(level);
            if (throwable == null) {
                this.utilLogger.log(javaLevel, message);
            } else {
                this.utilLogger.log(javaLevel, message, throwable);
            }
        } else if (this.commonsLogger != null) {
            if (throwable == null) {
                switch (level) {
                    case ERROR: {
                        this.callCommonsLogger("error", message);
                        break;
                    }
                    case FATAL: {
                        this.callCommonsLogger("fatal", message);
                        break;
                    }
                    case WARN: {
                        this.callCommonsLogger("warn", message);
                        break;
                    }
                    case INFO: {
                        this.callCommonsLogger("info", message);
                        break;
                    }
                    case DEBUG: {
                        this.callCommonsLogger("debug", message);
                        break;
                    }
                    case TRACE: {
                        this.callCommonsLogger("trace", message);
                    }
                }
            } else {
                switch (level) {
                    case ERROR: {
                        this.callCommonsLogger("error", message, throwable);
                        break;
                    }
                    case FATAL: {
                        this.callCommonsLogger("fatal", message, throwable);
                        break;
                    }
                    case WARN: {
                        this.callCommonsLogger("warn", message, throwable);
                        break;
                    }
                    case INFO: {
                        this.callCommonsLogger("info", message, throwable);
                        break;
                    }
                    case DEBUG: {
                        this.callCommonsLogger("debug", message, throwable);
                        break;
                    }
                    case TRACE: {
                        this.callCommonsLogger("trace", message, throwable);
                    }
                }
            }
        }
    }

    private Object callCommonsLogger(String methodName) {
        if (this.METHOD_CACHE_NO_PARAMS == null) {
            this.METHOD_CACHE_NO_PARAMS = new HashMap<String, Method>();
        }
        return this.callCommonsLogger(this.METHOD_CACHE_NO_PARAMS, methodName, CLASS_ARGS_EMPTY, EMPTY_ARGS);
    }

    private Object callCommonsLogger(String methodName, String message) {
        if (this.METHOD_CACHE_ONE_PARAM == null) {
            this.METHOD_CACHE_ONE_PARAM = new HashMap<String, Method>();
        }
        return this.callCommonsLogger(this.METHOD_CACHE_ONE_PARAM, methodName, CLASS_ARGS_ONE, new Object[]{message});
    }

    private Object callCommonsLogger(String methodName, String message, Throwable throwable) {
        if (this.METHOD_CACHE_TWO_PARAMS == null) {
            this.METHOD_CACHE_TWO_PARAMS = new HashMap<String, Method>();
        }
        return this.callCommonsLogger(this.METHOD_CACHE_TWO_PARAMS, methodName, CLASS_ARGS_TWO, new Object[]{message, throwable});
    }

    private Object callCommonsLogger(Map<String, Method> cache, String methodName, Class[] classOfArgs, Object[] args) {
        Method method = cache.get(methodName);
        if (method == null) {
            try {
                method = logClass.getMethod(methodName, classOfArgs);
                cache.put(methodName, method);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        if (method == null) {
            return null;
        }
        try {
            return method.invoke(this.commonsLogger, args);
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
    }

    static {
        EMPTY_ARGS = new Object[0];
        CLASS_ARGS_EMPTY = new Class[0];
        CLASS_ARGS_ONE = new Class[]{Object.class};
        CLASS_ARGS_TWO = new Class[]{Object.class, Throwable.class};
        LOGGER_TYPE = null;
    }

    public static enum Level {
        FATAL,
        ERROR,
        WARN,
        INFO,
        DEBUG,
        TRACE;

    }

    public static enum LoggerType {
        JAVA,
        COMMONS;

    }
}

