/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.command;

import org.scijava.command.DynamicCommand;
import org.scijava.command.Interactive;
import org.scijava.command.Previewable;
import org.scijava.display.Display;
import org.scijava.display.DisplayService;
import org.scijava.display.event.DisplayActivatedEvent;
import org.scijava.event.EventHandler;
import org.scijava.event.EventService;
import org.scijava.log.LogService;
import org.scijava.log.Logged;
import org.scijava.module.MethodCallException;
import org.scijava.module.ModuleItem;
import org.scijava.plugin.Parameter;
import org.scijava.thread.ThreadService;

public abstract class InteractiveCommand
extends DynamicCommand
implements Interactive,
Previewable,
Logged {
    @Parameter
    private DisplayService displayService;
    @Parameter
    private EventService eventService;
    @Parameter
    private ThreadService threadService;
    @Parameter
    private LogService log;
    private final String[] listenerNames;

    public InteractiveCommand(String ... listenerNames) {
        this.listenerNames = listenerNames;
    }

    @Override
    public void preview() {
        this.run();
        this.saveInputs();
    }

    @Override
    public void cancel() {
    }

    @Override
    public LogService log() {
        return this.log;
    }

    protected void updateInput(ModuleItem<?> item) {
        ModuleItem<Display<?>> displayItem = this.asDisplay(item);
        if (displayItem != null) {
            this.updateDisplay(displayItem);
        } else {
            this.log.warn("Input '" + item.getName() + "' (" + item.getClass().getName() + ") is not supported");
        }
    }

    protected <T> ModuleItem<T> asType(ModuleItem<?> item, Class<T> type) {
        if (!type.isAssignableFrom(item.getType())) {
            return null;
        }
        ModuleItem<?> typedItem = item;
        return typedItem;
    }

    protected <T> void update(ModuleItem<T> item, T newValue) {
        T oldValue = item.getValue(this);
        if (oldValue != newValue) {
            item.setValue(this, newValue);
            try {
                item.callback(this);
            }
            catch (MethodCallException exc) {
                this.log.error(exc);
            }
        }
    }

    @EventHandler
    protected void onEvent(DisplayActivatedEvent evt) {
        this.threadService.run(new Runnable(){

            @Override
            public void run() {
                for (String listenerName : InteractiveCommand.this.listenerNames) {
                    ModuleItem<?> item = InteractiveCommand.this.getInfo().getInput(listenerName);
                    InteractiveCommand.this.updateInput(item);
                }
            }
        });
    }

    private ModuleItem<Display<?>> asDisplay(ModuleItem<?> item) {
        Class<Display> displayClass = Display.class;
        return this.asType(item, displayClass);
    }

    private <D extends Display<?>> void updateDisplay(ModuleItem<D> item) {
        this.update(item, this.displayService.getActiveDisplay(item.getType()));
    }
}

