/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

public class Round
extends PostfixMathCommand {
    public Round() {
        this.numberOfParameters = -1;
    }

    @Override
    public void run(Stack inStack) throws ParseException {
        this.checkStack(inStack);
        if (this.curNumberOfParameters == 1) {
            Object param = inStack.pop();
            inStack.push(this.round(param));
        } else {
            Object r = inStack.pop();
            Object l = inStack.pop();
            inStack.push(this.round(l, r));
        }
    }

    private Object round(Object l, Object r) throws ParseException {
        if (l instanceof Number && r instanceof Number) {
            int dp = ((Number)r).intValue();
            double val = ((Number)l).doubleValue();
            double mul = Math.pow(10.0, dp);
            return new Double(Math.rint(val * mul) / mul);
        }
        throw new ParseException("Invalid parameter type");
    }

    public Object round(Object param) throws ParseException {
        if (param instanceof Number) {
            return new Double(Math.rint(((Number)param).doubleValue()));
        }
        throw new ParseException("Invalid parameter type");
    }
}

