/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.vectorJep.function;

import org.lsmp.djep.vectorJep.Dimensions;
import org.lsmp.djep.vectorJep.function.BinaryOperatorI;
import org.lsmp.djep.vectorJep.values.MVector;
import org.lsmp.djep.vectorJep.values.Matrix;
import org.lsmp.djep.vectorJep.values.MatrixValueI;
import org.lsmp.djep.vectorJep.values.Tensor;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.Subtract;

public class MSubtract
extends Subtract
implements BinaryOperatorI {
    @Override
    public Dimensions calcDim(Dimensions ldim, Dimensions rdim) {
        if (ldim.equals(rdim)) {
            return ldim;
        }
        return null;
    }

    @Override
    public MatrixValueI calcValue(MatrixValueI res, MatrixValueI lhs, MatrixValueI rhs) throws ParseException {
        int len = res.getNumEles();
        for (int i = 0; i < len; ++i) {
            res.setEle(i, super.sub(lhs.getEle(i), rhs.getEle(i)));
        }
        return res;
    }

    @Override
    public Object sub(Object param1, Object param2) throws ParseException {
        if (param1 instanceof MVector && param2 instanceof MVector) {
            return this.sub((MVector)param1, (MVector)param2);
        }
        if (param1 instanceof Matrix && param2 instanceof Matrix) {
            return this.sub((Matrix)param1, (Matrix)param2);
        }
        if (param1 instanceof Tensor && param2 instanceof Tensor) {
            return this.sub((Tensor)param1, (Tensor)param2);
        }
        return super.sub(param1, param2);
    }

    public MVector sub(MVector lhs, MVector rhs) throws ParseException {
        if (lhs.getNumEles() != rhs.getNumEles()) {
            throw new ParseException("Miss match in sizes (" + lhs.getNumEles() + "," + rhs.getNumEles() + ") when trying to add vectors!");
        }
        MVector res = new MVector(lhs.getNumEles());
        return (MVector)this.calcValue(res, lhs, rhs);
    }

    public Matrix sub(Matrix lhs, Matrix rhs) throws ParseException {
        if (lhs.getNumRows() != rhs.getNumRows()) {
            throw new ParseException("Miss match in number of rows (" + lhs.getNumRows() + "," + rhs.getNumRows() + ") when trying to add vectors!");
        }
        if (lhs.getNumCols() != rhs.getNumCols()) {
            throw new ParseException("Miss match in number of cols (" + lhs.getNumCols() + "," + rhs.getNumCols() + ") when trying to add vectors!");
        }
        Matrix res = (Matrix)Matrix.getInstance(lhs.getNumRows(), lhs.getNumCols());
        return (Matrix)this.calcValue(res, lhs, rhs);
    }

    public Tensor sub(Tensor lhs, Tensor rhs) throws ParseException {
        if (lhs.getNumEles() != rhs.getNumEles()) {
            throw new ParseException("Miss match in sizes (" + lhs.getNumEles() + "," + rhs.getNumEles() + ") when trying to add vectors!");
        }
        Tensor res = new Tensor(lhs.getDim());
        return (Tensor)this.calcValue(res, lhs, rhs);
    }
}

